/* 
 * Mach Operating System
 * Copyright (c) 1991,1990 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator   or   Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they made and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	bsd_machdep.c,v $
 * Revision 2.4  92/02/02  13:02:47  rpd
 * 	Added casts to thread_get_state arguments.
 * 	[92/01/31            rpd]
 * 
 * Revision 2.3  91/12/19  20:29:19  mrt
 * 	Updated to new copyright
 * 
 * Revision 2.2  90/09/08  00:20:34  rwd
 * 	Created from mips version.  Added machine_adjust_for_emulator().
 * 	[90/07/14            rwd]
 * 
 */
/*
 *	File:	./sun3/bsd_machdep.c
 *	Author:	Joseph S. Barrera III, Randall W. Dean
 *
 *	Copyright (c) 1990 Joseph S. Barrera III, Randall W. Dean
 */

#include <mach.h>
#include <mach/message.h>
#include <errno.h>
#include <fnode.h>
#include <loader_info.h>
#include <ux_user.h>
#include <ux_param.h>
#include <sun3/exec.h>
#include <sun3/vmparam.h>

#define	LOADER_PAGE_SIZE	(NBPG)
#define	loader_round_page(x)	((vm_offset_t)((((vm_offset_t)(x)) \
						+ LOADER_PAGE_SIZE - 1) \
					& ~(LOADER_PAGE_SIZE-1)))

#define	round_sun_segment(x)	(((x) + SGOFSET) & ~SGOFSET)

/*
 *	Object:
 *		ex_get_header			EXPORTED function
 *
 *		Reads the exec header for the loader's benefit
 *
 */
int ex_get_header(fn, lp)
	struct fnode	*fn;
	struct loader_info	*lp;
{
	struct exec x;
	register int	result;
	vm_size_t	resid;


	result = FOP_READ(fn, 0, &x, sizeof(x), &resid);
	if (result)
		return (result);
	if (resid)
		return (ENOEXEC);

	switch ((int)x.a_magic) {

	    case 0407:
		lp->format = EX_READIN;
		lp->text_start  = 0;
		lp->text_size   = 0;
		lp->text_offset = 0;
		lp->data_start  = LOADER_PAGE_SIZE;	/* ??? */
		lp->data_size   = x.a_text + x.a_data;
		lp->data_offset = sizeof(struct exec);
		lp->bss_size    = x.a_bss;
		break;

	    case 0410:
		if (x.a_text == 0) {
			return(ENOEXEC);
		}
		lp->format = EX_SHAREABLE;
		lp->text_start  = LOADER_PAGE_SIZE;
		lp->text_size   = loader_round_page(x.a_text);
		lp->text_offset = sizeof(struct exec);
		lp->data_start  = round_sun_segment(lp->text_start +
						lp->text_size);
		lp->data_size   = loader_round_page(x.a_data);
		lp->data_offset = lp->text_offset + lp->text_size;
		lp->bss_size    = loader_round_page(x.a_bss);
		break;

	    case 0413:
		if (x.a_text == 0) {
			return(ENOEXEC);
		}
		lp->format = EX_PAGEABLE;
		lp->text_start  = LOADER_PAGE_SIZE;
		lp->text_size   = loader_round_page(x.a_text);
		lp->text_offset = 0;
		lp->data_start  = round_sun_segment(lp->text_start +
						lp->text_size);
		lp->data_size   = loader_round_page(x.a_data);
		lp->data_offset = lp->text_offset + lp->text_size;
		lp->bss_size    = loader_round_page(x.a_bss);
		break;
	    default:
		return (ENOEXEC);
	}
	lp->entry_1 = x.a_entry;
	lp->entry_2 = 0;

	return(0);
}

xx_thread_set_state(user_thread, lp, arg_pos)
	mach_port_t user_thread;
	struct loader_info *lp;
	int arg_pos;
{
	struct sun_thread_state regs;
	kern_return_t kr;
	unsigned int		reg_size;

	reg_size = SUN_THREAD_STATE_REGS_COUNT;
	kr = thread_get_state(user_thread,
				SUN_THREAD_STATE_REGS,
				(thread_state_t)&regs,
				&reg_size);
	if (kr) mach_error("vm_get_state", kr);


	regs.pc = lp->entry_1;
	regs.sp = arg_pos;

	kr = thread_set_state(user_thread,
				SUN_THREAD_STATE_REGS,
				(thread_state_t)&regs,
				reg_size);
	if (kr) mach_error("thread_set_state", kr);
}

/* XXX this should be made obsolete */
thread_get_pc(thread, pc)
	mach_port_t thread;
	int *pc;
{
	struct sun_thread_state regs;
	int error;
	unsigned int reg_size;

	reg_size = SUN_THREAD_STATE_REGS_COUNT;
	error = thread_get_state(thread, SUN_THREAD_STATE_REGS,
				(thread_state_t)&regs, &reg_size);
	if (error) {
		return error;
	}
	*pc = regs.pc;
	return 0;
}

/*This is obsolete, now that ptrace sorta works*/

thread_dump(thread)
	mach_port_t thread;
{
	struct sun_thread_state state;
	mach_msg_type_number_t count;
	register kern_return_t kr;

	printf("sun3 thread_dump(%x)\n",thread);
	count = SUN_THREAD_STATE_REGS_COUNT;
	kr = thread_get_state(thread, SUN_THREAD_STATE_REGS,
			      (thread_state_t) &state, &count);
	if (kr != KERN_SUCCESS || count != SUN_THREAD_STATE_REGS_COUNT)
		return 0;

	printf("d0 = 0x%x\td1 = 0x%x\td2 = 0x%x\td3 = 0x%x\n",
	       state.d0, state.d1, state.d2, state.d3);
	printf("d4 = 0x%x\td5 = 0x%x\td6 = 0x%x\td7 = 0x%x\n",
	       state.d4, state.d5, state.d6, state.d7);
	printf("a0 = 0x%x\ta1 = 0x%x\ta2 = 0x%x\ta3 = 0x%x\n",
	       state.a0, state.a1, state.a2, state.a3);
	printf("a4 = 0x%x\ta5 = 0x%x\ta6 = 0x%x\tsp = 0x%x\n",
	       state.a4, state.a5, state.a6, state.sp);
	printf("pc = 0x%x\tsr = 0x%x\n",
	       state.pc, state.sr);
	return 0;
}

get_threadstate(ut)
	struct ux_task *ut;
{
	int error;
	unsigned int size;
	struct sun_regs {
		struct sun_thread_state		ts;
		struct fpa_regs			fs;
	} *sr;

	if (ut->ut_threadstate) {
		return 0;
	}
	sr = (struct sun_regs *) malloc(sizeof(*sr));
	size = SUN_THREAD_STATE_REGS_COUNT;
	error = thread_get_state(ut->ut_thread, SUN_THREAD_STATE_REGS,
				 (thread_state_t) &sr->ts, &size);
	if (error) {
		free(sr);
printf("AAA.2\n");
		return ESRCH;
	}
	size = SUN_THREAD_STATE_FPA_COUNT;
	error = thread_get_state(ut->ut_thread, SUN_THREAD_STATE_FPA,
				 (thread_state_t) &sr->fs, &size);
	if (error) {
		free(sr);
printf("AAA.3\n");
		return ESRCH;
	}
	ut->ut_threadstate = (char *) sr;
	return 0;
}

set_entry_address(lp, entry, entry_count)
	struct loader_info *lp;
	int		*entry;		/* pointer to OUT array */
	unsigned int	*entry_count;	/* out */
{
	entry[0] = lp->entry_1;
	*entry_count = 1;
}

/*
 * Clone the parent's registers into the child thread for fork.
 */
boolean_t
thread_dup(child_thread, new_state, new_state_count, parent_pid, rc)
	thread_t	child_thread;
	thread_state_t	new_state;
	unsigned int	new_state_count;
	int		parent_pid, rc;
{
	struct sun_thread_state	*regs = (struct sun_thread_state *)new_state;

	if (new_state_count != SUN_THREAD_STATE_REGS_COUNT)
	    return (KERN_INVALID_ARGUMENT);

	regs->d0 = parent_pid;
	regs->d1 = rc;

	return thread_set_state(child_thread, SUN_THREAD_STATE_REGS,
				new_state, new_state_count);

}

kern_return_t
machine_deallocate_for_exec(task)
task_t task;
{
	kern_return_t error;

	error = vm_deallocate(task, 0, EMULATOR_BASE);
	if (error) return error;
	error = vm_deallocate(task, EMULATOR_END,
			      STACK_END - STACK_SIZE - EMULATOR_END);
	if (error) return error;
}

int
machine_adjust_for_emulator(li)
struct loader_info *li;
{
	li->text_start = EMULATOR_BASE;
	li->data_start += EMULATOR_BASE;
	return 0;
}
