void
gdk_draw_arcs (GdkDrawable *drawable, GdkGC *gc, gint filled, GdkArc *arcs, 
               gint narcs)
{
  GdkWindowPrivate *drawable_private;
  GdkGCPrivate *gc_private;

  if (narcs <= 0)
    return;

  g_return_if_fail (drawable != NULL);
  g_return_if_fail (arcs != NULL);
  g_return_if_fail (gc != NULL);

  drawable_private = (GdkWindowPrivate*) drawable;
  if (drawable_private->destroyed)
    return;
  gc_private = (GdkGCPrivate*) gc;

  if (filled)
    XFillArcs (drawable_private->xdisplay, drawable_private->xwindow,
               gc_private->xgc, (XArc *) arcs, narcs);
  else
    XDrawArcs (drawable_private->xdisplay, drawable_private->xwindow,
               gc_private->xgc, (XArc *) arcs, narcs);
}

void
gdk_draw_rectangles (GdkDrawable  *drawable, GdkGC *gc, gint filled, 
                     GdkRectangle *rectangles, gint nrectangles)
{
  GdkWindowPrivate *drawable_private;
  GdkGCPrivate *gc_private;

  if (nrectangles <= 0)
    return;

  g_return_if_fail (drawable != NULL);
  g_return_if_fail (rectangles != NULL);
  g_return_if_fail (gc != NULL);

  drawable_private = (GdkWindowPrivate*) drawable;
  if (drawable_private->destroyed)
    return;
  gc_private = (GdkGCPrivate*) gc;

  if (filled)
    XFillRectangles (drawable_private->xdisplay, drawable_private->xwindow,
                     gc_private->xgc, (XRectangle *) rectangles, nrectangles);
  else
    XDrawRectangles (drawable_private->xdisplay, drawable_private->xwindow,
                     gc_private->xgc, (XRectangle *) rectangles, nrectangles);
}
