## Process the output of makedepend.
## Copyright (c) 1994 Amdahl Corporation.
## Written by Ben Wing, December 1994.

## This file is used as part of 'make depend', to produce the
## dependency list for src/Makefile.in.in.

## Unfortunately, makedepend (at least the one that comes as part
## of Open Windows under Solaris) is stupid and doesn't follow the
## documented behavior.  So we have to force the definitions of
## certain options through -D flags (even though it's supposed to
## pick this up), and post-process the output to get rid of stuff
## we don't want.

## The sed stage gets rid of include files in other directories,
## except for lwlib.h (makedepend puts system include files in,
## which is pretty stupid).  We also get rid of some standard
## include files that are in every or pretty much every file
## and where changes in those files don't usually merit
## recompilation of everything.  Finally, we eliminate entirely
## the dependencies for some files (such as unex*.c) that get
## screwed up by makedepend.  We just put those in by hand at
## the top of the dependency list.

## For Mule, we need to do some additional processing: conversion
## to MULESRCDIR (at least so that the include files don't get
## wiped out by the next stage) and removing the mule/ prefix
## from the object file names.

## The awk stage puts one dependency per line.  Then we pass
## the result through sort and uniq (makedepend is supposed
## to not put in duplicate dependencies, but it does so
## occasionally).

## After running 'make depend', verify that the output (in
## depend.out) is reasonable and then replace the stuff in
## Makefile.in.in marked "generated by 'make depend'".

sed -e '
1d
s/ \/[^ ]*\/lwlib\// $(LWLIBSRCDIR)\//g
s/\.\.\/etc\//${srcdir}\/${etcdir}/g
s/^mule\///g
s/ mule\// $(MULESRCDIR)\/mule\//g
s/ \/[^ ]*\.h//g
s/ \/[^ ]*gray//g
s/ [a-z][^ ]*\/[^ ]*\.h//g
s/ lisp\.h//g
s/ lisp-union\.h//g
s/ lisp-disunion\.h//g
s/ lrecord\.h//g
s/ emacsfns\.h//g
s/ symeval\.h//g
s/ symsinit\.h//g
s/ syssignal\.h//g
s/ intl\.h//g
s/ tt_c\.h//g
s/ descrip\.h//g
/^unex/d
/^sgiplay/d
/^Extern/d
/^extw/d
/^[^ ]*\.o:$/d
' | awk '
{ for (i = 2; i <= NF; i++)
  printf ("%s %s\n", $1, $i)
}
' | sort | uniq
