;;!emacs
;;
;; FILE:         kprop-em19.el
;; SUMMARY:      Koutline text property handling under Emacs 19.
;; USAGE:        GNU Emacs Lisp Library
;; KEYWORDS:     outlines, wp
;;
;; AUTHOR:       Bob Weiner
;;
;; ORIG-DATE:    7/27/93
;; LAST-MOD:     21-Jun-95 at 00:50:38 by Bob Weiner
;;
;; This file is part of Hyperbole.
;; Available for use and distribution under the same terms as GNU Emacs.
;;
;; Copyright (C) 1993-1995, Free Software Foundation, Inc.
;; Developed with support from Motorola Inc.
;;
;; DESCRIPTION:  
;; DESCRIP-END.

;;; ************************************************************************
;;; Other required Elisp libraries
;;; ************************************************************************

(require 'hversion)

;;; ************************************************************************
;;; Public functions
;;; ************************************************************************

(fset 'kproperty:get 'get-text-property)

(defun kproperty:map (function property value)
  "Apply FUNCTION to each PROPERTY `eq' to VALUE in the current buffer."
  (let ((result)
	(start (point-min)))
    (while (setq start
		 (text-property-any start (point-max) property value))
      (setq result (cons (funcall function (text-properties-at start))
			 result)))
    (nreverse result)))

(fset 'kproperty:next-single-change 'next-single-property-change)

(fset 'kproperty:previous-single-change 'previous-single-property-change)

(fset 'kproperty:properties 'text-properties-at)

(fset 'kproperty:put 'put-text-property)

(fset 'kproperty:remove 'remove-text-properties)

(defun kproperty:set (property value)
  "Set PROPERTY of character at point to VALUE."
  (kproperty:put (point) (min (+ 2 (point)) (point-max)) property value))
