;;; xwem-load.el --- Load everything we will need.

;; Copyright (C) 2003 by Free Software Foundation, Inc.

;; Authors: Zajcev Evgeny <zevlg@yandex.ru>
;;	    Alex Ott <ottalex@narod.ru>
;; Created: 1 Sep 2003
;; Keywords: xlib, xwem
;; X-CVS: $Id: xwem-load.el,v 1.2 2004/03/27 07:49:30 lg Exp $

;; This file is part of XWEM.

;; XWEM is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XWEM is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Synched up with: Not in FSF

;;; Commentary:

;; 

;;; Code:

(eval-when-compile
  (require 'cl))

;; Compatibility layer
(require 'xwem-compat)

;; Macros
(require 'xwem-macros)

;; Autoload some xwem commands
;;
;; TODO:
;;   * write tiny funcition which will recognize `define-xwem-command'
;;     as autoloadable defun.
;;
(mapc (lambda (fun)
	(autoload fun "xwem-help" nil t))
      (list 'xwem-describe-prefix-bindings 'xwem-help-describe-bindings
	    'xwem-help-describe-key 'xwem-help-frames 'xwem-help-wins
	    'xwem-help-clients 'xwem-help-where-is))

(mapc (lambda (fun)
	(autoload fun "xwem-win" nil t))
      (list 'xwem-balance-windows 'xwem-transpose-windows))

(mapc (lambda (fun)
	(autoload fun "xwem-clients" nil t))
      (list 'xwem-cl-switch 'xwem-cl-switch-other-win 'xwem-cl-switch-other-frame
	    'xwem-cl-switch-to-other 'xwem-cl-switch-to-other-in-other-win
	    'xwem-kill-cl-and-window 'xwem-cl-transpose 'xwem-client-toggle-other-on-split
	    'xwem-client-kill 'xwem-client-demanage-others 'xwem-client-run-copy
	    'xwem-client-run-copy-other-win 'xwem-client-run-copy-other-frame
	    'xwem-cl-pop-to-client 'xwem-cl-set-title 'xwem-client-iconify
	    'xwem-client-turn-on-other-on-split 'xwem-client-turn-off-other-on-split
	    'xwem-client-info 'xwem-client-set-mark))

(mapc (lambda (fun)
	(autoload fun "xwem-frame" nil t))
      (list 'xwem-make-frame 'xwem-frame-lower 'xwem-frame-raise 'xwem-frame-switch-nth
	    'xwem-frame-switch-nth-linkage 'xwem-frame-destroy 'xwem-frame-del-win
	    'xwem-frame-del-others 'xwem-frame-split-horiz 'xwem-frame-split-vert
	    'xwem-frame-win-enlarge-hor 'xwem-frame-win-enlarge-ver
	    'xwem-frame-goto-next 'xwem-frame-goto-prev 'xwem-frame-goto-next-vert
	    'xwem-frame-goto-next-hor 'xwem-frame-goto-prev-vert 'xwem-frame-goto-prev-hor
	    'xwem-frame-split-sbs 'xwem-frame-sbs-hor-split 'xwem-frame-sbs-vert-split
	    'xwem-frame-fit-screen 'xwem-frame-transpose 'xwem-frame-showroot
	    'xwem-frame-hide 'xwem-frame-next 'xwem-frame-previous 'xwem-transpose-frames
            'xwem-frame-set-name))

(mapc (lambda (fun)
	(autoload fun "xwem-help" nil t))
      (list 'xwem-help 'xwem-help-for-help 'xwem-describe-prefix-bindings
	    'xwem-help-describe-bindings 'xwem-help-describe-key1 'xwem-help-describe-key
	    'xwem-help-frames 'xwem-help-wins 'xwem-help-clients 'xwem-help-where-is))

(mapc (lambda (fun)
	(autoload fun "xwem-keyboard" nil t))
      (list 'xwem-undefined-command 'xwem-keyboard-quit 'xwem-kbd-quit
	    'xwem-kbd-quote-command 'xwem-universal-argument 'xwem-universal-digit
	    'xwem-universal-minus 'xwem-universal-command))

(mapc (lambda (fun)
	(autoload fun "xwem-keymacro" nil t))
      (list 'xwem-keymacro-end 'xwem-keymacro-begin 'xwem-keymacro-undefined
	    'xwem-keymacro-play-last 'xwem-keymacro-play 'xwem-keymacro-save-macros
	    'xwem-keymacro-recursive-edit 'xwem-keymacro-exit-recursive-edit))

(mapc (lambda (fun)
	(autoload fun "xwem-launcher" nil t))
      (list 'xwem-run-program 'xwem-launcher-turn-on-horizontal-split-type
	    'xwem-launcher-turn-on-vertical-split-type 'xwem-launcher-toggle-split-type
	    'xwem-launcher-turn-on-normal-frame-type 'xwem-launcher-turn-on-embedded-frame-type
	    'xwem-launcher-toggle-frame-type 'xwem-launch-program 'xwem-launch-program-other-win
	    'xwem-launch-program-other-frame
	    'xwem-launch-xterm 'xwem-launch-xterm-other-win 'xwem-launch-xterm-other-frame
	    'xwem-launch-lupe 'xwem-launch-lupe-other-win 'xwem-launch-lupe-other-frame
	    'xwem-launch-xlock))

(mapc (lambda (fun)
	(autoload fun "xwem-misc" nil t))
      (list 'xwem-eval-expression 'xwem-execute-extended-command 'xwem-mini-calc
	    'xwem-misc-make-screenshot 'xwem-beginning-of-cl 'xwem-end-of-cl
	    'xwem-show-message-log
	    ))

(mapc (lambda (fun)
	(autoload fun "xwem-mouse" nil t))
      (list 'xwem-popup-function-menu 'xwem-popup-auto-menu))

(mapc (lambda (fun)
	(autoload fun "xwem-strokes" nil t))
      (list 'xwem-strokes-define 'xwem-strokes-descrcurr 'xwem-strokes-begin
	    'xwem-strokes-cmplx-begin))


(mapc (lambda (fun)
	(autoload fun "xwem-edmacro" nil t))
      (list 'xwem-edmacro-edit-kbd-macro))

;; install default bindings
(eval-when 'load
  (load "xwem-keydefs")			; default keybindings

  (run-hooks 'xwem-load-hook))


(provide 'xwem-load)

;;; xwem-load.el ends here
