


C Library Functions                             CLISP-READLINE(3)



NNNNAAAAMMMMEEEE
     readline - get a line from a user with editing

NNNNOOOOTTTTAAAATTTTIIIIOOOONNNN
     An emacs-style notation is used to denote keystrokes.   Con-
     trol  keys  are denoted by C-_k_e_y, e.g., C-n means Control-N.
     Similarly, _m_e_t_a keys are denoted  by  M-_k_e_y,  so  M-x  means
     Meta-X.   (On keyboards without a _m_e_t_a key, M-_x means ESC _x,
     i.e., press the Escape key then the _x key.  This  makes  ESC
     the _m_e_t_a _p_r_e_f_i_x.  The combination M-C-_x means ESC-Control-_x,
     or press the Escape key then  hold  the  Control  key  while
     pressing the _x key.)

     Readline commands may be given numeric _a_r_g_u_m_e_n_t_s, which nor-
     mally  act as a repeat count.  Sometimes, however, it is the
     sign of the argument that is significant.  Passing  a  nega-
     tive  argument  to a command that acts in the forward direc-
     tion (e.g., kkkkiiiillllllll----lllliiiinnnneeee) causes that command to act in a back-
     ward  direction.   Commands  whose  behavior  with arguments
     deviates from this are noted.

     When a command  is  described  as  _k_i_l_l_i_n_g  text,  the  text
     deleted  is  saved  for possible future retrieval (_y_a_n_k_i_n_g).
     The killed text is saved in a _k_i_l_l _r_i_n_g.  Consecutive  kills
     cause the text to be accumulated into one unit, which can be
     yanked all at once. Commands which do not kill text separate
     the chunks of text on the kill ring.

IIIINNNNIIIITTTTIIIIAAAALLLLIIIIZZZZAAAATTTTIIIIOOOONNNN FFFFIIIILLLLEEEE
     Readline is customized by putting commands in an initializa-
     tion  file  (the  _i_n_p_u_t_r_c  file).   The name of this file is
     taken from the value of the  IIIINNNNPPPPUUUUTTTTRRRRCCCC  environment  variable.
     If  that variable is unset, the default is ~/._i_n_p_u_t_r_c.  When
     a program which uses the readline  library  starts  up,  the
     init  file  is  read, and the key bindings and variables are
     set.  There are only a few basic constructs allowed  in  the
     readline  init file.  Blank lines are ignored.  Lines begin-
     ning with a #### are comments.  Lines beginning with a $$$$  indi-
     cate  conditional  constructs.  Other lines denote key bind-
     ings and variable settings.  Each program using this library
     may add its own commands and bindings.

     For example, placing

          M-Control-u: universal-argument
     or
          C-Meta-u: universal-argument
     into the _i_n_p_u_t_r_c would make M-C-u execute the readline  com-
     mand _u_n_i_v_e_r_s_a_l-_a_r_g_u_m_e_n_t.

     The following symbolic character names are recognized  while
     processing  key  bindings:   _R_U_B_O_U_T, _D_E_L, _E_S_C, _L_F_D, _N_E_W_L_I_N_E,



GNU               Last change: 1998 October 11                  1






C Library Functions                             CLISP-READLINE(3)



     _R_E_T, _R_E_T_U_R_N, _S_P_C, _S_P_A_C_E, and _T_A_B.  In  addition  to  command
     names,  readline allows keys to be bound to a string that is
     inserted when the key is pressed (a _m_a_c_r_o).

  KKKKeeeeyyyy BBBBiiiinnnnddddiiiinnnnggggssss
     The syntax for controlling key bindings in the _i_n_p_u_t_r_c  file
     is  simple.  All that is required is the name of the command
     or the text of a macro and a key sequence to which it should
     be  bound. The name may be specified in one of two ways:  as
     a symbolic key name, possibly with _M_e_t_a-  or  _C_o_n_t_r_o_l-  pre-
     fixes,   or   as  a  key  sequence.   When  using  the  form
     kkkkeeeeyyyynnnnaaaammmmeeee:_f_u_n_c_t_i_o_n-_n_a_m_e or _m_a_c_r_o, _k_e_y_n_a_m_e is the name of a key
     spelled out in English.  For example:

          Control-u: universal-argument
          Meta-Rubout: backward-kill-word
          Control-o: ">&output"

     In  the  above  example,  _C-_u  is  bound  to  the   function
     uuuunnnniiiivvvveeeerrrrssssaaaallll-aaaarrrrgggguuuummmmeeeennnntttt,   _M-_D_E_L   is   bound   to  the  function
     bbbbaaaacccckkkkwwwwaaaarrrrdddd-kkkkiiiillllllll-wwwwoooorrrrdddd, and  _C-_o  is  bound  to  run  the  macro
     expressed  on  the  right  hand side (that is, to insert the
     text >&_o_u_t_p_u_t into the line).

     In the second form, """"kkkkeeeeyyyysssseeeeqqqq"""":_f_u_n_c_t_i_o_n-_n_a_m_e or _m_a_c_r_o,  kkkkeeeeyyyysssseeeeqqqq
     differs  from  kkkkeeeeyyyynnnnaaaammmmeeee  above  in  that  strings denoting an
     entire key sequence may be specified by placing the sequence
     within  double quotes.  Some GNU Emacs style key escapes can
     be used, as in the following example.

          "\C-u": universal-argument
          "\C-x\C-r": re-read-init-file
          "\e[11~": "Function Key 1"

     In  this  example,  _C-_u  is  again  bound  to  the  function
     uuuunnnniiiivvvveeeerrrrssssaaaallll-aaaarrrrgggguuuummmmeeeennnntttt.   _C-_x  _C-_r  is  bound  to  the  function
     rrrreeee-rrrreeeeaaaadddd-iiiinnnniiiitttt-ffffiiiilllleeee, and _E_S_C [ _1 _1 ~ is bound  to  insert  the
     text FFFFuuuunnnnccccttttiiiioooonnnn KKKKeeeeyyyy 1111.  The full set of GNU Emacs style escape
     sequences is
          \\\\CCCC-  control prefix
          \\\\MMMM-  meta prefix
          \\\\eeee   an escape character
          \\\\\\\\   backslash
          """" \\\\"""" literal "
          \\\\''''   literal '

     In addition to the  GNU  Emacs  style  escape  sequences,  a
     second set of backslash escapes is available:
          \\\\aaaa   alert (bell)
          \\\\bbbb   backspace
          \\\\dddd   delete
          \\\\ffff   form feed



GNU               Last change: 1998 October 11                  2






C Library Functions                             CLISP-READLINE(3)



          \\\\nnnn   newline
          \\\\rrrr   carriage return
          \\\\tttt   horizontal tab
          \\\\vvvv   vertical tab
          \\\\_n_n_n the character whose ASCII code is the octal  value
               _n_n_n (one to three digits)
          \\\\xxxx_n_n_n
               the character whose ASCII code is the  hexadecimal
               value _n_n_n (one to three digits)

     When entering the text of a macro, single or  double  quotes
     should  be  used  to  indicate a macro definition.  Unquoted
     text is assumed to be a function name.  In the  macro  body,
     the   backslash   escapes   described  above  are  expanded.
     Backslash will quote any other character in the macro  text,
     including " and '.

     BBBBaaaasssshhhh  allows  the  current  readline  key  bindings  to   be
     displayed  or  modified  with the bbbbiiiinnnndddd builtin command.  The
     editing mode may be switched during interactive use by using
     the  -oooo  option  to the sssseeeetttt builtin command.  Other programs
     using this library provide similar mechanisms.  The  _i_n_p_u_t_r_c
     file may be edited and re-read if a program does not provide
     any other means to incorporate new bindings.

  VVVVaaaarrrriiiiaaaabbbblllleeeessss
     Readline has variables that can be used to further customize
     its  behavior.   A  variable  may be set in the _i_n_p_u_t_r_c file
     with a statement of the form

          sssseeeetttt _v_a_r_i_a_b_l_e-_n_a_m_e _v_a_l_u_e

     Except where noted, readline variables can take  the  values
     OOOOnnnn or OOOOffffffff.  The variables and their default values are:

     bbbbeeeellllllll-ssssttttyyyylllleeee ((((aaaauuuuddddiiiibbbblllleeee))))
          Controls what happens when readline wants to  ring  the
          terminal  bell.   If  set to nnnnoooonnnneeee, readline never rings
          the bell.  If set to vvvviiiissssiiiibbbblllleeee, readline uses  a  visible
          bell  if one is available.  If set to aaaauuuuddddiiiibbbblllleeee, readline
          attempts to ring the terminal's bell.
     ccccoooommmmmmmmeeeennnntttt-bbbbeeeeggggiiiinnnn ((((````````;;;;''''''''))))
          The string  that  is  inserted  in  vvvviiii  mode  when  the
          iiiinnnnsssseeeerrrrtttt-ccccoooommmmmmmmeeeennnntttt  command  is  executed.  This command is
          bound to MMMM-#### in emacs mode and to #### in vi command mode.
     ccccoooommmmpppplllleeeettttiiiioooonnnn-iiiiggggnnnnoooorrrreeee-ccccaaaasssseeee ((((OOOOffffffff))))
          If set to OOOOnnnn, readline performs filename  matching  and
          completion in a case-insensitive fashion.
     bbbblllliiiinnnnkkkk-mmmmaaaattttcccchhhhiiiinnnngggg-ppppaaaarrrreeeennnn ((((OOOOnnnn))))
          If set to OOOOnnnn, readline will display  the  corresponding
          opening  parenthesis  when  a  closing  parenthesis  is
          typed.



GNU               Last change: 1998 October 11                  3






C Library Functions                             CLISP-READLINE(3)



     ccccoooommmmpppplllleeeettttiiiioooonnnn-qqqquuuueeeerrrryyyy-iiiitttteeeemmmmssss ((((111100000000))))
          This determines when the user is queried about  viewing
          the  number  of  possible  completions generated by the
          ppppoooossssssssiiiibbbblllleeee----ccccoooommmmpppplllleeeettttiiiioooonnnnssss command.  It may  be  set  to  any
          integer  value  greater  than or equal to zero.  If the
          number of possible completions is greater than or equal
          to  the  value  of  this  variable,  the  user is asked
          whether or not he wishes to view them;  otherwise  they
          are simply listed on the terminal.
     ddddiiiissssaaaabbbblllleeee-ccccoooommmmpppplllleeeettttiiiioooonnnn ((((OOOOffffffff))))
          If set to OOOOnnnn, readline will  inhibit  word  completion.
          Completion characters will be inserted into the line as
          if they had been mapped to sssseeeellllffff----iiiinnnnsssseeeerrrrtttt.
     eeeeddddiiiittttiiiinnnngggg-mmmmooooddddeeee ((((eeeemmmmaaaaccccssss))))
          Controls whether readline begins  with  a  set  of  key
          bindings  similar  to _e_m_a_c_s or _v_i.  eeeeddddiiiittttiiiinnnngggg-mmmmooooddddeeee can be
          set to either eeeemmmmaaaaccccssss or vvvviiii.
     eeeennnnaaaabbbblllleeee-kkkkeeeeyyyyppppaaaadddd ((((OOOOffffffff))))
          When set to OOOOnnnn, readline will try to enable the  appli-
          cation  keypad  when  it  is called.  Some systems need
          this to enable the arrow keys.
     eeeexxxxppppaaaannnndddd-ttttiiiillllddddeeee ((((OOOOffffffff))))
          If set to oooonnnn, tilde expansion is performed  when  read-
          line attempts word completion.
     hhhhoooorrrriiiizzzzoooonnnnttttaaaallll-ssssccccrrrroooollllllll-mmmmooooddddeeee ((((OOOOffffffff))))
          When set to OOOOnnnn, makes readline use a  single  line  for
          display,  scrolling  the input horizontally on a single
          screen line when it  becomes  longer  than  the  screen
          width rather than wrapping to a new line.
     kkkkeeeeyyyymmmmaaaapppp ((((eeeemmmmaaaaccccssss))))
          Set the current readline keymap.  The set of legal key-
          map  names is _e_m_a_c_s, _e_m_a_c_s-_s_t_a_n_d_a_r_d, _e_m_a_c_s-_m_e_t_a, _e_m_a_c_s-
          _c_t_l_x, _v_i, _v_i-_m_o_v_e, _v_i-_c_o_m_m_a_n_d, and  _v_i-_i_n_s_e_r_t.   _v_i  is
          equivalent   to  _v_i-_c_o_m_m_a_n_d;  _e_m_a_c_s  is  equivalent  to
          _e_m_a_c_s-_s_t_a_n_d_a_r_d.  The default value is _e_m_a_c_s; the  value
          of eeeeddddiiiittttiiiinnnngggg-mmmmooooddddeeee also affects the default keymap.
     mmmmaaaarrrrkkkk-ddddiiiirrrreeeeccccttttoooorrrriiiieeeessss ((((OOOOnnnn))))
          If set to OOOOnnnn, completed directory names  have  a  slash
          appended.
     mmmmaaaarrrrkkkk-mmmmooooddddiiiiffffiiiieeeedddd-lllliiiinnnneeeessss ((((OOOOffffffff))))
          If set to OOOOnnnn, history lines that have been modified are
          displayed with a preceding asterisk (****).
     ccccoooonnnnvvvveeeerrrrtttt-mmmmeeeettttaaaa ((((OOOOnnnn))))
          If set to OOOOnnnn, readline will convert characters with the
          eighth  bit  set  to an ASCII key sequence by stripping
          the eighth bit and prepending an escape  character  (in
          effect, using escape as the _m_e_t_a _p_r_e_f_i_x).
     mmmmeeeettttaaaa-ffffllllaaaagggg ((((OOOOffffffff))))
          If set to OOOOnnnn,  readline  will  enable  eight-bit  input
          (that is, it will not strip the high bit from the char-
          acters it  reads),  regardless  of  what  the  terminal
          claims it can support.



GNU               Last change: 1998 October 11                  4






C Library Functions                             CLISP-READLINE(3)



     oooouuuuttttppppuuuutttt-mmmmeeeettttaaaa ((((OOOOffffffff))))
          If set to OOOOnnnn, readline will display characters with the
          eighth  bit set directly rather than as a meta-prefixed
          escape sequence.
     pppprrrriiiinnnntttt-ccccoooommmmpppplllleeeettttiiiioooonnnnssss-hhhhoooorrrriiiizzzzoooonnnnttttaaaallllllllyyyy ((((OOOOffffffff))))
          If set to OOOOnnnn, readline will  display  completions  with
          matches  sorted  horizontally  in  alphabetical  order,
          rather than down the screen.
     sssshhhhoooowwww-aaaallllllll-iiiiffff-aaaammmmbbbbiiiigggguuuuoooouuuussss ((((OOOOffffffff))))
          This alters the  default  behavior  of  the  completion
          functions.   If  set  to oooonnnn, words which have more than
          one possible completion cause the matches to be  listed
          immediately instead of ringing the bell.
     vvvviiiissssiiiibbbblllleeee-ssssttttaaaattttssss ((((OOOOffffffff))))
          If set to OOOOnnnn, a character denoting  a  file's  type  as
          reported  by  ssssttttaaaatttt(2)  is appended to the filename when
          listing possible completions.

  CCCCoooonnnnddddiiiittttiiiioooonnnnaaaallll CCCCoooonnnnssssttttrrrruuuuccccttttssss
     Readline implements a facility similar in spirit to the con-
     ditional  compilation  features  of the C preprocessor which
     allows key bindings and variable settings to be performed as
     the result of tests.  There are four parser directives used.

     $$$$iiiiffff  The $$$$iiiiffff construct allows bindings to be made  based  on
          the  editing  mode,  the  terminal  being  used, or the
          application using  readline.   The  text  of  the  test
          extends  to  the  end  of  the  line; no characters are
          required to isolate it.

          mmmmooooddddeeee The mmmmooooddddeeee==== form of the $$$$iiiiffff  directive  is  used  to
               test  whether  readline  is  in  emacs or vi mode.
               This may be used in conjunction with the sssseeeetttt  kkkkeeeeyyyy----
               mmmmaaaapppp  command, for instance, to set bindings in the
               _e_m_a_c_s-_s_t_a_n_d_a_r_d  and  _e_m_a_c_s-_c_t_l_x  keymaps  only  if
               readline is starting out in emacs mode.

          tttteeeerrrrmmmm The tttteeeerrrrmmmm==== form may be used  to  include  terminal-
               specific  key  bindings,  perhaps  to bind the key
               sequences output by the terminal's function  keys.
               The  word  on  the  right  side of the ==== is tested
               against the full name of the terminal and the por-
               tion  of  the  terminal  name  before the first ----.
               This allows _s_u_n to match both _s_u_n and _s_u_n-_c_m_d, for
               instance.

          aaaapppppppplllliiiiccccaaaattttiiiioooonnnn
               The  aaaapppppppplllliiiiccccaaaattttiiiioooonnnn  construct  is  used  to  include
               application-specific settings.  Each program using
               the readline library sets  the  _a_p_p_l_i_c_a_t_i_o_n  _n_a_m_e,
               and an initialization file can test for a particu-
               lar  value.   This  could  be  used  to  bind  key



GNU               Last change: 1998 October 11                  5






C Library Functions                             CLISP-READLINE(3)



               sequences  to functions useful for a specific pro-
               gram.  For instance, the following command adds  a
               key  sequence  that quotes the current or previous
               word in Bash:

               $$$$iiiiffff bash
               # Quote the current or previous word
               "\C-xq": "\eb\"\ef\""
               $$$$eeeennnnddddiiiiffff

     $$$$eeeennnnddddiiiiffff
          This command, as seen in  the  previous  example,  ter-
          minates an $$$$iiiiffff command.

     $$$$eeeellllsssseeee
          Commands in this branch of the $$$$iiiiffff directive  are  exe-
          cuted if the test fails.

     $$$$iiiinnnncccclllluuuuddddeeee
          This directive takes a single filename as  an  argument
          and  reads  commands  and bindings from that file.  For
          example,   the   following   directive    would    read
          /_e_t_c/_i_n_p_u_t_r_c:

          $$$$iiiinnnncccclllluuuuddddeeee  /_e_t_c/_i_n_p_u_t_r_c

SSSSEEEEAAAARRRRCCCCHHHHIIIINNNNGGGG
     Readline provides commands for searching through the command
     history  for lines containing a specified string.  There are
     two search modes:  _i_n_c_r_e_m_e_n_t_a_l and _n_o_n-_i_n_c_r_e_m_e_n_t_a_l.

     Incremental searches begin before the user has finished typ-
     ing  the  search  string.   As  each character of the search
     string is typed, readline displays the next entry  from  the
     history  matching  the  string typed so far.  An incremental
     search requires only as many characters as  needed  to  find
     the  desired history entry.  The Escape character is used to
     terminate an incremental search.  Control-J will  also  ter-
     minate  the  search.   Control-G  will  abort an incremental
     search and restore the original line.  When  the  search  is
     terminated,  the  history entry containing the search string
     becomes the current line.  To find other matching entries in
     the  history  list, type Control-S or Control-R as appropri-
     ate.  This will search backward or forward  in  the  history
     for  the  next line matching the search string typed so far.
     Any other key sequence bound to a readline command will ter-
     minate the search and execute that command.  For instance, a
     _n_e_w_l_i_n_e will terminate  the  search  and  accept  the  line,
     thereby executing the command from the history list.

     Non-incremental  searches  read  the  entire  search  string
     before  starting  to search for matching history lines.  The



GNU               Last change: 1998 October 11                  6






C Library Functions                             CLISP-READLINE(3)



     search string may be typed by the user or  be  part  of  the
     contents of the current line.

EEEEDDDDIIIITTTTIIIINNNNGGGG CCCCOOOOMMMMMMMMAAAANNNNDDDDSSSS
     The following is a list of the names of the commands and the
     default  key  sequences  to  which  they are bound.  Command
     names without an accompanying key sequence  are  unbound  by
     default.

  CCCCoooommmmmmmmaaaannnnddddssss ffffoooorrrr MMMMoooovvvviiiinnnngggg
     bbbbeeeeggggiiiinnnnnnnniiiinnnngggg-ooooffff-lllliiiinnnneeee ((((CCCC-aaaa))))
          Move to the start of the current line.
     eeeennnndddd-ooooffff-lllliiiinnnneeee ((((CCCC-eeee))))
          Move to the end of the line.
     ffffoooorrrrwwwwaaaarrrrdddd-cccchhhhaaaarrrr ((((CCCC-ffff))))
          Move forward a character.
     bbbbaaaacccckkkkwwwwaaaarrrrdddd-cccchhhhaaaarrrr ((((CCCC-bbbb))))
          Move back a character.
     ffffoooorrrrwwwwaaaarrrrdddd-wwwwoooorrrrdddd ((((MMMM-ffff))))
          Move forward to the end of the next  word.   Words  are
          composed   of   alphanumeric  characters  (letters  and
          digits).
     bbbbaaaacccckkkkwwwwaaaarrrrdddd-wwwwoooorrrrdddd ((((MMMM-bbbb))))
          Move back to the start of this, or the previous,  word.
          Words  are composed of alphanumeric characters (letters
          and digits).
     cccclllleeeeaaaarrrr-ssssccccrrrreeeeeeeennnn ((((CCCC-llll))))
          Clear the screen leaving the current line at the top of
          the screen.  With an argument, refresh the current line
          without clearing the screen.
     rrrreeeeddddrrrraaaawwww-ccccuuuurrrrrrrreeeennnntttt-lllliiiinnnneeee
          Refresh the current line.

  CCCCoooommmmmmmmaaaannnnddddssss ffffoooorrrr MMMMaaaannnniiiippppuuuullllaaaattttiiiinnnngggg tttthhhheeee HHHHiiiissssttttoooorrrryyyy
     aaaacccccccceeeepppptttt-lllliiiinnnneeee ((((NNNNeeeewwwwlllliiiinnnneeee,,,, RRRReeeettttuuuurrrrnnnn))))
          Accept the line regardless of where the cursor is.   If
          this  line is non-empty, add it to the history list. If
          the line is a modified history line, then  restore  the
          history line to its original state.
     pppprrrreeeevvvviiiioooouuuussss-hhhhiiiissssttttoooorrrryyyy ((((CCCC-pppp))))
          Fetch the previous command from the history list,  mov-
          ing back in the list.
     nnnneeeexxxxtttt-hhhhiiiissssttttoooorrrryyyy ((((CCCC-nnnn))))
          Fetch the next command from the  history  list,  moving
          forward in the list.
     bbbbeeeeggggiiiinnnnnnnniiiinnnngggg-ooooffff-hhhhiiiissssttttoooorrrryyyy ((((MMMM-<<<<))))
          Move to the first line in the history.
     eeeennnndddd-ooooffff-hhhhiiiissssttttoooorrrryyyy ((((MMMM->>>>))))
          Move to the end of the input history,  i.e.,  the  line
          currently being entered.
     rrrreeeevvvveeeerrrrsssseeee-sssseeeeaaaarrrrcccchhhh-hhhhiiiissssttttoooorrrryyyy ((((CCCC-rrrr))))
          Search backward starting at the current line and moving



GNU               Last change: 1998 October 11                  7






C Library Functions                             CLISP-READLINE(3)



          `up'  through  the  history  as  necessary.  This is an
          incremental search.
     ffffoooorrrrwwwwaaaarrrrdddd-sssseeeeaaaarrrrcccchhhh-hhhhiiiissssttttoooorrrryyyy ((((CCCC-ssss))))
          Search forward starting at the current line and  moving
          `down'  through  the  history as necessary.  This is an
          incremental search.
     nnnnoooonnnn-iiiinnnnccccrrrreeeemmmmeeeennnnttttaaaallll-rrrreeeevvvveeeerrrrsssseeee-sssseeeeaaaarrrrcccchhhh-hhhhiiiissssttttoooorrrryyyy ((((MMMM-pppp))))
          Search backward through the  history  starting  at  the
          current  line  using  a  non-incremental  search  for a
          string supplied by the user.
     nnnnoooonnnn-iiiinnnnccccrrrreeeemmmmeeeennnnttttaaaallll-ffffoooorrrrwwwwaaaarrrrdddd-sssseeeeaaaarrrrcccchhhh-hhhhiiiissssttttoooorrrryyyy ((((MMMM-nnnn))))
          Search  forward  through  the  history  using  a   non-
          incremental search for a string supplied by the user.
     hhhhiiiissssttttoooorrrryyyy-sssseeeeaaaarrrrcccchhhh-ffffoooorrrrwwwwaaaarrrrdddd
          Search forward through the history for  the  string  of
          characters  between  the  start of the current line and
          the current cursor position (the  _p_o_i_n_t).   This  is  a
          non-incremental search.
     hhhhiiiissssttttoooorrrryyyy-sssseeeeaaaarrrrcccchhhh-bbbbaaaacccckkkkwwwwaaaarrrrdddd
          Search backward through the history for the  string  of
          characters  between  the  start of the current line and
          the point.  This is a non-incremental search.
     yyyyaaaannnnkkkk-nnnntttthhhh-aaaarrrrgggg ((((MMMM-CCCC-yyyy))))
          Insert the first argument to the previous command (usu-
          ally  the  second  word  on the previous line) at point
          (the current cursor position).   With  an  argument  _n,
          insert  the  _nth  word  from  the previous command (the
          words in the previous command begin with  word  0).   A
          negative  argument inserts the _nth word from the end of
          the previous command.
     yyyyaaaannnnkkkk----llllaaaasssstttt----aaaarrrrgggg ((((MMMM----....,,,, MMMM----____))))
          Insert the last argument to the previous  command  (the
          last  word  of  the  previous  history entry).  With an
          argument, behave exactly like yyyyaaaannnnkkkk----nnnntttthhhh----aaaarrrrgggg.  Successive
          calls  to  yyyyaaaannnnkkkk----llllaaaasssstttt----aaaarrrrgggg  move back through the history
          list, inserting the last argument of each line in turn.

  CCCCoooommmmmmmmaaaannnnddddssss ffffoooorrrr CCCChhhhaaaannnnggggiiiinnnngggg TTTTeeeexxxxtttt
     ddddeeeelllleeeetttteeee-cccchhhhaaaarrrr ((((CCCC-dddd))))
          Delete the character under the cursor.  If point is  at
          the  beginning  of the line, there are no characters in
          the line, and the last character typed was not bound to
          ddddeeeelllleeeetttteeee----cccchhhhaaaarrrr, then return EEEEOOOOFFFF.
     bbbbaaaacccckkkkwwwwaaaarrrrdddd-ddddeeeelllleeeetttteeee-cccchhhhaaaarrrr ((((RRRRuuuubbbboooouuuutttt))))
          Delete the character behind the cursor.  When  given  a
          numeric  argument,  save  the  deleted text on the kill
          ring.
     qqqquuuuooootttteeeedddd-iiiinnnnsssseeeerrrrtttt ((((CCCC-qqqq,,,, CCCC-vvvv))))
          Add the next character that you type to the line verba-
          tim.   This  is  how to insert characters like CCCC----qqqq, for
          example.
     ttttaaaabbbb-iiiinnnnsssseeeerrrrtttt ((((MMMM----TTTTAAAABBBB))))



GNU               Last change: 1998 October 11                  8






C Library Functions                             CLISP-READLINE(3)



          Insert a tab character.
     sssseeeellllffff-iiiinnnnsssseeeerrrrtttt ((((aaaa,,,, bbbb,,,, AAAA,,,, 1111,,,, !!!!,,,, ............))))
          Insert the character typed.
     ttttrrrraaaannnnssssppppoooosssseeee-cccchhhhaaaarrrrssss ((((CCCC-tttt))))
          Drag the character before point forward over the  char-
          acter at point.  Point moves forward as well.  If point
          is at the end of the line, then transpose the two char-
          acters before point.  Negative arguments don't work.
     ttttrrrraaaannnnssssppppoooosssseeee-wwwwoooorrrrddddssss ((((MMMM-tttt))))
          Drag the word behind the cursor past the word in  front
          of the cursor moving the cursor over that word as well.
     uuuuppppccccaaaasssseeee-wwwwoooorrrrdddd ((((MMMM-uuuu))))
          Uppercase the current  (or  following)  word.   With  a
          negative  argument, uppercase the previous word, but do
          not move point.
     ddddoooowwwwnnnnccccaaaasssseeee-wwwwoooorrrrdddd ((((MMMM-llll))))
          Lowercase the current  (or  following)  word.   With  a
          negative  argument, lowercase the previous word, but do
          not move point.
     ccccaaaappppiiiittttaaaalllliiiizzzzeeee-wwwwoooorrrrdddd ((((MMMM-cccc))))
          Capitalize the current (or  following)  word.   With  a
          negative argument, capitalize the previous word, but do
          not move point.

  KKKKiiiilllllllliiiinnnngggg aaaannnndddd YYYYaaaannnnkkkkiiiinnnngggg
     kkkkiiiillllllll-lllliiiinnnneeee ((((CCCC-kkkk))))
          Kill the text from the current cursor position  to  the
          end of the line.
     bbbbaaaacccckkkkwwwwaaaarrrrdddd-kkkkiiiillllllll-lllliiiinnnneeee ((((CCCC-xxxx RRRRuuuubbbboooouuuutttt))))
          Kill backward to the beginning of the line.
     uuuunnnniiiixxxx-lllliiiinnnneeee-ddddiiiissssccccaaaarrrrdddd ((((CCCC-uuuu))))
          Kill backward from point to the beginning of the  line.
          The killed text is saved on the kill-ring.
     kkkkiiiillllllll-wwwwhhhhoooolllleeee-lllliiiinnnneeee
          Kill all characters on  the  current  line,  no  matter
          where the cursor is.
     kkkkiiiillllllll-wwwwoooorrrrdddd ((((MMMM-dddd))))
          Kill from the cursor to the end of the current word, or
          if  between  words,  to the end of the next word.  Word
          boundaries are the same as those used by ffffoooorrrrwwwwaaaarrrrdddd----wwwwoooorrrrdddd.
     bbbbaaaacccckkkkwwwwaaaarrrrdddd-kkkkiiiillllllll-wwwwoooorrrrdddd ((((MMMM-RRRRuuuubbbboooouuuutttt))))
          Kill the word behind the cursor.  Word  boundaries  are
          the same as those used by bbbbaaaacccckkkkwwwwaaaarrrrdddd----wwwwoooorrrrdddd.
     uuuunnnniiiixxxx-wwwwoooorrrrdddd-rrrruuuubbbboooouuuutttt ((((CCCC-wwww))))
          Kill the word behind the cursor, using white space as a
          word  boundary.  The word boundaries are different from
          bbbbaaaacccckkkkwwwwaaaarrrrdddd-kkkkiiiillllllll-wwwwoooorrrrdddd.
     ddddeeeelllleeeetttteeee-hhhhoooorrrriiiizzzzoooonnnnttttaaaallll-ssssppppaaaacccceeee ((((MMMM-\\\\))))
          Delete all spaces and tabs around point.
     kkkkiiiillllllll-rrrreeeeggggiiiioooonnnn
          Kill the text between the point and _m_a_r_k (saved  cursor
          position).  This text is referred to as the _r_e_g_i_o_n.



GNU               Last change: 1998 October 11                  9






C Library Functions                             CLISP-READLINE(3)



     ccccooooppppyyyy-rrrreeeeggggiiiioooonnnn-aaaassss-kkkkiiiillllllll
          Copy the text in the region to the kill buffer.
     ccccooooppppyyyy-bbbbaaaacccckkkkwwwwaaaarrrrdddd-wwwwoooorrrrdddd
          Copy the word before point to  the  kill  buffer.   The
          word boundaries are the same as bbbbaaaacccckkkkwwwwaaaarrrrdddd----wwwwoooorrrrdddd.
     ccccooooppppyyyy-ffffoooorrrrwwwwaaaarrrrdddd-wwwwoooorrrrdddd
          Copy the word following point to the kill buffer.   The
          word boundaries are the same as ffffoooorrrrwwwwaaaarrrrdddd----wwwwoooorrrrdddd.
     yyyyaaaannnnkkkk ((((CCCC-yyyy))))
          Yank the top of the kill ring into the  buffer  at  the
          cursor.
     yyyyaaaannnnkkkk-ppppoooopppp ((((MMMM-yyyy))))
          Rotate the kill ring, and yank the new top.  Only works
          following yyyyaaaannnnkkkk or yyyyaaaannnnkkkk-ppppoooopppp.

  NNNNuuuummmmeeeerrrriiiicccc AAAArrrrgggguuuummmmeeeennnnttttssss
     ddddiiiiggggiiiitttt-aaaarrrrgggguuuummmmeeeennnntttt ((((MMMM-0000,,,, MMMM-1111,,,, ............,,,, MMMM--))))
          Add this digit to the argument already accumulating, or
          start a new argument.  M-- starts a negative argument.
     uuuunnnniiiivvvveeeerrrrssssaaaallll-aaaarrrrgggguuuummmmeeeennnntttt
          This is another way to specify an  argument.   If  this
          command  is  followed by one or more digits, optionally
          with a leading minus  sign,  those  digits  define  the
          argument.   If  the command is followed by digits, exe-
          cuting uuuunnnniiiivvvveeeerrrrssssaaaallll-aaaarrrrgggguuuummmmeeeennnntttt again ends the numeric  argu-
          ment,  but is otherwise ignored.  As a special case, if
          this command is immediately  followed  by  a  character
          that  is  neither  a  digit or minus sign, the argument
          count for the next command is multiplied by four.   The
          argument  count  is  initially  one,  so executing this
          function the first time makes the argument count  four,
          a  second time makes the argument count sixteen, and so
          on.

  CCCCoooommmmpppplllleeeettttiiiinnnngggg
     ccccoooommmmpppplllleeeetttteeee ((((TTTTAAAABBBB))))
          Attempt to perform completion on the text before point.
          The   actual   completion   performed  is  application-
          specific.  CCCClllliiiisssspppp, for instance, attempts completion  of
          symbol  names,  of  function names (if the text is pre-
          fixed by (((( or ####'''') or of filenames (if the text is  pre-
          fixed  by  ####"""").  BBBBaaaasssshhhh, on the other hand, attempts com-
          pletion treating the text as a variable  (if  the  text
          begins  with  $$$$), username (if the text begins with ~~~~),
          hostname (if  the  text  begins  with  @@@@),  or  command
          (including  aliases and functions) in turn.  If none of
          these  produces  a  match,   filename   completion   is
          attempted.   GGGGddddbbbb, finally, allows completion of program
          functions and variables,  and  only  attempts  filename
          completion under certain circumstances.
     ppppoooossssssssiiiibbbblllleeee-ccccoooommmmpppplllleeeettttiiiioooonnnnssss ((((MMMM-????))))
          List the possible completions of the text before point.



GNU               Last change: 1998 October 11                 10






C Library Functions                             CLISP-READLINE(3)



     iiiinnnnsssseeeerrrrtttt-ccccoooommmmpppplllleeeettttiiiioooonnnnssss ((((MMMM-****))))
          Insert all completions of the text  before  point  that
          would have been generated by ppppoooossssssssiiiibbbblllleeee----ccccoooommmmpppplllleeeettttiiiioooonnnnssss.
     mmmmeeeennnnuuuu-ccccoooommmmpppplllleeeetttteeee
          Similar to ccccoooommmmpppplllleeeetttteeee, but replaces the word to  be  com-
          pleted  with  a  single match from the list of possible
          completions.  Repeated execution of mmmmeeeennnnuuuu----ccccoooommmmpppplllleeeetttteeee steps
          through  the  list  of  possible completions, inserting
          each match in turn.  At the end of the list of  comple-
          tions,  the  bell  is  rung  and  the  original text is
          restored.  An argument of _n moves _n  positions  forward
          in the list of matches; a negative argument may be used
          to move backward through the  list.   This  command  is
          intended to be bound to TTTTAAAABBBB, but is unbound by default.

  KKKKeeeeyyyybbbbooooaaaarrrrdddd MMMMaaaaccccrrrroooossss
     ssssttttaaaarrrrtttt-kkkkbbbbdddd-mmmmaaaaccccrrrroooo ((((CCCC-xxxx (((())))
          Begin saving the characters typed into the current key-
          board macro.
     eeeennnndddd-kkkkbbbbdddd-mmmmaaaaccccrrrroooo ((((CCCC-xxxx ))))))))
          Stop saving the characters typed into the current  key-
          board macro and store the definition.
     ccccaaaallllllll-llllaaaasssstttt-kkkkbbbbdddd-mmmmaaaaccccrrrroooo ((((CCCC-xxxx eeee))))
          Re-execute the last keyboard macro defined,  by  making
          the  characters  in the macro appear as if typed at the
          keyboard.

  MMMMiiiisssscccceeeellllllllaaaannnneeeeoooouuuussss
     rrrreeee-rrrreeeeaaaadddd-iiiinnnniiiitttt-ffffiiiilllleeee ((((CCCC-xxxx CCCC-rrrr))))
          Read in the contents of the _i_n_p_u_t_r_c  file,  and  incor-
          porate  any  bindings  or  variable  assignments  found
          there.
     aaaabbbboooorrrrtttt ((((CCCC-gggg))))
          Abort  the  current  editing  command  and   ring   the
          terminal's bell (subject to the setting of bbbbeeeellllllll-ssssttttyyyylllleeee).
     ddddoooo-uuuuppppppppeeeerrrrccccaaaasssseeee-vvvveeeerrrrssssiiiioooonnnn ((((MMMM-aaaa,,,, MMMM-bbbb,,,, MMMM-_x,,,, ............))))
          If the metafied character _x is lowercase, run the  com-
          mand that is bound to the corresponding uppercase char-
          acter.
     pppprrrreeeeffffiiiixxxx-mmmmeeeettttaaaa ((((EEEESSSSCCCC))))
          Metafy the next character typed.  EEEESSSSCCCC ffff  is  equivalent
          to MMMMeeeettttaaaa-ffff.
     uuuunnnnddddoooo ((((CCCC-____,,,, CCCC-xxxx CCCC-uuuu))))
          Incremental undo, separately remembered for each line.
     rrrreeeevvvveeeerrrrtttt-lllliiiinnnneeee ((((MMMM-rrrr))))
          Undo all changes made to this line.  This is like  exe-
          cuting the uuuunnnnddddoooo command enough times to return the line
          to its initial state.
     ttttiiiillllddddeeee-eeeexxxxppppaaaannnndddd ((((MMMM-~~~~))))
          Perform tilde expansion on the current word.
     sssseeeetttt-mmmmaaaarrrrkkkk ((((CCCC-@@@@,,,, MMMM----<<<<ssssppppaaaacccceeee>>>>))))
          Set the mark  to  the  current  point.   If  a  numeric



GNU               Last change: 1998 October 11                 11






C Library Functions                             CLISP-READLINE(3)



          argument is supplied, the mark is set to that position.
     eeeexxxxcccchhhhaaaannnnggggeeee-ppppooooiiiinnnntttt-aaaannnndddd-mmmmaaaarrrrkkkk ((((CCCC-xxxx CCCC-xxxx))))
          Swap the point with the mark.  The current cursor posi-
          tion  is  set to the saved position, and the old cursor
          position is saved as the mark.
     cccchhhhaaaarrrraaaacccctttteeeerrrr-sssseeeeaaaarrrrcccchhhh ((((CCCC-]]]]))))
          A character is read and point  is  moved  to  the  next
          occurrence   of   that  character.   A  negative  count
          searches for previous occurrences.
     cccchhhhaaaarrrraaaacccctttteeeerrrr-sssseeeeaaaarrrrcccchhhh-bbbbaaaacccckkkkwwwwaaaarrrrdddd ((((MMMM-CCCC-]]]]))))
          A character is read and point is moved to the  previous
          occurrence   of   that  character.   A  negative  count
          searches for subsequent occurrences.
     iiiinnnnsssseeeerrrrtttt-ccccoooommmmmmmmeeeennnntttt ((((MMMM-####))))
          The value of the  readline  ccccoooommmmmmmmeeeennnntttt-bbbbeeeeggggiiiinnnn  variable  is
          inserted  at the beginning of the current line, and the
          line is accepted as if a newline had been typed.   This
          makes the current line a shell comment.
     dddduuuummmmpppp-ffffuuuunnnnccccttttiiiioooonnnnssss
          Print all of the functions and their  key  bindings  to
          the  readline  output stream.  If a numeric argument is
          supplied, the output is formatted in such a way that it
          can be made part of an _i_n_p_u_t_r_c file.
     dddduuuummmmpppp-vvvvaaaarrrriiiiaaaabbbblllleeeessss
          Print all of the settable variables and their values to
          the  readline  output stream.  If a numeric argument is
          supplied, the output is formatted in such a way that it
          can be made part of an _i_n_p_u_t_r_c file.
     dddduuuummmmpppp-mmmmaaaaccccrrrroooossss
          Print all of the readline key sequences bound to macros
          and  the  strings they ouput.  If a numeric argument is
          supplied, the output is formatted in such a way that it
          can be made part of an _i_n_p_u_t_r_c file.
     eeeemmmmaaaaccccssss-eeeeddddiiiittttiiiinnnngggg-mmmmooooddddeeee ((((CCCC-eeee))))
          When in vvvviiii editing mode, this causes a switch to  eeeemmmmaaaaccccssss
          editing mode.
     vvvviiii-eeeeddddiiiittttiiiinnnngggg-mmmmooooddddeeee ((((MMMM-CCCC-jjjj))))
          When in eeeemmmmaaaaccccssss editing mode, this causes a switch to  vvvviiii
          editing mode.

DDDDEEEEFFFFAAAAUUUULLLLTTTT KKKKEEEEYYYY BBBBIIIINNNNDDDDIIIINNNNGGGGSSSS
     The following is a list of the default emacs  and  vi  bind-
     ings.   Characters  with  the  8th  bit  set  are written as
     M-<character>, and are referred to as  _m_e_t_a_f_i_e_d  characters.
     The  printable ASCII characters not mentioned in the list of
     emacs standard bindings are bound to the  _s_e_l_f-_i_n_s_e_r_t  func-
     tion,  which just inserts the given character into the input
     line.  In vi insertion mode, all characters not specifically
     mentioned  are bound to _s_e_l_f-_i_n_s_e_r_t.  Characters assigned to
     signal generation by _s_t_t_y(1) or the terminal driver, such as
     C-Z  or  C-C,  retain  that  function.  Upper and lower case
     _m_e_t_a_f_i_e_d characters are bound to the same  function  in  the



GNU               Last change: 1998 October 11                 12






C Library Functions                             CLISP-READLINE(3)



     emacs  mode  meta  keymap.   The  remaining  characters  are
     unbound, which causes readline to ring the bell (subject  to
     the setting of the bbbbeeeellllllll-ssssttttyyyylllleeee variable).

  EEEEmmmmaaaaccccssss MMMMooooddddeeee
           Emacs Standard bindings

           "C-@"                    set-mark
           "C-A"                    beginning-of-line
           "C-B"                    backward-char
           "C-D"                    delete-char
           "C-E"                    end-of-line
           "C-F"                    forward-char
           "C-G"                    abort
           "C-H"                    backward-delete-char
           "C-I"                    complete
           "C-J"                    accept-line
           "C-K"                    kill-line
           "C-L"                    clear-screen
           "C-M"                    accept-line
           "C-N"                    next-history
           "C-P"                    previous-history
           "C-Q"                    quoted-insert
           "C-R"                    reverse-search-history
           "C-S"                    forward-search-history
           "C-T"                    transpose-chars
           "C-U"                    unix-line-discard
           "C-V"                    quoted-insert
           "C-W"                    unix-word-rubout
           "C-Y"                    yank
           "C-]"                    character-search
           "C-_"                    undo
           " " to "/"               self-insert
           "0"  to "9"              self-insert
           ":"  to "~"              self-insert
           "C-?"                    backward-delete-char

           Emacs Meta bindings

           "M-C-G"                  abort
           "M-C-H"                  backward-kill-word
           "M-C-I"                  tab-insert
           "M-C-J"                  vi-editing-mode
           "M-C-M"                  vi-editing-mode
           "M-C-R"                  revert-line
           "M-C-Y"                  yank-nth-arg
           "M-C-["                  complete
           "M-C-]"                  character-search-backward
           "M-space"                set-mark
           "M-#"                    insert-comment
           "M-&"                    tilde-expand
           "M-*"                    insert-completions



GNU               Last change: 1998 October 11                 13






C Library Functions                             CLISP-READLINE(3)



           "M--"                    digit-argument
           "M-."                    yank-last-arg
           "M-0"                    digit-argument
           "M-1"                    digit-argument
           "M-2"                    digit-argument
           "M-3"                    digit-argument
           "M-4"                    digit-argument
           "M-5"                    digit-argument
           "M-6"                    digit-argument
           "M-7"                    digit-argument
           "M-8"                    digit-argument
           "M-9"                    digit-argument
           "M-<"                    beginning-of-history
           "M-="                    possible-completions
           "M->"                    end-of-history
           "M-?"                    possible-completions
           "M-B"                    backward-word
           "M-C"                    capitalize-word
           "M-D"                    kill-word
           "M-F"                    forward-word
           "M-L"                    downcase-word
           "M-N"                    non-incremental-forward-search-history
           "M-P"                    non-incremental-reverse-search-history
           "M-R"                    revert-line
           "M-T"                    transpose-words
           "M-U"                    upcase-word
           "M-Y"                    yank-pop
           "M-\"                    delete-horizontal-space
           "M-~"                    tilde-expand
           "M-C-?"                  backward-delete-word
           "M-_"                    yank-last-arg

           Emacs Control-X bindings

           "C-XC-G"                 abort
           "C-XC-R"                 re-read-init-file
           "C-XC-U"                 undo
           "C-XC-X"                 exchange-point-and-mark
           "C-X("                   start-kbd-macro
           "C-X)"                   end-kbd-macro
           "C-XE"                   call-last-kbd-macro
           "C-XC-?"                 backward-kill-line


  VVVVIIII MMMMooooddddeeee bbbbiiiinnnnddddiiiinnnnggggssss
           VI Insert Mode functions

           "C-D"                    vi-eof-maybe
           "C-H"                    backward-delete-char
           "C-I"                    complete
           "C-J"                    accept-line
           "C-M"                    accept-line



GNU               Last change: 1998 October 11                 14






C Library Functions                             CLISP-READLINE(3)



           "C-R"                    reverse-search-history
           "C-S"                    forward-search-history
           "C-T"                    transpose-chars
           "C-U"                    unix-line-discard
           "C-V"                    quoted-insert
           "C-W"                    unix-word-rubout
           "C-Y"                    yank
           "C-["                    vi-movement-mode
           "C-_"                    undo
           " " to "~"               self-insert
           "C-?"                    backward-delete-char

           VI Command Mode functions

           "C-D"                    vi-eof-maybe
           "C-E"                    emacs-editing-mode
           "C-G"                    abort
           "C-H"                    backward-char
           "C-J"                    accept-line
           "C-K"                    kill-line
           "C-L"                    clear-screen
           "C-M"                    accept-line
           "C-N"                    next-history
           "C-P"                    previous-history
           "C-Q"                    quoted-insert
           "C-R"                    reverse-search-history
           "C-S"                    forward-search-history
           "C-T"                    transpose-chars
           "C-U"                    unix-line-discard
           "C-V"                    quoted-insert
           "C-W"                    unix-word-rubout
           "C-Y"                    yank
           " "                      forward-char
           "#"                      insert-comment
           "$"                      end-of-line
           "%"                      vi-match
           "&"                      vi-tilde-expand
           "*"                      vi-complete
           "+"                      next-history
           ","                      vi-char-search
           "-"                      previous-history
           "."                      vi-redo
           "/"                      vi-search
           "0"                      beginning-of-line
           "1" to "9"               vi-arg-digit
           ";"                      vi-char-search
           "="                      vi-complete
           "?"                      vi-search
           "A"                      vi-append-eol
           "B"                      vi-prev-word
           "C"                      vi-change-to
           "D"                      vi-delete-to



GNU               Last change: 1998 October 11                 15






C Library Functions                             CLISP-READLINE(3)



           "E"                      vi-end-word
           "F"                      vi-char-search
           "G"                      vi-fetch-history
           "I"                      vi-insert-beg
           "N"                      vi-search-again
           "P"                      vi-put
           "R"                      vi-replace
           "S"                      vi-subst
           "T"                      vi-char-search
           "U"                      revert-line
           "W"                      vi-next-word
           "X"                      backward-delete-char
           "Y"                      vi-yank-to
           "\"                      vi-complete
           "^"                      vi-first-print
           "_"                      vi-yank-arg
           "`"                      vi-goto-mark
           "a"                      vi-append-mode
           "b"                      vi-prev-word
           "c"                      vi-change-to
           "d"                      vi-delete-to
           "e"                      vi-end-word
           "f"                      vi-char-search
           "h"                      backward-char
           "i"                      vi-insertion-mode
           "j"                      next-history
           "k"                      prev-history
           "l"                      forward-char
           "m"                      vi-set-mark
           "n"                      vi-search-again
           "p"                      vi-put
           "r"                      vi-change-char
           "s"                      vi-subst
           "t"                      vi-char-search
           "u"                      undo
           "w"                      vi-next-word
           "x"                      vi-delete
           "y"                      vi-yank-to
           "|"                      vi-column
           "~"                      vi-change-case

SSSSEEEEEEEE AAAALLLLSSSSOOOO
     _T_h_e _G_n_u _R_e_a_d_l_i_n_e _L_i_b_r_a_r_y, Brian Fox
     _T_h_e _G_n_u _H_i_s_t_o_r_y _L_i_b_r_a_r_y, Brian Fox
     _b_a_s_h(1)

FFFFIIIILLLLEEEESSSS
     ~/._i_n_p_u_t_r_c
          Individual rrrreeeeaaaaddddlllliiiinnnneeee initialization file

AAAAUUUUTTTTHHHHOOOORRRRSSSS
     Brian Fox, Free Software Foundation (primary author)



GNU               Last change: 1998 October 11                 16






C Library Functions                             CLISP-READLINE(3)



     bfox@ai.MIT.Edu

     Chet Ramey, Case Western Reserve University
     chet@ins.CWRU.Edu

     Bruno Haible
     haible@clisp.cons.org

BBBBUUUUGGGG RRRREEEEPPPPOOOORRRRTTTTSSSS
     If you find a bug in rrrreeeeaaaaddddlllliiiinnnneeee,,,, you should  report  it.  Send
     mail to _h_a_i_b_l_e@_c_l_i_s_p._c_o_n_s._o_r_g.

BBBBUUUUGGGGSSSS
     It's too big and too slow.









































GNU               Last change: 1998 October 11                 17



