/* Libart_LGPL - library of basic graphic primitives
 * Copyright (C) 1998 Raph Levien
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __ART_VPATHO_PIXBUF_H__
#define __ART_VPATHO_PIXBUF_H__

#include <libart_lgpl/art_misc.h>
#include <libart_lgpl/art_vpath.h>
#include <libart_lgpl/art_pixbuf.h>

/* create a vpath outline from the objects contained in an RGBA pixbuf */

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _ArtTriplet ArtTriplet;
struct _ArtTriplet
{
  double ax, ay;
  double bx, by;
  double cx, cy;
};


/* feed only ART_PIX_RGB images with alpha into this function,
 * this will return NULL, for invalid or completely empty pixbufs
 */
ArtVpath* art_vpath_outline_from_pixbuf (const ArtPixBuf *pixbuf,
					 int              alpha_threshold);

int
art_affine_from_triplets (const ArtTriplet *src_triplet,
			  const ArtTriplet *transformed_triplet,
			  double matrix[6]);

double art_vpath_area (const ArtVpath *vpath);
       

#ifdef __cplusplus
}
#endif

#endif /* __ART_VPATHO_PIXBUF_H__ */
