/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __PTRBUF_H__
#define __PTRBUF_H__

#include "buffer.h"

#define GIMP_PTR_BUFFER(b)        ((GimpPtrBuffer*)(b))
#define GIMP_PTR_BUFFER_CLASS(b)  ((GimpPtrBufferClass*)(b))

typedef struct _GimpPtrBuffer        GimpPtrBuffer;
typedef struct _GimpPtrBufferClass   GimpPtrBufferClass;


struct _GimpPtrBuffer
{
  /* we are a GimpBuffer subclass */
  GimpBuffer buffer;

  /* this needs to be a GimpMemPtr, can this be fixed? */
  GimpMemPtr yuck;
};

struct _GimpPtrBufferClass
{
  /* we are a GimpBuffer subclass */
  GimpBufferClass parent_class;

  /* no class specific extensions */
};


/* public methods */

GimpPtrBuffer *
gimp_ptr_buffer_new (void * ptr,
                     Tag    tag,
                     gint   x_len,
                     gint   x_period,
                     gint   x_offset,
                     gint   y_len,
                     gint   y_period,
                     gint   y_offset);

#endif /* __PTRBUF_H__ */
