#include <stdio.h>
#include <string.h>
#include <math.h>
#include <gtk/gtk.h>
#include "gtkglwindow.h"


static void glinit();
static void gldraw( GtkWidget *, gpointer );
static void glresize( GtkWidget *, GtkAllocation *, gpointer );
static gint glmotion( GtkWidget *, GdkEventMotion * );
static gint glbutton( GtkWidget *, GdkEventButton * );
static void destroy_event( GtkWidget *, gpointer );
static void setCamera( int dx, int dy );

static double vertices[][3] =
{
    {  1,  1,  1 },
    { -1,  1,  1 },
    { -1, -1,  1 },
    {  1, -1,  1 },
    {  1,  1, -1 },
    { -1,  1, -1 },
    { -1, -1, -1 },
    {  1, -1, -1 }
};

static int faces[][4] =
{
    { 0, 1, 2, 3 },
    { 1, 0, 4, 5 },
    { 2, 1, 5, 6 },
    { 3, 2, 6, 7 },
    { 0, 3, 7, 4 },
    { 7, 6, 5, 4 }
};

static double normals[][3] =
{
    {  0,  0,  1 },
    {  0,  1,  0 },
    { -1,  0,  0 },
    {  0, -1,  0 },
    {  1,  0,  0 },
    {  0,  0, -1 }
};
	

static GtkWidget *glWindow;
static int lastX = 0;
static int lastY = 0;

void
main( int argc, char **argv )
{
    GtkWidget *window;

    GtkWidget *menu;
    GtkWidget *menu_bar;
    GtkWidget *root_menu;
    GtkWidget *menu_item;
    GtkWidget *vbox;
    GtkWidget *button;
    int attrib[] = { GLX_RGBA,
		     GLX_RED_SIZE, 1,
		     GLX_GREEN_SIZE, 1,                 
		     GLX_BLUE_SIZE, 1,
		     GLX_DOUBLEBUFFER,
		     None };

    gtk_init( &argc, &argv );

    window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
    gtk_window_set_title( GTK_WINDOW(window), "Cube" );
    gtk_widget_set_usize( window, 400, 400 );
    gtk_signal_connect( GTK_OBJECT(window), "delete_event",
			(GtkSignalFunc) gtk_exit, NULL );

    root_menu = gtk_menu_item_new_with_label( "File" );
    gtk_widget_show( root_menu );    
    menu = gtk_menu_new();
    gtk_menu_item_set_submenu( GTK_MENU_ITEM(root_menu), menu );
    menu_item = gtk_menu_item_new_with_label( "Quit" );
    gtk_menu_append( GTK_MENU(menu), menu_item );
    gtk_signal_connect( GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(gtk_exit), NULL );
    gtk_widget_show( menu_item );
    menu_bar = gtk_menu_bar_new();
    gtk_menu_bar_append( GTK_MENU_BAR(menu_bar), root_menu );
    gtk_widget_show( menu_bar );

    /* GL window */
    glWindow = gtk_glwindow_new( attrib, 9, 0 );
    gtk_widget_set_events( glWindow,
			   GDK_BUTTON_MOTION_MASK |
			   GDK_BUTTON1_MOTION_MASK |
			   GDK_BUTTON2_MOTION_MASK |
			   GDK_BUTTON3_MOTION_MASK |
			   GDK_BUTTON_PRESS_MASK |
			   GDK_BUTTON_RELEASE_MASK );
    gtk_widget_show( glWindow );
    gtk_signal_connect( GTK_OBJECT(glWindow), "glinit",
			GTK_SIGNAL_FUNC(glinit), 0 );
    gtk_signal_connect( GTK_OBJECT(glWindow), "gldraw",
			GTK_SIGNAL_FUNC(gldraw), 0 );
    gtk_signal_connect( GTK_OBJECT(glWindow), "glresize",
			GTK_SIGNAL_FUNC(glresize), 0 );
    gtk_signal_connect( GTK_OBJECT(glWindow), "motion_notify_event",
			GTK_SIGNAL_FUNC(glmotion), 0 );
    gtk_signal_connect( GTK_OBJECT(glWindow), "button_press_event",
			GTK_SIGNAL_FUNC(glbutton), 0 );
    gtk_signal_connect( GTK_OBJECT(glWindow), "button_release_event",
			GTK_SIGNAL_FUNC(glbutton), 0 );

    /* pack it all together */
    vbox = gtk_vbox_new( FALSE, 1 );
    gtk_container_border_width( GTK_CONTAINER(vbox), 1 );
    gtk_container_add( GTK_CONTAINER(window), vbox );
    gtk_box_pack_start( GTK_BOX(vbox), menu_bar, FALSE, TRUE, 0 );
    gtk_box_pack_start( GTK_BOX(vbox), glWindow, TRUE, TRUE, 0 );
    gtk_widget_show( vbox );

    gtk_widget_show( window );
    gtk_main();
}


void
glinit( GtkGLWindow *w )
{
    GLfloat ambient[] = { 0.0, 0.0, 0.0, 1.0 };
    GLfloat diffuse[] = { 1.0, 1.0, 1.0, 1.0 };
    GLfloat specular[] = { 1.0, 1.0, 1.0, 1.0 };
    GLfloat position[] = { 0.0, 3.0, 3.0, 0.0 };
    GLfloat lmodel_ambient[] = { 0.2, 0.2, 0.2, 1.0 };
    GLfloat local_view[] = { 0.0 };
    GLfloat mat[4];
    
    /**** set lighting parameters ****/
    glLightfv( GL_LIGHT0, GL_AMBIENT, ambient );
    glLightfv( GL_LIGHT0, GL_DIFFUSE, diffuse );
    glLightfv( GL_LIGHT0, GL_POSITION, position );
    glLightModelfv( GL_LIGHT_MODEL_AMBIENT, lmodel_ambient );
    glLightModelfv( GL_LIGHT_MODEL_LOCAL_VIEWER, local_view );

    glEnable( GL_CULL_FACE );
    glEnable( GL_LIGHTING );
    glEnable( GL_LIGHT0 );
    glEnable( GL_DEPTH_TEST );
    glDepthFunc( GL_LESS );

    glMatrixMode( GL_MODELVIEW );
    glLoadIdentity();
    glTranslated( 0, 0, -5 );    
}

void
glresize( GtkWidget *w, GtkAllocation *alloc, gpointer data )
{
    glViewport( 0, 0, alloc->width, alloc->height );
    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    glFrustum( -.2, .2, -.2, .2, .2, 200 );
}
	    
void
gldraw( GtkWidget *w, gpointer data )
{
    int i, j;
    
    glClearColor( 0, 0, 0, 0 );
    glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

    for( i=0; i<6; i++ )
    {
	glBegin( GL_POLYGON );
	glNormal3dv( normals[i] );
	for( j=0; j<4; j++ )
	    glVertex3dv( vertices[faces[i][j]] );
	glEnd();
    }
}

gint
glbutton( GtkWidget *w, GdkEventButton *e )
{
    int b1 = e->state & GDK_BUTTON1_MASK;
    int b2 = e->state & GDK_BUTTON2_MASK;
    int b3 = e->state & GDK_BUTTON3_MASK;

    if( e->button==1 && !b2 && !b3 )
    {
	lastX = (int) e->x;
	lastY = (int) e->y;
    }
}

gint
glmotion( GtkWidget *w, GdkEventMotion *e )
{
    int b1 = e->state & GDK_BUTTON1_MASK;
    int b2 = e->state & GDK_BUTTON2_MASK;
    int b3 = e->state & GDK_BUTTON3_MASK;

    if( b1 && !b2 && !b3 )
    {
	int dx = e->x - lastX;
	int dy = e->y - lastY;
	
	lastX = e->x;
	lastY = e->y;
	setCamera( dx, dy );
	gtk_glwindow_draw( GTK_GLWINDOW(glWindow) );
    }
}

/* this doesn't work the way I wanted it to.  I know how to fix
   it, but I'm too lazy to do it. */
void
setCamera( int dx, int dy )
{
    const double GAIN_PHI = 1.8;
    const double GAIN_THETA = 1.2;

    double phi   = dx*GAIN_THETA;
    double theta = dy*GAIN_PHI;

    glMatrixMode( GL_MODELVIEW );
    glRotated( phi, 0, 1, 0 );
    glRotated( theta, 1, 0, 0 );
}
