/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __CSL_SAMPLE_H__
#define __CSL_SAMPLE_H__


#include	<csl/csldefs.h>
#include	<csl/cslmain.h>
#include	<csl/cslutils.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/**
 * An opaque type used as a handle to API functions that work with samples.
 *
 * @short Sample type.
 */
typedef	struct _CslSample	CslSample;


/* --- CSL Sample API --- */
CslErrorType	csl_sample_new		  (CslDriver	  *driver,
					   const char     *name,
					   const char     *role,
					   const char     *title,
					   CslSample	 **sample_p);
void		csl_sample_release	  (CslSample	  *sample);
CslErrorType	csl_sample_new_from_file  (CslDriver	  *driver, 
					   const char	  *filename,
					   const char     *role,
					   const char     *title,
					   CslSample     **sample_p);
CslErrorType    csl_sample_new_from_cache (CslDriver      *driver,
					   const char     *name,
					   const char     *role,
					   const char     *title,
					   CslSample     **sample_p);
int		csl_sample_write	  (CslSample	  *sample,
				 	   unsigned int    n_bytes,
				 	   void           *bytes);
CslErrorType	csl_sample_write_done	  (CslSample	  *sample);
CslErrorType	csl_sample_cache_add	  (CslSample	  *sample);
CslErrorType	csl_sample_cache_remove	  (CslSample	  *sample);

/* palying samples */
CslErrorType	csl_sample_play		  (CslSample	  *sample);
CslBool		csl_sample_is_playing	  (CslSample	  *sample);
CslErrorType	csl_sample_stop		  (CslSample	  *sample);
CslErrorType	csl_sample_wait_done	  (CslSample	  *sample);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __CSL_SAMPLE_H__ */

/* vim:ts=8:sw=2:sts=2
 */
