
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bseproject.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bseproject.h>
#include <bse/bsestorage.h>
#include <bse/bsesong.h>
#include <bse/bseundostack.h>
#include <bse/bsewaverepo.h>
#include <bse/bsecsynth.h>
#include <bse/bsemidisynth.h>
#include <bse/bsedatapocket.h>
#include <bse/bsemidifile.h>


#line 33 "bseproject.proc"


/* --- is-playing --- */
static void
is_playing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 35 "bseproject.proc"
 {
#line 37 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_playing", "Is Playing", "Whether the project is currently playing songs or synths",
                          FALSE, SFI_PARAM_STANDARD);
#line 41 "bseproject.proc"
}  }
static BseErrorType
#line 41 "bseproject.proc"
is_playing_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 44 "bseproject.proc"
{
#line 45 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 48 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 52 "bseproject.proc"
  
  
#line 54 "bseproject.proc"
  
  sfi_value_set_bool (out_values++, project->state == BSE_PROJECT_PLAYING);
  
  return BSE_ERROR_NONE;
}

/* --- is-active --- */
static void
is_active_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 60 "bseproject.proc"
 {
#line 62 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_active", NULL, "Whether the project is currently producing sound",
                          FALSE, SFI_PARAM_STANDARD);
#line 66 "bseproject.proc"
}  }
static BseErrorType
#line 66 "bseproject.proc"
is_active_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 69 "bseproject.proc"
{
#line 70 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 73 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 77 "bseproject.proc"
  
  
#line 79 "bseproject.proc"
  
  sfi_value_set_bool (out_values++, project->state != BSE_PROJECT_INACTIVE);
  
  return BSE_ERROR_NONE;
}

/* --- import-midi-file --- */
static void
import_midi_file_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 85 "bseproject.proc"
 {
#line 87 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("file-name", "MIDI File", "MIDI file name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_enum ("error", "Error", "Error indicating possible failures",
                               BSE_ERROR_NONE, BSE_TYPE_ERROR_TYPE,
                               SFI_PARAM_STANDARD);
#line 94 "bseproject.proc"
}  }
static BseErrorType
#line 94 "bseproject.proc"
import_midi_file_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 97 "bseproject.proc"
{
#line 98 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *file_name = sfi_value_get_string (in_values++);
  BseMidiFile *smf;
  BseErrorType error;
  
#line 104 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 108 "bseproject.proc"
  
  smf = bse_midi_file_load (file_name, &error);
  if (!error)
    {
      BseUndoStack *ustack = bse_item_undo_open (project, "import-midi-file");
      gchar *basename = g_path_get_basename (file_name);
      BseSong *song;
      bse_item_exec (project, "create-song", basename, &song);
      g_free (basename);
      bse_midi_file_setup_song (smf, song);
      bse_item_undo_close (ustack);
#if 1
      bse_undo_stack_clear (project->undo_stack);
      bse_undo_stack_clear (project->redo_stack);
      g_object_notify (project, "dirty");
#endif
    }
  if (smf)
    bse_midi_file_free (smf);
  g_printerr ("error: %u\n", error);
  
#line 129 "bseproject.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- restore-from-file --- */
static void
restore_from_file_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 135 "bseproject.proc"
 {
#line 137 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("file-name", "File", "Source file name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_enum ("error", "Error", "Error indicating possible failures",
                               BSE_ERROR_NONE, BSE_TYPE_ERROR_TYPE,
                               SFI_PARAM_STANDARD);
#line 144 "bseproject.proc"
}  }
static BseErrorType
#line 144 "bseproject.proc"
restore_from_file_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 147 "bseproject.proc"
{
#line 148 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *file_name = sfi_value_get_string (in_values++);
  BseErrorType error;
  
#line 153 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 157 "bseproject.proc"
  
  if (!project->in_undo && !project->in_redo)
    {
      BseStorage *storage = g_object_new (BSE_TYPE_STORAGE, NULL);
      error = bse_storage_input_file (storage, file_name);
      if (!error)
        error = bse_project_restore (project, storage);
      bse_storage_reset (storage);
      g_object_unref (storage);
      bse_undo_stack_clear (project->undo_stack);
      bse_undo_stack_clear (project->redo_stack);
      g_object_notify (project, "dirty");
    }
  else
    error = BSE_ERROR_PROC_BUSY;

#line 173 "bseproject.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- store-bse --- */
static void
store_bse_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 179 "bseproject.proc"
 {
#line 182 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("super", "Super", NULL,
                                 BSE_TYPE_SUPER, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("file-name", "File", "Destination file name",
                            NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_bool ("self-contained", "Self Contained",
                          "Whether references to other objects (e.g. samples) should "
                          "be stored or whether to include everything in a self-contained .bse file",
                          FALSE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "Error indicating possible failures",
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
                                SFI_PARAM_STANDARD);
#line 195 "bseproject.proc"
}  }
static BseErrorType
#line 195 "bseproject.proc"
store_bse_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 198 "bseproject.proc"
{
#line 199 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  BseSuper *super = bse_value_get_object (in_values++);
  gchar *file_name = sfi_value_get_string (in_values++);
  gboolean self_contained = sfi_value_get_bool (in_values++);
  BseErrorType error;
  
#line 206 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  if (super && BSE_ITEM (super)->parent != BSE_ITEM (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

  error = bse_project_store_bse (project, super, file_name, self_contained);
  
#line 214 "bseproject.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- create-song --- */
static void
create_song_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 220 "bseproject.proc"
 {
#line 222 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "Song name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("song", "Song", "The new song",
                                 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
#line 228 "bseproject.proc"
}  }
static BseErrorType
#line 228 "bseproject.proc"
create_song_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 231 "bseproject.proc"
{
#line 232 "bseproject.proc"
  
  BseContainer *container = bse_value_get_object (in_values++);
  const gchar *name       = sfi_value_get_string (in_values++);
  BseUndoStack *ustack;
  BseItem *child;

#line 238 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (container))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 242 "bseproject.proc"
  
  ustack = bse_item_undo_open (container, "create-song");
  child = bse_container_new_child (container, BSE_TYPE_SONG, NULL);
  if (name)
    bse_item_set (child, "uname", name, NULL);
  bse_item_push_undo_proc (container, "remove-snet", child);
  bse_item_undo_close (ustack);

#line 250 "bseproject.proc"
  
  bse_value_set_object (out_values++, child);

  return BSE_ERROR_NONE;
}

/* --- get-wave-repo --- */
static void
get_wave_repo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 256 "bseproject.proc"
 {
#line 258 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("wrepo", "Wave Repo", "The project's unique wave repo",
                                 BSE_TYPE_WAVE_REPO, SFI_PARAM_STANDARD);
#line 262 "bseproject.proc"
}  }
static BseErrorType
#line 262 "bseproject.proc"
get_wave_repo_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 265 "bseproject.proc"
{
#line 266 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  BseWaveRepo *wrepo = NULL;
  
#line 270 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 274 "bseproject.proc"
  
  wrepo = bse_project_get_wave_repo (project);
  
#line 277 "bseproject.proc"
  
  bse_value_set_object (out_values++, wrepo);
  
  return BSE_ERROR_NONE;
}

/* --- get-data-pocket --- */
static void
get_data_pocket_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 283 "bseproject.proc"
 {
#line 285 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "Name of the data pocket",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket",
                                 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
#line 291 "bseproject.proc"
}  }
static BseErrorType
#line 291 "bseproject.proc"
get_data_pocket_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 294 "bseproject.proc"
{
#line 295 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *name = sfi_value_get_string (in_values++);
  BseItem *item;
  
#line 300 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 304 "bseproject.proc"
  
  item = bse_project_lookup_typed_item (project, BSE_TYPE_DATA_POCKET, name);
  if (!item)
    item = bse_container_new_child (BSE_CONTAINER (project), BSE_TYPE_DATA_POCKET,
                                    "uname", name,
                                    NULL);
  
#line 311 "bseproject.proc"
  
  bse_value_set_object (out_values++, item);
  
  return BSE_ERROR_NONE;
}

/* --- create-csynth --- */
static void
create_csynth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 317 "bseproject.proc"
 {
#line 319 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "Synth network name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("csynth", "Synthesizer Network", "New synth network",
                                 BSE_TYPE_CSYNTH, SFI_PARAM_STANDARD);
#line 325 "bseproject.proc"
}  }
static BseErrorType
#line 325 "bseproject.proc"
create_csynth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 328 "bseproject.proc"
{
#line 329 "bseproject.proc"
  
  BseContainer *container = bse_value_get_object (in_values++);
  const gchar *name       = sfi_value_get_string (in_values++);
  BseUndoStack *ustack;
  BseItem *child;
  
#line 335 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (container))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 339 "bseproject.proc"
  
  ustack = bse_item_undo_open (container, "create-csynth");
  child = bse_container_new_child (container, BSE_TYPE_CSYNTH, NULL);
  if (name)
    bse_item_set (child, "uname", name, NULL);
  bse_item_push_undo_proc (container, "remove-snet", child);
  bse_item_undo_close (ustack);
  
#line 347 "bseproject.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- create-midi-synth --- */
static void
create_midi_synth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 353 "bseproject.proc"
 {
#line 355 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "MIDI synth name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("midi_synth", "MIDI Synthesizer", "New MIDI synth",
                                 BSE_TYPE_MIDI_SYNTH, SFI_PARAM_STANDARD);
#line 361 "bseproject.proc"
}  }
static BseErrorType
#line 361 "bseproject.proc"
create_midi_synth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 364 "bseproject.proc"
{
#line 365 "bseproject.proc"
  
  BseContainer *container = bse_value_get_object (in_values++);
  gchar *name             = sfi_value_get_string (in_values++);
  BseUndoStack *ustack;
  BseItem *child;

#line 371 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (container))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 375 "bseproject.proc"
  
  ustack = bse_item_undo_open (container, "create-midi-synth");
  child = bse_container_new_child (container, BSE_TYPE_MIDI_SYNTH, NULL);
  if (name)
    bse_item_set (child, "uname", name, NULL);
  bse_item_push_undo_proc (container, "remove-snet", child);
  bse_item_undo_close (ustack);

#line 383 "bseproject.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- remove-snet --- */
static void
remove_snet_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 389 "bseproject.proc"
 {
#line 391 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("snet", "SNet", "Synthesizer Network",
                                 BSE_TYPE_SNET, SFI_PARAM_STANDARD);
#line 395 "bseproject.proc"
}  }
static BseErrorType
#line 395 "bseproject.proc"
remove_snet_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 398 "bseproject.proc"
{
#line 399 "bseproject.proc"
  
  BseContainer *self  = bse_value_get_object (in_values++);
  BseItem      *child = bse_value_get_object (in_values++);
  BseUndoStack *ustack;
  
#line 404 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self) || !BSE_IS_SNET (child) || child->parent != (BseItem*) self)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 408 "bseproject.proc"
  
  if (!BSE_SOURCE_PREPARED (self))
    {
      ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 412 "bseproject.proc"
      
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 414 "bseproject.proc"
      
      bse_item_push_redo_proc (self, "remove-snet", child);
#line 416 "bseproject.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 418 "bseproject.proc"
      
      bse_item_undo_close (ustack);
    }
  
  return BSE_ERROR_NONE;
}

/* --- list-uname-paths --- */
static void
list_uname_paths_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 425 "bseproject.proc"
 {
#line 428 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("item_type", NULL, NULL,
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("uname_paths", "Uname Paths", NULL, BSE_TYPE_STRING_SEQ, SFI_PARAM_STANDARD);
#line 433 "bseproject.proc"
}  }
static BseErrorType
#line 433 "bseproject.proc"
list_uname_paths_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 436 "bseproject.proc"
{
#line 437 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  const gchar *tname  = sfi_value_get_string (in_values++);
  GType type          = tname ? g_type_from_name (tname) : 0;
  
#line 442 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !g_type_is_a (type, BSE_TYPE_ITEM))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 446 "bseproject.proc"
  
  bse_value_take_boxed (out_values++, bse_project_list_upaths (project, type));
  
  return BSE_ERROR_NONE;
}

/* --- find-item --- */
static void
find_item_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 452 "bseproject.proc"
 {
#line 454 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("uname_path", NULL, NULL,
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("item", NULL, NULL,
                                 BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
#line 460 "bseproject.proc"
}  }
static BseErrorType
#line 460 "bseproject.proc"
find_item_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 463 "bseproject.proc"
{
#line 464 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  const gchar *string = sfi_value_get_string (in_values++);
  
#line 468 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !string)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 472 "bseproject.proc"
  
  bse_value_set_object (out_values++, bse_container_resolve_upath (BSE_CONTAINER (project), string));
  
  return BSE_ERROR_NONE;
}

/* --- match-items-by-uname --- */
static void
match_items_by_uname_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 478 "bseproject.proc"
 {
#line 480 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("item_type", NULL, NULL,
                            NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("uname", NULL, NULL,
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("item_list", "Item List", NULL, BSE_TYPE_ITEM_SEQ, SFI_PARAM_STANDARD);
#line 487 "bseproject.proc"
}  }
static BseErrorType
#line 487 "bseproject.proc"
match_items_by_uname_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 490 "bseproject.proc"
{
#line 491 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  const gchar *tname  = sfi_value_get_string (in_values++);
  const gchar *string = sfi_value_get_string (in_values++);
  GType type          = tname ? g_type_from_name (tname) : 0;
  GList *list, *free_list;
  BseItemSeq *iseq;
  
#line 499 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !string || !g_type_is_a (type, BSE_TYPE_ITEM))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 503 "bseproject.proc"
  
  iseq = bse_item_seq_new ();
  free_list = bse_objects_list_by_uname (type, string);
  for (list = free_list; list; list = list->next)
    if (bse_item_get_project (list->data) == project)
      {
        bse_item_seq_append (iseq, list->data);
        break;
      }
  g_list_free (free_list);
  
#line 514 "bseproject.proc"
  
  bse_value_take_boxed (out_values++, iseq);
  
  return BSE_ERROR_NONE;
}

/* --- get-supers --- */
static void
get_supers_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 520 "bseproject.proc"
 {
#line 522 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("super_list", NULL, NULL, BSE_TYPE_ITEM_SEQ, SFI_PARAM_STANDARD);
#line 525 "bseproject.proc"
}  }
static BseErrorType
#line 525 "bseproject.proc"
get_supers_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 528 "bseproject.proc"
{
#line 529 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  BseItemSeq *iseq;
  GSList *slist;
  
#line 534 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 538 "bseproject.proc"
  
  iseq = bse_item_seq_new ();
  for (slist = project->supers; slist; slist = slist->next)
    bse_item_seq_append (iseq, slist->data);
  
#line 543 "bseproject.proc"
  
  bse_value_take_boxed (out_values++, iseq);
  
  return BSE_ERROR_NONE;
}

/* --- can-play --- */
static void
can_play_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 549 "bseproject.proc"
 {
#line 551 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("can_play", "Can Play", "Whether project playback makes sense",
                          FALSE, SFI_PARAM_STANDARD);
#line 555 "bseproject.proc"
}  }
static BseErrorType
#line 555 "bseproject.proc"
can_play_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 558 "bseproject.proc"
{
#line 559 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gpointer wrepo;
  
#line 563 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 567 "bseproject.proc"
  
  wrepo = bse_project_get_wave_repo (project);
  sfi_value_set_bool (out_values++, project->supers->data != wrepo || project->supers->next);
  
  return BSE_ERROR_NONE;
}

/* --- get-state --- */
static void
get_state_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 574 "bseproject.proc"
 {
#line 576 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("state", "State", "Project playback/activation state",
                                BSE_TYPE_PROJECT_STATE, BSE_PROJECT_INACTIVE, SFI_PARAM_STANDARD);
#line 580 "bseproject.proc"
}  }
static BseErrorType
#line 580 "bseproject.proc"
get_state_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 583 "bseproject.proc"
{
#line 584 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  
#line 587 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 591 "bseproject.proc"
  
  g_value_set_enum (out_values++, self->state);
  
  return BSE_ERROR_NONE;
}

static void
undo_do_deactivate (BseUndoStep  *ustep,
                    BseUndoStack *ustack)
{
  BseProject *self = bse_undo_pointer_unpack (ustep->data[0].v_pointer, ustack);
  bse_project_stop_playback (self);
}

static void
undo_do_deactivate_free (BseUndoStep *ustep)
{
  g_free (ustep->data[0].v_pointer);
}

static void
project_push_undo_silent_deactivate (BseProject *self)
{
  BseUndoStack *ustack = bse_item_undo_open (self, "deactivate-project");
  BseUndoStep *ustep = bse_undo_step_new (undo_do_deactivate, undo_do_deactivate_free, 1);
#line 616 "bseproject.proc"
  
  ustep->data[0].v_pointer = bse_undo_pointer_pack (self, ustack);
  bse_undo_stack_push_add_on (ustack, ustep);
  bse_item_undo_close (ustack);
}

/* --- activate --- */
static void
activate_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 628 "bseproject.proc"
 {
#line 630 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
                                SFI_PARAM_STANDARD);
#line 635 "bseproject.proc"
}  }
static BseErrorType
#line 635 "bseproject.proc"
activate_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 638 "bseproject.proc"
{
#line 639 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  BseProjectState state_before;
  BseErrorType error;

#line 644 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  state_before = self->state;
  error = bse_project_activate (self);
  if (state_before == BSE_PROJECT_INACTIVE && self->state != BSE_PROJECT_INACTIVE)
    {
#line 652 "bseproject.proc"
      
      project_push_undo_silent_deactivate (self);
    }
  
  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- start-playback --- */
static void
start_playback_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 661 "bseproject.proc"
 {
#line 663 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 665 "bseproject.proc"
}  }
static BseErrorType
#line 665 "bseproject.proc"
start_playback_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 668 "bseproject.proc"
{
#line 669 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  BseProjectState state_before;

#line 673 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  state_before = self->state;
  bse_project_start_playback (self);
  if (state_before == BSE_PROJECT_INACTIVE && self->state != BSE_PROJECT_INACTIVE)
    {
#line 681 "bseproject.proc"
      
      project_push_undo_silent_deactivate (self);
    }

  return BSE_ERROR_NONE;
}

/* --- play --- */
static void
play_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 688 "bseproject.proc"
 {
#line 690 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
                                SFI_PARAM_STANDARD);
#line 695 "bseproject.proc"
}  }
static BseErrorType
#line 695 "bseproject.proc"
play_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 698 "bseproject.proc"
{
#line 699 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  BseErrorType error;
  BseProjectState state_before;
  
#line 704 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  state_before = self->state;
  error = bse_project_activate (self);
  if (!error)
    {
      if (self->state == BSE_PROJECT_PLAYING)
        bse_project_stop_playback (self);
      bse_project_start_playback (self);
    }
  if (state_before == BSE_PROJECT_INACTIVE && self->state != BSE_PROJECT_INACTIVE)
    {
#line 718 "bseproject.proc"
      
      project_push_undo_silent_deactivate (self);
    }

  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- deactivate --- */
static void
deactivate_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 727 "bseproject.proc"
 {
#line 729 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 731 "bseproject.proc"
}  }
static BseErrorType
#line 731 "bseproject.proc"
deactivate_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 734 "bseproject.proc"
{
#line 735 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 738 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_project_deactivate (self);

  return BSE_ERROR_NONE;
}

/* --- stop-playback --- */
static void
stop_playback_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 747 "bseproject.proc"
 {
#line 749 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 751 "bseproject.proc"
}  }
static BseErrorType
#line 751 "bseproject.proc"
stop_playback_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 754 "bseproject.proc"
{
#line 755 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 758 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_project_stop_playback (self);

  return BSE_ERROR_NONE;
}

/* --- stop --- */
static void
stop_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 767 "bseproject.proc"
 {
#line 769 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 771 "bseproject.proc"
}  }
static BseErrorType
#line 771 "bseproject.proc"
stop_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 774 "bseproject.proc"
{
#line 775 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 778 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_project_deactivate (self);

  return BSE_ERROR_NONE;
}

/* --- auto-deactivate --- */
static void
auto_deactivate_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 787 "bseproject.proc"
 {
#line 789 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("msec_delay", NULL, "Delay for deactivation in milliseconds",
                         0, -1, G_MAXINT, 1000, SFI_PARAM_STANDARD);
#line 793 "bseproject.proc"
}  }
static BseErrorType
#line 793 "bseproject.proc"
auto_deactivate_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 796 "bseproject.proc"
{
#line 797 "bseproject.proc"
  
  BseProject *self  = bse_value_get_object (in_values++);
  gint64      msecs = sfi_value_get_int (in_values++);

#line 801 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  self->deactivate_usecs = msecs < 0 ? -1 : msecs * 1000;

  return BSE_ERROR_NONE;
}

/* --- undo-depth --- */
static void
undo_depth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 810 "bseproject.proc"
 {
#line 812 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("undo_depth", NULL, "Number of times undo can be called on the project",
                         0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 816 "bseproject.proc"
}  }
static BseErrorType
#line 816 "bseproject.proc"
undo_depth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 819 "bseproject.proc"
{
#line 820 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 823 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 827 "bseproject.proc"
  
  sfi_value_set_int (out_values++, bse_undo_stack_depth (project->undo_stack));

  return BSE_ERROR_NONE;
}

/* --- undo --- */
static void
undo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 833 "bseproject.proc"
 {
#line 835 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 837 "bseproject.proc"
}  }
static BseErrorType
#line 837 "bseproject.proc"
undo_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 840 "bseproject.proc"
{
#line 841 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);

#line 844 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 848 "bseproject.proc"
  
  if (!project->in_undo && !project->in_redo)
    {
      const gchar *name = bse_undo_stack_peek (project->undo_stack);
      if (name)
        {
          project->in_undo = TRUE;
          bse_undo_group_open (project->redo_stack, name);
          bse_undo_stack_undo (project->undo_stack);
          bse_undo_group_close (project->redo_stack);
          project->in_undo = FALSE;
        }
    }

  return BSE_ERROR_NONE;
}

/* --- redo-depth --- */
static void
redo_depth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 865 "bseproject.proc"
 {
#line 867 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("redo_depth", NULL, "Number of times redo can be called on the project",
                         0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 871 "bseproject.proc"
}  }
static BseErrorType
#line 871 "bseproject.proc"
redo_depth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 874 "bseproject.proc"
{
#line 875 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 878 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 882 "bseproject.proc"
  
  sfi_value_set_int (out_values++, bse_undo_stack_depth (project->redo_stack));

  return BSE_ERROR_NONE;
}

/* --- redo --- */
static void
redo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 888 "bseproject.proc"
 {
#line 890 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 892 "bseproject.proc"
}  }
static BseErrorType
#line 892 "bseproject.proc"
redo_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 895 "bseproject.proc"
{
#line 896 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 899 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 903 "bseproject.proc"
  
  if (!project->in_undo && !project->in_redo)
    {
      const gchar *name = bse_undo_stack_peek (project->redo_stack);
      if (name)
        {
          project->in_redo = TRUE;
          bse_undo_group_open (project->undo_stack, name);
          bse_undo_stack_undo (project->redo_stack);
          bse_undo_group_close (project->undo_stack);
          project->in_redo = FALSE;
        }
    }

  return BSE_ERROR_NONE;
}

/* --- clear-undo --- */
static void
clear_undo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 920 "bseproject.proc"
 {
#line 922 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 924 "bseproject.proc"
}  }
static BseErrorType
#line 924 "bseproject.proc"
clear_undo_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 927 "bseproject.proc"
{
#line 928 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 931 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 935 "bseproject.proc"
  
  if (!project->in_undo && !project->in_redo)
    {
      bse_undo_stack_clear (project->undo_stack);
      bse_undo_stack_clear (project->redo_stack);
      g_object_notify (project, "dirty");
    }

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static BseExportNodeProc __enode_is_playing = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseProject+is-playing", 
    NULL,
    "/Methods/BseProject/General/Is Playing",
    "Check whether a project is currently playing",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, is_playing_setup, is_playing_exec, 
};
static BseExportNodeProc __enode_is_active = {
  { (BseExportNode*) &__enode_is_playing, BSE_EXPORT_NODE_PROC,
    "BseProject+is-active", 
    NULL,
    "/Methods/BseProject/General/Is Active",
    "Check whether a project is active",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, is_active_setup, is_active_exec, 
};
static BseExportNodeProc __enode_import_midi_file = {
  { (BseExportNode*) &__enode_is_active, BSE_EXPORT_NODE_PROC,
    "BseProject+import-midi-file", 
    NULL,
    "/Methods/BseProject/File/Import MIDI",
    "Import a song from a MIDI file.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, import_midi_file_setup, import_midi_file_exec, 
};
static BseExportNodeProc __enode_restore_from_file = {
  { (BseExportNode*) &__enode_import_midi_file, BSE_EXPORT_NODE_PROC,
    "BseProject+restore-from-file", 
    NULL,
    "/Methods/BseProject/File/Restore",
    "Load a project from file",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, restore_from_file_setup, restore_from_file_exec, 
};
static BseExportNodeProc __enode_store_bse = {
  { (BseExportNode*) &__enode_restore_from_file, BSE_EXPORT_NODE_PROC,
    "BseProject+store-bse", 
    NULL,
    "/Methods/BseProject/File/Store",
    "Save supers of a project into a BSE file. "
          "If no super is specified, the project itself is stored.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, store_bse_setup, store_bse_exec, 
};
static BseExportNodeProc __enode_create_song = {
  { (BseExportNode*) &__enode_store_bse, BSE_EXPORT_NODE_PROC,
    "BseProject+create-song", 
    NULL,
    "/Methods/BseProject/General/Create Song",
    "Create a song for this project.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, create_song_setup, create_song_exec, 
};
static BseExportNodeProc __enode_get_wave_repo = {
  { (BseExportNode*) &__enode_create_song, BSE_EXPORT_NODE_PROC,
    "BseProject+get-wave-repo", 
    NULL,
    "/Methods/BseProject/General/Get Wave Repo",
    "Ensure the project has a wave repository",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, get_wave_repo_setup, get_wave_repo_exec, 
};
static BseExportNodeProc __enode_get_data_pocket = {
  { (BseExportNode*) &__enode_get_wave_repo, BSE_EXPORT_NODE_PROC,
    "BseProject+get-data-pocket", 
    NULL,
    "/Methods/BseProject/General/Get Data Pocket",
    "Retrieve a specifically named data pocket for this project",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, get_data_pocket_setup, get_data_pocket_exec, 
};
static BseExportNodeProc __enode_create_csynth = {
  { (BseExportNode*) &__enode_get_data_pocket, BSE_EXPORT_NODE_PROC,
    "BseProject+create-csynth", 
    NULL,
    "/Methods/BseProject/General/Create Csynth",
    "Create a synthsizer network for this project.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, create_csynth_setup, create_csynth_exec, 
};
static BseExportNodeProc __enode_create_midi_synth = {
  { (BseExportNode*) &__enode_create_csynth, BSE_EXPORT_NODE_PROC,
    "BseProject+create-midi-synth", 
    NULL,
    "/Methods/BseProject/General/Create Midi Synth",
    "Create a MIDI synthesizer network for this project.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, create_midi_synth_setup, create_midi_synth_exec, 
};
static BseExportNodeProc __enode_remove_snet = {
  { (BseExportNode*) &__enode_create_midi_synth, BSE_EXPORT_NODE_PROC,
    "BseProject+remove-snet", 
    NULL,
    "/Methods/BseProject/General/Remove Snet",
    "Remove an existing synthesizer network from this project.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, remove_snet_setup, remove_snet_exec, 
};
static BseExportNodeProc __enode_list_uname_paths = {
  { (BseExportNode*) &__enode_remove_snet, BSE_EXPORT_NODE_PROC,
    "BseProject+list-uname-paths", 
    NULL,
    "/Methods/BseProject/General/List Uname Paths",
    ("List uname paths for all items of a specified type within this project. "
           "By their uname paths, items are uniquely identifyable within a project."),
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, list_uname_paths_setup, list_uname_paths_exec, 
};
static BseExportNodeProc __enode_find_item = {
  { (BseExportNode*) &__enode_list_uname_paths, BSE_EXPORT_NODE_PROC,
    "BseProject+find-item", 
    NULL,
    "/Methods/BseProject/General/Find Item",
    "Find an item within a project, given its uname path.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, find_item_setup, find_item_exec, 
};
static BseExportNodeProc __enode_match_items_by_uname = {
  { (BseExportNode*) &__enode_find_item, BSE_EXPORT_NODE_PROC,
    "BseProject+match-items-by-uname", 
    NULL,
    "/Methods/BseProject/General/Match Items By Uname",
    "Retrieve all items of a specific type within a project with matching uname",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, match_items_by_uname_setup, match_items_by_uname_exec, 
};
static BseExportNodeProc __enode_get_supers = {
  { (BseExportNode*) &__enode_match_items_by_uname, BSE_EXPORT_NODE_PROC,
    "BseProject+get-supers", 
    NULL,
    "/Methods/BseProject/General/Get Supers",
    "Retrieve all supers of this project.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, get_supers_setup, get_supers_exec, 
};
static BseExportNodeProc __enode_can_play = {
  { (BseExportNode*) &__enode_get_supers, BSE_EXPORT_NODE_PROC,
    "BseProject+can-play", 
    NULL,
    "/Methods/BseProject/General/Can Play",
    "Check whether project playback would makes sense.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, can_play_setup, can_play_exec, 
};
static BseExportNodeProc __enode_get_state = {
  { (BseExportNode*) &__enode_can_play, BSE_EXPORT_NODE_PROC,
    "BseProject+get-state", 
    NULL,
    "/Methods/BseProject/General/Get State",
    "Retrieve the current project state.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, get_state_setup, get_state_exec, 
};
static BseExportNodeProc __enode_activate = {
  { (BseExportNode*) &__enode_get_state, BSE_EXPORT_NODE_PROC,
    "BseProject+activate", 
    NULL,
    "/Methods/BseProject/General/Activate",
    "Activate a project, precondition to start playback.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, activate_setup, activate_exec, 
};
static BseExportNodeProc __enode_start_playback = {
  { (BseExportNode*) &__enode_activate, BSE_EXPORT_NODE_PROC,
    "BseProject+start-playback", 
    NULL,
    "/Methods/BseProject/General/Start Playback",
    "Start playback in an activated project.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, start_playback_setup, start_playback_exec, 
};
static BseExportNodeProc __enode_play = {
  { (BseExportNode*) &__enode_start_playback, BSE_EXPORT_NODE_PROC,
    "BseProject+play", 
    NULL,
    "/Methods/BseProject/General/Play",
    "Activate a project and start project playback (and already playing project is first halted).",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, play_setup, play_exec, 
};
static BseExportNodeProc __enode_deactivate = {
  { (BseExportNode*) &__enode_play, BSE_EXPORT_NODE_PROC,
    "BseProject+deactivate", 
    NULL,
    "/Methods/BseProject/General/Deactivate",
    "Deactivate the project, automatically stop playback.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, deactivate_setup, deactivate_exec, 
};
static BseExportNodeProc __enode_stop_playback = {
  { (BseExportNode*) &__enode_deactivate, BSE_EXPORT_NODE_PROC,
    "BseProject+stop-playback", 
    NULL,
    "/Methods/BseProject/General/Stop Playback",
    "Stop project playback.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, stop_playback_setup, stop_playback_exec, 
};
static BseExportNodeProc __enode_stop = {
  { (BseExportNode*) &__enode_stop_playback, BSE_EXPORT_NODE_PROC,
    "BseProject+stop", 
    NULL,
    "/Methods/BseProject/General/Stop",
    "Stop project playback and deactivate project.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, stop_setup, stop_exec, 
};
static BseExportNodeProc __enode_auto_deactivate = {
  { (BseExportNode*) &__enode_stop, BSE_EXPORT_NODE_PROC,
    "BseProject+auto-deactivate", 
    NULL,
    "/Methods/BseProject/General/Auto Deactivate",
    "Automatically deactivate a project once playback stopped.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, auto_deactivate_setup, auto_deactivate_exec, 
};
static BseExportNodeProc __enode_undo_depth = {
  { (BseExportNode*) &__enode_auto_deactivate, BSE_EXPORT_NODE_PROC,
    "BseProject+undo-depth", 
    NULL,
    "/Methods/BseProject/General/Undo Depth",
    "Check whether a project can perform undo steps",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, undo_depth_setup, undo_depth_exec, 
};
static BseExportNodeProc __enode_undo = {
  { (BseExportNode*) &__enode_undo_depth, BSE_EXPORT_NODE_PROC,
    "BseProject+undo", 
    NULL,
    "/Methods/BseProject/General/Undo",
    "Undo a previous operation in a project",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, undo_setup, undo_exec, 
};
static BseExportNodeProc __enode_redo_depth = {
  { (BseExportNode*) &__enode_undo, BSE_EXPORT_NODE_PROC,
    "BseProject+redo-depth", 
    NULL,
    "/Methods/BseProject/General/Redo Depth",
    "Check whether a project can perform redo steps",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, redo_depth_setup, redo_depth_exec, 
};
static BseExportNodeProc __enode_redo = {
  { (BseExportNode*) &__enode_redo_depth, BSE_EXPORT_NODE_PROC,
    "BseProject+redo", 
    NULL,
    "/Methods/BseProject/General/Redo",
    "Redo a previously undone operaiton in a project",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, redo_setup, redo_exec, 
};
static BseExportNodeProc __enode_clear_undo = {
  { (BseExportNode*) &__enode_redo, BSE_EXPORT_NODE_PROC,
    "BseProject+clear-undo", 
    NULL,
    "/Methods/BseProject/General/Clear Undo",
    "Delete all recorded undo or redo steps.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, clear_undo_setup, clear_undo_exec, 
};
BseExportNode* bse__builtin_init_bseproject_gen_proc_c (void);
BseExportNode* bse__builtin_init_bseproject_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_clear_undo;
}

/**
 ** Generated data ends here
 **/
