
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bseeditablesample.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bseeditablesample.h>
#include        <bse/gsldatahandle.h>


#line 27 "bseeditablesample.proc"


/* --- open --- */
static GType type_id_open = 0;
static void
open_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 29 "bseeditablesample.proc"
 {
#line 31 "bseeditablesample.proc"
  *(in_pspecs++) = g_param_spec_object ("esample", "Editable Sample", NULL,
			       BSE_TYPE_EDITABLE_SAMPLE, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", NULL,
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
#line 30 "bseeditablesample.proc"
  proc->help = ("Open the sample for reading.");
#line 24 "bseeditablesample.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bseeditablesample.proc"
  proc->copyright = "Tim Janik";
#line 26 "bseeditablesample.proc"
  proc->date = "2002";
#line 36 "bseeditablesample.proc"
}  }
static BseErrorType
#line 36 "bseeditablesample.proc"
open_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 39 "bseeditablesample.proc"
{
#line 40 "bseeditablesample.proc"
  
  BseEditableSample *esample = g_value_get_object (in_values++);
  BseErrorType error;

#line 44 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 48 "bseeditablesample.proc"
  
  if (!esample->wchunk)
    error = BSE_ERROR_NOT_FOUND;
  else if (esample->open_count)
    {
      esample->open_count++;
      error = BSE_ERROR_NONE;
    }
  else
    {
      error = gsl_wave_chunk_open (esample->wchunk);
      if (!error)
	esample->open_count++;
    }

#line 63 "bseeditablesample.proc"
  
  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- close --- */
static GType type_id_close = 0;
static void
close_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 69 "bseeditablesample.proc"
 {
#line 71 "bseeditablesample.proc"
  *(in_pspecs++) = g_param_spec_object ("esample", "Editable Sample", NULL,
			       BSE_TYPE_EDITABLE_SAMPLE, BSE_PARAM_DEFAULT);
#line 70 "bseeditablesample.proc"
  proc->help = ("Close an opened sample.");
#line 24 "bseeditablesample.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bseeditablesample.proc"
  proc->copyright = "Tim Janik";
#line 26 "bseeditablesample.proc"
  proc->date = "2002";
#line 73 "bseeditablesample.proc"
}  }
static BseErrorType
#line 73 "bseeditablesample.proc"
close_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 76 "bseeditablesample.proc"
{
#line 77 "bseeditablesample.proc"
  
  BseEditableSample *esample = g_value_get_object (in_values++);

#line 80 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample) || !esample->wchunk || !esample->open_count)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 84 "bseeditablesample.proc"
  
  esample->open_count--;
  if (!esample->open_count)
    gsl_wave_chunk_close (esample->wchunk);

  return BSE_ERROR_NONE;
}

/* --- get-length --- */
static GType type_id_get_length = 0;
static void
get_length_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 92 "bseeditablesample.proc"
 {
#line 94 "bseeditablesample.proc"
  *(in_pspecs++) = g_param_spec_object ("esample", "Editable Sample", NULL,
			       BSE_TYPE_EDITABLE_SAMPLE, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_uint ("length", NULL, "Number of values",
			     0, G_MAXINT, 1, BSE_PARAM_DEFAULT);
#line 93 "bseeditablesample.proc"
  proc->help = ("Return the number of values in the sample.");
#line 24 "bseeditablesample.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bseeditablesample.proc"
  proc->copyright = "Tim Janik";
#line 26 "bseeditablesample.proc"
  proc->date = "2002";
#line 98 "bseeditablesample.proc"
}  }
static BseErrorType
#line 98 "bseeditablesample.proc"
get_length_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 101 "bseeditablesample.proc"
{
#line 102 "bseeditablesample.proc"
  
  BseEditableSample *esample = g_value_get_object (in_values++);
  GslDataCache *dcache = NULL;
  
#line 106 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 110 "bseeditablesample.proc"
  
  if (BSE_EDITABLE_SAMPLE_OPENED (esample) && esample->wchunk)
    dcache = esample->wchunk->dcache;
  g_value_set_uint (out_values++, dcache ? gsl_data_handle_length (dcache->dhandle) : 0);

  return BSE_ERROR_NONE;
}

/* --- get-n-channels --- */
static GType type_id_get_n_channels = 0;
static void
get_n_channels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 118 "bseeditablesample.proc"
 {
#line 120 "bseeditablesample.proc"
  *(in_pspecs++) = g_param_spec_object ("esample", "Editable Sample", NULL,
			       BSE_TYPE_EDITABLE_SAMPLE, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_uint ("n-channels", NULL, "Number of channels",
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
#line 119 "bseeditablesample.proc"
  proc->help = ("Return the number of channels in the sample.");
#line 24 "bseeditablesample.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bseeditablesample.proc"
  proc->copyright = "Tim Janik";
#line 26 "bseeditablesample.proc"
  proc->date = "2002";
#line 124 "bseeditablesample.proc"
}  }
static BseErrorType
#line 124 "bseeditablesample.proc"
get_n_channels_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 127 "bseeditablesample.proc"
{
#line 128 "bseeditablesample.proc"
  
  BseEditableSample *esample = g_value_get_object (in_values++);

#line 131 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 135 "bseeditablesample.proc"
  
  g_value_set_uint (out_values++, esample->wchunk ? esample->wchunk->n_channels : 1);

  return BSE_ERROR_NONE;
}

/* --- get-osc-freq --- */
static GType type_id_get_osc_freq = 0;
static void
get_osc_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 141 "bseeditablesample.proc"
 {
#line 143 "bseeditablesample.proc"
  *(in_pspecs++) = g_param_spec_object ("esample", "Editable Sample", NULL,
			       BSE_TYPE_EDITABLE_SAMPLE, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_freq_simple ("osc-freq", NULL, "Oscillator Frequency",
				      BSE_PARAM_DEFAULT);
#line 142 "bseeditablesample.proc"
  proc->help = ("Return the oscillator frequency for the sample.");
#line 24 "bseeditablesample.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bseeditablesample.proc"
  proc->copyright = "Tim Janik";
#line 26 "bseeditablesample.proc"
  proc->date = "2002";
#line 147 "bseeditablesample.proc"
}  }
static BseErrorType
#line 147 "bseeditablesample.proc"
get_osc_freq_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 150 "bseeditablesample.proc"
{
#line 151 "bseeditablesample.proc"
  
  BseEditableSample *esample = g_value_get_object (in_values++);
  
#line 154 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 158 "bseeditablesample.proc"
  
  g_value_set_float (out_values++, esample->wchunk ? esample->wchunk->osc_freq : BSE_KAMMER_FREQUENCY_f);

  return BSE_ERROR_NONE;
}

/* --- read-samples --- */
static GType type_id_read_samples = 0;
static void
read_samples_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 164 "bseeditablesample.proc"
 {
#line 166 "bseeditablesample.proc"
  *(in_pspecs++) = g_param_spec_object ("esample", "Editable Sample", NULL,
			       BSE_TYPE_EDITABLE_SAMPLE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("voffset", NULL, "Value offset",
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_boxed ("sample_block", NULL, "Block of samples",
			      BSW_TYPE_VALUE_BLOCK, BSE_PARAM_DEFAULT);
#line 165 "bseeditablesample.proc"
  proc->help = ("Read a set of samples from a specific offset.");
#line 24 "bseeditablesample.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bseeditablesample.proc"
  proc->copyright = "Tim Janik";
#line 26 "bseeditablesample.proc"
  proc->date = "2002";
#line 172 "bseeditablesample.proc"
}  }
static BseErrorType
#line 172 "bseeditablesample.proc"
read_samples_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 175 "bseeditablesample.proc"
{
#line 176 "bseeditablesample.proc"
  
  BseEditableSample *esample = g_value_get_object (in_values++);
  guint              voffset = g_value_get_uint (in_values++);
  GslDataCache *dcache = NULL;
  BswValueBlock *vblock;

#line 182 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample))
    return BSE_ERROR_PROC_PARAM_INVAL;

  if (BSE_EDITABLE_SAMPLE_OPENED (esample) && esample->wchunk)
    dcache = esample->wchunk->dcache;
  if (!dcache || voffset >= gsl_data_handle_length (dcache->dhandle))
    vblock = bsw_value_block_new (1024);
  else
    {
      GslDataCacheNode *dnode = gsl_data_cache_ref_node (dcache, voffset, TRUE);
      guint i, l, dnode_length = dcache->node_size;

      l = dnode_length - (voffset - dnode->offset) + dcache->padding;
      l = MIN (l, gsl_data_handle_length (dcache->dhandle) - voffset);
      vblock = bsw_value_block_new (l);
      for (i = 0; i < l; i++)
	vblock->values[i] = dnode->data[voffset - dnode->offset + i];
      gsl_data_cache_unref_node (dcache, dnode);
    }

#line 203 "bseeditablesample.proc"
  
  g_value_set_boxed_take_ownership (out_values++, vblock);

  return BSE_ERROR_NONE;
}

/* --- collect-stats --- */
static GType type_id_collect_stats = 0;
static void
collect_stats_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 209 "bseeditablesample.proc"
 {
#line 211 "bseeditablesample.proc"
  *(in_pspecs++) = g_param_spec_object ("esample", "Editable Sample", NULL,
			       BSE_TYPE_EDITABLE_SAMPLE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("voffset", NULL, "Offset of first stat block",
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_double ("offset_scale", NULL, "Factor to scale voffset increments with",
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("block_size", NULL, "Block size to compute stat pairs from",
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("stepping", NULL, "Stepping within a stat block",
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("max_pairs", NULL, "Maximum number of (min, max) pairs to collect",
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_boxed ("sample_block", NULL, "Block of samples",
			      BSW_TYPE_VALUE_BLOCK, BSE_PARAM_DEFAULT);
#line 210 "bseeditablesample.proc"
  proc->help = ("Collect statistics from sample blocks as (minimum, maximum) pairs.");
#line 24 "bseeditablesample.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bseeditablesample.proc"
  proc->copyright = "Tim Janik";
#line 26 "bseeditablesample.proc"
  proc->date = "2002";
#line 225 "bseeditablesample.proc"
}  }
static BseErrorType
#line 225 "bseeditablesample.proc"
collect_stats_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 228 "bseeditablesample.proc"
{
#line 229 "bseeditablesample.proc"
  
  BseEditableSample *esample    = g_value_get_object (in_values++);
  guint              voffset    = g_value_get_uint (in_values++);
  double             offs_scale = g_value_get_double (in_values++);
  guint              block_size = g_value_get_uint (in_values++);
  guint              stepping   = g_value_get_uint (in_values++);
  guint              max_pairs  = g_value_get_uint (in_values++);
  BswValueBlock *vblock;
  GslDataCache *dcache = NULL;

#line 239 "bseeditablesample.proc"
  
  if (!BSE_IS_EDITABLE_SAMPLE (esample) || stepping < 1)
    return BSE_ERROR_PROC_PARAM_INVAL;

  if (BSE_EDITABLE_SAMPLE_OPENED (esample) && esample->wchunk)
    dcache = esample->wchunk->dcache;
  if (!dcache || voffset + block_size > gsl_data_handle_length (dcache->dhandle))
    vblock = bsw_value_block_new (max_pairs * 2);
  else
    {
      GslDataCacheNode *dnode = gsl_data_cache_ref_node (dcache, voffset, GSL_DATA_CACHE_DEMAND_LOAD);
      guint j, dnode_length = dcache->node_size;

      vblock = bsw_value_block_new (max_pairs * 2);
      for (j = 0; j < max_pairs; j++)
	{
	  guint i, cur_offset = j * offs_scale;
	  gfloat min = +1, max = -1;

#line 258 "bseeditablesample.proc"
	  
	  cur_offset /= stepping;
	  cur_offset = voffset + cur_offset * stepping;

#line 262 "bseeditablesample.proc"
	  
	  for (i = cur_offset; i < cur_offset + block_size; i += stepping)
	    {
	      guint pos;
	      
	      if (i < dnode->offset || i >= dnode->offset + dnode_length)
		{
		  gsl_data_cache_unref_node (dcache, dnode);
#line 270 "bseeditablesample.proc"
		  
		  dnode = gsl_data_cache_ref_node (dcache, i, j == 0 ? GSL_DATA_CACHE_DEMAND_LOAD : GSL_DATA_CACHE_PEEK);
		  if (!dnode)
		    goto break_loops;
		}
	      pos = i - dnode->offset;
	      min = MIN (min, dnode->data[pos]);
	      max = MAX (max, dnode->data[pos]);
	    }
	  vblock->values[j * 2] = min;
	  vblock->values[j * 2 + 1] = max;
	}
      gsl_data_cache_unref_node (dcache, dnode);
    break_loops:
      vblock->n_values = j * 2;
    }

#line 287 "bseeditablesample.proc"
  
  g_value_set_boxed_take_ownership (out_values++, vblock);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_open, "BseEditableSample+open", NULL, 0, open_setup, open_exec, NULL, "/Method/BseEditableSample/General/Open", { 0, }, },
  { &type_id_close, "BseEditableSample+close", NULL, 0, close_setup, close_exec, NULL, "/Method/BseEditableSample/General/Close", { 0, }, },
  { &type_id_get_length, "BseEditableSample+get-length", NULL, 0, get_length_setup, get_length_exec, NULL, "/Method/BseEditableSample/General/Get Length", { 0, }, },
  { &type_id_get_n_channels, "BseEditableSample+get-n-channels", NULL, 0, get_n_channels_setup, get_n_channels_exec, NULL, "/Method/BseEditableSample/General/Get N Channels", { 0, }, },
  { &type_id_get_osc_freq, "BseEditableSample+get-osc-freq", NULL, 0, get_osc_freq_setup, get_osc_freq_exec, NULL, "/Method/BseEditableSample/General/Get Osc Freq", { 0, }, },
  { &type_id_read_samples, "BseEditableSample+read-samples", NULL, 0, read_samples_setup, read_samples_exec, NULL, "/Method/BseEditableSample/General/Read Samples", { 0, }, },
  { &type_id_collect_stats, "BseEditableSample+collect-stats", NULL, 0, collect_stats_setup, collect_stats_exec, NULL, "/Method/BseEditableSample/General/Collect Stats", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
