#ifndef lint
static char SccsId[] = "%W%  %G%";
#endif

/* Module:	mainkey.c (Main Key)
 * Purpose:	Dispatch responses mapped to various keyboard keys
 * Subroutine:	key_response()			returns: void
 * Subroutine:	set_iraf_key_trigger()		returns: void
 * Xlib calls:	XWarpPointer(), XSync()
 * Copyright:	1989 Smithsonian Astrophysical Observatory
 *		You may do anything you like with this file except remove
 *		this copyright.  The Smithsonian Astrophysical Observatory
 *		makes no representations about the suitability of this
 *		software for any purpose.  It is provided "as is" without
 *		express or implied warranty.
 * Modified:	{0} Michael VanHilst	initial version		29 June 1989
 *		{1} MVH display window key to trigger IRAF write 16 Aug 1989
 *		{2} MVH support for text cursor			  1 Jun 1991 
 *		{n} <who> -- <does what> -- <when>
 */

#include <X11/Xlib.h>		/*  X window stuff  */
#include <X11/Xutil.h>		/*  X window manager stuff  */
#include <X11/keysym.h>
#include <X11/keysymdef.h>
#include "hfiles/constant.h"	/*  Define codes  */
#include "hfiles/struct.h"	/*  Declare structure types  */
#include "hfiles/extern.h"	/*  Extern main parameter structures  */

#define MAX_MAPPED_STRING_LENGTH 16
#define MetaMask Mod1Mask


#ifdef ANSIC
/*  Exported declarations must be centralized before ANSI C can be used  */

void		grab_keys_for_textcursor(	int state);
void		set_iraf_key_trigger(	int state);
void		key_response();

#endif


static int textcursor = 0;
/*  Subroutine:	grab_keys_for_textcursor
 *  Purpose:	Direct all key input to the text cursor editor
 */
#ifdef ANSIC
void grab_keys_for_textcursor ( int state )
#else
void grab_keys_for_textcursor ( state )
     int state;
#endif
{
  textcursor = state;
}


#ifdef IMTOOL
static int iraf_trigger = 0;
/*  Subroutine:	set_iraf_key_trigger
 *  Purpose:	Set and clear trigger for cursor readback through IRAF pipe
 */
#ifdef ANSIC
void set_iraf_key_trigger ( int state )
#else
void set_iraf_key_trigger ( state )
     int state;
#endif
{
  iraf_trigger = state;
}
#endif


/*  Subroutine:	key_response
 *  Purpose:	Respond to a key stroke
 */
void key_response()
{
  KeySym keysym;
  XComposeStatus compose;
  int char_cnt;
  int x, y;
  static int bufsize = MAX_MAPPED_STRING_LENGTH;
  char buffer[MAX_MAPPED_STRING_LENGTH];
#ifdef IMTOOL
  int trigger_curpos_to_iraf();
#endif
  void magnify_pan(), magnify_disp(), say_goodbye(), disp_panbox();
  void disp_dispbox(), raise_windows(), get_new_cmd(), print_table();
  void ascii_region(), textcursor_keyentry();

  /*  Decode the key event to ascii  */
  char_cnt = XLookupString(&control.event.xkey, buffer, bufsize,
			   &keysym, &compose);
  /*  Key input from display window may be redirected for special purposes  */
  if( control.event.xkey.window == dispbox.ID ) {
#ifdef IMTOOL
    if( iraf_trigger && (char_cnt == 1) &&
	trigger_curpos_to_iraf(&control.event.xkey, (int)buffer[0]) )
      return;
#endif
    /*  Redirect keyboard input for textcursor editor  */
    if( textcursor ) {
      textcursor_keyentry(&control.event.xkey, keysym);
      return;
    }
  }
  /*  Ignore modifier key pressing  */
  if( ((control.event.xkey.state & (ControlMask | MetaMask)) == 0) ||
      (keysym >= XK_BackSpace) ) {
    switch( keysym ) {
    case XK_Shift_L:
    case XK_Shift_R:
#ifdef IMTOOL
      /*  Don't update tracking now if in IRAF interactive mode  */
      if( iraf_trigger )
	return;
#endif
      if( control.event.xkey.window == panbox.ID ) {
	/*  Update magnifier if in panbox  */
	magnify_pan (&control.event);
      } else if( (control.event.xkey.window == dispbox.ID) &&
		 (!control.magni_track) ) {
	/*  If in disp window and not now tracking, update magnifier  */
	magnify_disp (&control.event, 1, !control.coord_track);
      }
      break;
#ifdef SUN
      /*  Shifted arrow keys on Sun keypad  */
    case XK_R8:
    case XK_R10:
    case XK_R12:
    case XK_R14:
      if( keysym == XK_R8 )
	keysym = XK_Up;
      else if( keysym == XK_R10 )
	keysym = XK_Left;
      else if( keysym == XK_R12 )
	keysym = XK_Right;
      else if( keysym == XK_R14 )
	keysym = XK_Down;
#endif
    case XK_Up:
    case XK_Down:
    case XK_Left:
    case XK_Right:
      /*  Use the mouse coordinates at time of key strike  */
      if( keysym == XK_Up )
	y = control.event.xkey.y - 1;
      else if( keysym == XK_Down )
	y = control.event.xkey.y + 1;
      else
	y = control.event.xkey.y;
      if( keysym == XK_Right )
	x = control.event.xkey.x + 1;
      else if( keysym == XK_Left )
	x = control.event.xkey.x - 1;
      else
	x = control.event.xkey.x;
      /*  Move the mouse (supercede any recent mouse movement)  */
      XSync (control.event.xkey.display, 0);
      XWarpPointer(control.event.xkey.display, None,
		   control.event.xkey.window, 0, 0, 0, 0, x, y);
      break;
    case XK_A:
    case XK_a:
      /*  a or r (?) TO RAISE ALL WINDOWS OUT OF KAOS  */
      disp_panbox();
      disp_dispbox();
      raise_windows();
      break;
    case XK_L:
    case XK_l:
      /*  Debugging print_table without scaling (fool it about scaling)  */
      x = img.fiscaled;
      img.fiscaled = 0;
      print_table();
      img.fiscaled = x;
      break;
    case XK_N:
    case XK_n:
      /*  Open a new image file (see CmdNew.c)  */
      get_new_cmd();
      break;
#ifdef QUITKEY
    case XK_Q:
    case XK_q:
      /*  q FOR QUIT  */
      say_goodbye(0);
      break;
#endif
    case XK_R:
    case XK_r:
      raise_windows();
      break;
    case XK_T:
    case XK_t:
      /*  Print table of image values if in display or pan windows  */
      print_table();
      break;
    case XK_Delete:
    case XK_D:
    case XK_d:
    case XK_E:
    case XK_e:
    case XK_S:
    case XK_s:
      /*  Character control in region (cursor) mode  */
      if( control.mode == COP ) {
	if( (control.event.xkey.window == dispbox.ID) ||
	    (cursor.type == COP_Text) )
	ascii_region(&control.event.xkey, keysym);
      }
      break;
    default:
      break;
    }
  }
}
