/* 
 * tclXmain.c --
 *
 * Main to run the Tcl shell.  This file is a useful template for custom
 * applications that wish to have Tcl as the top level command language.
 * This file can also be compiled with C++.
 *-----------------------------------------------------------------------------
 * Copyright 1991-1993 Karl Lehenbauer and Mark Diekhans.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies.  Karl Lehenbauer and
 * Mark Diekhans make no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *-----------------------------------------------------------------------------
 * $Id: tclXmain.c,v 2.11 1993/11/09 05:42:59 markd Exp $
 *-----------------------------------------------------------------------------
 */

#ifdef __cplusplus
#    include "tcl++.h"
#else
#    include "tclExtend.h"
#endif

/*
 * Name of a user-specific startup script to source if the application is
 * being run interactively (e.g. "~/.tclrc").  Set by Tcl_AppInit.
 *  NULL means don't source anything ever.
 */
char *tcl_RcFileName = NULL;

static char *exitCmd = "exit";

#ifdef __cplusplus
int
main (int           argc,
      const char  **argv)
#else
main(argc, argv)
    int           argc;
    CONST char  **argv;
#endif
{
    Tcl_Interp *interp;

    /* 
     * Create a basic Tcl interpreter.
     */
    interp = Tcl_CreateInterp();

    /*
     * Do command line parsing.  This does not return on an error.  Information
     * for command line is saved in Tcl variables.
     */
    TclX_ParseCmdLine (interp, argc, (char **) argv);

    /*
     * Initialized all packages and application specific commands.  This
     * includes Extended Tcl initialization.
     */
    if (TclX_AppInit (interp) == TCL_ERROR)
        TclX_ErrorExit (interp, 255);

    /*
     * Start the interactive shell or eval a command or file.
     */
    if (TclX_RunShell (interp) == TCL_ERROR)
        TclX_ErrorExit (interp, 255);

    /* 
     * Delete the interpreter if memory debugging or explictly requested.
     * Useful for finding memory leaks.
     */

#if defined(TCL_MEM_DEBUG) || defined(TCL_DELETE_INTERP)
    Tcl_DeleteInterp(interp);

#ifdef TCL_SHELL_MEM_LEAK
    printf (" >>> Dumping active memory list to mem.lst <<<\n");
    if (Tcl_DumpActiveMemory ("mem.lst") != TCL_OK)
        panic ("error accessing `mem.lst': %s", strerror (errno));
#endif
    exit(0);
#endif

    /*
     * If no memory debugging, exit though the exit command to clean up.
     * (Tcl_VarEval is used to keep GCC happy).
     */
    Tcl_VarEval (interp, exitCmd, (char *) NULL);

    exit (0);  /* Just in case */
}
