#ifndef _TCLOBST_H
#define _TCLOBST_H
/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 *
 * --------------------------------------------------------------------------
 * Interface definitions for the Tcl --> OBST Interface.
 * --------------------------------------------------------------------------
 * ORIGINAL: D. Theobald				DATE: 14/2/93
 * --------------------------------------------------------------------------
 */
#include "tcl.h"
#include "c2obst.h"

#ifdef __cplusplus
extern "C" {
#endif


extern const char* t2o_version;


/* ----- Utilities: Error Handling ---------------------------------------- */

extern void t2o_err_handler __FSIG_(());


/* ----- Initialization / Customization ----------------------------------- */

extern const char *t2o_ObjPrefStr,    *t2o_ObjCmdStr,
		  *t2o_AllowAbbrStr,  *t2o_AllowDfltStr,
		  *t2o_CpCstrStr,
		  *t2o_AggCmdStr,     *t2o_CallCmdStr,
		  *t2o_CntCmdStr,     *t2o_CtrlCmdStr,
   		  *t2o_UtilCmdStr;

extern sos_Bool _t2o_BindDefs __FSIG_((Tcl_Interp*, sos_Bool));
extern int      t2o_customize __FSIG_((const Tcl_Interp*,
				       const char*, const char*));

/* force a reference to the static suffix of the tclOBST shared library */
extern sos_Bool __t2o_dummy;
#define t2o_BindDefs(i,b) (__t2o_dummy=(b),_t2o_BindDefs(i,__t2o_dummy))


/* -----  Object/String Conversions  ------------------------------------- */

extern char*    t2o_obj2str       __FSIG_((Tcl_Interp*, const sos_Object*));
extern char*    t2o_scalar2str    __FSIG_((Tcl_Interp*, const sos_Object*));
extern char*    t2o_classinst2str __FSIG_((Tcl_Interp*, const sos_Object*));
extern sos_Bool t2o_str2obj       __FSIG_((Tcl_Interp*, 
					   sos_Object*, const char*));

/* -----  OBST tracing  -------------------------------------------------- */

#define t2o_H  160
#define t2o_M  161
#define t2o_L  162
#define t2o_VL 163

/* Tracing conventions:
 *      t2o_VL: object conversions
 *      t2o_L : auxiliary operations for command functions
 *      t2o_M : module initialization, customization, OBST error handling
 *      t2o_H : tcl command functions
 */

#ifdef __cplusplus
}
#endif
#endif
