/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 *
 * --------------------------------------------------------------------------
 * Implementation of the Tcl --> OBST Interface: global definitions
 * --------------------------------------------------------------------------
 * ORIGINAL: D. Theobald				DATE: 27/9/93
 * --------------------------------------------------------------------------
 */
/* tclOBST LIBRARY MODULE */

#include "obst_progstd.h"
#include "_tclOBST.h"

/*
 * Default module initialization, has to be called explicitly only if
 * a specific initialization order is to be guaranteed.
 */
LOCAL int _dummy = (t2o_init(), 0);

/*
 * Used to force a reference to the static suffix of the tclOBST shared library.
 */
EXPORT sos_Bool __t2o_dummy;


// -----------------------------------------------------------------------
// DEFINITION: Utilities
// -----------------------------------------------------------------------

EXPORT const char*     t2o_version	= TCLOBST_VERSION;

EXPORT const char*     t2o_ObjPrefStr	= t2o_OBJPREFSTR;
EXPORT const char*     t2o_ObjCmdStr	= t2o_OBJCMDSTR;
EXPORT const char*     t2o_AllowAbbrStr = t2o_ALLOWABBRSTR;
EXPORT const char*     t2o_AllowDfltStr = t2o_ALLOWDFLTSTR;
EXPORT const char*     t2o_CpCstrStr    = t2o_CPCSTRSTR;
EXPORT const char*     t2o_AggCmdStr	= t2o_AGGCMDSTR;
EXPORT const char*     t2o_CallCmdStr	= t2o_CALLCMDSTR;
EXPORT const char*     t2o_CntCmdStr	= t2o_CNTCMDSTR;
EXPORT const char*     t2o_CtrlCmdStr	= t2o_CTRLCMDSTR;
EXPORT const char*     t2o_UtilCmdStr	= t2o_UTILCMDSTR;

EXPORT const char*     t2o_errinfo[]    = { "error (OBST) in: ",
					    "usage error (OBST) in: ",
					    "warning (OBST) for: "
				          };
EXPORT const char*     t2o_errcode[]    = { "OBST_SYS","OBST_USE","OBST_WNG" };

EXPORT int	       t2o_error	= TRUE;
EXPORT int	       t2o_handle_errors= TRUE;
EXPORT t2o_InterpData* _t2o_current_ip   /* = NULL */;


// -----------------------------------------------------------------------
// DEFINITION: Command options
// -----------------------------------------------------------------------

#define t2o_ArraySz(array)  (sizeof(array)/sizeof(*array))

EXPORT _t2o_OptionInfo _t2o_option_data[] = {
   { "access",
     "<sos_Access_mode> <sos_Sync_mode> <ct> --> <sos_Open_result",
     t2o_CntCmdC,  4, 9999, t2o_Nop,	     4,    1 },
   { "bind",
     "[<name>] --> [0/1]",
     t2o_CtrlCmdC, 2,    3, t2o_Nop     },
   { "card",
     " <sos_Aggregate> --> <int>",
     t2o_AggCmdC,  3,    3, t2o_ObjCode },
   { "clear",
     "<ct>",
     t2o_CntCmdC,  2, 9999, t2o_Nop,	     2,    1 },
   { "close",
     "<ct>.. | {<ct>..}",
     t2o_CntCmdC,  2, 9999, t2o_Nop,	     2, 9999 },
   { "commit",
     "<ct>.. | {<ct>..}",
     t2o_CntCmdC,  3, 9999, t2o_Nop,	     2, 9999 },
   { "compress",
     "<ct>",
     t2o_CntCmdC,  3, 9999, t2o_Nop,	     2,    1 },
   { "const",
     "<name> --> <value>",
     t2o_UtilCmdC, 2,    3, t2o_MapStr  },
   { "create",
     "--> <ct>",
     t2o_CntCmdC,  2,    2, t2o_Nop,	     0 },
   { "current",
     "[agg | role1 | role2] [<level>] --> <sos_Object>",
     t2o_AggCmdC,  2,    4, t2o_Nop     },
   { "customize",
     "<resource> [<value>]",
     t2o_CtrlCmdC, 3,    4, t2o_Nop     },
   { "destroy",
     "<ct>",
     t2o_CntCmdC,  2, 9999, t2o_Nop,	     2,    1 },
   { "exists",
     "<ct> --> 0/1",
     t2o_CntCmdC,  3, 9999, t2o_Nop,	     2,    1 },
   { "has_type",
     "<sos_Object> <type name> --> 0/1",
     t2o_UtilCmdC, 4,    4, t2o_ObjCode },
   { "isa",
     "<sos_Object> <type name> --> 0/1",
     t2o_UtilCmdC, 4,    4, t2o_ObjCode },
   { "is_scalar",
     "<sos_Object> --> 0/1",
     t2o_UtilCmdC, 3,    3, t2o_ObjCode },
   { "is_some",
     "<sos_Object> <type name> --> 0/1",
     t2o_UtilCmdC, 4,    4, t2o_ObjCode },
   { "loop",
     "[forward|fwd|reverse|rev] <sos_Aggregate> <body>",
     t2o_AggCmdC,  4,    5, t2o_MapStr  },
   { "modified",
     "<ct> --> 0/1",
     t2o_CntCmdC,  3, 9999, t2o_Nop,	     2,    1 },
   { "obj2scalar",
     "<sos_Scalar_object> --> <value>",
     t2o_UtilCmdC, 3,    3, t2o_ObjCode },
   { "object_exists",
     "<sos_Offset> <sos_Int> <ct> --> <sos_Existing_status>",
     t2o_CntCmdC,  5,    5, t2o_Nop,	     4,    1 },
   { "objsize",
     "<sos_Object> --> <int>",
     t2o_UtilCmdC, 3,    3, t2o_ObjCode },
   { "occupied",
     "<ct> --> <int>",
     t2o_CntCmdC,  3,    3, t2o_Nop,	     2,    1 },
   { "open",
     "<sos_Access_mode> <sos_Sync_mode> (<ct>.. | {<ct>..}) --> <sos_Open_result>",
     t2o_CntCmdC,  4, 9999, t2o_Nop,	     4, 9999 },
   { "open_containers",
     "(<sos_Container_status> | <sos_Container_mod_status>) --> {<ct>..}",
     t2o_CntCmdC,  3,    3, t2o_Nop,	     0 },
   { "open_sets",
     "{<ct.rd>..} {<ct.co>..} {<ct.wr>..} --> <sos_Open_result>",
     t2o_CntCmdC,  6,    6, t2o_Nop,	     0 },
   { "reset",
     "<ct>... | {<ct>..}",
     t2o_CntCmdC,  2, 9999, t2o_Nop,	     2, 9999 },
   { "root_object",
     "<ct> --> <sos_Object>",
     t2o_CntCmdC,  3, 9999, t2o_Nop,	     2,    1 },
   { "scalar2obj",
     "<value> <type name> --> <sos_Scalar_object>",
     t2o_UtilCmdC, 4,    4, t2o_Nop,	   },
   { "schemas",
     "<schema name>.. | {<schema name>..}",
     t2o_CtrlCmdC, 2, 9999, t2o_List	   },
   { "squeeze",
     "<ct>",
     t2o_CntCmdC,  3, 9999, t2o_Nop,	     2,    1 },
   { "statistics",
     "--> <text>",
     t2o_CtrlCmdC, 2,    2, t2o_Nop	   },
   { "status",
     "<ct> --> <sos_Container_status>",
     t2o_CntCmdC,  3, 9999, t2o_Nop,	     2,    1 },
   { "_test",
     "<arg>.. --> <text>",
     t2o_CtrlCmdC, 2, 9999, t2o_Nop	   },
   { "tmpstr",
     "<text> --> <sos_String>",
     t2o_UtilCmdC, 3,    3, t2o_Nop	   },
   { "trace",
     "[<file> [<trclevel>]] | ( <switch> [((enter|leave) [<proc>]) | <text>] --> [0/1] )",
     t2o_CtrlCmdC, 2,    5, t2o_Nop	   },
   { "trigger",
     "(after|before|instead) <class> <method> <arity> [<code>] --> <code> | current (obj | argc | argv [<no>]) --> <text>",
     t2o_CtrlCmdC, 4,    7, t2o_MapStr	   },
   { "type",
     "(<sos_Object> | <type name>) --> <sos_Type>",
     t2o_UtilCmdC, 3,    3, t2o_Nop	   },
   { "update",
     "<ct>",
     t2o_CntCmdC,  3, 9999, t2o_Nop,	     2,    1 },
   { "version",
     "--> <text>",
     t2o_CtrlCmdC, 2,    2, t2o_Nop     }
};


LOCAL t2o_OptVariant t2o_bool_variants[] =
   { {"FALSE", t2o_FalseC}, {"TRUE", t2o_TrueC},
     {"false", t2o_FalseC}, {"true", t2o_TrueC},
     {"no",    t2o_FalseC}, {"yes",  t2o_TrueC},
     {"off",   t2o_FalseC}, {"on",   t2o_TrueC},
     {"0",     t2o_FalseC}, {"1",    t2o_TrueC}
   };
/*
 * required: t2o_custom_variants[i].code == i!
 */
LOCAL t2o_OptVariant t2o_custom_variants[] =
   { {t2o_AGGCMDSTR,    t2o_AggCmdC },  {t2o_CALLCMDSTR,   t2o_CallCmdC  },
     {t2o_CNTCMDSTR,    t2o_CntCmdC },  {t2o_CTRLCMDSTR,   t2o_CtrlCmdC  },
     {t2o_UTILCMDSTR,   t2o_UtilCmdC},  {t2o_OBJPREFSTR,   t2o_ObjPrefC  },
     {t2o_OBJCMDSTR,    t2o_ObjCmdC },  {t2o_ALLOWABBRSTR, t2o_AllowAbbrC},
     {t2o_ALLOWDFLTSTR, t2o_AllowDfltC},{t2o_CPCSTRSTR,	   t2o_CpCstrC},
   };
LOCAL t2o_OptVariant t2o_const_variants[] =
   { {"NO_OBJECT",      t2o_NOOBJECT_C  }, {"ROOT_CONTAINER",   t2o_ROOTcntC },
     {"SYNC_CONTAINER", t2o_SYNCcntC    }, {"TEMP_CONTAINER",   t2o_TEMPcntC },
#ifdef OBST_HAVE_JOYCE
     {"TRANSACTION",    t2o_TransactionC},
#endif
     {"UNUSED_CONTAINER", t2o_UNUSEDcntC}
   };
LOCAL t2o_OptVariant t2o_aggDir_variants[] =
   { {"forward", t2o_ForwardC}, {"fwd", t2o_ForwardC},
     {"reverse", t2o_ReverseC}, {"rev", t2o_ReverseC} 
   };
LOCAL t2o_OptVariant t2o_aggCurr_variants[] =
   { {"agg",   t2o_AggC  },
     {"role1", t2o_Role1C}, {"role2", t2o_Role2C}
   };

// The first 3 indices must be identical to the t2o_*Idx constants defined
// for trigger handling in t2o_cmd.C.
LOCAL t2o_OptVariant t2o_trigger_variants[] =
   { {"before", t2o_BeforeC}, {"instead", t2o_InsteadC},
     {"after",  t2o_AfterC }, {"current", t2o_CurrentC}
   };

LOCAL t2o_OptVariant t2o_trgCurr_variants[] =
   { {"argv", t2o_ArgvC}, {"receiver", t2o_ReceiverC}, {"argc", t2o_ArgcC}
   };


EXPORT t2o_OptVariants t2o_bool_opts	  = { t2o_ArraySz(t2o_bool_variants),
					      t2o_bool_variants
					    };
EXPORT t2o_OptVariants t2o_custom_opts	  = { t2o_ArraySz(t2o_custom_variants),
					      t2o_custom_variants
					    };
EXPORT t2o_OptVariants t2o_const_opts	  = { t2o_ArraySz(t2o_const_variants),
					      t2o_const_variants
					    };
EXPORT t2o_OptVariants t2o_aggDirect_opts = { t2o_ArraySz(t2o_aggDir_variants),
					      t2o_aggDir_variants
					    };
EXPORT t2o_OptVariants t2o_aggCurr_opts	  = { t2o_ArraySz(t2o_aggCurr_variants),
					      t2o_aggCurr_variants
					    };
EXPORT t2o_OptVariants t2o_trigger_opts	  = { t2o_ArraySz(t2o_trigger_variants),
					      t2o_trigger_variants
					    };
EXPORT t2o_OptVariants t2o_trgCurr_opts   = { t2o_ArraySz(t2o_trgCurr_variants),
					      t2o_trgCurr_variants
					    };

EXPORT t2o_OptVariants t2o_option[t2o_LastCommand()+1];
