# --------------------------------------------------------------------------
# Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
#
# You can use and distribute this software under the terms of the license
# version 1 you should have received along with this software.
# If not or if you want additional information, write to
# Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
# D-76131 Karlsruhe, Germany.
# --------------------------------------------------------------------------

#
# This file contains some randomly collected utility functions for working
# with OBST objects.
#

# ----------- object/type names -----------------------------------------------

#
# The name of the type of the given object.
#
proc obst::type {obj} {
   return [[[$obj type] get_name] make_Cstring]
}

#
# The name of the type of the given OBST $obj, or "" if $obj refers
# to NO_OBJECT or does not denote an OBST object.
#
proc obst::type2 {obj} {
   if {[string match "obst????????????????????????????????" $obj]} {
      if {$obj != [OBST const NO_OBJECT]} {
	 return [[[$obj type] get_name] make_Cstring]
   }}
   return ""
}

#
# The name of a named object, i.e. an instance of a subclass of sos_Named. The
# object must be such an instance and as well the object as its name must be
# defined.
#
proc obst::name {obj} {
   return [[$obj get_name] make_Cstring]
}

#
# The name of a named object, i.e. an instance of a subclass of sos_Named.
#
proc obst::name2 {obj} {
   if {[OBST isa $obj sos_Named]} then {
      if {[set name [$obj get_name]] = [OBST const NO_OBJECT]} then {
         return "<NO_OBJECT>"
      }
      return [$name make_Cstring]
   }
   return "<NO_NAME>"
}

# ----------- container stuff -------------------------------------------------

#
# Close (and thereby commit) all currently opened containers.
#
proc obst::commit {} {
   cnt close [cnt open_containers OPEN]
}

#
# Reset and close all containers.
#
proc obst::abort {} {
   cnt reset [cnt open_containers MODIFIABLE]
   cnt close [cnt open_containers OPEN]
}

#
# The pathname of the container directory.
#
proc obst::readCONTAINER {} {
   global env
   set result ""

   if {[catch {set result $env(OBSTCONTAINER)}]} then {
      catch {set result $env(SOSCONTAINER)}
   }
   return $result
}

# ----------- meta database stuff ---------------------------------------------

proc obst::class2ascii {cl} {
#
# Yields a string which almost contains a valid declaration for the class
# type $cl. $cl must no be a generic class.
# What's missing are create parameters for the class itself and its base
# classes, initialization expressions for components, and default expressions
# of method parameters.
#
   set rootcl [$cl root]
   set elems  {}

   set code(sos_PUBLIC)    0
   set code(sos_PROTECTED) 1
   set code(sos_PRIVATE)   2
   set code(0)		   public
   set code(1)		   protected
   set code(2)		   private

   agg loop [$cl get_components] {
      set m [[agg current] get_get_method]
      if {[[$m get_defined_in] root] == $rootcl} {
	 set key "$code([$m get_kind])$code([[[agg current] get_set_method] get_kind])"
	 set txt ""
	 if {[[agg current] get_is_local] == "TRUE"} {
	    append key 1
	    append txt "local "
	 } else {
	    append key 0
	 }
	 append key [set nm [obst::name [agg current]]]
	 append txt "[obst::name [[$m get_result_type] make_type]]\t$nm;"

	 lappend elems [list "$key" "$txt"]
   }}
   agg loop [$cl get_local_methods] {
      set m   [agg current]
      set key "$code([$m get_kind])9"
      set txt ""
      if {[$m get_is_static] == "TRUE"} {
	 append key 0
	 append txt "static "
      } elseif {[$m get_is_definite] == "TRUE"} {
	 append key 1
	 append txt "definite "
      } elseif {[$m get_is_abstract] == "TRUE"} {
	 append key 2
	 append txt "abstract "
      } else {
	 append key 9
      }

      append key [set nm [obst::name $m]]
      append txt "[obst::name [[$m get_result_type] make_type]]\t"

      if {[$m get_is_operator] == "TRUE"} {append txt "operator"}

      append txt "$nm ("

      set comma 0
      agg loop [$m get_params] {
	 if {$comma} {
	    append txt ", "
	 } else {
	    set comma 1
	 }
	 append txt [obst::name [[[agg current] get_type] make_type]]
	 if {[[agg current] get_is_ref] == "TRUE"} {
	    append txt "&"
      }}

      lappend elems [list "$key" "$txt);"]
   }

   set txt ""
   if {[$cl get_is_abstract] == "TRUE"} {append txt "abstract "}

   append txt "class [obst::name $cl]"

   if {[agg card [set agg [$cl get_super_classes]]] > 0} {
      append txt "\n\t: "

      set comma 0
      agg loop $agg {
	 if {[[agg current] get_is_direct] == "TRUE"} {
	    if {$comma} {
	       append txt ", "
	    } else {
	       set comma 1
	    }
	    append txt [obst::name [[[agg current] get_super_class] make_type]]
   }}}
   append txt "\n{"

   set access1 ""
   set access2 $code(sos_PRIVATE)
   set lbreak  ""
   foreach elem [lsort [set elems]] {
      set str  [string range [lindex [set elem] 0] 0 2]
      set acc1 [string range $str 0 0]
      set acc2 [string range $str 1 1]

      if {$acc1 != $access1  ||  $acc2 != $access2 && $acc2 != 9} {
	 append txt "\n $code([set access1 $acc1])"
	 if {$acc2 != $access2 && $acc2 != 9} {
	    if {[set access2 $acc2] != $acc1} {
	       append txt ", $code($acc2) get"
	 }}
	 append txt ":\n"
      } elseif {$lbreak != $str} {
	 append txt "\n"
      }
      set lbreak $str

      append txt "   [lindex [set elem] 1]\n"
   }
   return "[set txt]}\n"
}
