#!../../bin/wish -f
# --------------------------------------------------------------------------
# Copyright 1993-1994 by Forschungszentrum Informatik (FZI)
#
# You can use and distribute this software under the terms of the license
# version 1 you should have received along with this software.
# If not or if you want additional information, write to
# Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
# D-76131 Karlsruhe, Germany.
# --------------------------------------------------------------------------
# Program: graph_tk
# Tcl version: 7.3 (Tcl/Tk/XF)
# Tk version: 3.6
# XF version: 2.2
#

# module inclusion
global env
global xfLoadPath
global xfLoadInfo
set xfLoadInfo 0
if {[info exists env(XF_LOAD_PATH)]} {
  if {[string first $env(XF_LOAD_PATH) .:/usr/local/lib/] == -1} {
    set xfLoadPath $env(XF_LOAD_PATH):.:/usr/local/lib/
  } {
    set xfLoadPath .:/usr/local/lib/
  }
} {
  set xfLoadPath .:/usr/local/lib/
}



# procedure to show window ShowWindow.name
proc ShowWindow.name { args} {
# xf ignore me 7

  # build widget .name
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .name"
  } {
    catch "destroy .name"
  }
  toplevel .name 

  # Window manager configurations
  global tkVersion
  wm positionfrom .name ""
  wm sizefrom .name ""
  wm maxsize .name 1000 900
  wm minsize .name 10 10
  if {$tkVersion >= 3.0} {
    wm protocol .name WM_DELETE_WINDOW {cb.name.close}
  }
  wm title .name {Node Name}


  # build widget .name.frame8
  frame .name.frame8  -borderwidth {2}

  # build widget .name.frame8.frame
  frame .name.frame8.frame

  # build widget .name.frame8.frame.scrollbar1
  scrollbar .name.frame8.frame.scrollbar1  -command {.name.frame8.frame.entry2 view}  -orient {horizontal}  -width {10}

  # build widget .name.frame8.frame.entry2
  entry .name.frame8.frame.entry2  -relief {sunken}  -scrollcommand {.name.frame8.frame.scrollbar1 set}  -textvariable {name_entry}  -width {32}

  # pack widget .name.frame8.frame
  pack append .name.frame8.frame  .name.frame8.frame.entry2 {top frame center expand fill}  .name.frame8.frame.scrollbar1 {top frame center fillx}

  # build widget .name.frame8.label1
  label .name.frame8.label1  -text {name  }

  # pack widget .name.frame8
  pack append .name.frame8  .name.frame8.label1 {left frame center filly}  .name.frame8.frame {top frame center fillx}

  # build widget .name.frame9
  frame .name.frame9  -borderwidth {2}

  # build widget .name.frame9.button10
  button .name.frame9.button10  -command {cb.name.set}  -text {set}  -width {7}

  # build widget .name.frame9.button11
  button .name.frame9.button11  -command {cb.name.close}  -text {close}  -width {7}

  # pack widget .name.frame9
  pack append .name.frame9  .name.frame9.button10 {left frame center expand}  .name.frame9.button11 {left frame center expand}

  # pack widget .name
  pack append .name  .name.frame8 {top frame center pady 32 fillx}  .name.frame9 {top frame center pady 16 fill}

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .name"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.name {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .name]" != ""} {
      global xfShowWindow.name
      set xfShowWindow.name 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .name; XFEditSetShowWindows"
    }
  } {
    catch "destroy .name"
    update
  }
}


# procedure to show window ShowWindow.options
proc ShowWindow.options { args} {
# xf ignore me 7

  # build widget .options
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .options"
  } {
    catch "destroy .options"
  }
  toplevel .options   -borderwidth {8}

  # Window manager configurations
  global tkVersion
  wm positionfrom .options ""
  wm sizefrom .options ""
  wm maxsize .options 1000 900
  wm minsize .options 10 10
  if {$tkVersion >= 3.0} {
    wm protocol .options WM_DELETE_WINDOW {DestroyWindow.options}
  }
  wm title .options {Edge Options}


  # build widget .options.button16
  button .options.button16  -command {DestroyWindow.options}  -text {close}  -width {7}

  # build widget .options.frame17
  frame .options.frame17

  # build widget .options.frame17.frame0
  frame .options.frame17.frame0

  # build widget .options.frame17.frame0.radiobutton1
  radiobutton .options.frame17.frame0.radiobutton1  -relief {flat}  -text {solid}  -value {solid}  -variable {edit_stipple}

  # build widget .options.frame17.frame0.radiobutton2
  radiobutton .options.frame17.frame0.radiobutton2  -relief {flat}  -text {dimmed}  -value {gray50}  -variable {edit_stipple}

  # pack widget .options.frame17.frame0
  pack append .options.frame17.frame0  .options.frame17.frame0.radiobutton1 {top frame nw}  .options.frame17.frame0.radiobutton2 {top frame nw}

  # build widget .options.frame17.frame10
  frame .options.frame17.frame10

  # build widget .options.frame17.frame10.radiobutton11
  radiobutton .options.frame17.frame10.radiobutton11  -relief {flat}  -text {green}  -value {green}  -variable {arrow_(EdgeColor)}

  # build widget .options.frame17.frame10.radiobutton12
  radiobutton .options.frame17.frame10.radiobutton12  -relief {flat}  -text {blue}  -value {blue}  -variable {arrow_(EdgeColor)}

  # build widget .options.frame17.frame10.radiobutton13
  radiobutton .options.frame17.frame10.radiobutton13  -relief {flat}  -text {red}  -value {red}  -variable {arrow_(EdgeColor)}

  # build widget .options.frame17.frame10.radiobutton14
  radiobutton .options.frame17.frame10.radiobutton14  -relief {flat}  -text {black}  -value {black}  -variable {arrow_(EdgeColor)}

  # pack widget .options.frame17.frame10
  pack append .options.frame17.frame10  .options.frame17.frame10.radiobutton11 {top frame w}  .options.frame17.frame10.radiobutton13 {top frame w}  .options.frame17.frame10.radiobutton12 {top frame w}  .options.frame17.frame10.radiobutton14 {top frame w}

  # build widget .options.frame17.scale9
  scale .options.frame17.scale9  -command {arrow_option width}  -from {1}  -orient {horizontal}  -sliderlength {15}  -to {8}  -width {8}

  # pack widget .options.frame17
  pack append .options.frame17  .options.frame17.frame10 {top frame nw}  .options.frame17.frame0 {top frame sw pady 10}  .options.frame17.scale9 {top frame s pady 10}

  # build widget .options.frame18
  frame .options.frame18

  # build widget .options.frame18.frame1
  frame .options.frame18.frame1

  # build widget .options.frame18.frame1.radiobutton2
  radiobutton .options.frame18.frame1.radiobutton2  -relief {flat}  -text {bidirectional}  -value {bidir}  -variable {arrow_(EdgeType)}

  # build widget .options.frame18.frame1.radiobutton3
  radiobutton .options.frame18.frame1.radiobutton3  -relief {flat}  -text {unidirectional}  -value {unidir}  -variable {arrow_(EdgeType)}

  # build widget .options.frame18.frame1.radiobutton4
  radiobutton .options.frame18.frame1.radiobutton4  -relief {flat}  -text {undirected}  -value {nodir}  -variable {arrow_(EdgeType)}

  # pack widget .options.frame18.frame1
  pack append .options.frame18.frame1  .options.frame18.frame1.radiobutton4 {top frame w}  .options.frame18.frame1.radiobutton3 {top frame w}  .options.frame18.frame1.radiobutton2 {top frame w}

  # build widget .options.frame18.frame5
  frame .options.frame18.frame5

  # build widget .options.frame18.frame5.radiobutton6
  radiobutton .options.frame18.frame5.radiobutton6  -relief {flat}  -text {gridded}  -value {gridded}  -variable {arrow_(AttachMode)}

  # build widget .options.frame18.frame5.radiobutton7
  radiobutton .options.frame18.frame5.radiobutton7  -relief {flat}  -text {continuous}  -value {continuous}  -variable {arrow_(AttachMode)}

  # pack widget .options.frame18.frame5
  pack append .options.frame18.frame5  .options.frame18.frame5.radiobutton7 {top frame w}  .options.frame18.frame5.radiobutton6 {top frame w}

  # pack widget .options.frame18
  pack append .options.frame18  .options.frame18.frame1 {top frame sw}  .options.frame18.frame5 {top frame sw pady 32}

  # pack widget .options
  pack append .options  .options.button16 {bottom frame s pady 16}  .options.frame17 {left frame n padx 8}  .options.frame18 {right frame n padx 8}

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .options"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.options {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .options]" != ""} {
      global xfShowWindow.options
      set xfShowWindow.options 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .options; XFEditSetShowWindows"
    }
  } {
    catch "destroy .options"
    update
  }
}


# procedure to show window ShowWindow.file
proc ShowWindow.file { args} {
# xf ignore me 7

  # build widget .file
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .file"
  } {
    catch "destroy .file"
  }
  toplevel .file   -borderwidth {4}

  # Window manager configurations
  global tkVersion
  wm positionfrom .file ""
  wm sizefrom .file ""
  wm maxsize .file 1000 900
  wm minsize .file 10 10
  wm title .file {File Name}
  if {$tkVersion >= 3.0} {
    wm protocol . WM_DELETE_WINDOW {DestroyWindow.file}
  }

  # build widget .file.frame1
  frame .file.frame1

  # build widget .file.frame1.scrollbar1
  scrollbar .file.frame1.scrollbar1  -command {.file.frame1.entry2 view}  -orient {horizontal}  -width {11}

  # build widget .file.frame1.entry2
  entry .file.frame1.entry2  -relief {sunken}  -scrollcommand {.file.frame1.scrollbar1 set}  -textvariable {file_entry} -width 30

  # pack widget .file.frame1
  pack append .file.frame1  .file.frame1.entry2 {top frame center expand fill}  .file.frame1.scrollbar1 {top frame center fillx}

  # build widget .file.button2
  button .file.button2  -command {cb.file.do} -text {do}  -width {7}

  # build widget .file.button3
  button .file.button3  -command {DestroyWindow.file}  -text {close}  -width {7}

  # pack widget .file
  pack append .file  .file.frame1 {top frame center pady 12 fillx}  .file.button2 {left frame center expand}  .file.button3 {right frame center expand}

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .file"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.file {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .file]" != ""} {
      global xfShowWindow.file
      set xfShowWindow.file 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .file; XFEditSetShowWindows"
    }
  } {
    catch "destroy .file"
    update
  }
}


# procedure to show window .
proc ShowWindow. {args} {# xf ignore me 7

  # Window manager configurations
  global tkVersion
  wm positionfrom . ""
  wm sizefrom . ""
  wm maxsize . 1152 900
  wm minsize . 0 0
  if {$tkVersion >= 3.0} {
    wm protocol . WM_DELETE_WINDOW {cb.main.close}
  }
  wm title . {Graph Editor [write]}

  # build widget .frame0
  frame .frame0 \
    -borderwidth {1} \
    -relief {raised}

  # build widget .frame0.menubutton1
  menubutton .frame0.menubutton1 \
    -borderwidth {1} \
    -menu {.frame0.menubutton1.m} \
    -relief {raised} \
    -text {Help}

  # build widget .frame0.menubutton1.m
  menu .frame0.menubutton1.m
  .frame0.menubutton1.m add command \
    -command {infobox::displayInfo about} \
    -label {About...}

  # build widget .frame0.menubutton2
  menubutton .frame0.menubutton2 \
    -borderwidth {1} \
    -menu {.frame0.menubutton2.m} \
    -relief {raised} \
    -text {Graph }

  # build widget .frame0.menubutton2.m
  menu .frame0.menubutton2.m
  .frame0.menubutton2.m add command \
    -command {cb.main.file write} \
    -label {Write File}
  .frame0.menubutton2.m add command \
    -command {cb.main.file read} \
    -label {Read File}
  .frame0.menubutton2.m add separator
  .frame0.menubutton2.m add command \
    -command {cb.main.file postscript} \
    -label {Write Postscript}
  .frame0.menubutton2.m add separator
  .frame0.menubutton2.m add command \
    -command {cb.main.save} \
    -label {Save}
  .frame0.menubutton2.m add command \
    -command {cb.main.reset} \
    -label {Reset}
  .frame0.menubutton2.m add separator
  .frame0.menubutton2.m add command \
    -command {cb.main.close} \
    -label {Save & Exit}
  .frame0.menubutton2.m add command \
    -command {cb.main.close 1} \
    -label {Reset & Exit}

  # build widget .frame0.menubutton3
  menubutton .frame0.menubutton3 \
    -borderwidth {1} \
    -menu {.frame0.menubutton3.m} \
    -relief {raised} \
    -text { Edit  }

  # build widget .frame0.menubutton3.m
  menu .frame0.menubutton3.m
  .frame0.menubutton3.m add command \
    -command {cb.options.start} \
    -label {Options}

  # pack widget .frame0
  pack append .frame0 \
    .frame0.menubutton2 {left frame center} \
    .frame0.menubutton3 {left frame center} \
    .frame0.menubutton1 {right frame center}

  # build widget .frame4
  frame .frame4 \
    -borderwidth {1}

  # build widget .frame4.scrollbar1
  scrollbar .frame4.scrollbar1 \
    -command {.frame4.canvas2 yview} \
    -relief {sunken} \
    -width {10}

  # build widget .frame4.scrollbar3
  scrollbar .frame4.scrollbar3 \
    -command {.frame4.canvas2 xview} \
    -orient {horizontal} \
    -relief {sunken} \
    -width {10}

  # build widget .frame4.canvas2
  canvas .frame4.canvas2 \
    -borderwidth {5} \
    -height {200} \
    -insertofftime {600} \
    -relief {groove} \
    -scrollregion {0c 0c 20c 20c} \
    -width {300} \
    -xscrollcommand {.frame4.scrollbar3 set} \
    -yscrollcommand {.frame4.scrollbar1 set}
  # bindings
  bind .frame4.canvas2 <Double-Button-1> {cb.edit.node_new %x %y}

  # pack widget .frame4
  pack append .frame4 \
    .frame4.scrollbar1 {left frame center filly} \
    .frame4.canvas2 {top frame center expand fill} \
    .frame4.scrollbar3 {top frame center fillx}

  # pack widget .
  pack append . \
    .frame0 {top frame center fillx} \
    .frame4 {top frame center expand fill}


  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree ."
    after 2 "catch {XFEditSetShowWindows}"
  }
}


# User defined procedures


# ---------
proc cb.main.close { {reset "0"} {exit "0"}} {
#
# Either commits (reset == 0) or undoes (reset == 1) all changes, terminates
# the main program, and closes all windows.
# The second parameter gives the program exit code (defaults to 0).
#
   db.graph.exit $reset
   destroy .
   exit $exit
}


# ---------
proc cb.main.save {} {
#
# Saves the current state of the graph permanently.
#
   db.cnt.savepoint
}


# ---------
proc cb.main.reset {} {
#
# Restores the currently edited graph to the last savepoint.
#
   global edit_canvas

   edit.cursor 0

   foreach nodeID [Node_list $edit_canvas] {
      cb.edit.node_delete $nodeID 0
   }

   db.cnt.savepoint 0 1
   db.graph.init

   edit.cursor 1
}


# ---------
proc cb.main.file { what} {
#
# Initializes and then starts the 'file name' dialog. 'what' is memorized for
# further processing in cb.file.do.
#
   global file_command file_entry

   set ext [file extension $file_entry]
   if {$what == "postscript"} {
      if {$ext == ""} {
	 append file_entry .ps
      }
   } elseif {$ext == ".ps"} {
      set file_entry [file rootname $file_entry]
   }
   set file_command $what

   ShowWindow.file
}

# ---------
proc cb.main.stipple { name1 name2 args} {
#
# Procedure to mirror the value of $arrow_(EdgeStipple) into $edit_stipple
# and vice versa. There is one conversion:
# $arrow_(EdgeStipple) == "" <--> $edit_stipple == "solid".
# (This procedure is necessary since a radiobutton can not trigger on the
#  value "".)
#
   global edit_stipple arrow_

   set value [expr {($edit_stipple == "solid") ? "" : $edit_stipple}]

   if {$value != $arrow_(EdgeStipple)} {
      if {$name1 == "edit_stipple"} {
	 arrow_option stipple $value
      } else {
	 set value	  $arrow_(EdgeStipple)
	 set edit_stipple [expr {($value == "") ? "solid" : $value}]
      }
   }
}

# ---------
proc cb.options.start {} {
#
# Starts up the 'Edge Options' dialog and binds the scale widget contained
# therein to the current edge width.
#
   set width [arrow_option width]
   ShowWindow.options
   [SymbolicName options::scale] set $width
}


# ---------
proc cb.name.close {} {
#
# Terminates the 'node name' dialog and clears any entry fields contained
# therein. Furthermore, the name_nodeID variable is deleted.
#
   global name_entry name_nodeID

   set name_entry ""
   unset name_nodeID

   DestroyWindow.name
}


# ---------
proc cb.name.set {} {
#
# Sets the name of the current node as taken from the entry field of the
# 'node name' dialog and terminates this dialog.
# Furthermore, the 'arrows' module gets informed about the change and the
# display of the node is refreshed wrt. to that module, too.
#
   global edit_canvas name_nodeID name_entry

   $edit_canvas itemconfigure $name_nodeID -text [set name_entry]

   Node_add  $edit_canvas $name_nodeID refresh
   Node_move $edit_canvas $name_nodeID

   db.graph.node update $name_nodeID
   cb.name.close
}


# ---------
proc cb.file.do {} {
#
# Executes the operation currently associated with the 'file name' dialog and
# then terminates this dialog.
#
   global edit_canvas edit_mode file_command file_entry

   if {$file_command == "postscript"} {
      [SN edit.canvas] postscript -file $file_entry

   } else {
      edit.cursor 0

      if {$file_command == "read"} {
	 if {$edit_mode == "read-only"} {
	    infobox::displayText "*** This operation is not allowed in read-only mode!"
	    edit.cursor 1
	    return
	 }
	 foreach nodeID [Node_list $edit_canvas] {
	    cb.edit.node_delete $nodeID 0
	 }
      }
      db.file.do $file_command $file_entry

      edit.cursor 1
   }
   DestroyWindow.file
}


# ---------
proc cb.edit.node_new { x y} {
#
# If not in read-only mode, computes a default node text and initiates the
# creation of a new node at the given coordinates.
# Nothing will be done in read-only mode.
#
   global edit_mode edit_selected_node edit_counter

   set edit_selected_node ""

   if {$edit_mode != "read-only"} {
      cb.edit.node_create $x $y "node #$edit_counter"
   }
}


# ---------
proc cb.edit.node_create { x y text {update_db "1"}} {
#
# Creates the graphic structure of a node on $edit_canvas (currently just a
# text item holding the given text) at the given coordinates and sets up event
# bindings for that structure.
# The structure is tagged with an unique (wrt. to this invocation of the graph
# editor) identifier which does then also serve as node ID.
# Furthermore, the structure is defined as an 'arrows' node.
#
# The result value is the ID of the newly created 'arrows' node.
#
# If update_db == 1, a node is created in the persistent graph representation,
# too. In this case, the result value will be "".
#
# In the read-only edit mode, the procedure does not set up any event bindings
# for the created nodes. Hence, these can not be modified.
#
   global edit_mode edit_canvas edit_counter

   set w  $edit_canvas
   set id "n[incr edit_counter]"

   $w create text $x $y -text "$text" -tags $id
   Node_add $w $id new

   if {$edit_mode != "read-only"} {
      $w bind $id <1>		     "Node_drag init %W $id %x %y"
      $w bind $id <B1-Motion>	     "Node_drag move %W $id %x %y"
      $w bind $id <ButtonRelease-1>  "cb.edit.node_dragged $id"
      $w bind $id <Double-2>	     "cb.edit.node_edit    $id"
      $w bind $id <Control-Button-1> "cb.edit.node_delete  $id"
      $w bind $id <2>		     "cb.edit.edge create $id"
      $w bind $id <3>		     "cb.edit.edge delete $id"
   }
   if {$update_db} {
      db.graph.node create $id
   }
   return $id
}


# ---------
proc cb.edit.node_delete { id {update_db "1"}} {
#
# Deletes the given node from $edit_canvas, i.e. as well the node definition
# as the node contents themselves.
# If update_db == 1, the deletion is performed in the persistent store, too.
#
   global edit_canvas edit_selected_node

   set edit_selected_node ""

   if {$update_db} {
      db.graph.node delete $id
   }
   Node_remove $edit_canvas "$id"
   $edit_canvas delete "$id"
}


# ---------
proc cb.edit.node_edit { id} {
#
# Starts the 'node name' dialog for the node with the given id and defines
# 'name_entry' and 'name_nodeID' for passing the text value and the ID of the
# node, respectively.
#
   global name_entry name_nodeID edit_canvas edit_selected_node

   set edit_selected_node ""

   set name_entry  [lindex [$edit_canvas itemconfigure $id -text] 4]
   set name_nodeID $id
   ShowWindow.name
}


# ---------
proc cb.edit.node_dragged { id} {
#
# Cleans up after the node denoted by $id was (possibly) dragged.
#
   global edit_selected_node

   set edit_selected_node ""
   db.graph.node update $id
}


# ---------
proc cb.edit.edge { what id} {
#
# Performs an edge operation by either creating (what == "create") or
# removing an edge (what == "delete") between two nodes.
# This procedure has to be invoked twice without any interleaved call of
# another callback handler of $edit_canvas. The first call does just register
# the node $id in edit_selected_node.
#
   global edit_canvas edit_selected_node

   if {$edit_selected_node == ""} {
      set edit_selected_node $id
   } else {
      if {$what == "create"} {
	 Edge_create $edit_canvas $edit_selected_node $id
	 db.graph.edge create $edit_selected_node $id

      } elseif {[Edge_ID $edit_canvas $edit_selected_node $id] != ""} {
	 db.graph.edge delete $edit_selected_node $id
         Edge_remove $edit_canvas $edit_selected_node $id
      }
      set edit_selected_node ""
   }
}


# ---------
proc edit.mode.set { new_mode} {
#
# Changes the edit mode to $new_mode.
#
   global edit_mode

   if {$edit_mode != $new_mode} {
      wm title . "Graph Editor \[[set edit_mode $new_mode]\]"
   }
}


# ---------
proc edit.cursor { normal} {
#
# Changes the cursor to either normal shape ($normal == 1), or to a shape
# which indicates that the program has some work to do ($normal == 0).
#
   global edit_canvas

   if {$normal} {
      $edit_canvas configure -cursor {}
   } else {
      $edit_canvas configure -cursor box_spiral
      update
   }
}


# Internal procedures



# module load procedure
proc XFLocalIncludeModule {{moduleName ""}} {
  global env
  global xfLoadInfo
  global xfLoadPath
  global xfStatus

  foreach p [split $xfLoadPath :] {
    if {[file exists "$p/$moduleName"]} {
      if {![file readable "$p/$moduleName"]} {
        puts stderr "Cannot read $p/$moduleName (permission denied)"
        continue
      }
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName..."
      }
      source "$p/$moduleName"
      return 1
    }
    # first see if we have a load command
    if {[info exists env(XF_VERSION_SHOW)]} {
      set xfCommand $env(XF_VERSION_SHOW)
      regsub -all {\$xfFileName} $xfCommand $p/$moduleName xfCommand
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName...($xfCommand)"
      }
      if {[catch "exec $xfCommand" contents]} {
        continue
      } {
        eval $contents
        return 1
      }
    }
    # are we able to load versions from wish ?
    if {[catch "afbind $p/$moduleName" aso]} {
      # try to use xf version load command
      global xfVersion
      if {[info exists xfVersion(showDefault)]} {
        set xfCommand $xfVersion(showDefault)
      } {
	# our last hope
        set xfCommand "vcat -q $p/$moduleName"
      }
      regsub -all {\$xfFileName} $xfCommand $p/$moduleName xfCommand
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName...($xfCommand)"
      }
      if {[catch "exec $xfCommand" contents]} {
        continue
      } {
        eval $contents
        return 1
      }
    } {
      # yes we can load versions directly
      if {[catch "$aso open r" inFile]} {
        puts stderr "Cannot open $p/[$aso attr af_bound] (permission denied)"
        continue
      }
      if {$xfLoadInfo} {
        puts stdout "Loading $p/[$aso attr af_bound]..."
      }
      if {[catch "read \{$inFile\}" contents]} {
        puts stderr "Cannot read $p/[$aso attr af_bound] (permission denied)"
        close $inFile
        continue
      }
      close $inFile
      eval $contents
      return 1
    }
  }
  puts stderr "Cannot load module $moduleName -- check your xf load path"
  puts stderr "Specify a xf load path with the environment variable:"
  puts stderr "  XF_LOAD_PATH (e.g \"export XF_LOAD_PATH=.\")"
  catch "destroy ."
  catch "exit 0"
}



# end source
proc EndSrc {} {
#
# The program is either invoked without any parameter and will then work with
# a graph container whose name is entered in the "tclOBST Graph Editor" slot
# of the OBST root directory. This container will be newly created if necessary.
#
# Otherwise, the program is invoked either by
#	$main_self new
# or by
#	$main_self <container> (read-only | copy-on-write | write)
# The last parameter defines an edit mode as described below. If a new graph
# container was created during the program run and the container does still
# exist at program end, its name will be printed onto stdout upon termination.
# Otherwise, no output will result.
#
# environment, parameters:
#  - OBST*, argc, argv
#
# global variables:
#  - main_self
#	Name of the program.
#
#  - edit_canvas
#	Path of editor canvas.
#  - edit_mode
#       Enumeration defining how operations take effect (set in db.init,
#	db.cnt.savepoint):
#	 read-only	the graph must not be modified
#	 copy-on-write	like 'write', but the old graph (i.e. its persistent
#			representation) will not be changed but instead copied
#			upon the first modification
#	 write		graph may be freely changed
#	 new		like 'write', but the graph container was newly
#			created and will be printed at program end (unless
#			reset to the initial, empty state)
#  - edit_mode_orig
#	Original value of $edit_mode as set in db.init.
#  - edit_attrs
#	Array which holds lists of names of those display parameter which are
#	to be stored into / read from the graph container. Indices are:
#	 canvas   name of (item)configure options of an edge item
#	 arrows   corresponding names for the arrow_options procedure
#	 graph	  names of arrow_options parameters stored with the graph
#  - edit_counter
#	Counter (starting at 0) for generating unique identifiers.
#  - edit_selected_node
#	Id of last node selected for a 2-node operation; defaults to "".
#	All callback handlers for $edit_canvas except for cb.edit.edge_do have
#	to reset this variable.
#  - edit_stipple
#	Variable for radiobutton array which selects the current edge stipple
#	(see cb.main.stipple).
#
#  - file_entry
#	Textvariable attached to the entry field in the 'file name' dialog.
#	Only valid while the dialog box is active.
#	It defaults to "./graph".
#  - file_command
#	Operation which is to be performed if the 'do' button is pressed in
#	the 'file name' dialog.
#
#  - name_entry
#	Textvariable attached to the entry field in the 'node name' dialog.
#	Only valid while the dialog box is active.
#  - name_nodeID
#	ID of the node whose name is shown in the 'node name' dialog.
#	Only valid while the dialog box is active.
#
#  - db_container
#	Container where the currently edited graph is stored.
#	Set in db.init, db.cnt.savepoint.
#  - db_container_orig
#	"" if a new container was created in db.init, otherwise the original
#	value of $db_container as set in db.init.
#  - db_container_new
#	1 if a new container was created in edit_mode "new" or "copy-on-write"
#	and will persist, otherwise 0. Set in db.init, db.cnt.savepoint.
#  - db_graph
#	Root of the objects making up the graph in $db_container.
#	Set in db.graph.init.
#  - db_IDmap
#	Tcl array holding the persistent object ID corresponding to the node/
#	edge IDs used by the 'arrows' module, and vice versa.
#	Indices have to be prepended by "p," (persistent --> arrows), or by
#	"a," (arrows --> persistent), respectively.
#	The array is cleared in db.graph.init.
#
   global edit_canvas edit_attrs edit_counter edit_selected_node edit_mode file_entry edit_stipple arrow_

   # block incomming send requests
   rename send ""

   tclOBST bind
   tclOBST customize copy_Cstrings false

   set file_entry	  "./graph"

   set edit_canvas	  [SymbolicName edit.canvas]
   set edit_counter	  0
   set edit_selected_node ""
   set edit_mode	  ""

   set edit_attrs(canvas) { -fill -width -stipple }
   set edit_attrs(arrows) { color width  stipple  }
   set edit_attrs(graph)  { color width  stipple attach type }

   arrow_option attach  continuous
   arrow_option type    nodir
   arrow_option width   1
   arrow_option color   black
   arrow_option stipple ""

   set edit_stipple	solid

   trace variable edit_stipple	      w cb.main.stipple
   trace variable arrow_(EdgeStipple) w cb.main.stipple

   db.init
}

XFLocalIncludeModule arrows.tcl
XFLocalIncludeModule graph_obst.tcl
XFLocalIncludeModule infobox_tk.tcl
XFLocalIncludeModule xfstuff.tcl


# initialize global variables
proc InitGlobals {} {
  global {infobox::aboutText}
  set {infobox::aboutText} {
                   tclOBST Graph Editor

The Graph Editor is a simple example for the use of the
`arrows' module that supports the display and manipulation
of a graph of movable nodes and edges connecting them.

Nodes and edges are created and manipulated with the mouse:
 o Double clicking with the left mouse button creates a new
   node with a default name.
 o A node is deleted by clicking on it with the left mouse
   button while pressing the 'control' key.
 o A node is dragged with the left mouse button held down.
   Any edge attached to that node will follow the movement.
 o A new edge is created by clicking with the middle mouse
   button on the start and then on the end node.
 o An edge is likewise deleted by clicking with the right
   mouse button on the connected nodes.
 o Double clicking on a node with the middle mouse button
   pops up a dialog in which the node name can be changed.

Use the `Graph' menu to write to / read from a file:
 o You can either write the current graph into a text file
   (`Write File'),
 o read a previously written graph from a text file
   (`Read File'), or
 o generate a postscript representation of the ** currently
   visible portion ** of the graph (`Write Postscript').
You can use ~ substitution as in the C shell.

Use the `Graph' menu also to handle savepoints and to exit
the program:
 o You can either write a savepoint (`Save'),
 o set back to the previous savepoint (`Reset'),
 o commit changes and exit the program (`Save & Exit'), or
 o reset to the last savepoint and exit (`Reset & Exit').
If there is no previous savepoint, the graph editor will
reset to the initial state at program startup.

Edge display options can be set in the dialog box which is
activated by the `Edit.Options' menu entry:
 o Edges are either moved smoothly ('continuous') along the
   bounding box of a node or are only attached to a few
   points on that boundary ('gridded').
 o The remaining options apply to newly created edges, i.e.
   an edge has to be destroyed and then recreated in order
   to change such an edge display parameter. There are:
   o Edge color and saturation,
   o edge width in pixels, and
   o whether the edge is 'undirected', 'unidirectional', or
     'bidirectional'.}
  global {main_self}
  set {main_self} {graphedit}

  # please don't modify the following
  # variables. They are needed by xf.
  global {autoLoadList}
  set {autoLoadList(arrows.tcl)} {0}
  set {autoLoadList(graph_obst.tcl)} {0}
  set {autoLoadList(graph_tk.tcl)} {0}
  set {autoLoadList(infobox_tk.tcl)} {0}
  set {autoLoadList(main.tcl)} {0}
  set {autoLoadList(xfstuff.tcl)} {0}
  global {internalAliasList}
  set {internalAliasList} {}
  global {moduleList}
  set {moduleList(arrows.tcl)} { arrow_doc arrow_init arrow_coordfunc arrow_set_coordfuncs arrow_option Node_add Node_move Node_drag Node_remove Node_list Node_neighbours Edge_create Edge_remove Edge_ID Edge_type Edge_coords arrow_set_nodeattrs arrow_gridded_rect_Tcl arrow_continuous_rect_Tcl arrow_continuous_oval_Tcl arrow_isct edge_create_bidir edge_move_bidir edge_remove_bidir edge_create_unidir edge_move_unidir edge_remove_unidir edge_create_nodir edge_move_nodir edge_remove_nodir}
  set {moduleList(graph_obst.tcl)} { db.init db.graph.init db.graph.save db.graph.clone db.graph.exit db.file.do db.graph.node db.graph.edge db.graph.ID_create db.cnt.access db.cnt.savepoint}
  set {moduleList(graph_tk.tcl)} { cb.main.close cb.main.save cb.main.reset cb.main.file cb.main.stipple cb.options.start cb.name.close cb.name.set cb.file.do cb.edit.node_new cb.edit.node_create cb.edit.node_delete cb.edit.node_edit cb.edit.node_dragged cb.edit.edge edit.mode.set edit.cursor . .options .name}
  set {moduleList(infobox_tk.tcl)} { infobox::displayInfo infobox::displayText .infobox}
  set {moduleList(xfstuff.tcl)} { Alias GetSelection MenuPopupAdd MenuPopupMotion MenuPopupPost MenuPopupRelease NoFunction SN SymbolicName Unalias}
  global {preloadList}
  set {preloadList(xfInternal)} {}
  global {symbolicName}
  set {symbolicName(edit.canvas)} {.frame4.canvas2}
  set {symbolicName(infobox::root)} {.infobox}
  set {symbolicName(infobox::text)} {.infobox.frame.text2}
  set {symbolicName(options::scale)} {.options.frame17.scale9}
  set {symbolicName(root)} {.}
  global {xfWmSetPosition}
  set {xfWmSetPosition} {}
  global {xfWmSetSize}
  set {xfWmSetSize} {}
  global {xfAppDefToplevels}
  set {xfAppDefToplevels} {}
}

# initialize global variables
InitGlobals

# display/remove toplevel windows.
ShowWindow.

global xfShowWindow.infobox
set xfShowWindow.infobox 0

global xfShowWindow.name
set xfShowWindow.name 0

global xfShowWindow.options
set xfShowWindow.options 0

global xfShowWindow.file
set xfShowWindow.file 0

# end source
EndSrc

# eof
#

