#ifndef _C2OBST_H
#define _C2OBST_H
/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 *
 * --------------------------------------------------------------------------
 * Interface definitions for the C --> OBST Interface.
 *
 * Definitions marked by XTND belong to the extended interface, the others
 * make up the basic interface.
 *
 * Functions marked by NoERR do not perform the standard sequence for
 * setting error codes.
 * --------------------------------------------------------------------------
 * ORIGINAL: D. Theobald				DATE: 14/2/93
 * --------------------------------------------------------------------------
 */

#include "obst_trc.h"
#ifdef __cplusplus
#  include "obst_err.h"
#  include "cci_use.h"

extern "C" {
#endif


/* -----  Object Definition  ------------------------------------------ */

#define OBST_OBJ_SIZE	20
#define OBST_ID_SIZE	 8

#ifndef __cplusplus
typedef struct
{  union
   {   long _for_alignment;
       char c[OBST_OBJ_SIZE];
   } u;
} sos_Object;

typedef struct
{  union
   {  long _for_alignment;
      char c[OBST_ID_SIZE];
   } u;
} sos_Id; 

extern sos_Object NO_OBJECT;
#endif


/* -----  Enumerations, Types ----------------------------------------- */
/* (XTND except for sos_Open_result, sos_Access_mode, sos_Sync_mode,	*/
/*  sos_Container_status.)						*/

#ifndef __cplusplus
typedef const char*   err_msg;

typedef float	      sos_Float;
typedef char          sos_Char;
typedef int           sos_Int;
typedef char*         sos_Cstring;
typedef void*         sos_Pointer;
typedef void	      (*sos_CppFctPtr)();
typedef unsigned      sos_Offset;

typedef sos_Int	      Index;

			/* incomplete signature since a function must not */
			/* be called from C via such a pointer		  */
typedef sos_Object    (*cci_Fun)();

typedef sos_Pointer   cci_Impl_obj;
typedef sos_CppFctPtr cci_IO_fun;
typedef sos_CppFctPtr cci_Cvt_fun;

typedef sos_Int	      sos_Timestamp;
typedef sos_Int	      sos_HostProc_Id;
typedef sos_Int	      sos_User_Id;

#  if OBSTVERSIONNO >= 340
typedef sos_Int	      sos_Shorty;
typedef sos_Int	      sos_Version;

typedef enum { PROT_NONE, PROT_DEL,
	       PROT_ADD,  PROT_MOD		    } sos_Change_kind;
#  endif

typedef enum { err_SYS, err_USE, err_WNG	    } err_class;

typedef enum { FALSE, TRUE			    } sos_Bool;
typedef enum { EQ_STRONG, EQ_WEAK		    } sos_Eq_kind;
typedef enum { CMP_LESS, CMP_EQUAL, CMP_GREATER     } sos_Comp_result;
typedef enum { LOCKED, OPENED,
	       UNACCESSIBLE, DEADLOCK	  	    } sos_Open_result;
typedef enum { READING, CHECKOUT, WRITING	    } sos_Access_mode;
typedef enum { TESTING, WAITING	    		    } sos_Sync_mode;
typedef enum { READABLE, CHECKEDOUT, 
	       WRITEABLE, DESTROYED, UNAVAILABLE    } sos_Container_status;
typedef enum { NOT_MODIFIABLE, MODIFIABLE, OPEN     } sos_Container_mod_status;
typedef enum { NOT_EXISTING, PERHAPS_EXISTING	    } sos_Existing_status;

typedef enum { AGG_HASH, AGG_LIST, AGG_AUTOMATIC    } agg_Impl;

typedef enum { sos_PRIVATE,
	       sos_PROTECTED,   sos_PUBLIC	    } sos_Method_kind;
typedef enum { sos_IMP_NONE,    sos_IMP_TYPE,
	       sos_IMP_GENERIC, sos_IMP_SUPERCLASS  } sos_Import_mode;

typedef enum { cci_OBJECT, cci_LIB,
	       cci_SCHEMA, cci_NONE 		    } cci_Dependency;

#  ifdef OBST_HAVE_JOYCE
typedef enum { NOTYPE,  TIMESTAMP,
	       LOCKING, OPTIMISTIC		    } sos_Transaction_tp;
typedef enum { INACTIVE, ACTIVE, COMMITTED, ABORTED } sos_Transaction_status;
typedef enum { READ_AC, CHECK_AC, WRITE_AC, NO_AC   } ta_Access_mode;
typedef enum { SYNC_OK,
	       SYNC_CONT_NO_FOUND,
               SYNC_TA_NOT_STARTED,
	       SYNC_TA_NOT_ACTIVE,
               SYNC_TA_IMPLICIT,
               SYNC_NOVALID_TS,
               SYNC_DEADLOCK,
               SYNC_TA_ABORTED,
               SYNC_IMPLTA_ABORTED,
               SYNC_NOT_GET,
               SYNC_WRONG_ACCESS,
               SYNC_TA_ALREADY_EXISTS,
               SYNC_TA_NOT_EXISTS,
               SYNC_TA_NOT_OWN,
               SYNC_SYNCOBJ_NOT_EXISTS		    } sos_Error;
typedef enum { NOLOCK, WRITE, READLOCK, WRITELOCK   } Lock_Mode;
#  endif
#endif


/* -----  Method Call Handling: programming interface  ---------------- */

extern
sos_Object obst_call_method  __FSIG_((const sos_Object*,
				      const char*, int, sos_Object[]));
extern
sos_Object obst_vcall_method __FSIG_((const sos_Object*,
				      const char*, int __VARARGS));

extern
sos_Object obst_call_classmethod  __FSIG_((const char*,
					   const char*, int, sos_Object[]));
extern
sos_Object obst_vcall_classmethod __FSIG_((const char*,
					   const char*, int __VARARGS));


/* -----  Method Call Handling: call handler interface  --------------- */

/*
 * Type encoding: either one of the constants below, or the name of a
 *		  non-void scalar type.
 */
#define obst_VOID		0
#define obst_CLASS		1
#define obst_CLASS_OR_SCALAR	2

typedef struct
{  cci_Fun code;	/* method implementation			*/
   void*   user_data;	/* client data associated with the method	*/
} obst_mData;

typedef struct
{  obst_mData md;
   char*      mname;	 /* method name					*/
   int	      param_no;	 /* number of parameters (incl. default args.)	*/
   char*      resulttp;	 /* result type encoding (see above)		*/
   int        *refparams;/* indices of reference params (-1 terminated)	*/
   char*      *paramtps; /* parameter type encoding (see above)		*/
} obst_mInfo;

extern obst_mInfo* obst_prepared;

extern sos_Bool	  obst_mcall_prep    __FSIG_((const sos_Object*,
					      const char*, int));
extern sos_Bool	  obst_cmcall_prep   __FSIG_((const char*,
					      const char*, int));
extern sos_Object obst_call_prepared __FSIG_((sos_Object[]));

extern int	  obst_prepared_info __FSIG_((sos_Object*, sos_Object*));


								/* XTND */
extern sos_Bool	  obst_method_data   __FSIG_((const char*, const char*, int,
					      obst_mData*, sos_Bool));


/* -----  Type Handling  ---------------------------------------------- */

extern void 	  obst_set_schemas __FSIG_((const char*[]));
extern char**	  obst_get_schemas __FSIG_(());
extern sos_Object obst_lookup_type __FSIG_((const char*));	/* XTND */


/* -----  Scalar Types  ----------------------------------------------- */

typedef void obst_proc();
typedef enum { cvt_String2Object, cvt_Object2String } obst_cvt_ops;

extern void obst_scalar_converter __FSIG_((const char*,
					   obst_cvt_ops, obst_proc*));


extern sos_Object obst_scalar2object __FSIG_((const char*, void*));
extern void	  obst_object2scalar __FSIG_((const sos_Object*, void*));

extern sos_Object obst_enum2object   __FSIG_((const char*, int));  /* XTND */
extern int        obst_object2enum   __FSIG_((const sos_Object*)); /* XTND */

extern sos_Object obst_string2object __FSIG_((const char*,
					      const char*));	   /* XTND */
extern char*	  obst_object2string __FSIG_((const sos_Object*)); /* XTND */

extern void       obst_string2scalar __FSIG_((const char*,
					      const char*, void*));/* XTND */
extern char*      obst_scalar2string __FSIG_((const char*, void*));/* XTND */


/* -----  Container, Container_set  ----------------------------------- */

typedef void* obst_Container_set;

#ifndef __cplusplus
typedef union {sos_Float _for_alignment; int i;} sos_Container;

extern sos_Container* ROOT_CONTAINER;
extern sos_Container* SYNC_CONTAINER;
extern sos_Container* TEMP_CONTAINER;
extern sos_Container* UNUSED_CONTAINER;

#  ifdef OBST_HAVE_JOYCE
extern sos_Object    obst_TRANSACTION;
#  endif
#endif

extern sos_Object	    obst_cnt_root_object   __FSIG_((sos_Container));
extern sos_Container_status obst_cnt_status        __FSIG_((sos_Container));
extern sos_Bool 	    obst_cnt_modified      __FSIG_((sos_Container));
extern sos_Bool 	    obst_cnt_exists        __FSIG_((sos_Container));
extern sos_Int		    obst_cnt_occupied      __FSIG_((sos_Container));
extern sos_Existing_status  obst_cnt_object_exists __FSIG_((sos_Container,
							    sos_Offset,
							    sos_Int));

extern sos_Open_result obst_cnt_open	 __FSIG_((sos_Container,
					          sos_Access_mode,
						  sos_Sync_mode));
extern sos_Open_result obst_cnt_access   __FSIG_((sos_Container,
					          sos_Access_mode,
						  sos_Sync_mode));

extern sos_Container obst_cnt_create   __FSIG_(());
extern void 	     obst_cnt_close    __FSIG_((sos_Container));
extern void	     obst_cnt_destroy  __FSIG_((sos_Container));
extern void	     obst_cnt_commit   __FSIG_((sos_Container));
extern void	     obst_cnt_reset    __FSIG_((sos_Container));
extern void	     obst_cnt_clear    __FSIG_((sos_Container));
extern void	     obst_cnt_update   __FSIG_((sos_Container));
extern void	     obst_cnt_compress __FSIG_((sos_Container));
extern void	     obst_cnt_squeeze  __FSIG_((sos_Container));

extern obst_Container_set obst_cset_create  __FSIG_(());
extern obst_Container_set obst_cset_clone   __FSIG_((obst_Container_set));
extern void		  obst_cset_destroy __FSIG_((obst_Container_set));

extern obst_Container_set obst_cset_open_containers 
 					__FSIG_((sos_Container_status));
extern obst_Container_set obst_cset_open_containers_mod
 					__FSIG_((sos_Container_mod_status));

#if OBSTVERSIONNO >= 336
extern void		  obst_cset_clear    __FSIG_((obst_Container_set));
#endif
extern obst_Container_set obst_cset_insert   __FSIG_((obst_Container_set,
						      sos_Container));
extern obst_Container_set obst_cset_remove   __FSIG_((obst_Container_set,
						      sos_Container));
extern obst_Container_set obst_cset_add	     __FSIG_((obst_Container_set,
						      obst_Container_set));
extern obst_Container_set obst_cset_sub	     __FSIG_((obst_Container_set,
						      obst_Container_set));
extern int		 obst_cset_card	     __FSIG_((obst_Container_set));
extern sos_Container	 obst_cset_at        __FSIG_((obst_Container_set,int));

extern sos_Open_result   obst_cset_open_sets __FSIG_((obst_Container_set,
						      obst_Container_set,
						      obst_Container_set,
						      sos_Sync_mode));
extern sos_Open_result   obst_cset_open      __FSIG_((obst_Container_set,
						      sos_Access_mode,
						      sos_Sync_mode));
extern void		 obst_cset_close     __FSIG_((obst_Container_set));
extern void		 obst_cset_commit    __FSIG_((obst_Container_set));
extern void		 obst_cset_reset     __FSIG_((obst_Container_set));


/* -----  Error handling  --------------------------------------------- */

							     /* XTND, NoERR */
extern void  	  obst_err_raise __FSIG_((err_class, err_msg, err_msg, int));

extern int   	  obst_err_occurred    __FSIG_((err_class)); /* XTND, NoERR */
extern void  	  obst_err_reset       __FSIG_(());	     /* XTND, NoERR */

extern err_class  obst_err_last_class  __FSIG_(()); 	     /* XTND, NoERR */
extern err_msg    obst_err_last_raised __FSIG_(());	     /* XTND, NoERR */
extern err_msg	  obst_err_last_origin __FSIG_(());	     /* XTND, NoERR */

extern obst_proc* obst_err_sethandler  __FSIG_((obst_proc*));/* XTND, NoERR */

extern int  	  obst_err_blockstart  __FSIG_(());	     /* XTND, NoERR */
extern void 	  obst_err_blockend    __FSIG_(());	     /* XTND, NoERR */

							     /* XTND, NoERR */
#ifndef __cplusplus
#define obst_err_block	   if(obst_err_blockstart()){
#define obst_err_exception obst_err_blockend();}else{
#define obst_err_block_end }
#endif


/* -----  Utilities, Shortcuts  --------------------------------------- */

extern sos_Bool   obst_identical  __FSIG_((const sos_Object*,
				  	   const sos_Object*)); /* XTND */

extern sos_Object obst_type       __FSIG_((const sos_Object*)); /* XTND */
extern sos_Bool	  obst_is_scalar  __FSIG_((const sos_Object*)); /* XTND */
extern sos_Bool	  obst_has_type   __FSIG_((const sos_Object*,	/* XTND */
					   const char*));
extern sos_Bool	  obst_isa	  __FSIG_((const sos_Object*,	/* XTND */
					   const char*));
extern sos_Bool	  obst_is_some    __FSIG_((const sos_Object*,	/* XTND */
					   const char*));

extern int 	  obst_objsize    __FSIG_((const sos_Object*)); /* XTND */

extern int	  obst_card	  __FSIG_((const sos_Object*)); /* XTND */

extern sos_Int	     obst_obj2int __FSIG_((const sos_Object*)); /* XTND */
extern sos_Object    obst_int2obj __FSIG_((sos_Int));		/* XTND */

extern sos_Container obst_obj2cnt __FSIG_((const sos_Object*)); /* XTND */
extern sos_Object    obst_cnt2obj __FSIG_((sos_Container));	/* XTND */

extern char* 	     obst_obj2str __FSIG_((const sos_Object*)); /* XTND */
extern sos_Object    obst_str2obj __FSIG_((const char*));	/* XTND */

extern char*	     obst_stats   __FSIG_(());			/* XTND */


/* -----  Iterators  -------------------------------------------------- */

extern void* obst_iter_start  __FSIG_((const sos_Object*, sos_Bool)); /*XTND*/
extern void* obst_iter_next   __FSIG_((void*));	 	  	  /* XTND */
extern void  obst_iter_finish __FSIG_((void*));		  	  /* XTND */
extern char* obst_iter_elemtp __FSIG_((void*, int));		  /* XTND */

extern sos_Object obst_iter_role1  __FSIG_((void*));	 	  /* XTND */
extern sos_Object obst_iter_role2  __FSIG_((void*));	 	  /* XTND */
extern sos_Object obst_iter_get    __FSIG_((void*));	 	  /* XTND */

#define obst_iterate(agg) \
{void*__iter=obst_iter_start(agg,TRUE);for(;__iter;__iter=obst_iter_next(__iter)){
#define obst_iterate_end(agg) }obst_iter_finish(__iter);}
#define obst_iterate_role1()  obst_iter_role1(__iter)
#define obst_iterate_role2()  obst_iter_role2(__iter)
#define obst_iterate_get()    obst_iter_get(__iter)


/* -----  Controlling the Interface ----------------------------------- */

typedef struct
{ sos_Bool   allow_defaults;		/* method handling		*/
  sos_Bool   check_args;	       	/* error handling		*/
  sos_Bool   catch_syserrs;
  err_msg    syserr;
  obst_proc* set_schemas_trigger;	/* type table management	*/
  sos_Bool   copy_Cstrings;		/* scalar conversion handling	*/
} c2obst_Ctrls;

extern c2obst_Ctrls c2obst_ctrls;

extern const char*  c2obst_version;


/* -----  OBST tracing  ----------------------------------------------- */

#define c2o_H  150
#define c2o_M  151
#define c2o_L  152
#define c2o_VL 153

/* Tracing conventions:
 *      c2o_VL: internal meta schema interface
 *      c2o_L : module initialization
 *		internal operations: conversions, method handling
 *      c2o_M : externally visible operations except for method handling
 *      c2o_H : externally visible method call handling
 */

#ifdef __cplusplus
}
#endif
#endif
