/* --------------------------------------------------------------------------
* Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "OBST", Haid-und-Neu-Str. 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
*/

// **************************************************************************
// Module blob (experimental)
// **************************************************************************
// implements methods of classes: sos_Blob
// **************************************************************************

#define OBST_IMP_STDCONST
#define OBST_IMP_FORMATTED_IO
#define OBST_IMP_STRINGOP
#include "obst_stdinc.h"

// #include "obst_config.h"
#include "obst_progstd.h"
#include "obst_err.h"

#include "obst_trc.h"
#include "blob_obst.h"

// For tracing only (module trc)

#define blob_H  130
#define blob_M  131
#define blob_L  132
#define blob_VL 133


/*
access to regions and iterators are not yet implemented

// *************************************************************************
sos_CString sos_Blob::get_region (sos_Int pos, sos_Int size)
// *************************************************************************
// "size" specifies, how many characters should be read.
// Default is 1.
{  T_PROC ("sos_Blob::get_region")
   TT (blob_H, T_ENTER; TI(pos); TI(size))

   TT (blob_H, T_LEAVE)
   return result;
}
*/

#define ADDR(a,p) a+p-1

// *************************************************************************
void sos_Blob::set_nth (sos_Int pos, sos_Char c)
// *************************************************************************
{  T_PROC ("sos_Blob::get_nth")
   TT (blob_H, T_ENTER; TI(pos); TC(c))

   // assert 1 <= position <= legth
   err_assert ((0 < pos) AND (pos <= self.get_length()),
               "Blob:set_nth:position invalid");

   self.container().write (ADDR(self.get_address(),pos), 1, &c);

   TT (blob_H, T_LEAVE)
}

// *************************************************************************
sos_Char sos_Blob::get_nth (sos_Int pos)
// *************************************************************************
{  T_PROC ("sos_Blob::get_nth")
   TT (blob_H, T_ENTER; TI(pos))

   err_assert ((0 < pos) AND (pos <= self.get_length()),
               "Blob:get_nth:position invalid");
   sos_Char c;
   self.container().read (ADDR(self.get_address(),pos), 1, &c);

   TT (blob_H, T_LEAVE; TC(c))
   return c;
}

// *************************************************************************
sos_Char sos_Blob::operator[] (sos_Int pos)
// *************************************************************************
// completely identical to sos_Blob::get_nth
{  T_PROC ("sos_Blob::operator[]")
   TT (blob_H, T_ENTER; TI(pos))

   err_assert ((0 < pos) AND (pos <= self.get_length()),
               "Blob:[]:position invalid");
   sos_Char c;
   self.container().read (ADDR(self.get_address(),pos), 1, &c);

   TT (blob_H, T_LEAVE; TC(c))
   return c;
}

// *************************************************************************
void sos_Blob::replace (sos_Int pos, sos_Blob b, sos_Int size)
// *************************************************************************
// "size" specifies, how many characters should be replaced.
// A value of 0 for "size" means replace whole b
{  T_PROC ("sos_Blob::replace")
   TT (blob_H, T_ENTER; TI(pos))

   sos_Int replace_length = (size==0 ? b.get_length(): size);

   err_assert ((0 < pos) AND (pos+replace_length-1 <= self.get_length()),
               "Blob:replace:position invalid");

   self.container().copy (ADDR(self.get_address(),pos), replace_length,
                          b.container(), b.get_address());

   TT (blob_H, T_LEAVE)
}

// *************************************************************************
void sos_Blob::replace_Cstring (sos_Int pos, sos_Cstring cs, sos_Int size)
// *************************************************************************
{  T_PROC ("sos_Blob::replace_Cstring")
   TT (blob_H, T_ENTER; TI(pos); TI(size))

   err_assert ((0 < pos) AND (pos+size-1 <= self.get_length()),
               "Blob:replace:position invalid");

   self.container().write (ADDR(self.get_address(),pos), size, cs);

   TT (blob_H, T_LEAVE)
}

// *************************************************************************
void sos_Blob::operator+= (sos_Blob b)
// *************************************************************************
{  T_PROC ("sos_Blob::operator+=")
   TT (blob_H, T_ENTER)

   sos_Int    size = b.get_length(),
              old_size = self.get_length();
   sos_Offset old_addr = self.get_address();
   sos_Container ct   = self.container();

   self.set_length (old_size + size);
   sos_Offset addr = ct.allocate (old_size + size);
   ct.copy (addr, old_size, ct, old_addr);
   ct.copy (addr+old_size, size, b.container(), b.get_address());
   ct.deallocate (old_addr, old_size);

   // This is not very sophisticated because incrementally growing
   // Blobs lead to fragmentation in the container even if there is 
   // enough free space after the original location
   
   TT (blob_H, T_LEAVE)
}

// *************************************************************************
sos_Blob sos_Blob::copy_Cstring (sos_Container cnt,
                                 sos_Cstring cstr, sos_Int size)
// *************************************************************************
{  T_PROC ("sos_Blob::copy_Cstring")
   TT (blob_H, T_ENTER)

   sos_Blob result = sos_Blob::create(cnt, size);

   if (cstr && *cstr)
   {  
      cnt.write (result.get_address(), size, cstr);
   }
   TT (blob_H, T_LEAVE)
   return result;
}


// *************************************************************************
void sos_Blob::assign_Cstring (sos_Cstring s, sos_Int size)
// *************************************************************************
{  T_PROC ("sos_Blob::assign_Cstring")
   TT (blob_H, T_ENTER; TI(size));

   sos_Int       old_size = self.get_length();
   sos_Container ct = self.container();
 
   if (old_size != size)
   {  self.set_length (size);
      if (old_size > 0)              // remove the old contents
	 ct.deallocate (self.get_address(), old_size);
   }
   if (size > 0)
   {  
      sos_Offset new_addr;
      if (old_size == size)      // it's not necessary to allocate new space
         new_addr = self.get_address();
      else
      {  new_addr = ct.allocate (size);
         self.set_address (new_addr);
      }  
      ct.write (new_addr, size, s);
   }
   TT (blob_H, T_LEAVE; TI (old_size))
}

// *************************************************************************
sos_Cstring sos_Blob::make_Cstring ()
// *************************************************************************
{  T_PROC ("sos_Blob::make_Cstring")
   TT (blob_H, T_ENTER)

   int         size = self.get_length();
   sos_Cstring str  = new char[size+1];

   self.container().read (self.get_address(), size, str);
   str[size] = '\0';

   TT (blob_H, T_LEAVE; TI (size));
   return str;
}

// **************************************************************************
sos_Int sos_Blob::size()
// **************************************************************************
{  T_PROC ("sos_Blob::size")
   TT (blob_H, T_ENTER)

   sos_Int sz = self.container().realsize (self.get_length())
		+ self.sos_Object::size();

   TT (blob_H, T_LEAVE)
   return sz;
}

// *************************************************************************
void sos_Blob::local_finalize (sos_Blob str)
// *************************************************************************
{  T_PROC ("sos_Blob::local_finalize")
   TT (blob_M, T_ENTER)

   sos_Int size = str.get_length();

   if (size > 0)
      str.container().deallocate (str.get_address(), size);

   TT (blob_M, T_LEAVE)
}

// *************************************************************************
sos_Bool sos_Blob::local_equal (sos_Blob x, sos_Object o, sos_Eq_kind)
// *************************************************************************
{  T_PROC ("sos_Blob::local_equal")
   TT (blob_M, T_ENTER)

   sos_Blob y   = sos_Blob::make (o);
   sos_Int    l_y = y.get_length();
   
   sos_Bool result = (sos_Bool)(x.get_length() == l_y AND
				x.container().equal(x.get_address(), l_y,
						    y.container(),
						    y.get_address()));
   TT (blob_M, T_LEAVE; TB(result));
   return result;
}

// *************************************************************************
sos_Int sos_Blob::local_hash_value (sos_Blob x)
// *************************************************************************
{  T_PROC ("sos_Blob::local_hash_value")
   TT (blob_M, T_ENTER)

   sos_Int result = x.container().hash_value (x.get_address(), x.get_length());

   TT (blob_M, T_LEAVE; TI (result));
   return result;
}

// *************************************************************************
void sos_Blob::local_assign (sos_Blob x, sos_Object o)
// *************************************************************************
{  T_PROC ("sos_Blob::local_assign")
   TT (blob_M, T_ENTER)

   sos_Blob b = sos_Blob::make (o);
 
   sos_Int       size = b.get_length(),
		 old_size = x.get_length();
   sos_Container ct   = x.container();

   if (old_size != size)
   {  x.set_length (size);
      if (old_size > 0)              // remove the old contents
	 ct.deallocate (x.get_address(), old_size);
   }
   if (size > 0)
   {
      sos_Offset new_addr;
      if (old_size == size)      // it's not necessary to allocate new space
         new_addr = x.get_address();
      else
      {  new_addr = ct.allocate (size);
         x.set_address (new_addr);
      }  
     ct.copy (new_addr, size, b.container(), b.get_address());
   }

   TT (blob_M, T_LEAVE)
}

// *************************************************************************
void sos_Blob::local_initialize (sos_Blob b)
// *************************************************************************
{  T_PROC ("sos_Blob::local_initialize")
   TT (blob_M, T_ENTER)

   sos_Int size = b.get_length();
   if (size > 0)
      b.set_address (b.container().allocate (size));
   else 
   {
      err_assert (size == 0, "Blob:create:negative length");
      b.set_address (0);
   }
 
   TT (blob_M, T_LEAVE)
}
