/* =================================================================== */
/*       EXPORT FILE                                               === */
/* =================================================================== */
/*                                                                     */
/* CONCEPT: Source of Error                                            */
/*                                                                     */
/*                                                                     */
/* =================================================================== */
#ifndef ERRC
#define ERRC 1

/* =================================================================== */
/* error module of SOS                                                 */
#include "obst_err.h"
#include "smg.h"

/* =================================================================== */

// NULL elements
#define SOS_NO_STRING sos_String::make(NO_OBJECT)
#define SOS_NO_TYPE sos_Type::make(NO_OBJECT)
extern sos_Id NOID;    
#define ID_NO_ID add_Id::make(NO_OBJECT)
#define SOS_NO_STRING sos_String::make(NO_OBJECT)
#define EMPTY_CSTRING ""


// Constant definitions for this class :                               
const int ERR_MAX_ERR_MESSAGE_LENGTH = 1000;
const sos_Cstring ERR_UNEXPECTED_ERROR_STRING = "!! ";

  // errors:
const int ERR_CONSISTENT = 111;
const int ERR_INCONSISTENT = 112;
const int ERR_UNEXPECTED_ERROR = 113;
const int ERR_FATAL_ERROR = 114;
const int ERR_DELETION_NOT_PERMITTED = 115;
const int ERR_WARNING = 116;
const int ERR_ASSIGN_NOT_PERMITTED = 117;

extern sos_Object sos_Id2Object(sos_Id id);

inline sos_Id sos_Id_of(sos_Object o)
{
  return sos_Id::make(o.container(), o.offset());
}

inline sos_Cstring make_string_from_sos_Id(sos_Id& i)
{  
  static char result[40];
  // sos_Cstring result  = new char[40];
  sprintf(result,"<%d,%d>", (int)i.container(), (int)i.offset());
  return result;
/*   smg_String s  = smg_String("<") + (int)i.container()
				   + "," + (int)i.offset() + ">";
   return s.make_Cstring (SMG_TRANSFER);  // SMG_COPY creates a string on the heap.
*/
}

inline sos_Id make_sos_Id_object_from_sos_String (sos_String S)
{  
   int        ct, os;
   sos_Cstring s = S.make_Cstring();
   int n = sscanf (s, "<%d,%d>", &ct, &os);
   delete s;
   if (n == 2)
     return sos_Id::make(sos_Container::make(ct), os);
   else
     return NOID;
}

#endif
