/* =================================================================== */
/*       CLASS - IMPLEMENTATION                                    === */
/* =================================================================== */
/*                                                                     */
/* CLASS-NAME: add_Id                       Class_Id: ID               */
/*                                                                     */
/* IMPLEMENTATION ISSUES:                                              */
/*  constant ids are indicated by (id.conatiner ==  ROOT_CONTAINER)).
    It is not possible to protect them to be changed after creation.
/*                                                                     */
/* =================================================================== */
#define ERR_CONCEPT 1

/* =================================================================== */
/* Substitution of C-symbols :                                         */
#include "predef.h"

/* =================================================================== */
/* Trace switches:                                                     */
#include "trc_add.h"

/* =================================================================== */
// Export File of this concept
#include "Source_of_Error_obst.h"

/*
sos_Id add_Id::sos_id()

// PURPOSE:                                                
// returns the sos_id of the referenced object.
//                                                         
// PRECONDITION:                                           
//          None.                                          
//                                                         
// POSTCONDITION, ERRORS:                                  
//           None

{
 return (self.get_sos_id());
}     
*/

sos_Object add_Id::object()

// PURPOSE:                                                
// returns the referenced object
//                                                         
// PRECONDITION:                                           
//          None.                                          
//                                                         
// POSTCONDITION, ERRORS:                                  
// returns NO_OBJECT if the container is not opened, or
// if the referenced object is not existing.

{
  T_PROC("add_Id::object()");
  TT(serr_H, T_ENTER);
  sos_Container cnt = self.get_container();
  sos_Object obj;
  
  if ((cnt != TEMP_CONTAINER) AND
      ((cnt.status() == UNAVAILABLE) OR
       (cnt.status() == DESTROYED)))
    {
      TT(0, TXT("access to an object in an unopened container"));
      TT(serr_H, T_LEAVE);
      return(NO_OBJECT);
    }
  if (cnt == ROOT_CONTAINER)
    {
      cerr << "add_Id::object(): access to WSP_BROADCAST_ALL or an object in the root container\n";
      TT(0, TXT("access to WSP_BROADCAST_ALL or an object in the root container"));
      TT(serr_H, T_LEAVE);
      return(NO_OBJECT);
    }

//  if (cnt.object_exists(self.get_offset(), self.get_object_size())
  if (cnt.object_exists(self.get_offset(), 10)
      == NOT_EXISTING)
    {
      TT(0, TXT("access to an non existing object"));
      TT(serr_H, T_LEAVE);
      return(NO_OBJECT);
    }
  
  err_block
    {
      obj = sos_Object::make(sos_Typed_id::make(sos_Id::make(cnt, self.get_offset())));
    }
  err_exception
    {
      obj = NO_OBJECT;
    }
  err_block_end;
  
  TT(serr_H, T_LEAVE; TOBJ(obj));
  
  return(obj);
}

	
Void add_Id::assign_obj(sos_Object obj)
//
// PURPOSE:                                                
// assigns a reference of another object;
//                                                         
// PRECONDITION:                                           
//          None.                                          
//                                                         
// POSTCONDITION, ERRORS:                                  
//           None

{
   T_PROC("add_Id::assign_obj(sos_Object obj)");
   TT(serr_H, T_ENTER);

/*  constant ids are indicated by (id.conatiner ==  ROOT_CONTAINER)).
    It is not possible to protect them to be changed after creation.
  if (self.get_container() == ROOT_CONTAINER)
    {
      cerr << "add_Id::assign_obj(sos_Object obj): attempt to change constant WSP_BROADCAST_ALL\n";
      TT(0, TXT("attempt to change constant WSP_BROADCAST_ALL"));
      TT(serr_H, T_LEAVE);
      return;
    }
*/
   self.set_container(obj.container());
   self.set_offset(obj.offset());
//   self.set_object_size(obj.size());

   TT(serr_H, T_LEAVE; TOBJ(obj));
   return;
}


Void add_Id::assign_cnt_offset(sos_Container cnt , sos_Offset offset, sos_Int obj_size)
//
// PURPOSE:                                                
// assigns a reference of another object;
//                                                         
// PRECONDITION:                                           
//          None.                                          
//                                                         
// POSTCONDITION, ERRORS:                                  
//           None

{
   T_PROC("add_Id::assign_cnt_offset(sos_Container, sos_Offset)");
   TT(serr_H, T_ENTER);

/*  constant ids are indicated by (id.conatiner ==  ROOT_CONTAINER)).
    It is not possible to protect them to be changed after creation.
  if (self.get_container() == ROOT_CONTAINER)
    {
      cerr << "add_Id::assign_cnt_offset(sos_Container, sos_Offset): " 
	   << "attempt to change constant WSP_BROADCAST_ALL\n";
      TT(0, TXT("attempt to change constant WSP_BROADCAST_ALL"));
      TT(serr_H, T_LEAVE);
      return;
    }
*/
   self.set_container(cnt);
   self.set_offset(offset);
   if (obj_size == 0)  //default
     self.set_object_size(self.size());
   else
     self.set_object_size(obj_size);

   TT(serr_H, T_LEAVE);
   return;
}


sos_Cstring add_Id::description()
   //
   // PURPOSE:                                                
   // returns a description of this Id
   // 
   // PRECONDITION:       
   // 
   // POSTCONDITION, ERRORS: 
{
  T_PROC ("add_Id::description()"); TT(serr_H, T_ENTER);
  sos_Cstring id_desc = new char[30];
  sprintf(id_desc, "<%d,%d>", sos_Int(self.get_container()), self.get_offset());
/*
  sos_Cstring id_desc = new char[50];
  if (self != ID_NO_ID)
      {
	  sos_Id sos_id = self.get_sos_id();
	  sprintf(id_desc, "<%d,%d>", sos_id.container(), sos_id.offset());
      }
  else
      strcpy(id_desc, "ID_NO_ID");
*/
  TT(serr_H, T_LEAVE; TS(id_desc));return (id_desc);
}


void add_Id::local_assign(add_Id destination,
			  sos_Object source_obj)

// PURPOSE:                                                
// initializes sos_Id
//                                                         
// PRECONDITION:                                           
//          None.                                          
//                                                         
// POSTCONDITION, ERRORS:                                  
//           None

{
   T_PROC("add_Id::local_assign(add_Id destination, sos_Object source_obj)");
   TT(serr_H, T_ENTER);
   add_Id source = add_Id::make(source_obj);

/*  constant ids are indicated by (id.conatiner ==  ROOT_CONTAINER)).
    It is not possible to protect them to be changed after creation.
    if (destination.get_offset() != source.get_offset() OR
      destination.get_container() != source.get_container()) {
	if (destination.get_container() == ROOT_CONTAINER)
	  {
	    cerr << "add_Id::local_assign(): "
	      << "attempt to change constant WSP_BROADCAST_ALL\n";
	    TT(0, TXT("attempt to change constant WSP_BROADCAST_ALL"));
	    TT(serr_H, T_LEAVE);
	    return;
	  }
*/	
	destination.set_container(source.get_container());
	destination.set_offset(source.get_offset());
//	destination.set_object_size(source.get_object_size());
//      }
					 
   TT(serr_H, T_LEAVE); return;
}     


sos_Bool add_Id::total_equal (add_Id this_one, sos_Object other_obj,
			      sos_Eq_kind eq_kind=EQ_STRONG)
// PURPOSE:                                                
// clean up
//                                                         
// PRECONDITION:                                           
//          None.                                          
//                                                         
// POSTCONDITION, ERRORS:                                  
//           None

{
   T_PROC("add_Id::local_equal (add_Id this_one, sos_Object other_obj, sos_Eq_kind eq_kind)");
   TT(serr_H, T_ENTER);
   add_Id other = add_Id::make(other_obj);
   sos_Bool retvalue = ((this_one.get_container() == other.get_container()) AND
			(this_one.get_offset() == other.get_offset()));
   TT(serr_H, sos_Cstring retvalue_desc;
      if (retvalue)
      {retvalue_desc = "equal";}
      else
      { retvalue_desc = "not equal"; }      
      T_LEAVE; TS( retvalue_desc));
   return(retvalue);
}     
