/* =================================================================== */
/*       CLASS - IMPLEMENTATION                                    === */
/* =================================================================== */
/*                                                                     */
/* CLASS-NAME: Name_Space_Element                 Class_Id: NSPEL      */
/*                                                                     */
/* IMPLEMENTATION ISSUES:                                              */
/*                                                                     */
/* =================================================================== */
#define NAME_SPACE_CONCEPT 1

/* =================================================================== */
/* Substitution of C-symbols :                                         */
#include "predef.h"

/* =================================================================== */
/* Trace switches:                                                     */
#include "trc_add.h"

/* =================================================================== */
// Export File of this concept
#include "Name_Space_obst.h"

// indicates that a name_space is assigned
// warnings about corrected names
// should be supressed during this phase.
// relevant for local_initialize.
extern sos_Bool nsp_no_corrected_syntax_warnings;

// --- Constants used in this file only ---- //
#define NSPEL_CREATION_FAILED 127


// ---- Test Environment ---- //

add_Name_Space test_root;

Void nsp_test_init ()
  // initializies the runtime data structures of this process
  // for a stand alone test of the name space concept.
  // This function should be called only by main();
{
  T_PROC("nsp_test_init"); TT(nsp_H, T_ENTER);
  sos_String tmp_string = sos_String::create(TEMP_CONTAINER);
  tmp_string.assign_Cstring("doc_root");
  test_root = add_Name_Space::create(TEMP_CONTAINER, tmp_string, NSP_NO_NSP);
  TT(nsp_H, T_LEAVE); return;
}


// ---- Public Methods of this Class ---- //


sos_Cstring add_Name_Space_Element::name()
   //
   // PURPOSE:
   // returns the name of this name_space element in a buffer.
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
  T_PROC("add_Name_Space_Element::name()"); TT(serr_H, T_ENTER);

  static sos_Cstring buffers_for_name [8] = 
    { new char [NSPEL_MAX_NAME_LENGTH], new char [NSPEL_MAX_NAME_LENGTH],
      new char [NSPEL_MAX_NAME_LENGTH], new char [NSPEL_MAX_NAME_LENGTH],
      new char [NSPEL_MAX_NAME_LENGTH], new char [NSPEL_MAX_NAME_LENGTH],
      new char [NSPEL_MAX_NAME_LENGTH], new char [NSPEL_MAX_NAME_LENGTH] 
      };
  static int buffer_no = 0;
  
  // static sos_Cstring copy_of_name = new char [NSPEL_MAX_NAME_LENGTH];
/*  sos_Cstring tmp = self.get_sos_name().make_Cstring();
  // during initialization self.get_sos_name() points to the create parameter
  // which may contain a string > NSPEL_MAX_NAME_LENGTH:
  strncpy(copy_of_name, tmp, NSPEL_MAX_NAME_LENGTH);  
  copy_of_name[NSPEL_MAX_NAME_LENGTH-1] = '\0';    
  delete tmp;

  TT(serr_H, TS( copy_of_name));
  TT(serr_H, T_LEAVE); return (copy_of_name);
*/
  sos_Cstring tmp = self.get_sos_name().make_Cstring();
  // during initialization self.get_sos_name() points to the create parameter
  // which may contain a string > NSPEL_MAX_NAME_LENGTH:
  if (buffer_no < 7)
    buffer_no++;
  else
    buffer_no = 0;
  strncpy(buffers_for_name[buffer_no], tmp, NSPEL_MAX_NAME_LENGTH);  
  buffers_for_name[buffer_no][NSPEL_MAX_NAME_LENGTH-1] = '\0';    
  delete tmp;

  TT(serr_H, TS( buffers_for_name[buffer_no]));
  TT(serr_H, T_LEAVE); return (buffers_for_name[buffer_no]);

} 


Void add_Name_Space_Element::new_name(sos_Cstring new_name)
   //
   // PURPOSE:
   // sets the name and pathname of the name_space element;
   //                                                         
   // PRECONDITION:                                           
   //     The string new_name must not contain any '/' !!
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     NSPEL_CHAR_NOT_ALLOWED  if new_name contains any '/'.
   //     NSP_EXISTING_NAME       if new_name denotes an existing element
   //                             in this name space.
   //     NSP_NAME_TOO_LONG       if strlen(new_name) > NSPEL_MAX_NAME_LENGTH
{  
  T_PROC("add_Name_Space_Element::new_name(sos_Cstring new_name)"); TT(nsp_H, T_ENTER);
  TT(nsp_H, TS( new_name));
  self.clear_error();

  // Is this a real change ?
  sos_Cstring current_name = self.get_sos_name().make_Cstring();
  if (streql(current_name, new_name))
      { delete current_name; TT(nsp_H, T_LEAVE); return; } 
  delete current_name;

  // Perform change:
  char correct_new_name [NSPEL_MAX_NAME_LENGTH];
  strcpy( correct_new_name, self.correct_syntax(new_name));
  self.method_successfull();

  add_Name_Space nsp = self.get_name_space();
  if (nsp != NO_OBJECT) {
    if (NOT nsp.rename_permitted(self,correct_new_name))
      {
	self.flag_error(NSPEL_RENAME_FAILED, self.error_message(NSPEL_RENAME_FAILED));
	TT(nsp_H, T_LEAVE); return;
      }

    // 1. Replace the old reference in the containing name space
    // 2. change of name (done here!!)
    nsp.note_rename(self,correct_new_name);
  }
  else {
    // 2. change of name 
    self.get_sos_name().assign_Cstring(correct_new_name);
  }

  // 3. notify others
  if (self.isa(add_Name_Space_type)) {
    // Notify all elements
    Map_str_to_nspel nspel_map = add_Name_Space::make(self).get_elements();
    agg_iterate_association (nspel_map, sos_String key, 
			     add_Name_Space_Element nspel)
      {  
	nspel.note_parent_rename();
      }
    agg_iterate_association_end (nspel_map, key, nspel);
  }

  TT(nsp_H, T_LEAVE); return;
} 


add_Name_Space add_Name_Space_Element::containing_name_space()
   //
   // PURPOSE:
   // returns the containing Name_Space object;
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
  add_Name_Space retvalue;

//  T_PROC("add_Name_Space_Element::containing_name_space()"); TT(nsp_H, T_ENTER);

  retvalue = self.get_name_space();

//  if revalue != NO_OBJECT
//  TT(nsp_H, TS( retvalue.pathname()));
//  TT(nsp_H, T_LEAVE); 
  return (retvalue);
} 


sos_Cstring add_Name_Space_Element::pathname()
   //
   // PURPOSE:
   // returns the class component object "pathname";
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
  T_PROC("add_Name_Space_Element::pathname()"); TT(nsp_L, T_ENTER);
  static sos_Cstring copy_of_pathname = new char [NSPEL_MAX_PATH_LENGTH];
/*
  sos_Cstring tmp = self.get_pathname().make_Cstring();
  copy_of_pathname[0] = '/';
  strcpy(REF(copy_of_pathname[1]), tmp);
  delete tmp;
*/

  sos_Cstring path = self.get_sos_name().make_Cstring();
  add_Name_Space parent = self.containing_name_space();
  while (parent != NO_OBJECT) 
    {
      sos_Cstring parent_name = 
	parent.get_name().make_Cstring();
      sos_Cstring old_path = path;
      path = new char[strlen(parent_name)+strlen(path)+2];
      sprintf(path,"%s/%s", parent_name, old_path);
      delete parent_name;
      delete old_path;
      parent = parent.containing_name_space();
    }

  copy_of_pathname[0] = '/';
  strcpy(REF(copy_of_pathname[1]), path);
  delete path;
  TT(nsp_L, T_LEAVE); return (copy_of_pathname);
} 


Void add_Name_Space_Element::move_to (add_Name_Space new_nsp)
   //
   // PURPOSE:
   // moves this Name_Space_Element to Name_Space new_nsp.
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   // NSPEL_MOVE_FAILED   in case the element could not be moved.
{
  T_PROC("add_Name_Space_Element::move_to (add_Name_Space new_nsp)"); 
  TT(nsp_H, T_ENTER; 
     if (new_nsp != NO_OBJECT)
     {TS( new_nsp.pathname());}
     else
     {TXT("new nsp = NO_OBJECT");}
     );

  add_Name_Space nsp = self.get_name_space();

  if (nsp != new_nsp)
    {
      if (new_nsp != NO_OBJECT) {
	// First, insert the element into the destination name space.
	if (new_nsp.is_existing_name(self.name())) {
	  char corrected_name [NSPEL_MAX_NAME_LENGTH];
	  strcpy(corrected_name, self.name());
	  int i = 0;
	  while (new_nsp.is_existing_name(corrected_name)
		 AND
		 i < NSPEL_MAX_NAME_LENGTH)
	    {
	      char cstring[NSPEL_MAX_NAME_LENGTH + 4];
	      strcpy(cstring, "2nd ");
	      strcat(cstring, corrected_name);
	      strncpy(corrected_name, cstring, NSPEL_MAX_NAME_LENGTH);
	      i = i+4; // denotes the number of chars of corrected_name
	               // which might been lost.
	    }
	  if(i < NSPEL_MAX_NAME_LENGTH) {
	    self.new_name(corrected_name);
	    new_nsp.note_insert(self);  // 2nd try
	  }
	}
	new_nsp.note_insert(self);
	if (NOT new_nsp.method_successfull())
	  {
	    self.flag_error(NSPEL_MOVE_FAILED, self.error_message(NSPEL_MOVE_FAILED));
	    TT(nsp_H, T_LEAVE); return;
	  }
      }
	
      // Second, remove the element from its orgin name space.
      if ((nsp != NO_OBJECT) AND (NOT nsp.destruction_permitted(self)))
	{
	  if(new_nsp != NO_OBJECT) {
	    // Undo insert in the destination name space.
	    if (NOT new_nsp.destruction_permitted(self))
	      self.signal_error(ERR_FATAL_ERROR, self.error_message(ERR_FATAL_ERROR));
	    new_nsp.note_remove(self);
	  }
	  self.flag_error(NSPEL_MOVE_FAILED, 
			  self.error_message(NSPEL_MOVE_FAILED));
	  TT(nsp_H, T_LEAVE); return;
	}
      if (nsp != NO_OBJECT) nsp.note_remove(self);
      self.set_name_space(new_nsp);
      self.note_new_ancestors();
    }
  self.clear_error();                    // indicate success
  TT(nsp_H, T_LEAVE); return;
}


add_Name_Space add_Name_Space_Element::root()
   //
   // PURPOSE:
   // returns the root of the pathname of this element.
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
  T_PROC("add_Name_Space_Element::root()"); TT(nsp_H, T_ENTER);
  add_Name_Space retvalue;
  if (self.isa(add_Name_Space_type))
      retvalue = add_Name_Space::make(self);
  else
      retvalue = self.get_name_space();

//  while (retvalue.get_name_space() != NO_OBJECT) 
//      retvalue = retvalue.get_name_space(); 
// /home/kobi/addd-3.3/src/Name_Space_Concept/Name_Space_Element.C:307: no member function `add_Name_Space::get_name_space'
// /home/kobi/addd-3.3/src/Name_Space_Concept/Name_Space_Element.C:308: no member function `add_Name_Space::get_name_space'
// *** Error code 1
// ?????????????????????????????????????
  while (retvalue.containing_name_space() != NO_OBJECT)
      retvalue = retvalue.containing_name_space();  

  TT(nsp_H, TS(retvalue.pathname()));
  TT(nsp_H, T_LEAVE); return (retvalue);
} 


sos_Bool add_Name_Space_Element::ready_for_destruction()
   //
   // PURPOSE:
   // returns TRUE if this object can be destroyed.
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
  T_PROC("add_Name_Space_Element::ready_for_destruction()"); TT(nsp_L, T_ENTER);

  sos_Bool retvalue = self.get_name_space().destruction_permitted(self);

  TT(nsp_L, T_LEAVE; TB( retvalue));return (retvalue);
} 


sos_Bool add_Name_Space_Element::ready_for_assignment(add_Source_of_Error source)
   //
   // PURPOSE:
   // returns TRUE if source can be assigned to this object correctly.
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
  T_PROC("add_Name_Space_Element::ready_for_assignment(add_Source_of_Error source)"); TT(nsp_L, T_ENTER);

  add_Name_Space_Element source_nspel = add_Name_Space_Element::make(source);

//  sos_Cstring name = source_nspel.get_sos_name().make_Cstring();
  sos_Bool retvalue = self.ready_for_destruction();
//     AND (self.get_name_space().rename_permitted(self, name)));

//  delete name;
  TT(nsp_L, T_LEAVE; TB( retvalue)); return (retvalue);
} 


sos_Cstring add_Name_Space_Element::description ()
   //
   // PURPOSE:
   // returns a description of this object.
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
   sos_Cstring retvalue;

   T_PROC(" add_Name_Space_Element::description()"); TT(nsp_H, T_ENTER);

   sos_Cstring a_string = self.add_Source_of_Error::description();
   sos_Cstring d_string;
   if (self.get_sos_name() == NO_OBJECT)
     {
       cerr << form("Name_Space_Element: assertion failed !!\nNAME == NO_OBJECT !!");
       d_string = strnew("","");
     }
   else
     d_string = self.get_sos_name().make_Cstring();
   retvalue = strnew(a_string, d_string);
   delete d_string;
   delete a_string;

   TT(nsp_H, T_LEAVE; TS( retvalue));return(retvalue);
}     
  

void add_Name_Space_Element::signal_error(int error_state, 
				    sos_Cstring latest_error_message)
//
// PURPOSE:
// signals the error_event to someone who might handle it.
//
// PRECONDITION:
//        None
//
// POSTCONDITION:
//        None
{
   T_PROC
     ("add_Name_Space_Element::signal_error(int error_state, sos_Cstring latest_error_message)");
   TT(nsp_H, T_ENTER);

   sos_Cstring tmp1 = strnew ("At ", self.name());
   sos_Cstring tmp2 = strnew ( tmp1, ": \n");
   sos_Cstring tmp3 = strnew ( tmp2, latest_error_message );

   self.add_Source_of_Error::signal_error( error_state, tmp3);

   delete tmp1;
   delete tmp2;
   delete tmp3;

   TT(nsp_H, T_LEAVE); return;
}

           
void add_Name_Space_Element::note_new_ancestors()
   //
   // PURPOSE:
   // rename pathname on account of the new containing name_space
   //                                                         
   // PRECONDITION:                                           
   // this method assumes a fully initalized object
   // [all components should be created].
   // The containing name space should be consistent.
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
}

void add_Name_Space_Element::note_parent_rename() {}


sos_Cstring add_Name_Space_Element::error_message(int err_value)
   //
   // PURPOSE:
   // returns the error message belonging to the error value.
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
   sos_Cstring retvalue;

   T_PROC(" add_Name_Space_Element::error_message(int err_value)"); 
   TT(nsp_H, T_ENTER);

   switch (err_value)
   {
        case NSPEL_CHAR_NOT_ALLOWED:
          retvalue = " a name must not contain any /. \n";
          break;
	case NSPEL_PATHNAME_EXISTING:
          retvalue = " pathname exists allready \n";
          break;
	case NSP_NAME_TOO_LONG:
          retvalue = " this name is too long: \n";
          break;
	case NSPEL_CREATION_FAILED:
          retvalue = " creation failed \n";
          break;
	case NSPEL_MOVE_FAILED:
          retvalue = " move failed \n";
          break;
	case NSPEL_RENAME_FAILED:
          retvalue = " rename failed \n";
          break;
	case NSPEL_CORRECTED_NAME:
          retvalue = " this name has been corrected: ";
          break;
	case NSPEL_LOST_AND_FOUND:
          retvalue = " created as lost_and_found in \n";
          break;
	default:
          retvalue = self.add_Source_of_Error::error_message(err_value);
   }

   TT(nsp_H, T_LEAVE); return(retvalue);
}


sos_Cstring add_Name_Space_Element::correct_syntax (sos_Cstring name_to_be_corrected)
   //
   // PURPOSE:
   // checks if the syntax of name is correct.
   // returns a correct name.
   // This method does not alter this object.
   // checks length and omits "/".
   //
       // DEMAND: further unwanted chars should be eliminated.
   //
   // PRECONDITION:                                           
   // name should not be a NULL-Pointer
   //                                                         
   // POSTCONDITION, ERRORS:                  
   // if possible an incorrect syntax is corrected and 
   // the new name is signaled to the user.
{
  T_PROC("add_Name_Space_Element::correct_syntax(sos_Cstring name_to_be_corrected)"); 

  TT(nsp_H, T_ENTER; TS( name_to_be_corrected));
  static char corrected_name [NSPEL_MAX_NAME_LENGTH];

  char copy_of_name_to_be_corrected [NSPEL_MAX_NAME_LENGTH];
  strcpy (copy_of_name_to_be_corrected, name_to_be_corrected);

//  if (self.get_name_space() == NSP_NO_NSP)
//    { 
//      if (strlen(name_to_be_corrected) > NSPEL_MAX_NAME_LENGTH)
//	{	
//	  strncpy (corrected_name, name_to_be_corrected, NSPEL_MAX_NAME_LENGTH);
//	  corrected_name[NSPEL_MAX_NAME_LENGTH-1] = '\0';
//	  sos_Cstring a_string = self.error_message(NSP_NAME_TOO_LONG);
//	  sos_Cstring b_string = strnew(a_string, corrected_name);
//	  self.flag_error(NSP_NAME_TOO_LONG, b_string);
//	  delete b_string;
//	}
//      else
//	strcpy(corrected_name, name_to_be_corrected);
//      // NO FURTHER SYNTAX CHECK FOR ROOT NAME
//    }
//  else
//    {

  int j = 0;
  for (int i = 0; ((copy_of_name_to_be_corrected[i] != '\0') AND 
		   (j < NSPEL_MAX_NAME_LENGTH)); i++)
    {
      if (copy_of_name_to_be_corrected[i] != '/' OR copy_of_name_to_be_corrected[i] != '\"' OR
	  copy_of_name_to_be_corrected[i] != '\'' OR copy_of_name_to_be_corrected[i] != '`'
	  )
	{
	  corrected_name[j] = copy_of_name_to_be_corrected[i];
	  j++;
	}
    }
  
  if (j == NSPEL_MAX_NAME_LENGTH)
    {
      corrected_name[j-1] = '\0';
      sos_Cstring a_string = self.error_message(NSP_NAME_TOO_LONG);
      sos_Cstring b_string = strnew(a_string, corrected_name);
      self.flag_error(NSP_NAME_TOO_LONG, b_string);
      delete b_string;
    }
  else
    corrected_name[j] = '\0';
  
  add_Name_Space nsp = self.get_name_space();
  if (streql(corrected_name, ""))
    {
      if (nsp != NO_OBJECT)
	strcpy(corrected_name, nsp.generate_name());
      else
	strcpy(corrected_name, "untitled");
    }

  if (nsp != NO_OBJECT) {
    i = 0;
    while (nsp.is_existing_name(corrected_name) AND
	   NOT streql(corrected_name, self.name()) AND
	   (i < NSPEL_MAX_NAME_LENGTH))
      {
	char cstring[NSPEL_MAX_NAME_LENGTH + 4];
	strcpy(cstring, "2nd ");
	strcat(cstring, corrected_name);
	strncpy(corrected_name, cstring, NSPEL_MAX_NAME_LENGTH);
	corrected_name[NSPEL_MAX_NAME_LENGTH-1] = '\0';
	i = i+4; // denotes the number of chars of corrected_name
	// which might been lost.
      }
  }

  if (NOT streql(corrected_name, copy_of_name_to_be_corrected) AND 
      NOT streql(corrected_name, self.name()))
    {
      sos_Cstring a_string = 
	strnew(self.error_message(NSPEL_CORRECTED_NAME), corrected_name);
      self.flag_error(NSPEL_CORRECTED_NAME, a_string);
      delete a_string;
      TT(nsp_H, TS( corrected_name));
    }

  TT(nsp_H, T_LEAVE); return (corrected_name);
}


Void add_Name_Space_Element::local_initialize(add_Name_Space_Element this_one)
   //
   // PURPOSE:
   // initialises the components of this Name_Space_Element; 
   // inserts this object into parent-name_space (->note_insert)
   //                                                         
   // PRECONDITION:                                           
   //     The string name must not contain any '/' !!
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     if insertion into the name space nsp is not permitted or
   //     if the name is allready existing in this name space
   //     this object is flagged ERR_INCONSISTENT.
{
  T_PROC
    ("add_Name_Space_Element::local_initialize(add_Name_Space_Element this_one)");
  TT(nsp_H, T_ENTER);

  add_Name_Space nsp = this_one.get_name_space();

  // initialize the name:
  char name[NSPEL_MAX_NAME_LENGTH];
  sos_String sos_str = this_one.get_sos_name();  // create parameter
  if (sos_str == NO_OBJECT) {
    if (nsp == NO_OBJECT)
      {
	// new element should be a root !!
	strcpy(name, "root");
      }
    else
      {
	strcpy(name, nsp.generate_name());
	strcpy (name, this_one.correct_syntax(name));
      }
  } 
  else {
    sos_Cstring tmp = sos_str.make_Cstring();
    strcpy (name, this_one.correct_syntax(tmp));
    delete tmp;
  }
  if(nsp_no_corrected_syntax_warnings)  // no warnings during
    this_one.clear_error();             // assignment of a name space.
  else
    this_one.method_successfull();

  sos_String private_name = sos_String::create(this_one.container(), name);
  this_one.set_sos_name(private_name);
  this_one.set_name(add_const_String::create(this_one.container(),
					     private_name));
  TT(nsp_H, char tmp_str [NSPEL_MAX_NAME_LENGTH+6]; 
     sprintf(tmp_str,"new: %s    ", name); 
     TXT(tmp_str);
     if (nsp != NO_OBJECT) { 
       TS( nsp.pathname());
     }
     else {
       TS ("no parent "); 
     }
     );

  if (nsp != NO_OBJECT)
    { // new element has a parent name space.
      // Insertion of the new object into parent name space.
      nsp.note_insert(this_one);
      switch(nsp.error_state()) 
	{
	case NSP_INSERT_NOT_PERMITTED:
	  nsp.method_successfull();
	  nsp = nsp.lost_and_found();
	  nsp.note_insert(this_one);
	  if (NOT nsp.method_successfull())
	    {
	      sos_Cstring a_string = 
		strnew(this_one.error_message(NSPEL_CREATION_FAILED),name);
	      sos_Cstring b_string = 
		strnew(a_string, this_one.error_message(ERR_INCONSISTENT));
	      this_one.signal_error(ERR_INCONSISTENT, b_string);
	      delete a_string;
	      delete b_string;
	      TT(nsp_H, T_LEAVE); return;
	    }
	  else
	    {
	      sos_Cstring a_string = 
		strnew(this_one.error_message(NSPEL_LOST_AND_FOUND),
		       nsp.pathname());
	      this_one.signal_error(NSPEL_LOST_AND_FOUND, a_string);
	      delete a_string;
	      this_one.set_name_space(nsp);
	    }
	  break;
	case NSP_EXISTING_NAME:
	  char corrected_name [NSPEL_MAX_NAME_LENGTH];
	  strcpy(corrected_name, this_one.name());
	  int i = 0;
	  while (nsp.is_existing_name(corrected_name)
		 AND
		 i < NSPEL_MAX_NAME_LENGTH)
	    {
	      char cstring[NSPEL_MAX_NAME_LENGTH + 4];
	      strcpy(cstring, "2nd ");
	      strcat(cstring, corrected_name);
	      strncpy(corrected_name, cstring, NSPEL_MAX_NAME_LENGTH);
	      i = i+4; // i denotes the number of chars of corrected_name which might be lost.
	    }
	  if(i < NSPEL_MAX_NAME_LENGTH) {
	    private_name.assign_Cstring(corrected_name);
	    nsp.note_insert(this_one);  // 2nd try
	  }
	  if(NOT nsp_no_corrected_syntax_warnings)  
	    this_one.method_successfull();
	  break;
	default:
	  nsp.method_successfull(); // signal errors which are not handled here
	}
    }

  TT(nsp_H, T_LEAVE); return;
} 


Void add_Name_Space_Element::local_assign(add_Name_Space_Element destination,
					  sos_Object source_obj)
   //
   // PURPOSE:
   //     assigns the name of this one to dest.
   //                                                         
   // PRECONDITION:                                           
   //                                                         
   // POSTCONDITION, ERRORS:                                  
{
//  T_PROC("add_Name_Space_Element::local_assign(add_Name_Space_Element this_one, sos_Object dest)"); TT(nsp_H, T_ENTER);
/*  
  add_Name_Space_Element source = add_Name_Space_Element::make(source_obj);

  sos_Cstring name = source.get_sos_name().make_Cstring();
  if(destination.get_name_space() != source.get_name_space())
    destination.get_name_space.note_rename(destination, name);
      // in case of clone() the containing name_space
  destination.get_sos_name().assign_Cstring(name);
  delete name;
*/
//  TT(nsp_H, T_LEAVE); return;
} 


Void add_Name_Space_Element::local_finalize(add_Name_Space_Element this_one)
   //
   // PURPOSE:
   //     removes the reference in the name space
   //     which points to this object.
   //                                                         
   // PRECONDITION:                                           
   //                                                         
   // POSTCONDITION, ERRORS:                                  
{
  T_PROC("add_Name_Space_Element::local_finalize(this_one)"); 
  TT(nsp_H, T_ENTER);
  TT(nsp_H, TXT(form("removed: %s", this_one.pathname())));

  add_Name_Space parent = this_one.get_name_space();
  if (parent != NO_OBJECT)
      parent.note_remove(this_one);
  this_one.get_name().destroy();
  this_one.get_sos_name().destroy();
  TT(nsp_H, T_LEAVE); return;
} 


