/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */

/* This is a C-file (no C++); trc.h provides the appropriate C/C++   */
/* interface.							     */

/* ================================================================= */
/* ===   MODULE - REALISATION                                    === */
/* ================================================================= */
/*                                                                   */
/* MODULE-NAME: obst_trc.c               KEY : trc                   */
/*                                                                   */
/* ORIGINAL                                                          */
/* AUTHOR : UNIBASE-Project              DATE: 6-3-86                */
/*                                                                   */
/* UPDATE HISTORY                                                    */
/* AUTHOR : rainer holzapfel             DATE: 26-11-86              */
/* AUTHOR : andreas geppert              DATE: 03-08-87              */
/* AUTHOR : dietmar theobald (dt)        DATE: 03-09-91              */
/*	    removed most superfluous stuff, tried to turn this into  */
/*	    maintainable code					     */
/*                                                                   */
/* ================================================================= */
/*                                                                   */
/* PURPOSE:                                                          */
/*P         This module contains the functions of trc, making        */
/*P         possible various kinds of test output.                   */
/*                                                                   */
/* ================================================================= */

/* ================================================================= */
/* global declaration of system                                      */
/* ================================================================= */

#define OBST_IMP_STDCONST
#define OBST_IMP_STRINGOP
#define OBST_IMP_FILE
#define OBST_IMP_MALLOC
#define OBST_IMP_ERROR
#define OBST_IMP_TIME
#define OBST_IMP_CHARTYPE
#include "obst_stdinc.h"

#include "_obst_config.h"
#include "obst_progstd.h"          /* programming guidelines         */
#include "obst.h"		   /* for obst_getenv()		     */

/* ================================================================= */
/* EXPORT:                                                           */
/* ================================================================= */

#ifdef NO_TT
#undef NO_TT	/* Assert that this module is part of the OBST library,	*/
#endif		/* even if OBST is generated without trace code.	*/

#include "obst_trc.h"


/* ================================================================= */
/*                                                                   */
/* REALISATION:                                                      */
/*                                                                   */
/* ================================================================= */

typedef int bool ;
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

typedef char* 	     string;
typedef const char * conststring;

extern   string		ttyname();
extern	 string     PTR environ;

extern   int		sys_nerr;
extern   string	        sys_errlist [];

/* ================================================================= */
/*    MODULE - CONSTANTS / MACROS:                                   */
/* ================================================================= */

/*#define tt_MAXLEVEL		(see _obst_config.h) */
#define tt_STDOUT    1
#define tt_STDERR    2
#define tt_DEL	     0177
/*#define tt_MAXCOLS		(see _obst_config.h) */
/*#define tt_STDINDENT		(see _obst_config.h) */
/*#define tt_MAXINDENT		(see _obst_config.h) */
#if tt_MAXCOLS <= 220
#  define tt_BUFSIZE	230
#else
#  define tt_BUFSIZE	tt_MAXCOLS+10
#endif
#define tt_BUFEXTRA	26

#define tt_TRACE_COND(level) (level % 10 == 0)

#define T_ALLOC(v,t,l)	(v = (t *) tt_alloc ( "v", (l) * sizeof (t) ))
#define T_CALLOC(v,t,l)	(v = (t *) tt_calloc ( "v", (l) * sizeof (t) ))
#define T_FREE(v)	(tt_free ( "v", v ), v = NULL )


/* ================================================================= */
/*    MODULE - TYPES:                                                */
/* ================================================================= */

/* ================================================================= */
/*    MODULE - VARIABLES:                                            */
/* ================================================================= */

/* in obst_globals.C: tt_digits, tt_addrformat */

/* At most 20 characters may be written into tt_buf without checking
 * if tt_BUFSIZE is exceeded. Otherwise, tt_buf must not be filled
 * beyond tt_BUFSIZE.
 */
LOCAL  char	    tt_buf [tt_BUFSIZE + tt_BUFEXTRA];

LOCAL  string       tt_command;
EXPORT string       tt_faddr;
EXPORT string       tt_laddr;
LOCAL  string	    tt_env_var	     = ENVVAR_TRC;	/*_obst_config.h*/
LOCAL  string	    _tt_default_file = tt_DEFAULT_FILE; /*_obst_config.h*/
LOCAL  string	    tt_default_file  /* = NULL */;
LOCAL  char	    tt_digits[]	     = "0123456789abcdef";
LOCAL  string	    tt_filename;
LOCAL  int	    tt_file	     = -1,
		    tt_tmp_file,
	            tt_col	     /* = 0 */,
	            tt_indent 	     /* = 0 */,
                    tt_cmd_indx;
EXPORT int          tt_do_indent  /* = FALSE */,  /* done       */
	            tt_afdebug    /* = FALSE */,  /* implicitly */
	            tt_screen     /* = FALSE */;
LOCAL  time_t	    tt_start;
LOCAL  T_addrformat tt_addrformat = T_HEX;

EXPORT unsigned char tt_active [tt_MAXLEVEL + 1];


/* ================================================================= */
/*    MODULE - OPERATIONS:                                           */
/* ================================================================= */

LOCAL	string	appitem      __FSIG_((conststring)),
		appint       __FSIG_((string, int, int)),
		applong      __FSIG_((string, long)),
		appstr       __FSIG_((string, conststring)),
		tt_ecc       __FSIG_((string, unsigned)),
		tt_enc       __FSIG_((string, long, T_addrformat)),
		tt_enp	     __FSIG_((string, conststring));
LOCAL   void    tt_writefile __FSIG_((string));


/* ***************************************************************** */
LOCAL int getchr ()
/* ***************************************************************** */
{  while ( TRUE )
   {  int c = tt_command[tt_cmd_indx ++];
      switch (c)
      {  case 'T' : return ('t');
	 case '#' :
	 case 't' :
	 case '-' :
	 case ',' :
	 case '0' :
	 case '1' :
	 case '2' :
	 case '3' :
	 case '4' :
	 case '5' :
	 case '6' :
	 case '7' :
	 case '8' :
	 case '9' :
	 case EOS : return (c);
      }
   }
} /* getchr */


/* ***************************************************************** */
LOCAL void ungetchr ()
/* ***************************************************************** */
{
   tt_cmd_indx--;
}  /* ungetchr */


/* ***************************************************************** */
LOCAL int getnum ()
/* ***************************************************************** */
{
   int  result = 0;
   char c;

   while ( '0' <= (c = getchr())  AND  c <= '9' )
      result = (result * 10) + (c - '0');

   ungetchr ();
   return (result > tt_MAXLEVEL) ? tt_MAXLEVEL
				 : result;
} /* getnum */


/* ***************************************************************** */
LOCAL void interval (int_lo, int_hi)
/* ***************************************************************** */

	int PTR int_lo,  PTR int_hi;

{	int	c;

   if ( '0' <= (c = getchr())  AND  c <= '9' )
   {  ungetchr ();
      CONT( int_lo ) = getnum ();
      CONT( int_hi ) = CONT( int_lo );
      c = getchr ();
   }
   else
   {  CONT( int_lo ) = 0;
      CONT( int_hi ) = -1;
   }
   if ( c NEQ '-' )
      ungetchr ();
   else
   {  c = getchr ();
      ungetchr ();

      CONT( int_hi ) = ('0' <= c  AND  c <= '9') ? getnum ()
						 : tt_MAXLEVEL;
   }
} /* interval */


/* ***************************************************************** */
LOCAL void interpret (cmd_str)
/* ***************************************************************** */

	string	cmd_str;

{	int	c;
	int	stdtrace;
	int	level, int_lo, int_hi;

   tt_command  = cmd_str;
   tt_cmd_indx = 0;

   while ( TRUE )
   {  while ( (c = getchr()) NEQ EOS  AND  c NEQ '#' )
	 ;
      if ( c EQ EOS )
	 break;

      if ( (c = getchr()) EQ 't' )
	 stdtrace = TRUE;
      else
      {  ungetchr ();
	 stdtrace = FALSE;
      }
      interval (REF( int_lo ), REF( int_hi ));
      if ( stdtrace )
	 for (level = int_lo; level <= int_hi; level++ )
	    tt_active[level] = tt_TRACE_COND(level);
      else
	 for (level = int_lo; level <= int_hi; level++ )
	    tt_active[level] = TRUE;
   }
} /* interpret */


/* ***************************************************************** */
LOCAL  void	tt_writefile ( end_pt )
/* ***************************************************************** */

   string	end_pt;	/* pointer into tt_buf, after last char to write */

{  if ( end_pt > tt_buf )
   {  if ( tt_file < 0 )
      {  static int call_level /* = 0 */;

	 if (call_level > 0)	/* Protect from trace text written in */
	    return;		/* the following call of tt_init.     */

	 ++ call_level;
	 tt_init ( NULL, TRUE );
	 -- call_level;
      }
      write ( tt_screen ? tt_STDERR : tt_file,
	      tt_buf,
	      (unsigned) (end_pt - tt_buf) );
   }
}


/* ***************************************************************** */
LOCAL  string	appbuf ( txt, pt, new_item )
/* ***************************************************************** */

	conststring	txt;
	string		pt;	/* either NULL, or pointer into tt_buf */
	int		new_item;

{	int	first_iter = TRUE;
 static string  bufend     = tt_buf + tt_BUFSIZE;


   if ( pt EQ NULL )
      pt = tt_buf;

   while ( CONT( txt ) )
   {  if ( tt_do_indent )	/* note: tt_MAX_INDENT << tt_MAXCOLS */
      {  if ( pt + tt_indent - tt_col > bufend )
	 {  tt_writefile ( pt );
	    pt = tt_buf;
	 }
	 for ( ;  tt_col < tt_indent;  ++ tt_col )
	    CONT( pt ++ ) = ' ';
      }
      if ( first_iter )
      {  first_iter = FALSE;

	 if ( new_item )
	 {  if ( tt_col > ( tt_do_indent ? tt_indent : 0 ) )
	    {  CONT( pt ++ ) = ',';
	       CONT( pt ++ ) = ' ';
	       tt_col += 2;
	    }
	    if ( CONT( txt ) EQ ' ' )
	       ++ txt;
	 }
      }

      while ( CONT( txt ) )
      {  if ( ( CONT( pt ++ ) = CONT( txt ++ ) ) EQ EOL )
	 {  tt_col = 0;
	    break;
	 }
	 if ( pt > bufend )
	 {  tt_writefile ( pt );
	    pt = tt_buf;
	 }
	 if ( ++ tt_col >= tt_MAXCOLS )
	 {  CONT( pt ++ ) = '|';
	    CONT( pt ++ ) = EOL;
	    tt_col	  = 0;
	    break;
	 }
      }
   }
   return ( pt );
} /* appbuf */


/* ***************************************************************** */
LOCAL  string	appstr ( pt, s )
/* ***************************************************************** */

   	string	    pt;	/* pointer into tt_buf */
        conststring s;

{  return appbuf ( s, pt, FALSE );
} /* appstr */


/* ***************************************************************** */
LOCAL  string	appitem ( s )
/* ***************************************************************** */

   	conststring  s;

{	string	pt = appbuf( s, NULL, TRUE );

   CONT( pt ++ ) = ' ';
   ++ tt_col;

   return pt;
} /* appitem */


/* ***************************************************************** */
LOCAL  string	appint ( pt, i, l )
/* ***************************************************************** */

   	string	pt;		/* pointer into tt_buf */
   	int	i, l;

{  	int	flag       = FALSE,
		zerofill   = TRUE,
		k;
	string  pt_initial = pt;

  if ( i < 0 )
  {  CONT( pt ++ ) = '-';
     i = -i;
  }
  if ( l < 0 )
  {  zerofill = FALSE;
     l = -l;
  }
  while ( l > 5 )
  {  CONT( pt ++ ) = zerofill ? '0' : ' ';
     l --;
  }
  if ( l EQ 5 )
     flag = TRUE;

  k  = i / 10000;
  i %= 10000;

  if ( flag OR k )
  {  if ( k OR zerofill )
        CONT( pt ++ ) = k + '0';
     else
        CONT( pt ++ ) = ' ';

     flag = TRUE;
  }
  else if ( l >= 4 )
     flag = TRUE;

  k  = i / 1000;
  i %= 1000;

  if ( flag OR k )
  {  if ( k OR zerofill )
       CONT( pt ++ ) = k + '0';
     else
       CONT( pt ++ ) = ' ';

     flag = TRUE;
  }
  else if ( l >= 3 )
     flag = TRUE;

  k  = i / 100;
  i %= 100;

  if ( flag OR k )
  {  if ( k OR zerofill )
       CONT( pt ++ ) = k + '0';
     else
       CONT( pt ++ ) = ' ';

     flag = TRUE;
  }
  else if ( l >= 2 )
     flag = TRUE;

  k = i / 10;
  i %= 10;

  if ( flag OR k )
  {  if ( k OR zerofill )
       CONT( pt ++ ) = k + '0';
     else
       CONT( pt ++ ) = ' ';
  }

  CONT( pt ++ ) = i + '0';
  CONT( pt    ) = EOS;

  tt_col += ( pt - pt_initial );

  return ( pt );
} /* appint */


/* ***************************************************************** */
LOCAL  string	applong ( pt, l )
/* ***************************************************************** */

   	string	pt;	/* pointer into tt_buf */
   	long	l;

{	char	buf [16];
   	string	buf_pt;

  if ( l < 0 )
  {  CONT( pt ++ ) = '-';
     ++ tt_col;
     l = -l;
  }
  else if ( l EQ 0 )
  {  CONT( pt ++ ) = '0';
     ++ tt_col;

     CONT( pt ) = EOS;
     return ( pt );
  }

  buf[15] = EOS;
  for ( buf_pt = buf + 14;  l;  buf_pt -- )
  {  CONT( buf_pt ) = (char) ( l MOD 10 ) + '0';
     l = l / 10;
  }

  while ( (CONT( pt ++ ) = CONT( ++ buf_pt )) )
     ++ tt_col;

  return ( pt - 1 );
} /* applong */


/* ***************************************************************** */
LOCAL  string	tt_ecc ( pt, val )
/* ***************************************************************** */

	string	 pt;	/* pointer into tt_buf */
	unsigned val;

{static int	 C_escapes [] = { '0', EOS, EOS, EOS, EOS, EOS, EOS, 'a',
				  'b', 't', 'n', 'v', 'f', 'r' };
	int	 esc_char;

  if ( val <= '\r' AND ( esc_char = C_escapes [val] ) )
  {  CONT( pt ++ ) = '\\';
     CONT( pt ++ ) = esc_char;
     tt_col += 2;
  }
  else if ( ' ' <= val  AND  val < tt_DEL )
  {  if ( val EQ ' ' )
     {  CONT( pt ++ ) = ( val = '.' );	/* write ' ' as ".." */
        tt_col ++;
     }
     CONT( pt ++ ) = val;
     tt_col ++;
  }
  else
  {  CONT( pt ++ ) = '\\';
     CONT( pt ++ ) = tt_digits [(val >> 6) BITAND 0x3];
     CONT( pt ++ ) = tt_digits [(val >> 3) BITAND 0x7];
     CONT( pt ++ ) = tt_digits [val	   BITAND 0x7];
     tt_col += 4;
  }
  CONT( pt ) = EOS;

  return ( pt );
} /* tt_ecc */


/* ***************************************************************** */
LOCAL	string	tt_eccs ( pt, c, count )
/* ***************************************************************** */

   	string	pt;	/* pointer into tt_buf */
        int     c;
   	int	count;

{	int	oldcol = tt_col;
	char	buf[20];
	string  buf_pt = buf;

  if ( count > 1 )
  {  buf_pt = tt_enc ( buf_pt, (long) count, T_DEC );
     CONT( buf_pt ++ ) = '*';
     ++ tt_col;
  }
  buf_pt = tt_ecc ( buf_pt, (unsigned)c );
  CONT( buf_pt ++ ) = ' ';
  CONT( buf_pt    ) = EOS;
  ++ tt_col;

  if ( tt_col < tt_MAXCOLS )
     tt_col = oldcol;
  else
  {  CONT( pt ++ ) = EOL;
     tt_col	   = 0;

     tt_writefile ( pt );
     pt = tt_buf;
  }
  pt = appstr ( pt, buf );
  
  return ( pt );
} /* tt_eccs */


/* ***************************************************************** */
LOCAL  string	tt_enc ( s, val, mode )
/* ***************************************************************** */

	string		s;
   	long		val;
   	T_addrformat	mode;

{	char	hbuf [20];
   	string	buf_pt = hbuf + 19;
	string	init_s = s;
   	bool	neg    = FALSE;
	long	help;
	int	shft;

  CONT( buf_pt -- ) = EOS;

  if ( val EQ 0 )
     CONT( buf_pt -- ) = '0';

  else if ( mode EQ T_UNS OR mode EQ T_DEC )
  {  if ( mode EQ T_DEC AND val < 0 )
     {  neg = TRUE;
        val = -val;
     }

     for ( ; val; val /= 10 )
        CONT( buf_pt -- ) = tt_digits [val MOD 10];

     if ( neg )
        CONT( buf_pt -- ) = '-';
  }
  else
  {  if ( mode EQ T_HEX )
     {  CONT( s ++ ) = 'X';
        help = 0xfL;
        shft = 4;
     }
     else
     {  CONT( s ++ ) = '0';
        help = 07L;
        shft = 3;
     }

     CONT( buf_pt -- ) = tt_digits [val BITAND help];
     val = ( val >> shft ) BITAND
		BITCPL( ( help << ( sizeof (long) * 8 - shft ) ) );

     while ( val )
     {  CONT( buf_pt -- ) = tt_digits [val BITAND help];
       val >>= shft;
     }
  }

  while ( (CONT( s ++ ) = CONT( ++ buf_pt )) )
     ;
  tt_col += ( ( -- s ) - init_s );

  return s;
} /* tt_enc */


/* ***************************************************************** */
LOCAL  string tt_enp ( pt, val )
/* ***************************************************************** */

   	string		pt;	/* pointer into tt_buf */
	conststring	val;

{  	long	hval = (long) val;

  if ( NOT val )
    return ( appstr ( pt, "NULL" ) );

  pt = tt_enc ( pt, hval, tt_addrformat );

  return ( pt );
} /* tt_enp */


/* ***************************************************************** */
LOCAL void tt_err ( action, file )
/* ***************************************************************** */

   	string	action;
        string  file;

{  	string	pt;

  tt_nl ();

  pt = appstr ( appitem( "Cannot" ), action );

  if ( file AND CONT( file ) )
  {
    CONT( pt ++ ) = ' ';
    CONT( pt ++ ) = '\'';
    pt = appstr ( pt, file );
    CONT( pt ++ ) = '\'';
    tt_col += 3;
  }

  if ( errno )
  {  CONT( pt ++ ) = ':';
     CONT( pt ++ ) = ' ';
     tt_col += 2;

     if ( errno < sys_nerr )
        pt = appstr ( pt, sys_errlist [errno] );
     else
     {  pt = appstr ( pt, "Unknown Error #" );
        pt = appint ( pt, errno, 0 );
     }
  }

  CONT( pt ++ ) = EOL;
  tt_col	= 0;

  tt_writefile ( pt );
} /* tt_err */


/* ***************************************************************** */
EXPORT  string	tt_alloc ( s, n )
/* ***************************************************************** */

   	string	s;
   	int	n;

{  	string	pt = malloc ( ( unsigned int ) n );

  T_PROC  ( "tt_alloc" );
  if (tt_afdebug)
  {  tt_s ( tt_proc, s ); TI (n); tt_p ( "=", pt );
     tt_nl ();
  }

  if ( NOT  pt )
  {  perror ( tt_proc );
     abort ();
  }

  if ( NOT  tt_faddr )
     tt_faddr =  pt;

  if ( pt > tt_laddr )
     tt_laddr =  pt + n - 1 ;

  return ( pt );
} /* tt_alloc */


/* ***************************************************************** */
EXPORT string	tt_calloc ( s, n )
/* ***************************************************************** */

   	string	s;
   	int	n;

{  	string	cpt;
	string  pt = malloc ( ( unsigned int ) n );

  T_PROC  ( "tt_calloc" );
  if (tt_afdebug)
  {  tt_s ( tt_proc, s ); TI (n); tt_p ( "=", pt );
     tt_nl ();
  }

  if ( NOT  pt )
  {  perror ( tt_proc );
     abort ();
  }

  if ( NOT  tt_faddr )
     tt_faddr =  pt;

  if ( pt > tt_laddr )
     tt_laddr =  pt + n - 1;

  for ( cpt = pt; n > 0; n -- )
     CONT( cpt ++ ) = EOS;

  return ( pt );
} /* tt_calloc */


/* ***************************************************************** */
EXPORT  void  tt_free ( s, p )
/* ***************************************************************** */

   	string	s;
   	string  p;

{ if (tt_afdebug)
  {  tt_s ( "tt_free", s ); tt_p ( "=", p );
     tt_nl ();
  }
  if ( p < tt_faddr OR p > tt_laddr )
  {  tt_p ( "can't tt_free", p );
     return;
  }
  free ( p );
} /* tt_free */


/* ***************************************************************** */
EXPORT  void tt_redef ( str )
/* ***************************************************************** */

   	conststring	str;

{  int	i;

   if ( str == NULL )
      str = obst_getenv ( tt_env_var );

   for ( i = tt_MAXLEVEL; i > 0; --i ) tt_active [i] = FALSE;
   tt_active[0] = TRUE;
     /* Richard 25.1.88: set level 0 always! */

   if ( str == NULL )
      return;

   while ( CONT( str ) )
   {  if (CONT( str ) EQ '#')
      {  interpret ( str );
	 break;
      }
      else if (isdigit ( CONT(str) ))
      {
	 int level = atoi ( str ),
	     j     = (level > tt_MAXLEVEL) ? tt_MAXLEVEL
					   : level;
	 while (j >= 0)
	    tt_active [j --] = TRUE;

	 while (isdigit( CONT(++ str) ))
	    ;
      }
      else
         switch ( CONT(str ++) )
	 {  case 'I': case 'i': tt_do_indent  = TRUE;  break;
	    case 'S': case 's': tt_screen     = TRUE;  break;
		      case 'a': tt_afdebug    = 1;     break;
	    case 'A':           tt_afdebug    = 2;     break;
	    case 'H': case 'h': tt_addrformat = T_HEX; break;
	    case 'D': case 'd': tt_addrformat = T_DEC; break;
	    case 'O': case 'o': tt_addrformat = T_OCT; break;
	    case 'U': case 'u': tt_addrformat = T_UNS; break;
	    case 'N': case 'n': tt_active[0]  = FALSE; break;
	 }
   }
} /* tt_redef */


/* ***************************************************************** */
EXPORT  void  tt_init ( pname, full_init )
/* ***************************************************************** */

   	conststring	pname;
   	int		full_init;

{
   	struct	tm	PTR tm;
	struct	tm	PTR localtime ();
	string  	pt;
	string  	envstr;

   if ( tt_default_file == NULL )
      tt_default_file = _tt_default_file;

   if ( NOT full_init )
  {  if ( tt_default_file NEQ _tt_default_file )
	 free ( tt_default_file );

      if ( pname EQ NULL  OR  strlen ( pname ) EQ 0 )
	 tt_default_file = _tt_default_file;
      else
	 tt_default_file = obst_strdup ( pname );

      return;
   }

   if ( tt_file >= 0 )
   {  if ( streql ( pname, tt_filename ) )
	 return;
      else
	 tt_exit();
   }
   tt_redef ( envstr = obst_getenv ( tt_env_var ) );

   tt_tmp_file = ( envstr == NULL );

   time ( REF( tt_start ) );
   tm = localtime ( REF( tt_start ) );

   if ( pname EQ NULL  OR  strlen ( pname ) EQ 0 )
      pname = tt_default_file;

  if ( ( tt_file = open ( pname, O_WRONLY | O_CREAT | O_TRUNC, 0666 ) ) < 0 )
  {
    perror ( pname );
    sleep ( 10 );
    exit ( 99 );
  }
  tt_filename = obst_strdup ( pname );

  fchmod ( tt_file, 0666 );
  fcntl ( tt_file, F_SETFD, 1 );

  tt_col    = 0;
  tt_indent = 0;
  pt        = tt_buf;

  if (envstr)
  {  pt = appstr ( pt, tt_env_var );
     CONT( pt++ ) = '=';
     pt = appstr ( pt, envstr );
     CONT( pt++ ) = EOL;

     tt_col = 0;
  }
  pt = appint ( appstr( pt, "pid " ),	  getpid (), 0 );

  pt = appint ( appstr( pt, "; start " ), tm -> tm_hour, 0 );
  pt = appint ( appstr( pt, ":" ),	  tm -> tm_min,  2 );
  pt = appint ( appstr( pt, ":" ),	  tm -> tm_sec,  2 );

  pt = appstr ( pt, "; tty " );
  if ((envstr = ttyname (tt_STDOUT)))
     pt = appstr ( pt, envstr );
  else
     CONT ( pt ++ ) = '?';

  CONT( pt ++ ) = EOL;
  tt_col	= 0;

  write ( tt_file, tt_buf, ( unsigned int ) ( pt - tt_buf ) );
} /* tt_init */


/* ***************************************************************** */
EXPORT  void  tt_exit ()
/* ***************************************************************** */

{
struct	tbuffer {
  long	p_user, p_sys,
	c_user, c_sys; } buf;
   	long	alltime, cputime;
   	string	pt;
	time_t	endtime;
   	struct	tm	PTR tm;
	struct	tm	PTR localtime ();

  if ( tt_file < 0 )
     return;

  if ( tt_tmp_file )
     unlink ( tt_filename );
  else
  {  tt_nl ();

     times ( REF( buf ) );
     time  ( REF( endtime ) );
     tm = localtime ( REF( endtime ) );

     cputime = ( buf.p_user * 100 ) / 60;
     pt = applong ( tt_buf, cputime / 100 );
     CONT( pt ++  )= '.';
     CONT( pt ++ ) = ( cputime MOD 100 ) / 10 + '0';
     CONT( pt ++ ) = cputime MOD 10 + '0';
     pt = appstr ( pt, " user, " );

     cputime = ( buf.p_sys * 100 ) / 60;
     pt = applong ( pt, cputime / 100 );
     CONT( pt ++ ) = '.';
     CONT( pt ++ ) = ( cputime MOD 100 ) / 10 + '0';
     CONT( pt ++ ) = cputime MOD 10 + '0';
     pt = appstr ( pt, " sys, " );

     alltime = endtime - tt_start;
     pt = appint ( pt, (int) (alltime / 3600), 0 );
     alltime %= 3600;
     pt = appint ( appstr( pt, ":" ), (int)(alltime  /  60), 2 );
     pt = appint ( appstr( pt, ":" ), (int)(alltime MOD 60), 2 );

     pt = appint ( appstr( pt, " real, end at " ), tm -> tm_hour, 0 );
     pt = appint ( appstr( pt, ":" ),		   tm -> tm_min,  2 );
     pt = appint ( appstr( pt, ":" ),		   tm -> tm_sec,  2 );

     CONT( pt ++ ) = EOL;
     CONT( pt    ) = EOS;
     tt_col	   = 0;

     write ( tt_file, tt_buf, ( unsigned int ) ( pt - tt_buf ) );
  }
  close ( tt_file );
  free ( tt_filename );

  tt_file = -1;
} /* tt_exit */


/* ***************************************************************** */
EXPORT  void  tt_enter ( proc )
/* ***************************************************************** */

   	conststring	proc;

{  	string		pt;

  tt_nl ();

  pt = appstr ( appitem ( "Enter {" ), proc );
  tt_writefile ( pt );

  tt_indent = ( tt_indent + tt_STDINDENT ) MOD tt_MAXINDENT;
} /* tt_enter */


/* ***************************************************************** */
EXPORT  void  tt_leave ( proc )
/* ***************************************************************** */

   	conststring	proc;

{  	string		pt;

  tt_indent = ( tt_indent + tt_MAXINDENT-tt_STDINDENT ) MOD tt_MAXINDENT;
  tt_nl ();

  pt = appstr ( appitem ( "Leave }" ), proc );
  tt_writefile ( pt );

} /* tt_leave */


/* ***************************************************************** */
EXPORT  void  tt_nl ()
/* ***************************************************************** */

{ if ( tt_col )
  {  string pt = tt_buf;

     CONT( pt ++ ) = EOL;
     CONT( pt    ) = EOS;
     tt_col	   = 0;

     tt_writefile ( pt );
  }
}


/* ***************************************************************** */
EXPORT  void tt_txt ( txt )
/* ***************************************************************** */

	conststring	txt;

{  tt_writefile ( appitem ( txt ) - 1 );
   -- tt_col;
}


/* ***************************************************************** */
EXPORT  void  tt_i ( txt, val )
/* ***************************************************************** */

	conststring	txt;
   	int		val;

{  tt_writefile ( tt_enc ( appitem( txt ), (long) val, T_DEC ) );
}


/* ***************************************************************** */
EXPORT  void  tt_u ( txt, val )
/* ***************************************************************** */

	conststring	txt;
   	unsigned 	val;

{  tt_writefile ( tt_enc ( appitem( txt ), (long) val, T_UNS ) );
}


/* ***************************************************************** */
EXPORT void tt_o ( txt, val )
/* ***************************************************************** */

	conststring	txt;
   	unsigned 	val;

{  tt_writefile ( tt_enc ( appitem( txt ), (long) val, T_OCT ) );
}


/* ***************************************************************** */
EXPORT  void  tt_x ( txt, val )
/* ***************************************************************** */

	conststring	txt;
   	unsigned 	val;

{  tt_writefile ( tt_enc ( appitem( txt ), (long) val, T_HEX ) );
}


/* ***************************************************************** */
EXPORT  void  tt_li ( txt, val )
/* ***************************************************************** */

	conststring	txt;
   	long		val;

{  tt_writefile ( tt_enc ( appitem( txt ), val, T_DEC ) );
}


/* ***************************************************************** */
EXPORT  void  tt_lo ( txt, val )
/* ***************************************************************** */

	conststring	txt;
   	long		val;

{  tt_writefile ( tt_enc ( appitem( txt ), val, T_OCT ) );
}


/* ***************************************************************** */
EXPORT  void  tt_lx ( txt, val )
/* ***************************************************************** */

	conststring	txt;
   	long		val;

{  tt_writefile ( tt_enc ( appitem( txt ), val, T_HEX ) );
}


/* ***************************************************************** */
EXPORT  void  tt_c ( txt, val )
/* ***************************************************************** */

	conststring	txt;
   	int		val;

{  tt_writefile ( tt_ecc ( appitem( txt ), (unsigned)val ) );
}


/* ***************************************************************** */
EXPORT  void  tt_s ( txt, val )
/* ***************************************************************** */

   	conststring  txt;
        conststring  val;

{
   	string	pt;
   	int	l = val ? strlen ( val ) : 6;

  if ( tt_col + l + ( txt ? strlen ( txt ) : 0 ) > tt_MAXCOLS )
     tt_nl ();

  pt = appitem ( txt );

  if ( NOT val )
     pt = appstr ( pt, "<NULL>" );
  else
  {  CONT( pt ++ ) = '<';
     pt = tt_enp ( pt, val );
     CONT( pt ++ ) = '>';
     CONT( pt ++ ) = ' ';
     CONT( pt ++ ) = '\'';
     tt_col += 4;

     while ( TRUE )
     {  conststring end = val + (tt_MAXCOLS - tt_col) - 2;

	while ( val <= end  AND  CONT( val ) )
	{  CONT ( pt ++ ) = CONT ( val );
	   if ( CONT( val ++ ) EQ EOL )
	   {  -- pt;
	      break;
	   }
	   ++ tt_col;
	}
	if ( CONT( val ) )
	{  CONT ( pt ++ ) = EOL;
	   tt_col	  = 0;

	   tt_writefile ( pt );
	   pt = tt_buf;
	}
	else
	   break;
     }
     CONT ( pt ++ ) = '\'';
     ++ tt_col;
  }
  tt_writefile ( pt );

} /* tt_s */


/* ***************************************************************** */
EXPORT  void tt_a ( txt, val, nel )
/* ***************************************************************** */

	conststring	txt;
   	conststring	val;
   	int		nel;

{
   	int	count;
	int	printable_max_seq;
   	string	pt;
        int     lastc;

  pt = appitem ( txt );
  CONT( pt ++ ) = '<';
  pt = tt_enp ( pt, val );
  CONT( pt ++ ) = '>';
  CONT( pt ++ ) = ' ';
  tt_col += 3;

  tt_writefile ( pt );

  if ( NOT val )
     return;

  pt = tt_buf;

  if ( nel <= 0 )
     nel = strlen ( val ) + 1;				/* note: nel >= 1! */

  printable_max_seq = ( nel > 50 ? 3 : 50 );

  lastc = CONT( val ++ );
  count = 1;
  while ( TRUE )
  {  if ( --nel > 0  AND  lastc EQ CONT( val ) )
        count ++;
     else
     {  if ( isprint ( lastc )  AND  count <= printable_max_seq )
	   while ( --count >= 0 )
	      pt = tt_eccs ( pt, lastc, 1 );
	else
	   pt = tt_eccs ( pt, lastc, count );

	if ( nel EQ 0 )
	   break;

        count = 1;
        lastc = CONT( val );
     }
     val ++;
  }
  CONT( pt ++ ) = EOL;
  tt_col	= 0;

  tt_writefile ( pt );
} /* tt_a */


/* ***************************************************************** */
EXPORT  void  tt_sa ( txt, val, nel )
/* ***************************************************************** */

	conststring	txt;
   	conststring	PTR val;
   	int		nel;

{
   	int	cnt;
   	string	pt = appitem ( txt );
	char	buf [5];

  CONT( pt ++ ) = EOL;
  tt_col	= 0;
  tt_writefile ( pt );

  buf[0] = '[';
  buf[3] = ']';
  buf[4] = EOS;

  for ( cnt = 0; nel > 0; cnt ++, val ++, nel -- )
  {  buf[1] = cnt  /  10 + '0';
     buf[2] = cnt MOD 10 + '0';

     tt_s ( buf, CONT( val ) );
     tt_nl ();
  }
} /* tt_sa */


/* ***************************************************************** */
EXPORT  void  tt_p ( txt, val )
/* ***************************************************************** */

	conststring	txt;
	const void*	val;

{  tt_writefile ( tt_enp ( appitem( txt ), val ) );
}
