#ifndef _SMG_H
#define _SMG_H 1
/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * you should have received along with this program.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
#ifdef __GNUG__
#pragma interface
#endif

#define OBST_IMP_STREAM
#define OBST_IMP_STRINGOP
#include "obst_stdinc.h"

class sos_Container;
class sos_String;

class smg_String_ptr
{  
   friend class smg_String;
   friend ostream& operator<< (ostream&, const smg_String&);
   friend void     _smg_init();

   char  managed;
   short rc;
   char* c;
   int   length;
   int   size;
};
extern smg_String_ptr smg_empty_string_ptr;

enum smg_access {SMG_COPY, SMG_TRANSFER, SMG_BORROW};

class smg_String
{  smg_String_ptr *ptr;
   friend ostream& operator<< (ostream&, const smg_String&);
public:

   smg_String () { ptr = &smg_empty_string_ptr; ++smg_empty_string_ptr.rc; }
   smg_String (char*, const smg_access access = SMG_BORROW);
   smg_String (sos_String);
   smg_String (const sos_Int, const int decimal_mode = 1);

   smg_String (const smg_String &s) { ptr = s.ptr; ptr->rc++; }
   smg_String& operator= (const smg_String&);
   smg_String& operator= (char*);

   ~smg_String () { if (--ptr->rc == 0) { if (ptr->managed) 
                                             if (ptr->c) delete ptr->c;
					  delete ptr; } }

   char* make_Cstring (const smg_access access = SMG_COPY) const;

   sos_String make_String (const sos_Container) const;

   int length () const { return ptr->length; }

   int compare (const smg_String &s) const
	{ return strcmp (ptr->c, s.ptr->c); }
   int equal (const smg_String &s)   const
	{ return strcmp (ptr->c, s.ptr->c) == 0; }
   smg_String& operator += (const smg_String& s)
	{ return (*this += s.ptr->c); }
   smg_String operator + (const smg_String& s) const 
	{ return (*this + s.ptr->c); }

   smg_String clone () const;
   void	      empty ();

   int compare (const char *c) const { return strcmp (ptr->c, c); }
   int equal (const char *c)   const { return strcmp (ptr->c, c) == 0; }
   smg_String& operator += (const char*);
   smg_String operator + (const char*) const;
};

ostream& operator<< (ostream&, const smg_String&);
ostream& operator<< (ostream&, const sos_String&);
void _smg_init();

#endif
