 /* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * you should have received along with this program.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */
// **************************************************************************
// Module prot                   13-Aug-1993	       Bernhard Schiefer (bs)
// **************************************************************************
// implements methods of all classes declared in schema "prot"
// **************************************************************************
 
#include "obst_progstd.h"
#include "obst.h"
#include "smg.h"
#include "mta_obst.h"
#include "trc_prot.h"

#include "prot_obst.h"

extern sos_Class_type_List mta_using_classes(const sos_Type_descr&);

#define MTA_USING_CLASSES(td) mta_using_classes(OBST_CAST(sos_Type_descr,td))


// -------------------------------------------------------------------------
// sos_TypeModif
// -------------------------------------------------------------------------
// **************************************************************************
void sos_TypeModif::local_finalize(sos_TypeModif tm)
// **************************************************************************
{
   T_PROC("sos_TypeModif::local_finalize");
   TT(prot_M, T_ENTER);

   if (VALID(tm.get_old_name()))
      tm.get_old_name().destroy();

   TT(prot_M, T_LEAVE);
}

// -------------------------------------------------------------------------
// sos_EnumModif
// -------------------------------------------------------------------------
// **************************************************************************
void sos_EnumModif::local_initialize(sos_EnumModif em)
// **************************************************************************
{
   T_PROC("sos_EnumModif::local_initialize");
   TT(prot_M, T_ENTER);

   sos_Container cnt = em.container();

   em.set_change_literals(sos_LitModif_List::create(cnt));

   TT(prot_M, T_LEAVE);
} 

// **************************************************************************
void sos_EnumModif::local_finalize(sos_EnumModif em)
// **************************************************************************
{
   T_PROC("sos_EnumModif::local_finalize");
   TT(prot_M, T_ENTER);

   sos_LitModif_List lmlist = em.get_change_literals();
   sos_LitModif      lm;
  
   agg_iterate(lmlist, lm)
   {
      lm.destroy();
   }agg_iterate_end(lmlist, lm);

   lmlist.destroy();

   TT(prot_M, T_LEAVE);
}
   
// **************************************************************************
sos_Int sos_EnumModif::add_lit(sos_String name)
// **************************************************************************
{
   T_PROC("sos_EnumModif::add_lit");
   TT(prot_H, T_ENTER);

   sos_LitModif_List  lmlist;
   sos_LitModif       lmod;
   sos_LitModif       lm;
   sos_Bool           found = FALSE;
   sos_Int            addpos;
   sos_Int            index = 0;
   sos_Int            fin;

   lmlist = self.get_change_literals();

   agg_iterate(lmlist, lmod)
   {
     index++;
     if (found)
     { sos_Change_kind chg = lmod.get_change();
       sos_Int	       pos = lmod.get_position();

       if (chg == PROT_DEL) 
          // if lit was not deleted, the deletion of lmod would have caused
          // the position of the lit to decrease.
       {  if (pos < addpos) 
             addpos--; 
          else
             lmod.set_position(pos+1);
       }
       else if (chg == PROT_ADD)
          // if lmod was inserted, it has been inserted at the end of the 
          // literals list. So if lit was not deleted, it would have caused 
          // the inserted literals to be inserted at a higher position
          // No lmod could have been inserted in front of lit. 
       {  lmod.set_position(pos+1);
          if (pos < addpos)
             addpos = pos;
       }
     }      
     else if (lmod.get_name().equal(name))   // !found
     {  lm     = lmod;
        found  = TRUE;
        addpos = lmod.get_position();
        fin    = index;
     }
   }agg_iterate_end(lmlist, lmod);

   if (!found)
   {  // the literal was not deleted before
      sos_Enum_type et     = sos_Enum_type::make(self.get_modified_type());
      sos_Container cnt    = self.container();
      sos_Int       addpos = et.get_literals().card()+1;

      lm = sos_LitModif::create(cnt);
      lm.set_name     (sos_String::clone(name, cnt));
      lm.set_position (addpos); 
      lm.set_change   (PROT_ADD);

      lmlist.append(lm);
 
      self.set_change(PROT_MOD);
   }
   else
   {  lmlist.remove(fin);
      lm.destroy();
   }

   TT(prot_H, T_LEAVE);
   return addpos;
} 
   
    
// **************************************************************************
void sos_EnumModif::del_lit(sos_String name)
// **************************************************************************
{
   T_PROC("sos_EnumModif::del_lit");
   TT(prot_H, T_ENTER);

   sos_String_List    llist;
   sos_LitModif_List  lmlist;
   sos_LitModif       lmod;
   sos_LitModif       lm;
   sos_String         lit;
   sos_Bool           found = FALSE;
   sos_Int            delpos;
   sos_Int            index = 0;
   sos_Int            fin;
 
   lmlist = self.get_change_literals();
 
   agg_iterate(lmlist, lmod)
   {
     index++;
     if (found)
     { sos_Change_kind chg = lmod.get_change();
       sos_Int	       pos = lmod.get_position();

       if (chg == PROT_ADD)
          // if lmod was inserted, it has been inserted at the end of the 
          // literals list. So if lit was not added, it would have caused 
          // the inserted literals to be inserted at a lower position
          // No lmod could have been inserted in front of lit, after the
          // insertion of lit. 
         lmod.set_position(pos-1);
     }     
     else if (lmod.get_name().equal(name))   // !found
     {  lm     = lmod;
        found  = TRUE;
        delpos = lmod.get_position();
        fin    = index;
     }
   }agg_iterate_end(lmlist, lmod);
 
   if (!found)
   {  // the literal was not inserted before
      sos_Enum_type et  = sos_Enum_type::make(self.get_modified_type());
      sos_Container cnt = self.container();
      
      index = 0; 
      llist = et.get_literals();
      agg_iterate(llist, lit)
      { 
        index++;
        if (lit.equal(name))
        {  delpos = index;
           break;
        }
      }agg_iterate_end(llist, lit);
 
      lm = sos_LitModif::create(cnt);
      lm.set_name    (sos_String::clone(name, cnt));
      lm.set_position(delpos);
      lm.set_change  (PROT_DEL);
 
      lmlist.append(lm);

      self.set_change(PROT_MOD);
   }
   else
   {  lmlist.remove(fin);
      lm.destroy();
   }

   TT(prot_H, T_LEAVE);
}

// -------------------------------------------------------------------------
// sos_LitModif
// -------------------------------------------------------------------------
// **************************************************************************
void sos_LitModif::local_finalize(sos_LitModif lm)
// **************************************************************************
{
   T_PROC("sos_LitModif::local_finalize");
   TT(prot_M, T_ENTER);

   if (VALID(lm.get_name()))
      lm.get_name().destroy();

   TT(prot_M, T_LEAVE);
}

// -------------------------------------------------------------------------
// sos_ExternModif
// -------------------------------------------------------------------------
// **************************************************************************
void sos_ExternModif::mod_size()
// **************************************************************************
{
   T_PROC("sos_ExternModif::mod_size");
   TT(prot_H, T_ENTER);

   sos_Schema_module   sc;
   sos_SchemaModif     sm;
   sos_Class_type_List using_classes;
   sos_Class_type      ct;
   sos_ClassModif      cm;
   sos_Extern_type     ext;

   if (self.get_old_obj_size() == -1)
   {  
      ext = sos_Extern_type::make(self.get_modified_type()); 

      self.set_old_obj_size(ext.get_object_size());
     
      using_classes = MTA_USING_CLASSES(ext); 
   
      // <af> moeglicherweise fuer zuviele Klassen aufgerufen 
      agg_iterate (using_classes, ct)
      {
         sc = sos_Schema_module::retrieve(ct.container());
         sm = sos_SchemaModif::mod_schema(sc);
         
         cm = sos_ClassModif::make(sm.mod_type(ct));
         cm.save_offsets(FALSE);
      }agg_iterate_end(using_classes,ct);

      using_classes.destroy();
      self.set_change(PROT_MOD);
   }

   TT(prot_H, T_LEAVE);
}

// **************************************************************************
void sos_ExternModif::local_initialize(sos_ExternModif em)
// **************************************************************************
{
   T_PROC("sos_ExternModif::local_initialize");
   TT(prot_M, T_ENTER);

   em.set_old_obj_size(-1);

   TT(prot_M, T_LEAVE);
}

// -------------------------------------------------------------------------
// sos_TypedefModif
// -------------------------------------------------------------------------
// **************************************************************************
void sos_TypedefModif::mod_type()
// **************************************************************************
{
   T_PROC("sos_TypedefModif::mod_type");
   TT(prot_H, T_ENTER);

   sos_Schema_module   sc;
   sos_SchemaModif     sm;
   sos_Class_type_List using_classes;
   sos_Class_type      ct;
   sos_ClassModif      cm;
   sos_Typedef_type    tyd;
 
   if (INVALID(self.get_old_named_type()))
   {  
      tyd = sos_Typedef_type::make(self.get_modified_type());  
      self.set_old_named_type(tyd.get_named_type());
    
      using_classes = MTA_USING_CLASSES(tyd);
  
      // <af> moeglicherweise fuer zuviele Klassen aufgerufen
      agg_iterate (using_classes, ct)
      {
         sc = sos_Schema_module::retrieve(ct.container());
         sm = sos_SchemaModif::mod_schema(sc);
 
         cm = sos_ClassModif::make(sm.mod_type(ct));
         cm.save_offsets(FALSE);
      }agg_iterate_end(using_classes,ct);
 
      using_classes.destroy();
      self.set_change(PROT_MOD);
   }

   TT(prot_H, T_LEAVE);
}

// **************************************************************************
void sos_TypedefModif::local_initialize(sos_TypedefModif tdm)
// **************************************************************************
{
   T_PROC("sos_TypedefModif::local_initialize");
   TT(prot_M, T_ENTER);

   tdm.set_old_named_type(sos_Type::make(NO_OBJECT)); 
   
   TT(prot_M, T_LEAVE);
} 

// -------------------------------------------------------------------------
// sos_UnionModif
// -------------------------------------------------------------------------
// **************************************************************************
void sos_UnionModif::add_type(sos_Type tp)
// **************************************************************************
{
   T_PROC("sos_UnionModif::add_type");
   TT(prot_H, T_ENTER);

   if (self.get_deleted_types().is_element(tp))
      self.get_deleted_types().remove(tp);
   else
   {  self.get_added_types().insert(tp);
      // <af> No offsets have to be saved because extern types are stored
      // as objects if an union type is used.
      self.set_change(PROT_MOD);
   }
   TT(prot_H, T_LEAVE);
}

// *************************************************************************
void sos_UnionModif::del_type(sos_Type tp)
// *************************************************************************
{
   T_PROC("sos_UnionModif::del_type");
   TT(prot_H, T_ENTER);
 
 
   if (self.get_added_types().is_element(tp))
      self.get_added_types().remove(tp);
   else
   {  self.get_deleted_types().insert(tp);
      self.set_change(PROT_MOD);
   }
   TT(prot_H, T_LEAVE);
}

// *************************************************************************
void sos_UnionModif::local_initialize(sos_UnionModif um)
// *************************************************************************
{
   T_PROC("sos_UnionModif::local_initialize");
   TT(prot_M, T_ENTER);

   sos_Container cnt = um.container();

   um.set_added_types  (sos_Type_Set::create(cnt));
   um.set_deleted_types(sos_Type_Set::create(cnt));

   TT(prot_M, T_LEAVE);
}

// *************************************************************************
void sos_UnionModif::local_finalize(sos_UnionModif um)
// *************************************************************************
{
   T_PROC("sos_UnionModif::local_finalize");
   TT(prot_M, T_ENTER);

   um.get_added_types().destroy();
   um.get_deleted_types().destroy();

   TT(prot_M, T_LEAVE);
}
