/* -----------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik(FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * -----------------------------------------------------------------------------
 */
/* 
********************************************************************************
   Includefile for system includes                 21.09.93    Oliver Spatscheck
********************************************************************************
*/

#include "obst_config.h"

#ifdef OBST_IMP_STDCONST
#  include <stdio.h>
#endif

#ifdef OBST_IMP_STDARG
#  include <stdarg.h>
#endif

#ifdef OBST_IMP_ERROR
#  include <errno.h>
   externC int sys_nerr;
   externC char* sys_errlist[];
#endif

#ifdef OBST_IMP_MEMOP
#  include <memory.h>
#endif

#ifdef OBST_IMP_STRINGOP
#  include <string.h>
#  ifdef __cplusplus
#     define obst_strdup(s1) strcpy(new char[strlen(s1)+1],(s1))
#  else
#     define obst_strdup(s1) strcpy(malloc(strlen(s1)+1),(s1))
#  endif
#  ifdef HPUX
#     include <strings.h> 
#  endif
#endif

#ifdef OBST_IMP_CHARTYPE
#  include <ctype.h>
#endif

#ifdef OBST_IMP_STREAM
#  include <stream.h>
#  ifdef HAVE_IOSTREAM_H
#     include <iostream.h>
#  endif
#  ifdef HAVE_OSFCN_H 
#     include <osfcn.h>
#  endif
#endif

#ifdef OBST_IMP_FORMATTED_IO
#  include <stdio.h>
#  include <stdlib.h>
#endif

#ifdef OBST_IMP_FILE
#  if defined(OPEN_IS_IN_SYSENT_H) && defined(__cplusplus)
#     include <sysent.h>
#  endif
#  include <sys/stat.h>
#  include <sys/types.h>
#  include <sys/file.h>
#  include <sys/param.h>
#  ifdef HAVE_UNISTD_H
#     include <unistd.h>
#  endif
#  include <fcntl.h>
#  include <stdio.h>
#  ifdef HAVE_FSYNC 
      externC int fsync __FSIG_((int));
#  else
#     ifdef HAVE_SYNC
#        define fsync(a)     sync()
#     else
#        define fsync(a)
#     endif
#  endif
#  ifndef SEEK_SET
#     define SEEK_SET        L_SET
#     define SEEK_CUR        L_INCR
#     define SEEK_END        L_XTND
#  endif
#  if OBST_ADDITIONAL_PROTOTYPES >= OBST_BASICSET
      externC int ftruncate __FSIG_((int, off_t));
#  endif
   externC char* getwd     __FSIG_((char*));
   externC char* mktemp    __FSIG_((char*));
#  ifdef HAVE_GETWD
#     define obst_getwd(buf) getwd(buf)
#  else
#     define obst_getwd(buf) getcwd(buf,sizeof(buf))
#  endif
#endif

#ifdef OBST_IMP_FILELOCK
#  include <sys/types.h>
#  include <sys/file.h>
   externC int flock __FSIG_((int,int));
#  ifdef HAVE_UNISTD_H
#     include <unistd.h>
#  endif
#endif

#ifdef OBST_IMP_MALLOC
#  include <stdlib.h>
#  ifdef REALLOC_NEED_MALLOC_T
#     define REALLOC(ptr,size) realloc((malloc_t)(ptr),(size))
#     include <malloc.h>
#  else
#     define REALLOC(ptr,size) realloc((char*)(ptr),(size))
#  endif
#endif

#ifdef OBST_IMP_SORT_SEARCH
#  ifdef HAVE_SEARCH_H
#     include <search.h>
#  endif
#  include <stdlib.h>
   typedef int   qsort_cmpfct_t   __FSIG_((_qsort_const_ void*,
					   _qsort_const_ void*));
   typedef int   tsearch_cmpfct_t __FSIG_((_tsearch_const_ void*,
					   _tsearch_const_ void*));
   externC void* tsearch	  __FSIG_((_tsearch_const_ void*,
                                           void**, tsearch_cmpfct_t*));
#  ifdef HPUX
#     include <strings.h> 
#  endif
#endif

#ifdef OBST_IMP_RANDOM
#  include <stdlib.h>
#  ifdef HAVE_RANDOM
#     if OBST_ADDITIONAL_PROTOTYPES >= OBST_BASICSET
         externC void srandom __FSIG_((int));
#     endif
      externC long random();
#  else
#     define srandom srand
#     define random  rand
#  endif
#endif

#ifdef OBST_IMP_TIME
#  include <stdlib.h>
#  include <sys/time.h>
#  ifdef TIME_WITH_SYS_TIME
#     include <time.h>
#  endif
   externC int gettimeofday __FSIG_((struct timeval*, struct timezone*));
#  if OBST_ADDITIONAL_PROTOTYPES == OBST_GCC2_5_SUNOS_41
      externC int usleep __FSIG_((unsigned));
#  endif
#endif

#ifdef OBST_IMP_TIMER
#  include <sys/time.h>
#endif

#ifdef OBST_IMP_SIGNAL
#  if !defined(WRAP_SIGNAL_H)
#     include <signal.h>
#  else
#  ifndef __OBST_SIGNAL_H
#     define __OBST_SIGNAL_H
#        define kill        ______kill
#        define sigaction   ______sigaction
#        define sigaddset   ______sigaddset
#        define sigdelset   ______sigdelset
#        define sigemptyset ______sigemptyset
#        define sigfillset  ______sigfillset
#        define sigismember ______sigismember
#        define sigpending  ______sigpending
#        define sigprocmask ______sigprocmask
#        define sigsuspend  ______sigsuspend

#        include <signal.h>
   
#        undef kill        
#        undef sigaction  
#        undef sigaddset 
#        undef sigdelset
#        undef sigemptyset 
#        undef sigfillset 
#        undef sigismember
#        undef sigpending
#        undef sigprocmask
#        undef sigsuspend

         struct  sigaction {
                 void            (*sa_handler)();
                 sigset_t        sa_mask;
                 int             sa_flags;
         };

         externC int kill __FSIG_(( pid_t p, int sig ));
         externC int sigaction __FSIG_(( int signo, struct sigaction *act,
						    struct sigaction *oldact ));
         externC int sigaddset __FSIG_(( sigset_t *mask, int signo ));
         externC int sigdelset __FSIG_(( sigset_t *mask, int signo ));
         externC int sigemptyset __FSIG_(( sigset_t *mask ));
         externC int sigfillset __FSIG_(( sigset_t *mask ));
         externC int sigismember __FSIG_(( sigset_t *mask, int signo ));
         externC int sigpending __FSIG_(( sigset_t *set ));
         externC int sigprocmask __FSIG_(( int how, sigset_t *set,
						    sigset_t *oldset ));
         externC int sigsuspend __FSIG_(( sigset_t *mask ));

#     endif
#  endif
#  if !defined(HAVE_SIGACTION)
#     if !defined(HAVE_SIGVEC) 
         typedef struct sigvec
         {
            void (*sv_handler) (int);
            sigset_t sv_mask;
            int  sv_flags;
            void (*sv_restorer) (void);
         };
	 externC int sigvec __FSIG_(int, struct sigvec*, struct sigvec*));
#     endif
#     define sigaction(a,b,c)\
         sigvec((a),(struct sigvec *)(b),(struct sigvec *)(c))
#  endif
#  if defined(HAVE_NO_SIGHDL_PARAM)
      typedef void sighandler_t();
#  else
#     if !defined(SIGVEC_IN_SIGNAL_H) 
         typedef void sighandler_t __FSIG_((int));
#     else
         typedef void sighandler_t __FSIG_((__VARARGS));
#     endif
#  endif
#endif

#ifdef OBST_IMP_SETJMP
/* The following definitions cope with a bug in the AT&T libraries on a sun:
 * Due to the way C header files are used within C++ header files, a line
 *    #pragma unknown_control_flow(______sigsetjmp,______setjmp,_______setjmp)
 * will appear in the output of cfront (an additional line dealing with
 * register allocation will appear on a sun3).
 * In the subsequent C compiler run this line causes three warnings (unknown
 * functions) and an occasional error at optimization level O2 and higher.
 * The definitions will just assure that a known function is named in the
 * pragma directives.
 */
#  if defined(KNOWS_PRAGMA_UNKNOWN_CONTROL_FLOW) && defined(______SIGSETJMP_DEFINED)
      extern void _obst_foo();
#     define ______sigsetjmp _obst_foo__Fv
#     define ______setjmp    _obst_foo__Fv
#     define _______setjmp   _obst_foo__Fv
#  endif
#  if !(defined(WRAP_SETJMP_H) && defined(__cplusplus))
#     include <setjmp.h>
#  else
#  ifndef __SETJMP_H
#     define __SETJMP_H
#     define sigsetjmp  ______sigsetjmp
#     define setjmp     ______setjmp
#     define _setjmp    _______setjmp
#     define siglongjmp ______siglongjmp
#     define longjmp    ______longjmp
#     define _longjmp   _______longjmp

#     include "/usr/include/setjmp.h"

#     undef _longjmp
#     undef _setjmp
#     undef longjmp
#     undef setjmp
#     undef siglongjmp
#     undef sigsetjmp

      externC int setjmp      __FSIG_((jmp_buf));
      externC void longjmp    __FSIG_((jmp_buf, int));
      externC int _setjmp     __FSIG_((jmp_buf));
      externC void _longjmp   __FSIG_((jmp_buf, int));
      externC int  sigsetjmp  __FSIG_((sigjmp_buf, int));
      externC void siglongjmp __FSIG_((sigjmp_buf, int));
#  endif
#  endif
#endif

#ifdef OBST_IMP_SOCKETS
#  include <sys/types.h>
#  if OBST_ADDITIONAL_PROTOTYPES == OBST_GCC1_40
#     define gethostbyname ________________gethostbyname
#     include <netdb.h>
#     undef gethostbyname
      externC struct hostent *gethostbyname __FSIG_((char*));
#  else
#     include <netdb.h>
#  endif
#  include <netinet/in.h>
#  include <arpa/inet.h>
#  include <sys/socket.h>
#  define uname     _______________uname
#  include <sys/utsname.h>
#  undef uname
   externC int uname  __FSIG_((struct utsname*));
#  if OBST_ADDITIONAL_PROTOTYPES == OBST_GCC2_5_SUNOS_41
      externC int socket      __FSIG_((int, int, int));
      externC int getsockname __FSIG_((int, struct sockaddr*, int*));
      externC int bind        __FSIG_((int, const void*, int));
      externC int recv        __FSIG_((int, void*, int, int));
      externC int connect     __FSIG_((int, const struct sockaddr*, int));
      externC int send        __FSIG_((int, const void*, int, int));
      externC int setitimer   __FSIG_((int, const struct itimerval*, 
				       struct itimerval*));
#  endif
#endif

#ifdef OBST_IMP_PROCESS
#  include <sys/types.h>
#  ifdef HAVE_UNISTD_H
#     include <unistd.h>
#  endif
#endif

#ifdef OBST_IMP_PROCEXEC
#  include <stdlib.h>
#endif

#ifdef OBST_IMP_PROCENV
#  include <stdlib.h>
#endif

#ifdef OBST_IMP_A_OUT
#  include <a.out.h>
#  if defined(MIPSEL) || defined(USG)
#     ifndef HPUX
#        define exec   aouthdr
#        define a_text text_start
#        define a_data data_start
#     endif
#  endif
#endif

#ifdef OBST_IMP_MEMMGR
#  include <sys/mman.h>
   externC int mprotect __FSIG_((char *, int, int));
#endif

#ifdef OBST_IMP_PROCRESOURCE
#  include <sys/time.h>
#  ifdef HAVE_GETRLIMIT
#     include <sys/resource.h>
      externC int getrlimit __FSIG_((int, struct rlimit*));
#     if OBST_ADDITIONAL_PROTOTYPES >= OBST_BASICSET
         externC int setrlimit __FSIG_((int, const struct rlimit*));
#     endif
#  endif
#endif

#ifdef OBST_IMP_XAW
#  ifdef __cplusplus
#     define XTFUNCPROTO
#  endif
   /* strlen conflicts (at least) in case of X11R4, g++ 2.5.8, SunOS 4.1.3 */
#  define strlen _______strlen
#  include <X11/IntrinsicP.h>
#  undef strlen
#  include <X11/Shell.h>

#  if XtSpecificationRelease == 4 && defined(__cplusplus)
      extern "C" 
      {
#     define XawListChange          _______XawListChange
#     define XawListUnhighlight     _______XawListUnhighlight
#     define XawListHighlight       _______XawListHighlight
#     define XawTextReplace         _______XawTextReplace
#     define XawTextEnableRedisplay _______XawTextEnableRedisplay
#  endif

#  include <X11/Xaw/List.h>
#  include <X11/Xaw/Form.h>
#  include <X11/Xaw/Command.h>
#  include <X11/Xaw/Label.h>
#  include <X11/Xaw/Text.h>
#  include <X11/Xaw/AsciiText.h>
#  include <X11/Xaw/Viewport.h>

#  if XtSpecificationRelease == 4 && defined(__cplusplus)
#     undef XawListChange
#     undef XawListUnhighlight
#     undef XawListHighlight
#     undef XawTextReplace
#     undef XawTextEnableRedisplay

      void XawListChange(Widget,String*,int,int,int);
      void XawListUnhighlight(Widget);
      void XawListHighlight(Widget,int);
      int  XawTextReplace(Widget,XawTextPosition,XawTextPosition,XawTextBlock*);
      int  XawTextEnableRedisplay(Widget);
      }
#  endif

#  include <X11/StringDefs.h>
#  include <X11/cursorfont.h>
#endif

#ifdef OBST_IMP_XLIB
#  include <X11/Xlib.h>
#  include <X11/Intrinsic.h>
#endif
