/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */

#define OBST_IMP_STDCONST
#define OBST_IMP_STRINGOP
#define OBST_IMP_SORT_SEARCH
#define OBST_IMP_CHARTYPE
#define OBST_IMP_FILE
#define OBST_IMP_MALLOC
#define OBST_IMP_PROCESS
#define OBST_IMP_PROCEXEC
#define OBST_IMP_PROCENV
#include "obst_stdinc.h"

#include "_obst_config.h"
#include "obst_progstd.h"
#include "obst_err.h"
#include "obst.h"
#include "obst_stats.h"
#include "smg.h"
#include "knl_use.h"
#include "agg_use.h"
#ifdef OBST_HAVE_INCRLD
#  include "cci_incrload.h"
#endif

extern const err_msg err_NO_CONTAINER_PATH;

extern void _psm_final_initialize();

#ifdef OBST_HAVE_JOYCE
EXPORT sos_Transaction TRANSACTION;
#endif
EXPORT int             obst_initialized /* = FALSE */;	// done implicitely


EXPORT char* obst_getenv (char* varname)
{  char*      value;
   smg_String vname = smg_String("OBST") + varname;

   if (!( value = getenv (vname.make_Cstring(SMG_BORROW)) ))
   {  vname = smg_String("SOS") + varname;
      value = getenv (vname.make_Cstring(SMG_BORROW));
   }
   return value;
}

LOCAL void check_cnt_compatibility()
{
   // Test of compatibility of the containers and this 
   // program version
   // call the script obst-check_cnt_version:
   // obst-check_cnt_version <OBSTVERSION> <pid>;
   smg_String cmd = smg_String("obst-check_cnt_version ") + obst_version +
		    " " + getpid();

   if (system (cmd.make_Cstring (SMG_BORROW)))
   {  // though script is not available or error is detected, 
      // still check correspondence of OBST version and container version
      // If script detects an error it kills the parent process if present.
      // Due to this the following code has no effect if the script detects
      // an error.

      char*      env_path = obst_getenv(ENVVAR_CONTAINER);
      smg_String path;
      if (env_path)
	 path = smg_String(env_path) + "/version";
      else
         err_raise (err_SYS, err_NO_CONTAINER_PATH, NULL, FALSE);

      int fd = ::open (path.make_Cstring(SMG_BORROW), O_RDONLY);
      if (fd >= 0)
      {  char contents[MAXPATHLEN*2];
         ::read (fd, (char *)&contents, MAXPATHLEN*2);
	 contents[MAXPATHLEN*2 - 1] = '\0';

	 char* version = contents;
	 while (*version && *(version ++) != ':')
	    ;
         if (!version
	     || strncmp(version, obst_version, strlen(obst_version)))
	 {  if (!version)
	       version = "<unknown>";
	    else
	    {  char* end = version;
	       while (*end && !isspace(*end))
		  ++ end;
	       *end = '\0';
	    }
	    smg_String msg = smg_String("container version (") + (version+1)
			     + ") != OBST version (" + obst_version + ")";
	    err_raise (err_WNG, msg.make_Cstring(SMG_BORROW));
         }
      }
      ::close (fd);
   }
} // check_cnt_compatibility

EXPORT void _obst_init (int, char *argv[])
{  if (!(obst_tempdir = obst_getenv (ENVVAR_TMPDIR)))
      obst_tempdir = getenv ("TMPDIR");

   obst_tempdir = (obst_tempdir) ? obst_strdup (obst_tempdir) : ".";

   _obst_initcore();
#ifdef OBST_HAVE_INCRLD
   cci_incr_ld.init (argv);
#endif

   // if programm init is called, transactions won't work
   char *basename, *ptr;
   basename = ptr = argv[0];
   while (*ptr)
      if (*(ptr ++) == '/')
         basename = ptr;

   if ((streql (basename, "init")) || (streql (basename, "sync_switch")))
#ifdef OBST_HAVE_JOYCE
      TRANSACTION = sos_Transaction::make (NO_OBJECT);
#else
      ;
#endif
   else
   {  _psm_final_initialize();
#ifdef OBST_HAVE_JOYCE
      TRANSACTION = sos_Transaction::create(TEMP_CONTAINER);
#endif
   }
   check_cnt_compatibility ();

   obst_initialized = TRUE;
}


// --------------------------------------------------------------------------

EXPORT void obst_add_histdata (register obst_histentry** harray,
			       register int* 		 size, int data)
{  for (register int idx = 0;  idx < *size;  ++ idx)
      if ((*harray)[idx].data >= data)
	 break;

   if (idx == *size || (*harray)[idx].data != data)
   {  *harray = (*size)
      		  ? (obst_histentry*)REALLOC(*harray,
					     (++ *size)*sizeof(obst_histentry))
		  : new obst_histentry[++ *size];

      register int    i    = *size - 1;		// # of elems to copy: 'i - idx'
      obst_histentry* from = *harray + i;	// '& *harray[i]'
      for (i = *size-1;  i > idx;  -- i)
      {  obst_histentry* to = from --;
	 *to = *from;
      }
      from->data       = data;
      from->occurences = 0;
   }
   ++ (*harray)[idx].occurences;
}

EXPORT obst_htabinfo* obst_add_htabinfo (obst_htabstat* htstat)
{  htstat->htabs
      = (htstat->size ++)
	    ? (obst_htabinfo*)REALLOC (htstat->htabs,
				       htstat->size * sizeof(obst_htabinfo))
	    : new obst_htabinfo[htstat->size];

   obst_htabinfo* newinfo = htstat->htabs + htstat->size - 1;
   newinfo->histsize  = 0;
   newinfo->histogram = NULL;
   newinfo->buckets   = 0;
   newinfo->descr     = NULL;

   return newinfo;
}

EXPORT void obst_free_htabstat (obst_htabstat* htstat)
{  for (int i = 0;  i < htstat->size;  ++ i)
   {  if (htstat->htabs[i].histsize)
	 delete htstat->htabs[i].histogram;
   }
   if (htstat->size)
      delete htstat->htabs;
}

EXPORT void obst_collect_stats (obst_htabstat* htstat)
{  htstat->size = 0;
   _cci_collect_stats (htstat);
   _psm_collect_stats (htstat);
}


EXPORT char* obst_print_htabstats (obst_htabstat* htstat, sos_Bool del)
{  smg_String txt;
   smg_String sep = "--------------------------------------------------------------------\n";

   for (int i = 0;  i < htstat->size;  ++ i)
   {  txt += sep
	  +  "TABLE: " + htstat->htabs[i].descr
	  +  "(" + htstat->htabs[i].buckets + " buckets)\n";

      for (int j = 0;  j < htstat->htabs[i].histsize;  ++ j)
      {  obst_histentry* histo = & htstat->htabs[i].histogram[j];
         txt += smg_String("\tbucket size: ") + histo->data
             +  "\toccurences: " + histo->occurences + "\n";
      }
   }
   txt += sep;

   if (del)
      obst_free_htabstat (htstat);

   return txt.make_Cstring (SMG_TRANSFER);
}


// --------------------------------------------------------------------------

#ifndef HAVE_TSEARCH
EXPORT void* tsearch (_tsearch_const_ void* key, 
		      void**		  rootp, 
		      tsearch_cmpfct_t*	  compar)
{
    struct _node {
	_tsearch_const_ void* keyptr;
	struct _node *llink;
        struct _node *rlink;
    };
    struct _node *nodeptr;

    
    if (*rootp == NULL) {
	nodeptr = new (struct _node);
	nodeptr->llink = NULL;
	nodeptr->rlink = NULL;
	nodeptr->keyptr = key;
	(*rootp) = (void *) nodeptr;
	return((void *) &key);
    }
    else {

	struct _node *treeptr;
	int K;

	treeptr = ((struct _node *) *rootp);

	while (1) {

	   K = compar(key, treeptr->keyptr);

	   if (K < 0) {

	      if (treeptr->llink == NULL) 
		 break;
	      else
		 treeptr = treeptr->llink;
	   }
	   else if (K > 0) {
	      if (treeptr->rlink == NULL) 
		 break;
	      else
		 treeptr = treeptr->rlink;
	   }
	   else
	      return((void *) &(treeptr->keyptr)); 
	}

       nodeptr = new (struct _node);
       nodeptr->llink = NULL;
       nodeptr->rlink = NULL;
       nodeptr->keyptr = key;

       if (K < 0) 
	 treeptr->llink = nodeptr;
       else
	 treeptr->rlink = nodeptr;
	 
       return((void *) &key);      
    }    
}
#endif

// --------------------------------------------------------------------------

EXPORT void _obst_foo() {}
