/* --------------------------------------------------------------------------
 * Copyright 1993-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the licence
 * you should have received along with this program.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
// ********************************************************************
// mtool_main
// ********************************************************************

/*
 * This is old/obsolete code which will probably be deleted in the next release
 * and which is probably also buggy.
 * This is a former test program which has been replaced by msh.
 *
 * Things which will have to be changed/checked:
 *  . find_methods_by_usage, find_all_methods_by_name,
 *    find_all_types_by_usage, display_class
 *	Contain invocations of methods which do no longer exist and must hence
 *	be replaced by the current methods, respectively by implementing the
 *	former methods in-place.
 *	Some functions will even crash since 'l' is undefined.
 *  . create_generic_from_class
 *	not yet implemented
 *  . modify_typedef
 *	better using read_sos_Type_descr here?
 *  . check_inherited_methods
 *	OK should not be printed after error messages were written.
 *  . check_inherited_methods
 *	deactivated code
 *  . read_sos_Cstring
 *	reads into fixed-size buffer without setting a limit
 *  . Probably not all transient objects are discarded after use.
 */

#define OBST_IMP_STREAM
#define OBST_IMP_PROCEXEC
#include "obst_stdinc.h"

#include "obst.h"
#include "obst_progstd.h"
#include "obst_err.h"
#include "smg.h"
#include "mta_obst.h"
#include "mta.h"

#include "mtool_stream.h"


// --------------------------------------------------------------------------

#define DO_MODIFY	0
#if DO_MODIFY
#  define MODIFY(code)	code
#else
#  define MODIFY(code)
#endif

LOCAL sos_Schema_module current_schema;
LOCAL sos_Method        current_method;
LOCAL sos_Comp_descr    current_comp;
LOCAL sos_Enum_type     current_enum;
LOCAL sos_Typedef_type  current_typedef;
LOCAL sos_Class_type    current_class;
LOCAL sos_Extern_type   current_extern;
LOCAL sos_Union_type    current_union;


// --------------------------------------------------------------------------

#define check_on_class() \
   if (INVALID (current_class)) \
   {  cout << "Please select a sos_Class_type first ..."; \
      return; \
   }
#define check_on_typedef() \
   if (INVALID (current_typedef)) \
   {  cout << "Please select a sos_Typedef_type first ..."; \
      return; \
   }
#define check_on_extern() \
   if (INVALID (current_extern)) \
   {  cout << "Please select a sos_Extern_type first ..."; \
      return; \
   }
#define check_on_union() \
   if (INVALID (current_union)) \
   {  cout << "Please select a sos_Union_type first ..."; \
      return; \
   }
#define check_on_schema() \
   if (INVALID (current_schema)) \
   {  cout << "Please select a sos_Schema first ..."; \
      return; \
   }
#define check_on_method() \
   if (INVALID (current_method)) \
   {  cout << "Please select a method first ..."; \
      return; \
   }

#define check_on_component() \
   if (INVALID (current_comp)) \
   {  cout << "Please select a component first ..."; \
      return; \
   }

#define check_on_enum() \
   if (INVALID (current_enum)) \
   {  cout << "Please select a enumeration first ..."; \
      return; \
   }


LOCAL sos_Bool redefinition (sos_Method_List ml, sos_Method m)
{  
   agg_iterate(ml,sos_Method tmp_m)
   {  if (tmp_m.redefines(m));
	 return TRUE;
   }
   agg_iterate_end(ml,tmp_m)
   return FALSE;
} // redefinition

LOCAL sos_Bool lookup (sos_Method_table mt, sos_Method m)
{  sos_Method_List ml = mt[m.get_name()];
   if (VALID(ml))
   {  agg_iterate(ml, sos_Method tmp_m)
      {
	 if (tmp_m == m)
	 {  ml.close_cursor (agg_current_cursor());
	    return TRUE;
	 }
      }
      agg_iterate_end(ml, tmp_m)
   }
   return FALSE;
} // lookup

LOCAL void check_components (sos_Class_type ct)
{  cout << "check_components:"; cout.flush();

   sos_Super_class_List super_closure = ct.get_super_closure();
   sos_Comp_descr_List  ct_components = ct.get_components();
   agg_iterate (super_closure, sos_Super_class sc)
   {  sos_Class_type sct = sos_Class_type::make(sc.get_super_class());
      agg_iterate (sct.get_components(), sos_Comp_descr sc_cd)
      {  sos_Bool found = FALSE;
	 agg_iterate (ct_components, sos_Comp_descr ct_cd)
	 {  if (ct_cd.get_name().equal (sc_cd.get_name()))
	    {  found = TRUE;
	       break;
            }
	 }
         agg_iterate_end (ct_components, ct_cd)
	 if (NOT found)
	    cout << "check_comp:error1: "
		 << sc_cd << "missing in " << ct.get_name() << "\n";
      }
      agg_iterate_end (sct.get_components(), sos_Comp_descr sc_cd)
   }
   agg_iterate_end (super_closure, sos_Super_class sc)

   cout << "OK\n";
} // check_components

LOCAL void test (sos_String_sos_Method_List_Mapping inhm)
{  cout << "test:card=" << inhm.card() << "\n";

   agg_iterate_association (inhm, sos_String name, sos_Method_List ml)
   {  cout << "inherited_methods@@@:" << name;
      agg_iterate (ml, sos_Method m)
         cout << ".";
      agg_iterate_end (ml, m)
   }
   agg_iterate_association_end (inhm, name,ml);
   cout << "test@@@:end\n";
}

LOCAL void check_inherited_methods(sos_Class_type ct)
{  
/*
// ---------------------------------------------
   cout << "####### TEST ######\n";
   sos_Method_table		      mt_org = ct.get_methods();
   sos_String_sos_Method_List_Mapping mt_tmp
   	= sos_String_sos_Method_List_Mapping::create (TEMP_CONTAINER);
   mt_tmp.change_impl_type (AGG_HASH);

   agg_iterate_association(mt_org,sos_String s,sos_Method_List ml)
   {  sos_String tmp_s = sos_String::create (TEMP_CONTAINER, s);
      mt_tmp.insert(tmp_s, ml);
   }
   agg_iterate_association_end(mt_org,s,ml);

   cout << "### DELETION ####\n";
   test (sos_String_sos_Method_List_Mapping::make(mt_org));
   test (mt_tmp);
   agg_iterate_association(mt_org,sos_String s,sos_Method_List ml)
   {  
      mt_tmp.remove (s);
      test (sos_String_sos_Method_List_Mapping::make(mt_org));
      // test (mt_tmp);
   }
   agg_iterate_association_end(mt_org,s,ml)
   cout << "SUCCESSFUL!!!\n";

// ---------------------------------------------
*/
   cout << "\ncheck_inherited_methods:";
   cout.flush();
   sos_Method_table inhm = ct.get_methods();
   if (INVALID(inhm))
   {  cout << "error:" << ct.make_type()  << ".inherited_methods = NO_OBJECT\n";
      abort();
   }

   sos_Method_table inhm_tmp = sos_Method_table::create(TEMP_CONTAINER);
   inhm_tmp.change("impl_type","AGG_LIST");
   agg_iterate_association(inhm, sos_String s, sos_Method_List ml)
   {  
      sos_Method_List tmp_ml = sos_Method_List::clone (ml, TEMP_CONTAINER);
      inhm_tmp.insert(s, tmp_ml);
   }
   agg_iterate_association_end(inhm,s,ml)

   sos_Method_List local_ml = ct.get_local_methods();
   agg_iterate(local_ml, sos_Method m) 
   {  
      if (NOT lookup(inhm,m))
         cout << "check_inhm1:" << m << " is not defined\n";
      else if (INVALID(m.get_comp_descr()))
      {  sos_Bool found =
#if DO_MODIFY
	 		  mta_remove_method(inhm_tmp,m,FALSE);
#else
	 		  TRUE;
#endif
	 if (NOT found)
	    cout << "check_inhm:" << m << "does not exist in inhm_tmp\n";
      }
   }
   agg_iterate_end(local_ml,m)

   agg_iterate(ct.get_components(),sos_Comp_descr cd) 
   {  sos_Method get_method = cd.get_get_method();
      sos_Method set_method = cd.get_set_method();

      if (get_method.get_defined_in() == ct)
      {  if (NOT lookup(inhm, get_method))
	    cout << "check_inhm2:" << get_method << " is not defined.\n";
         else
         {  sos_Bool found =
#if DO_MODIFY
	    		     mta_remove_method(inhm_tmp,get_method,FALSE);
#else
	 		     TRUE;
#endif
            if (NOT found)
	       cout << "check_inhm:" << get_method 
		    << "does not exist in inhm_tmp\n";
         }
      }
      if (set_method.get_defined_in () == ct)
      {  if (NOT lookup(inhm,set_method))
	    cout << "check_inhm3:" << set_method << " is not defined.\n";
         else
         {  sos_Bool found =
#if DO_MODIFY
	    		     mta_remove_method(inhm_tmp,set_method,FALSE);
#else
	 		     TRUE;
#endif
            if (NOT found)
	       cout << "check_inhm:" << set_method 
		    << "does not exist in inhm_tmp\n";
         }
      }
   }
   agg_iterate_end(ct.get_components(),cd) 
   sos_Super_class_List scll = ct.get_super_closure();
   agg_iterate(scll,sos_Super_class sc)
   {  sos_Method_table smt = sos_Class_type::make(
				       sc.get_super_class()).get_methods();
      agg_iterate_association(smt, sos_String s, sos_Method_List ml)
      {  agg_iterate(ml,sos_Method tmp_m)
         {  if (tmp_m.get_kind() != sos_PRIVATE  AND  NOT tmp_m.get_is_static())
	    {  
	       if (NOT lookup(inhm,tmp_m)) 
	       {  if (NOT redefinition(ct.get_local_methods(),tmp_m))
	           cout << "check_inhm:" 
			<< sc.get_super_class().make_type().get_name() 
			<< "::" << tmp_m << " is not contained here.\n";
	       }
               else if (inhm_tmp.is_key(tmp_m.get_name()))
	       {  sos_Method_List ml_tmp = inhm_tmp[tmp_m.get_name()];
		  if (ml_tmp.find (tmp_m))
		     MODIFY( mta_remove_method(inhm_tmp,tmp_m) );
	       }
            }
	 }
	 agg_iterate_association_end(ml, s, tmp_m);
      }
      agg_iterate_end(smt, ml)
   }
   agg_iterate_end(scll, sc)

   if (inhm_tmp.card() != 0)
      cout << "error:check_inhm:invalid insertion of the following methods:"
	   << inhm_tmp << "\n";
   inhm_tmp.destroy();

   cout << "OK\n";cout.flush();
}

LOCAL sos_Method_kind read_sos_Method_kind()
{  int kind;
   cout << "sos_Method_kind:(public=0;protected=1;private=2):";
   cin  >> kind;
   switch (kind)
   {  case 2:return sos_PRIVATE;
      case 1:return sos_PROTECTED;
      case 0:return sos_PUBLIC;
   }
   return sos_PUBLIC;
}

LOCAL sos_Cstring read_sos_Cstring (sos_Cstring prompt)
{  char tmp[80];

   cout << prompt;
   cin  >> tmp;

   return obst_strdup(tmp);
}

LOCAL sos_String read_sos_String ()
{  sos_Cstring tmp = read_sos_Cstring ("sos_String(@=NO_OBJECT):");

   sos_String t;
   if (tmp == "@")
      t = sos_String::make(NO_OBJECT);
   else
      t = sos_String::create(TEMP_CONTAINER, tmp);

   delete tmp;

   return t;
}

LOCAL sos_Class_type read_sos_Class_type(sos_Cstring c)
{  sos_Cstring    tmp = read_sos_Cstring(c);
   sos_String	  t   = sos_String::create (TEMP_CONTAINER, tmp);
   sos_Type_descr st  = sos_Type_descr::make(current_schema.lookup_type(t));
   if (INVALID (st)  OR  NOT st.isa(sos_Class_type_type))
   {  cout << "Unknown class.\n";
      st = sos_Type_descr::make(NO_OBJECT);
   }
   t.destroy();
   delete tmp;

   return sos_Class_type::make(st);
} // read_sos_Class_type

LOCAL sos_Type_descr read_sos_Type_descr(sos_Cstring str, sos_Cstring& input)
{  input = read_sos_Cstring(str);

   sos_String	       t	    = sos_String::create(TEMP_CONTAINER, input);
   sos_Type_descr      st	    = sos_Type_descr::make (NO_OBJECT);
   sos_Type_descr_List schema_types = current_schema.get_types();

   for (sos_Cursor c = schema_types.open_cursor();
        schema_types.is_valid(c);
        schema_types.to_succ(c))
   {  sos_Type_descr schema_type = schema_types.get(c);
      if (schema_type.has_type (sos_Typedef_type_type))
      {  sos_Typedef_type tdt = sos_Typedef_type::make (schema_type);
	 if (tdt.get_name().equal (t))
	    st =schema_type;
      }
      else if (schema_type.make_type().get_name().equal (t))
	 st = schema_type;
    }
    schema_types.close_cursor(c);

   if (INVALID (st))
   {  sos_Type_descr type = current_schema.lookup_type (t);
      if (VALID(type))
	 st = type;
   }
   if (INVALID(st))
      cout << "Unknown type.\n";
   t.destroy();
   return st;
} // read_sos_Type_descr

LOCAL sos_Type_descr read_sos_Type_descr(sos_Cstring str)
{  sos_Cstring    dummy;
   sos_Type_descr result = read_sos_Type_descr (str, dummy);
   delete dummy;

   return result;
}

LOCAL sos_Bool read_sos_Bool()
{  int i;
   cout << "input sos_Bool(0=FALSE;1=TRUE):";
   cin  >> i;

   if (i == 0)
   {  cout << "input was FALSE";
      return FALSE;
   }
   cout << "input was TRUE";
   return TRUE;
}

LOCAL sos_Int read_param_no_to_insert()
{  int card = current_method.get_params().card();
   int no;
   cout << "Insertion after parameter with the number [0-" << card << "]:";
   cin  >> no;
   if (no < 0  OR  no > card)
      return -1;
   return no;
}

LOCAL sos_Int read_param_no()
{
   int card = current_method.get_params().card();
   int no;
   cout << "parameter number [1-" << card << "]:";
   cin  >> no;

   if (no < 1  OR  no > card)
      return 0;
   return no;
}

LOCAL sos_Expr read_sos_Expr()
{  int x;
   cout << "sos_Expr:0=NO_OBJECT,1=sos_Int,2=sos_String:";
   cin  >> x;
   switch (x)
   {  case 0:
      {  return sos_Expr::make(NO_OBJECT);
      }
      case 1:
      {  cout << "value:";cin >> x;
	 sos_Int_expr ie = sos_Int_expr::create(TEMP_CONTAINER);
	 ie.set_value(x);
	 return sos_Expr::make(ie);
      }
      case 2:
      {  sos_String	s  = read_sos_String();
         sos_Identifier si = sos_Identifier::create(TEMP_CONTAINER);
	 si.set_id(s);
	 return sos_Expr::make(si);
      }
   }
   return sos_Expr::make (NO_OBJECT);
}

LOCAL void start_generator()
{
   check_on_schema();
   current_schema.generate ();
} // start_generator

LOCAL void display_defined_schemas()
{  
   sos_Schema_module_Directory schema_dir = sos_Schema_module::schema_dir();
   cout << "Defined schemas:";
   for (sos_Cursor c = schema_dir.open_cursor();
        schema_dir.is_valid(c);
        schema_dir.to_succ(c))
   {
      sos_Schema_module schema_module = schema_dir.get_info(c);
      cout << schema_module.get_name();
      sos_Import_List imports = schema_module.get_imports();
      if (imports.card() != 0)
	 cout << "{";
      sos_Bool first = TRUE;
      for (sos_Cursor c1 = imports.open_cursor();
           imports.is_valid(c1);
           imports.to_succ(c1))
      {  if (first)
	    first = FALSE;
	 else 
	    cout << " ";
         cout << imports.get(c1).get_module().get_name();
      }
      imports.close_cursor(c1);
      if (imports.card() != 0)
	 cout << "}";
      cout << " ";
   }
   schema_dir.close_cursor(c);
   cout << "\n";
}

LOCAL void select_schema()
{
   display_defined_schemas();
   sos_Cstring snm   = read_sos_Cstring(
			  "Name of the schema you want to work with:");
   sos_String  sname = sos_String::create(TEMP_CONTAINER, snm);

   sos_Schema_module_Directory sd = sos_Schema_module::schema_dir();
   sos_Schema_module	       sm = sd[sname];
   if (INVALID (sm))
      cout << "\nUnknown schema.\n";
   else
      current_schema = sm;

   sname.destroy();
   delete snm;
}// select_schema

LOCAL void display_types_in_schema(sos_Type t)
{   if (INVALID (t))
       cout << "Types";
    else
       cout << sos_Type_descr::make(t) << "'s";
    cout << " defined in " << current_schema.get_name() << ":";

    sos_Type_descr_List schema_types = current_schema.get_types();
    for (sos_Cursor c = schema_types.open_cursor();
         schema_types.is_valid(c);
         schema_types.to_succ(c))
    {  sos_Type_descr schema_type = schema_types.get(c);
       if (schema_type.has_type(t)  OR  INVALID(t))
       {  if (t == sos_Typedef_type_type)
             cout << sos_Typedef_type::make (schema_type).get_name() << " ";
          else
             cout << schema_type.make_type().get_name() << " ";
       }
    }
    schema_types.close_cursor(c);
    cout << "\n";
}

LOCAL void create_schema()
{  current_schema = sos_Schema_module::create_schema ();
}

LOCAL void delete_schema()
{  check_on_schema();
   current_schema.remove();
}

LOCAL void modify_schema_name()
{  check_on_schema();

   sos_String new_name = sos_String::create(TEMP_CONTAINER);
   cout << "New name of the schema " 
	<< current_schema.get_name() << ":";
   cin  >> new_name;
   current_schema.modify_name (new_name);
}

LOCAL void insert_schema_import()
{  check_on_schema()
   display_defined_schemas();

   sos_String new_import = sos_String::create(TEMP_CONTAINER);
   cout << "Name of the schema to import:";
   cin  >> new_import;
   sos_Schema_module import = sos_Schema_module::schema_dir()[new_import];
   if (INVALID (import))
      cout << "Unknown schema.\n";
   else
      current_schema.insert_import (import);
}

LOCAL void remove_schema_import()
{  check_on_schema();

   sos_String import_name = sos_String::create(TEMP_CONTAINER);
   cout << "Name of the import to remove:";
   cin  >> import_name;
   sos_Schema_module import = sos_Schema_module::schema_dir()[import_name];
   if (INVALID (import))
      cout << "Unknown schema.\n";
   else
      current_schema.remove_import (import);
}

LOCAL void schema_with_extern()
{  check_on_schema();

   cout
   << "'with_extern' is a flag to force inclusion of <schema_name>_ext.h.\n"
   << "<schema_name>_ext.h contains C++ declarations pertaining to <schema>.\n";

   cout << "Value of this with_extern flag:\n";
   sos_Bool b = read_sos_Bool();
   current_schema.modify_with_extern (b);
}

LOCAL void schema_commit()
{  check_on_schema();
   mta_commit();
}

LOCAL void schema_reset()
{  check_on_schema();
   mta_reset();
}

LOCAL void find_types_by_name ()
{  check_on_schema();

   sos_String name = sos_String::create (TEMP_CONTAINER);
   cout << "Name of the type to search:";
   cin  >> name;
   sos_Type_descr l = current_schema.lookup_type(name);
   cout << l << "\n";
   name.destroy();
}

LOCAL void find_types_by_usage ()
{  check_on_schema();

   sos_Type_descr st = read_sos_Type_descr(
			   "Name of the type that is used in the found types:");
   sos_Type_descr_List l ; // = current_schema.lookup_types(st);
   cout << l << "\n";
   if (VALID(l))
      l.destroy();
}

LOCAL void find_methods_by_name ()
{  check_on_schema();

   sos_String name = sos_String::create (TEMP_CONTAINER);
   cout << "Name of the methods to search:";
   cin  >> name;
   sos_Method_List l ; // = current_schema.lookup_methods (name);
   cout << "\n" << l << "\n";
   if (VALID(l))
      l.destroy();
}

LOCAL void select_type(sos_Type t)
{  check_on_schema() 
   display_types_in_schema(t);

   sos_Type_descr st = read_sos_Type_descr ("Name of the type:");
   if (NOT st.identical(NO_OBJECT))
   {  if (st.has_type(sos_Enum_type_type))
	 current_enum = sos_Enum_type::make (st);
      else if (st.has_type(sos_Typedef_type_type))
	 current_typedef = sos_Typedef_type::make (st);
      else if (st.has_type(sos_Union_type_type))
	 current_union = sos_Union_type::make (st);
      else if (st.has_type(sos_Class_type_type))
	 current_class = sos_Class_type::make (st);
      else if (st.has_type(sos_Extern_type_type))
	 current_extern = sos_Extern_type::make (st);
      else
	 cout << "Type " << st << " is not implemented.\n";
   }
} // select_type

LOCAL void select_method()
{  check_on_schema();
   check_on_class();

   sos_Method_List local_methods = current_class.get_local_methods();

   cout << "Methods defined in " << current_class.get_name() << ":";
   sos_Int no = 1;
   agg_iterate(local_methods, sos_Method m)
   {  if (INVALID(m.get_comp_descr()))
	 cout << " " << no++ << ":" << m.get_name();
   }
   agg_iterate_end(local_methods, m)

   int method_no;
   cout << "\nMethod number:";
   cin  >> method_no;
   no = 1;
   sos_Method tmp_m;
   agg_iterate(local_methods, sos_Method m)
   {  if (INVALID(m.get_comp_descr()))
         if (no++ == method_no) 
	    tmp_m = m; 
   }
   agg_iterate_end(local_methods, m);
   if (INVALID(tmp_m))
      cout << "Unknown method.\n";
   else
      current_method = tmp_m;
} // select_method

LOCAL void select_component()
{  check_on_schema();
   check_on_class();

   sos_Comp_descr_List components = current_class.get_components();

   cout << "Components defined in " << current_class.get_name() << ":";
   sos_Int no = 1;
   agg_iterate (components, sos_Comp_descr cd)
      cout << cd.get_name() << " ";
   agg_iterate_end(components, cd)

   sos_String comp_name = sos_String::create(TEMP_CONTAINER);
   cout << "\nName of the component:";
   cin  >> comp_name;

   sos_Method m = current_class.get_methods().lookup_comp(comp_name,FALSE);
   if (INVALID (m))
      cout << "Unknown component.\n";
   else
      current_comp = m.get_comp_descr();
}

LOCAL void modify_method()
{  check_on_schema();
   check_on_class();
   check_on_method();

   sos_String mn = sos_String::create(TEMP_CONTAINER);
   cout << "New name of the method:";
   cin  >> mn;

   cout << "is_static:";
   sos_Bool is_static = read_sos_Bool();

   cout << "is_abstract:";
   sos_Bool is_abstract = read_sos_Bool();

   cout << "is_definite:";
   sos_Bool is_definite = read_sos_Bool();

   sos_Method_kind kind = read_sos_Method_kind();

   display_types_in_schema (sos_Type::make (NO_OBJECT));
   sos_Type_descr new_result_type = read_sos_Type_descr("New result type:");

   MODIFY(
   mta_modify (current_method, new_result_type, mn,
	       kind,is_static,is_abstract, is_definite) );

   mn.destroy();
   check_inherited_methods( current_method.get_defined_in());
} // modify_method

LOCAL void insert_method_param()
{  check_on_schema();
   check_on_class();
   check_on_method();

   sos_Int no = read_param_no_to_insert();
   if (no == -1) 
      return;
   sos_Type_descr new_type = read_sos_Type_descr("New param type:");
   MODIFY( mta_create_method_param (current_method, no,new_type) );
}

LOCAL void delete_method_param()
{  check_on_schema();
   check_on_class();
   check_on_method();

   sos_Int no = read_param_no();
   if (no == 0)
      return;
   MODIFY( mta_remove_method_param (current_method, no) );
}

LOCAL void modify_method_param()
{  check_on_schema();
   check_on_class();
   check_on_method();

   sos_Int no = read_param_no();
   if (no == 0)
      return;
   sos_Type_descr st = read_sos_Type_descr("Name of the new parameter type");
   if (INVALID (st))
      return;

   cout << "is_ref:";
   sos_Bool   is_ref   = read_sos_Bool();
   sos_Expr   expr     = read_sos_Expr();
   sos_String new_name = sos_String::create(TEMP_CONTAINER);
   cout << "New name of the parameter:";
   cin  >> new_name;
   MODIFY( mta_modify_method_param (current_method, no, st, new_name,
				    is_ref,expr) );
}

LOCAL void create_method()
{  check_on_class();
   MODIFY( current_method = mta_create_method (current_class) );
   check_inherited_methods(current_class);
}

LOCAL void delete_method()
{  check_on_schema();
   check_on_class();
   check_on_method();

   sos_Class_type ct = current_method.get_defined_in();
   MODIFY( mta_remove (current_method) );
   current_method = sos_Method::make (NO_OBJECT);
   check_inherited_methods(ct);
}

LOCAL void create_component()
{  check_on_schema();
   check_on_class();
   MODIFY( current_comp = mta_create_comp(current_class) );
   
}

LOCAL void delete_component()
{  check_on_schema();
   check_on_class();
   check_on_component();
   MODIFY( mta_remove (current_comp) );
   current_comp = sos_Comp_descr::make (NO_OBJECT);
}

LOCAL void modify_component()
{  check_on_schema();
   check_on_class();
   check_on_component();

   sos_String new_name = sos_String::create(TEMP_CONTAINER);
   cout << "New name of the component:";
   cin  >> new_name;
   sos_Type_descr  new_type = read_sos_Type_descr(
					    "Name of the new component type:");
   sos_Method_kind new_kind = read_sos_Method_kind();

   cout << "local?";
   sos_Bool new_local = read_sos_Bool();
   sos_Expr new_expr  = read_sos_Expr();
   MODIFY( mta_modify (current_comp, new_name,
		       new_type, new_kind, new_kind, new_local, new_expr) );
   new_name.destroy();
   check_inherited_methods (current_class);
} // modify_component

LOCAL void create_class()
{  check_on_schema();
   MODIFY( current_class = mta_create_class (current_schema) );
   check_inherited_methods(current_class);
}

LOCAL void delete_class()
{  check_on_schema();
   check_on_class();

   MODIFY( mta_remove (current_class) );
   current_class = sos_Class_type::make (NO_OBJECT);
}

LOCAL void modify_class_name()
{  check_on_schema();
   check_on_class();

   sos_String new_name = sos_String::create(TEMP_CONTAINER);
   cout << "New name of the class:";
   cin  >> new_name;
   MODIFY( mta_modify_name (current_class, new_name) );
   new_name.destroy();
}

LOCAL void remove_super_class()
{  check_on_schema();
   check_on_class();

   cout << "Superclasses of " << current_class.get_name() << ":";
   sos_Super_class_List super_closure = current_class.get_super_closure();
   agg_iterate(super_closure, sos_Super_class s)
   {  cout << s.get_super_class().make_type().get_name() << " ";
   }
   agg_iterate_end(super_closure, s);

   sos_Class_type ct = read_sos_Class_type("Superclass to remove:");
   MODIFY( mta_remove_super_class (current_class, ct) );
}

LOCAL void insert_super_class()
{  check_on_schema();
   check_on_class();
   display_types_in_schema(sos_Type::make(NO_OBJECT));

   sos_Class_type ct =read_sos_Class_type("Name of the new superclass to add:");
   if (VALID (ct))
   {  sos_Type_descr_List agpl = sos_Type_descr_List::make (NO_OBJECT);
      if (VALID(ct.get_generic_class()))
      {  agpl = sos_Type_descr_List::create (TEMP_CONTAINER);

         sos_Gen_param_List gpl =ct.get_generic_class().get_formal_gen_params();
	 agg_iterate (gpl, sos_Gen_param gp) 
	 {  cout << "generic parameter:" << gp << ":";
	    sos_Cstring input;
	    sos_Type_descr tp = read_sos_Type_descr (
				    "Type or name of the generic parameter:",
				    input);
	    if (INVALID(tp))
	    {  cout << ", Assuming a new generic parameter named " 
		    << input << ".\n";
	       sos_Gen_param tmp_gp = sos_Gen_param::clone (gp,TEMP_CONTAINER);
	       tp = sos_Type_descr::make (tmp_gp);
	       tmp_gp.set_name (sos_String::create (TEMP_CONTAINER, input));
	       tmp_gp.get_name().assign_Cstring (input);
	    }
	    agpl.append (tp);
	    delete input;
	 }
	 agg_iterate_end (gpl, sos_Gen_param gp) 
      }
      MODIFY( mta_insert_super_class (current_class, ct, agpl) );
   }
}

LOCAL void display_super_classes(sos_Class_type ct) 
{  cout << "Superclasses of " << ct.get_name() << ":";
   agg_iterate(ct.get_super_classes(),sos_Super_class sc)
      cout << sc.get_super_class() << " ";
   agg_iterate_end(ct.get_super_classes(),sc)
   cout << "\n";
}

LOCAL void modify_super_class_param()
{  check_on_schema();
   check_on_class();

   display_super_classes(current_class);
   cout << "Name of the superclass to modify its parameter:";
   sos_Class_type ct = read_sos_Class_type("");
   if (INVALID (ct))
      return;
   if (INVALID (ct.get_create_params()))
   {  cout << ct.get_name() << " has no create parameter(s).\n";
      return;
   }
   int card = ct.get_create_params().card();
   int no;
   cout << "Number of the parameter to modify [1-" << card << "] :";
   cin  >> no;
   sos_Expr e = read_sos_Expr();
   MODIFY( mta_modify_super_class_param (current_class, ct, e, no) );
}

LOCAL void insert_friend_in_class()
{  check_on_schema();
   check_on_class();

   display_types_in_schema(sos_Type::make(NO_OBJECT));
   cout << "Name of the class becoming friend of "
	<< current_class.get_name() << ":";
   sos_Class_type ct = read_sos_Class_type("");
   MODIFY( mta_insert_friend (current_class, ct) );
}

LOCAL void remove_friend_from_class()
{  check_on_schema();
   check_on_class();

   cout << "Friends defined for " << current_class.get_name() << ":";
   agg_iterate (current_class.get_friends(),sos_Type tn)
      cout << tn.get_name() << " ";
   agg_iterate_end(current_class.get_friends(), tn);

   cout << "\nName of the friend to remove:";
   sos_Class_type ct = read_sos_Class_type("");
   MODIFY( mta_remove_friend (current_class, ct) );
}

LOCAL void create_generic_from_class()
{  check_on_schema();
   check_on_class();
} // create_generic_from_class

LOCAL void modify_create_param()
{  check_on_schema();
   check_on_class();

   int no;
   cout << "Number of the create parameter to modify:";
   cin  >> no;
   sos_Type_descr st = read_sos_Type_descr("Type of the parameter:");
   cout << "New name of the parameter:";
   sos_String name = read_sos_String();
   cout << "New expression";
   sos_Expr e = read_sos_Expr();
   MODIFY( mta_modify_create_param (current_class, no, st, name,e);
   	   mta_destroy(e) );
   name.destroy();
}

LOCAL void insert_create_param()
{  check_on_schema();
   check_on_class();

   int no;
   cout << "Position where the new parameter is to be inserted:";
   cin  >> no;
   cout << "Name:";
   sos_String name = read_sos_String ();
   sos_Type_descr td = read_sos_Type_descr ("New type:");
   MODIFY( mta_insert_create_param (current_class, name, td, no) );
}

LOCAL void remove_create_param()
{  check_on_schema();
   check_on_class();

   int no;
   cout << "Number of the create parameter to remove:";
   cin  >> no;
   MODIFY( mta_remove_create_param (current_class, no) );
}

LOCAL void display_class()
{  check_on_schema();
   check_on_class();

   sos_String_List l ; // = mta_get_declaration(current_class);
   cout << l;
   l.destroy();
   check_inherited_methods(current_class);
   check_components (current_class);
}

LOCAL void display_inherited_methods()
{  check_on_schema();
   check_on_class();

   cout << "inherited_methods of " << current_class.get_name() << ":\n";
   sos_Method_table inhm = current_class.get_methods();
   cout << inhm << "\n";

   cout << "predefined_methods:\n";
   sos_Method_List local_methods = current_class.get_local_methods();
   agg_iterate(local_methods, sos_Method m)
      cout << m << "\n";
   agg_iterate_end(local_methods, m);

   check_inherited_methods (current_class);
   check_components (current_class);
}

LOCAL void modify_enum()
{  check_on_schema();
   check_on_enum();
   
   sos_String name = sos_String::create(TEMP_CONTAINER);
   cout << "New name of the enumeration:";
   cin  >> name;
   MODIFY( mta_modify (current_enum, name) );
   name.destroy();
}

LOCAL void insert_literal_in_enum()
{  check_on_schema();
   check_on_enum();

   sos_String name = sos_String::create(TEMP_CONTAINER);
   cout << "Name of the literal to insert:";
   cin  >> name;
   MODIFY( mta_insert_literal (current_enum, name) );
   name.destroy();
}

LOCAL void delete_literal_from_enum()
{  check_on_schema();
   check_on_enum();

   sos_String name = sos_String::create(TEMP_CONTAINER);
   cout << "Name of the literal to remove:";
   cin  >> name;
   MODIFY( mta_remove_literal (current_enum, name) );
   name.destroy();
}

LOCAL void create_enum()
{  check_on_schema();
   MODIFY( current_enum = mta_create_enum (current_schema) );
}

LOCAL void delete_enum()
{  check_on_schema();
   check_on_enum();

   MODIFY( mta_remove (current_enum) );
   current_enum = sos_Enum_type::make (NO_OBJECT);
}

LOCAL void create_typedef()
{  check_on_schema();

   MODIFY( current_typedef = mta_create_typedef(current_schema) );
}

LOCAL void delete_typedef()
{  check_on_schema();
   check_on_typedef();

   MODIFY( mta_remove (current_typedef) );
   current_typedef = sos_Typedef_type::make (NO_OBJECT);
}

LOCAL void modify_typedef()
{  check_on_schema();
   check_on_typedef();
   display_types_in_schema(sos_Type::make(NO_OBJECT));

   sos_String name = sos_String::create(TEMP_CONTAINER);
   cout << "Name of the new type:";
   cin  >> name;
   sos_Type_descr t = current_schema.lookup_type(name);
   if (t.identical(NO_OBJECT))
      cout << "Unknown type.\n";
   else
   {  sos_Type_descr td = sos_Type_descr::make (t);  
      cout << "New name of the typedef declaration:";
      cin  >> name;
      MODIFY( mta_modify (current_typedef, name, td) );
   }
   name.destroy();
}

LOCAL void create_union()
{  check_on_schema();

   MODIFY( current_union = mta_create_union (current_schema) );
}

LOCAL void delete_union()
{  check_on_schema();
   check_on_union();

   MODIFY( mta_remove (current_union) );
   current_union = sos_Union_type::make (NO_OBJECT);
}

LOCAL void insert_type_into_union()
{  check_on_schema();
   check_on_union();

   sos_Type_descr st = read_sos_Type_descr("Name of the type to add:");
   MODIFY( mta_insert (current_union, st) );
}

LOCAL void remove_type_from_union()
{  check_on_schema();
   check_on_union();

   sos_Type_descr st = read_sos_Type_descr("Name of the type to remove:");
   if (VALID(st))
      MODIFY( mta_remove (current_union, st) );
}

LOCAL void create_extern()
{  check_on_schema();

   MODIFY(
   current_extern = sos_Extern_type::make(
		       current_schema.create_type (sos_Extern_type_type));
   )
}

LOCAL void delete_extern ()
{  check_on_extern();

   MODIFY(
   current_extern.remove ();
   current_extern = sos_Extern_type::make (NO_OBJECT);
   )
}

LOCAL void modify_extern ()
{  check_on_extern();

   sos_String name = sos_String::create(TEMP_CONTAINER);
   cout << "New name of " << current_extern.get_name() << ":";
   cin  >> name;
   int size;
   cout << "New size : ";
   cin  >> size;

   MODIFY(
   current_extern.modify_name (name);
   current_extern.modify_size (size);
   )

   name.destroy();
}

LOCAL void find_all_types_by_name()
{  
   sos_String name = sos_String::create (TEMP_CONTAINER);
   cout << "Name of the type to search globally:";
   cin  >> name;
   if (INVALID(name))
      return;

   sos_Schema_module_Directory sd = sos_Schema_module::schema_dir();
   sos_Type_descr_List	       l  = sos_Type_descr_List::create(TEMP_CONTAINER);
   agg_iterate_association (sd, sos_String n, sos_Schema_module sm)
      l.append (sm.get_type_table()[name]);
   agg_iterate_association_end (sd, n, sm);

   cout << l.card() << " types found:\n" << l;
   l.destroy();
   name.destroy();
}

LOCAL void find_all_types_by_usage()
{  
   sos_Type_descr st
    = read_sos_Type_descr("Name of the type that is used in the found types:");

   sos_Schema_module_Directory sd = sos_Schema_module::schema_dir();
   sos_Type_descr_List	       l  = sos_Type_descr_List::create(TEMP_CONTAINER);
   agg_iterate_association (sd, sos_String n, sos_Schema_module sm)
      /* l += sm.lookup_types(st) */;
   agg_iterate_association_end (sd, n, sm)

   cout << l.card() << " methods found:\n" << l << "\n";
   l.destroy();
}

LOCAL void find_all_methods_by_name()
{  sos_String name = sos_String::create (TEMP_CONTAINER);
   cout << "Name of the methods to search:";
   cin  >> name;
   sos_Method_List	       l   = sos_Method_List::create (TEMP_CONTAINER);
   sos_Schema_module_Directory smd = sos_Schema_module::schema_dir();
   agg_iterate_association (smd, sos_String n, sos_Schema_module sm)
      ; // l += sm.lookup_methods(name); 
   agg_iterate_association_end (smd, n, sm)
   cout << "\n" << l << "\n";
   l.destroy();
}

EXPORT int mtool_main(int, char**)
{
   mta_open_status (WRITING);

   current_schema  = sos_Schema_module::make (NO_OBJECT);
   current_class   = sos_Class_type::make    (NO_OBJECT);
   current_union   = sos_Union_type::make    (NO_OBJECT);
   current_method  = sos_Method::make        (NO_OBJECT);
   current_extern  = sos_Extern_type::make   (NO_OBJECT);
   current_typedef = sos_Typedef_type::make  (NO_OBJECT);
   current_enum    = sos_Enum_type::make     (NO_OBJECT);
   current_comp    = sos_Comp_descr::make    (NO_OBJECT);

   cout << "\n";
   int choice;
   do
   {
     cout << "Database         : 4-commit 5-reset 99-end of program\n";
     cout << "Global Retrieval :01-types_name 02-types_usage 03-methods_name\n";

     if (VALID(current_schema))
        cout << "Current schema   : " << current_schema <<  "\n";
     else 
        cout << "No current schema.\n"; 
     cout << "   10-Select 11-create";

     if (VALID(current_schema))
     {	cout << " 12-rm 13-modify name 14-insert Import\n"
             << "   15-remove Import 16-modify with extern 17-generate";
	cout << "\nFIND   : 20-types/name 21-types/usage 22-methods/name ";

	cout << "\nclass  :";
        if (VALID(current_class))
	   cout << " class " 
	        // << mta_get_declaration (sos_Type_descr::make (current_class))
		<< "\n        ";
        cout << " 30-Select 31-ins";
        if (VALID(current_class))
        {  cout << " 32-rm 33-name 34-sc-ins 35-sc-rm 36-sc-par 37-fr-ins\n"
		<< "         38-fr-rm 39-gen 40-cr-par 41-cr-ins 42-cr-del 43-look 44-inh-meth";
     
	   cout << "\nmethod :";
           if (VALID(current_method))
	      cout << " " // << mta_get_declaration (current_method, TRUE)
		   << "\n"
		   << "        ";
           cout << " 50-Select 51-ins";
           if (VALID(current_method))
              cout << " 52-rm 53-modify 54-P-ins 55-P-del 56-P-typ";
     
           cout << "\ncomp   :";
           if (VALID(current_comp))
	      cout << " " // << mta_get_declaration (current_comp,TRUE)
		   << "\n        ";
           cout << " 60-Select 61-ins";
           if (VALID(current_comp))
              cout << " 62-rm 63-modify";
	}
        cout << "\nenum   :"; 
        if (VALID(current_enum))
	   cout << " "; // << mta_get_declaration (current_enum);
        cout << " 70-Select 71-ins";
        if (VALID(current_enum))
           cout << " 72-rm 73-modify 74-ins-lit 75-rem-lit";
   
        cout << "\ntypedef:";
        if (VALID(current_typedef))
	   cout << " "; // << mta_get_declaration (current_typedef);
        cout << " 80-Select 81-ins";
        if (VALID(current_typedef))
	   cout << " 82-rm 83-modify";

        cout << "\nunion  :";
        if (VALID(current_union))
	   cout << " " ; // << mta_get_declaration (current_union);
        cout << " 85-Select 86-ins";
        if (VALID(current_union))
	   cout << " 87-rm 88-ins-type 89-rm-type";
   
        cout << "\nextern :";
        if (VALID(current_extern))
	   cout << " " << mta_get_declaration (current_extern);
        cout << " 90-Select 91-ins";
        if (VALID(current_extern))
	   cout << " 92-rm 93-modify";
     }

     cout << "\nselection:";
     cin  >> choice;

     err_block
        switch (choice)
        {  case 01: find_all_types_by_name();		break;
	   case 02: find_all_types_by_usage();		break;
	   case 03: find_all_methods_by_name();		break;

	   case 04: schema_commit();			break;
	   case 05: schema_reset();			break;

	   case 10: select_schema();			break;
	   case 11: create_schema();			break;
	   case 12: delete_schema();			break;
	   case 13: modify_schema_name();		break;
	   case 14: insert_schema_import();		break;
	   case 15: remove_schema_import();		break;
	   case 16: schema_with_extern();		break;
	   case 17: start_generator();			break;

	   case 20: find_types_by_name();		break;
	   case 21: find_types_by_usage();		break;
	   case 22: find_methods_by_name();		break;

	   case 30: select_type(sos_Class_type_type);	break;
	   case 31: create_class();			break;
	   case 32: delete_class();			break;
	   case 33: modify_class_name();		break;
	   case 34: insert_super_class();		break;
	   case 35: remove_super_class();		break;
	   case 36: modify_super_class_param();		break;
	   case 37: insert_friend_in_class();		break;
	   case 38: remove_friend_from_class();		break;
	   case 39: create_generic_from_class();	break;
	   case 40: modify_create_param();		break;
	   case 41: insert_create_param();		break;
	   case 42: remove_create_param();		break;
	   case 43: display_class();			break;
	   case 44: display_inherited_methods();	break;

	   case 50: select_method();			break;
	   case 51: create_method();			break;
	   case 52: delete_method();			break;
	   case 53: modify_method();			break;
	   case 54: insert_method_param();		break;
	   case 55: delete_method_param();		break;
	   case 56: modify_method_param();		break;
	   
	   case 60: select_component();			break;
	   case 61: create_component();			break;
	   case 62: delete_component();			break;
	   case 63: modify_component();			break;
	   
	   case 70: select_type(sos_Enum_type_type);	break;
	   case 71: create_enum();			break;
	   case 72: delete_enum();			break;
	   case 73: modify_enum();			break;
	   case 74: insert_literal_in_enum();		break;
	   case 75: delete_literal_from_enum();		break;

	   case 80: select_type (sos_Typedef_type_type);break;
	   case 81: create_typedef();			break;
	   case 82: delete_typedef();			break;
	   case 83: modify_typedef();			break;

	   case 85: select_type (sos_Union_type_type);	break;
	   case 86: create_union();			break;
	   case 87: delete_union();			break;
	   case 88: insert_type_into_union();		break;
	   case 89: remove_type_from_union();		break;

	   case 90: select_type (sos_Extern_type_type); break;
	   case 91: create_extern();			break;
	   case 92: delete_extern();			break;
	   case 93: modify_extern();			break;

	   case 99: cout << "\nquit...\n";		break;
	} // switch
     err_exception
	cout << "Error:\n" << err_last_raised() << "\n";
     err_block_end
   }
   while (choice != 99);
   return 0;
} // ** mtool_main


EXPORT int main (int argc, char *argv[])
{  obst_init (argc, argv);

   return mtool_main (argc, argv);
}
