 /* --------------------------------------------------------------------------
  * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
  *
  * You can use and distribute this software under the terms of the licence
  * you should have received along with this program.
  * If not or if you want additional information, write to
  * Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
  * D-76131 Karlsruhe, Germany.
  *
  * The license covers the source file msh.l and those parts of msh.l that are
  * copied into a file generated from msh.l.
  * --------------------------------------------------------------------------
  */
%{
extern "C"
{
#ifndef FLEX_SCANNER 
#  ifdef HAVE_YYWRAP 
   int yywrap();
#  endif
#endif
   int yyreject();
   int yyless(int);
   int yyback(int*, int);
   int yyinput();
   void yyoutput (int);
   void yyunput (int);
   extern YYSTYPE yylval;
}

#include "obst_progstd.h"
#include "msh_err.h"

LOCAL int  yylook();
LOCAL void yyecho();

LOCAL int name_or_keyword ()
{  switch (yytext[0])
   {  case 'a':
      {  if (streql (yytext, "abstract")) return abstract_tok;
	 break;
      }
      case 'c':
      {  if      (streql (yytext, "class"))	 return class_tok;
         else if (streql (yytext, "commit"))	 return commit_tok;
         else if (streql (yytext, "comp"))	 return comp_tok;
         else if (streql (yytext, "create"))	 return create_tok;
         else if (streql (yytext, "create_par")) return create_par_tok;
	 break;
      }
      case 'd':
      {  if (streql (yytext, "definite")) return definite_tok;
	 break;
      }
      case 'e':
      {  if      (streql (yytext, "endversion")) return endversion_tok;
         else if (streql (yytext, "enum"))	 return enum_tok;
         else if (streql (yytext, "extern"))	 return extern_tok;
         else if (streql (yytext, "exit"))	 return exit_tok;
	 break;
      }
      case 'f':
      {  if (streql (yytext, "friend")) return friend_tok;
	 break;
      }
      case 'g':
      {  if (streql (yytext, "generate")) return generate_tok;
	 break;
      }
      case 'h':
      {  if (streql (yytext, "help")) return help_tok;
	 break;
      }
      case 'i':
      {  if      (streql (yytext, "import"))	    return import_tok;
         else if (streql (yytext, "init"))	    return init_tok;
         else if (streql (yytext, "insert"))	    return insert_tok;
         else if (streql (yytext, "instantiation")) return instantiation_tok;
	 break;
      }
      case 'l':
      {  if      (streql (yytext, "literal")) return literal_tok;
         else if (streql (yytext, "local"))   return local_tok;
	 break;
      }
      case 'm':
      {  if (streql (yytext, "method")) return method_tok;
	 break;
      }
      case 'n':
      {  if (streql (yytext, "name")) return nname_tok;
	 break;
      }
      case 'o':
      {  if (streql (yytext, "operator")) return operator_tok;
	 break;
      }
      case 'p':
      {  if      (streql (yytext, "param"))     return param_tok;
         else if (streql (yytext, "private"))   return private_tok;
         else if (streql (yytext, "protected")) return protected_tok;
         else if (streql (yytext, "prot_gen"))  return prot_gen_tok;
         else if (streql (yytext, "public"))    return public_tok;
         else if (streql (yytext, "print"))     return print_tok;
	 break;
      }
      case 'q':
      {  if (streql (yytext, "quit")) return quit_tok;
	 break;
      }
      case 'r':
      {  if      (streql (yytext, "recursive")) return recursive_tok;
         else if (streql (yytext, "ref"))	return ref_tok;
         else if (streql (yytext, "reset")) 	return reset_tok;
         else if (streql (yytext, "result")) 	return result_tok;
         else if (streql (yytext, "remove")) 	return remove_tok;
	 break;
      }
      case 's':
      {  if      (streql (yytext, "schema"))   return schema_tok;
         else if (streql (yytext, "scope"))    return scope_tok;
         else if (streql (yytext, "set"))      return set_tok;
         else if (streql (yytext, "size"))     return size_tok;
         else if (streql (yytext, "static"))   return static_tok;
         else if (streql (yytext, "subclass")) return subclass_tok;
         else if (streql (yytext, "super"))    return super_tok;
	 break;
      }
      case 't':
      {  if      (streql (yytext, "type"))    return type_tok;
         else if (streql (yytext, "typedef")) return typedef_tok;
	 break;
      }
      case 'u':
      {  if      (streql (yytext, "union"))  return union_tok;
         else if (streql (yytext, "update")) return update_tok;
	 break;
      }
      case 'w':
      {  if      (streql (yytext, "wait"))	  return wait_tok;
         else if (streql (yytext, "with"))	  return with_tok;
         else if (streql (yytext, "with_extern")) return with_extern_tok;
	 break;
      }
      default:
	 break;
   }
   return name_tok;
}

%}

letter	[a-zA-Z_]
digit	[0-9]
diglet	[a-zA-Z_0-9]

%START comment
%%

"/*"			{yyecho(); BEGIN comment;}
<comment>[^\n*]*\n	{yyecho();}
<comment>[^\n*]*"*/"	{yyecho(); BEGIN 0;}
<comment>[^\n*]*"*"	{yymore();}

"//"[^\n]*\n		{yyecho();}

"<"			{yyecho(); return l_abr_tok;}
">"			{yyecho(); return r_abr_tok;}
"&"			{yyecho(); return ampersand_tok;}
"&="			{yyecho(); return ampersand_assign_tok;}
"&&"			{yyecho(); return and_tok;}
"="			{yyecho(); return assign_tok;}
"|"			{yyecho(); return bar_tok;}
"|="			{yyecho(); return bar_assign_tok;}
"["			{yyecho(); return l_br_tok;}
"]"			{yyecho(); return r_br_tok;}
"{"			{yyecho(); return l_brc_tok;}
"}"			{yyecho(); return r_brc_tok;}
"^"			{yyecho(); return circumflex_tok;}
"^="			{yyecho(); return circumflex_assign_tok;}
":"			{yyecho(); return colon_tok;}
"."			{yyecho(); return period_tok;}
","			{yyecho(); return comma_tok;}
"=="			{yyecho(); return equal_tok;}
">="			{yyecho(); return greater_equal_tok;}
"<="			{yyecho(); return less_equal_tok;}
"-"			{yyecho(); return minus_tok;}
"-="			{yyecho(); return minus_assign_tok;}
"!="			{yyecho(); return not_equal_tok;}
"||"			{yyecho(); return or_tok;}
"("			{yyecho(); return l_par_tok;}
")"			{yyecho(); return r_par_tok;}
"%"			{yyecho(); return percent_tok;}
"%="			{yyecho(); return percent_assign_tok;}
"+"			{yyecho(); return plus_tok;}
"+="			{yyecho(); return plus_assign_tok;}
">>="			{yyecho(); return rshift_assign_tok;}
"<<="			{yyecho(); return lshift_assign_tok;}
"/"			{yyecho(); return slash_tok;}
"/="			{yyecho(); return slash_assign_tok;}
"*"			{yyecho(); return star_tok;}
"*="			{yyecho(); return star_assign_tok;}
";"			{yyecho(); return semicolon_tok;}
"!"			{yyecho(); return exclam_tok;}
{digit}+		{yyecho();
			 yylval.i = atoi (yytext);
			 return number_tok;}
{letter}({diglet})*	{yyecho();
			 int tok = name_or_keyword();
			 if (tok == name_tok)
			 {  yylval.s = new char[yyleng+1];
			    strcpy (yylval.s, yytext);
			 }
			 return tok;}
\"{letter}({diglet})*\" {yyecho();
			 yylval.s = new char[yyleng-1];
			 strncpy (yylval.s, yytext+1, yyleng-2);
			 yylval.s [yyleng-2] = '\0';
			 return name_tok;}
[ \t]			{yyecho();}
[\014\n]		{yyecho(); msh_prompt(); }
.			{yyecho(); msh_error (err_USE, err_MSH_LEXICAL_ERROR);}
