#ifndef _MTA_ERR_H
#define _MTA_ERR_H 1
/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the licence
 * you should have received along with this program.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe 1, Germany.
 * --------------------------------------------------------------------------
 */

#include "obst_err.h"
#include "knl_use.h"

extern const err_msg err_MTA_AMBIGUOUS_GEN_PARAMS;
extern const err_msg err_MTA_AMBIGUOUS_METHODS;
extern const err_msg err_MTA_AMBIGUOUS_TYPES;
extern const err_msg err_MTA_ASSIGN_WITHOUT_EQUAL;
extern const err_msg err_MTA_CIRCLED_DECL;
extern const err_msg err_MTA_CIRCLED_IMPORT;
extern const err_msg err_MTA_CLASS_EXPECTED;
extern const err_msg err_MTA_CREATE_PARAM_TYPE_MISMATCH;
extern const err_msg err_MTA_CREATE_PARAM_USED;
extern const err_msg err_MTA_CONTAINER_YET_OPEN;
extern const err_msg err_MTA_DEFINITE_REDEFINED;
extern const err_msg err_MTA_DONT_MODIFY_INSTANTIATION;
extern const err_msg err_MTA_EQUAL_WITHOUT_HASH;
extern const err_msg err_MTA_FEW_CREATE_PARAMS;
extern const err_msg err_MTA_GENERATOR_COULD_NOT_CALLED;
extern const err_msg err_MTA_GENERIC_CLASS_EXPECTED;
extern const err_msg err_MTA_GENERIC_PARAM_MISMATCH;
extern const err_msg err_MTA_IMPORT_NOT_FOUND;
extern const err_msg err_MTA_INTERNAL;
extern const err_msg err_MTA_INVALID_ACCESS_RESTR;
extern const err_msg err_MTA_INVALID_IMPORT;
extern const err_msg err_MTA_INVALID_LOCAL_METHOD;
extern const err_msg err_MTA_INVALID_METHOD;
extern const err_msg err_MTA_INVALID_NAME;
extern const err_msg err_MTA_INVALID_OVERLOADING;
extern const err_msg err_MTA_INVALID_METHOD_NAME;
extern const err_msg err_MTA_OVERLOADED_METHOD;
extern const err_msg err_MTA_OVERLOADED_NOT_FOUND;
extern const err_msg err_MTA_INVALID_POSITION;
extern const err_msg err_MTA_INVALID_REDEFINITION;
extern const err_msg err_MTA_INVALID_SUPERCLASS;
extern const err_msg err_MTA_INVALID_TYPE_NAME;
extern const err_msg err_MTA_L_AND_T_ASSIGN;
extern const err_msg err_MTA_L_AND_T_EQUAL;
extern const err_msg err_MTA_L_AND_T_HASH;
extern const err_msg err_MTA_L_AND_T_FINALIZE;
extern const err_msg err_MTA_L_AND_T_INIT;
extern const err_msg err_MTA_MANY_CREATE_PARAMS;
extern const err_msg err_MTA_METHOD_MUST_NOT_MODIFIED;
extern const err_msg err_MTA_METHOD_NOT_EXECUTABLE;
extern const err_msg err_MTA_MULTIPLE_TYPE_DECL;
extern const err_msg err_MTA_NAME_IN_USE;
extern const err_msg err_MTA_NO_RESERVED_SCHEMA_NAME;
extern const err_msg err_MTA_NOT_FOUND;
extern const err_msg err_MTA_RESERVED_SCHEMA_NAME;
extern const err_msg err_MTA_SCHEMA_IN_USE;
extern const err_msg err_MTA_SCHEMA_NOT_EMPTY;
extern const err_msg err_MTA_SIZE_TOO_BIG;
extern const err_msg err_MTA_SUPERCLASS_EXISTS;
extern const err_msg err_MTA_SYNTAX;
extern const err_msg err_MTA_TOO_MANY_LITERALS;
extern const err_msg err_MTA_TRANS_IMP_REMOVE;
extern const err_msg err_MTA_TYPE_IN_USE;
extern const err_msg err_MTA_UNDECL_CLASS;
extern const err_msg err_MTA_UNKNOWN_TYPE;
extern const err_msg err_MTA_UNOPENED_CONTAINER;

extern const err_msg MTA_ERR;

void mta_error (const err_class, err_msg );
void mta_error (const err_class, err_msg , const sos_Cstring );
void mta_error (const err_class, err_msg , const sos_String& );
void mta_error (const err_class, err_msg , const sos_String&,
					   const sos_String& );
void mta_repeat_last_error ();
void mta_internal_error(sos_Cstring);

#define assert_no_error_block(a)  { smg_String __w(a);\
				  err_block
#define assert_no_error_block_end err_exception\
				     __w += err_last_raised();\
				     mta_error (err_SYS, err_MTA_INTERNAL,\
						__w.make_Cstring(SMG_BORROW));\
				  err_block_end }

#endif /* _MTA_ERR_H */
