#ifndef _GRAPH_UT_H
#define _GRAPH_UT_H 1
/* --------------------------------------------------------------------------
 * Copyright 1992 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
// **************************************************************************
// OBST graphic tools - common utilities
// **************************************************************************

#ifdef __GNUG__
#pragma interface
#endif

#define OBST_IMP_STDCONST
#define OBST_IMP_CHARTYPE
#define OBST_IMP_FILE
#define OBST_IMP_MALLOC
#define OBST_IMP_SORT_SEARCH
#define OBST_IMP_PROCEXEC
#define OBST_IMP_XAW
#include "obst_stdinc.h" 

#undef TRUE
#undef FALSE

#include "obst_progstd.h"
#include "smg.h"
#include "gtools_err.h"
#include "knl_use.h"

// ---------------------------------------------------------------------------
// ************************  Classes  ****************************************
// ---------------------------------------------------------------------------

class WdgtPosition
{ public:
   static const int default_distance;

   int x, y;

   static WdgtPosition root ();
   static WdgtPosition at (Widget);
   static WdgtPosition next_to (Widget);
   static WdgtPosition center (Widget);
};

class KnownObject
{
  friend class KnownObjectList;
  friend class ObjectCmdMenu;

  public:
   sos_Object    obj;
  protected:
   int           key;
   Widget        wdgt;

   int           list_length;
   char          **descr_list;

   virtual void item_selected (int) = 0;
   static  void callback_handler (Widget, caddr_t, caddr_t);
           void display (sos_Bool, WdgtPosition);

  public:
   virtual ~KnownObject();
};

class KnownObjectList
{ protected:
   KnownObjectList *next;
   KnownObject     *kobj;
   void		   insert (KnownObjectList*, KnownObject*);

  public:
   KnownObjectList () {next = NULL; kobj = NULL;}

   void		   remove (KnownObject*);
   void            remove_all();
   Widget	   widget (sos_Object);
   KnownObject     *known_object (sos_Object);
   KnownObject     *known_object (int);
}; 

class ModalDialog
{ protected:
   Widget   main_wdgt;
   sos_Bool active;

   void activate(sos_Bool);
   void callback_handler();
};

class VarTextDialog : public ModalDialog
{
   char     **text;
   
   int      nr_pars;
   int      size;
   sos_Bool do_pressed;
   Widget   *par_wdgts, *label_wdgts;
   Widget   do_but, cancel_but, header;

  public:
   int	  get_parnr()      { return nr_pars; }
   char   *get_text(int i) { return text[i]; }
   Widget get_main() 	   { return main_wdgt;}

   VarTextDialog() { label_wdgts = par_wdgts = NULL; size = 0; }

   static VarTextDialog* alloc_dialog();

   void     prepare_start (char*);
   void     prepare_add (char*);
   sos_Bool activate (sos_Bool);
   void     finish();
   void     install ();
  private:
   void        add_par();
   static void free_dialog (VarTextDialog*);
   static void cancel_callback_handler (Widget, caddr_t, caddr_t);
   static void do_callback_handler (Widget, caddr_t, caddr_t);
};

class ConfirmDialog : public ModalDialog
{
   Widget         question_label;
   sos_Bool       answer;
public:
   sos_Bool get_answer() { return answer; }

   void     activate (char*);
   void     install();
private:
   static void cancel_callback_handler (Widget, caddr_t, caddr_t);
   static void do_callback_handler (Widget, caddr_t, caddr_t);
};

class InfoLine
{
#define InfoLine_INFO_LENGTH	78

   Widget wdgt;
   char   text [InfoLine_INFO_LENGTH + 1];

  public: 
   void install();

   void display (const char*);
   void display_OBST_error ();
};

class ObjectCmdMenu
{
   Widget      wdgt;
 protected:
   KnownObject *kobj;
  public:
   void     activate (KnownObject*, char*[]);
   void     install (char*[]);
   virtual void install () = 0;

  protected:
   virtual void do_it (int) = 0;

  private:
   static  void callback_handler (Widget, caddr_t, caddr_t);
};

class MenuSystem
{  friend class Application;

   static const int NO_MENU;

   int     active_menu;
   int     no_menus;
   Widget  *headers;
   Widget  *lists;

  public:
   MenuSystem() { active_menu = NO_MENU; }

   void install (int, char*[], char**[]);
   void change_list (int, char*[]);
  protected:
   virtual void do_it (int, int) = 0;

  private:
   static void header_callback_handler (Widget, caddr_t, caddr_t);
   static void list_callback_handler (Widget, caddr_t, caddr_t);
};

class Application
{ protected:
   sos_Object initial_root;
   sos_Object standard_root;

  public:
   XtAppContext      app_context;
   Widget 	     app_shell_wdgt,
    	  	     app_form_wdgt,
   	  	     form_wdgt,
   	  	     viewport_wdgt;
   Pixel  	     red_pxl,
   	  	     green_pxl,
   	  	     blue_pxl;

   static sos_Object make_object (sos_Container, sos_Offset);

   static void  enter_ptr (void*, void*);
   static void* lookup_ptr (void*);

   void access_ct (sos_Container);
   void commit ();
   void reset ();
   void commit_and_exit ();

   virtual void display_root (sos_Bool) = 0;
   virtual void init (int, char**) = 0;

   void install (int, char**, char*, int, char*[], char**[]);
   void run ();

   static void scroll_viewport (Widget);
   static void drag_callback_handler (Widget, caddr_t, XEvent*);
};


// ---------------------------------------------------------------------------
// ************************  Variables  **************************************
// ---------------------------------------------------------------------------

extern KnownObjectList  *the_known_objects;
extern VarTextDialog	*the_text_dialog;
extern VarTextDialog    *the_container_dialog;
extern ConfirmDialog    the_confirm_dialog;
extern InfoLine		the_info_line;
extern ObjectCmdMenu    *the_object_menu;
extern MenuSystem       *the_menu_system;
extern Application	*the_application;


// ---------------------------------------------------------------------------
// **********************  Get/SetValue Arguments  **************************
// ---------------------------------------------------------------------------

const  int ac_max = 30;
extern Arg al[ac_max];	// X argument array
extern int ac;		// Position to place next argument,
			// resp. size of used array part

inline void RESET_ARGLIST ()
{  ac = 0;
}

inline void ADD_ARG (String key, XtArgVal value)
{  XtSetArg (al[ac], key, value);
   if (ac >= ac_max)
   {  cerr << "argument overflow\n";
      exit (1);
   }
   ac++;
}

inline Arg *ARGLIST ()
{  return al;
}

inline int ARGNR ()
{  return ac;
}

inline void SETVALUES (Widget w)
{  XtSetValues (w, al, ac);
}

inline void GETVALUES (Widget w)
{  XtGetValues (w, al, ac);
}


// ---------------------------------------------------------------------------
// **********************  Utilities  ****************************************
// ---------------------------------------------------------------------------

#endif
