#ifndef _ERR_H
#define _ERR_H 1
/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

#define  OBST_IMP_SETJMP
#include "obst_stdinc.h"

enum err_class { err_SYS, err_USE, err_WNG };
typedef const char* err_msg;

extern const err_msg err_NOT_IMPLEMENTED;
extern const err_msg err_ABSTRACT_METHOD;
extern const err_msg err_ASSERTION_FAILED;

#define err_raise_not_implemented(m) \
		err_raise(err_SYS,err_NOT_IMPLEMENTED,m,FALSE);
#define err_raise_abstract_method(m) \
		err_raise(err_SYS,err_ABSTRACT_METHOD,m,FALSE);

#if ERR_NO_ASSERT
#  define err_assert(b,w)
#else
#  define err_assert(b,w) if(!(b))err_raise(err_SYS,err_ASSERTION_FAILED,w,0)
#endif

extern void (*err_output_handler) ();

extern void err_raise (err_class, err_msg, err_msg = 0, int = 1);

extern int  err_occurred (err_class);
extern void err_reset ();

extern err_class err_last_class ();
extern err_msg   err_last_raised ();
extern err_msg   err_last_origin ();

extern void err_push_env();
extern void err_pop_env();

extern sigjmp_buf* err_top_env;

#define err_block     if(err_push_env(),!sigsetjmp(*err_top_env,0)){
#define err_exception err_pop_env();}else{
#define err_block_end }

#endif
