/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */

#include "UnixFile_obst.h"

void UnixFile::append (UnixFile f)
{ self.set_size(self.get_size() + f.get_size()); }

void UnixFile::rename (sos_Cstring s)
{ self.get_name().assign_Cstring (s); }

void UnixFile::local_initialize (UnixFile f)
{  if (f.get_name() == NO_OBJECT)
   {  sos_String default_name = sos_String::create (f.container());
      default_name.assign_Cstring ("DEFAULT_FILE_NAME");
      f.set_name (default_name);
   }
}
void UnixFile::local_finalize (UnixFile f)
{  f.get_name().destroy(); }
