#
#  C source for GNU CHESS
#
#  Revision: 1990-12-26
#
#  Modified by Daryl Baker for use in MS WINDOWS environment
#
#  This file is part of CHESS.
#
#  CHESS is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY.  No author or distributor accepts responsibility to anyone for
#  the consequences of using it or for whether it serves any particular
#  purpose or works at all, unless he says so in writing.  Refer to the CHESS
#  General Public License for full details.
#
#  Everyone is granted permission to copy, modify and redistribute CHESS, but
#  only under the conditions described in the CHESS General Public License.
#  A copy of this license is supposed to have been given to you along with
#  CHESS so you can know your rights and responsibilities.  It should be in a
#  file named COPYING.  Among other things, the copyright notice and this
#  notice must be preserved on all copies.
#
#
PROJ = chess
PROJFILE = chess.mak

CFLAGS_G  = /AM /W4 /G2sw /Zp /BATCH /nologo
LINKER  = link
LRF  = echo > NUL
RC  = rc
IMPLIB  = implib
LFLAGS_G  =   /BATCH /nologo /align:16 /map
LFLAGS_R  =  /NOF /NOP
MAPFILE_R  = chess.map
CC  = cl
CFLAGS_D  = /Od /Zi /Gi$(PROJ).mdt
CFLAGS_R  = /Osge
LLIBS_R  =  /NOD:MLIBCE MLIBCEW
LLIBS_G  = LIBW.LIB
ASM  = masm
AFLAGS_G  = /Mx /T

DEF_FILE  = CHESS.DEF
OBJS  = CHESS.obj INIT.obj BOARD.obj ABOUT.obj PIECE.obj \
        HITTEST.obj COLOR.obj TIMECNT.obj SEARCH.obj INITIALI.obj \
        EVAL.obj GLOBALS.obj DSP.obj MSWDSP.obj BOOK.obj CREATE.obj \
        SAVEOPEN.obj NUMDLG.obj INITMENU.obj REVIEW.obj STATS.obj \
        TEST.obj PROMOTE.obj

RT_OBJS = VERSION.obj

RESS = chess.res

BMPS = king.bmp kingm.bmp kingo.bmp pawn.bmp pawno.bmp pawnm.bmp \
       rook.bmp rooko.bmp rookm.bmp knight.bmp knightm.bmp knighto.bmp \
       bishop.bmp bishopm.bmp bishopo.bmp queen.bmp queenm.bmp queeno.bmp

HELPFILES = chess.rtf article.rtf article2.rtf copying.rtf move-gen.rtf heuristi.rtf match.rtf
HELPSOURCE = chess.doc article.doc article2.doc copying.doc move-gen.doc heuristi.doc match.doc

all: $(PROJ).exe $(PROJ).hlp

.SILIENT:

.SUFFIXES: .rc .res .c .obj .doc .rtf

CHESS.RES : chess.rc $(BMPS) color.dlg chess.ico timecnt.dlg saveopen.dlg \
            getnum.dlg review.dlg about.dlg stats.dlg test.dlg promote.dlg

ABOUT.obj : ABOUT.C

BOARD.obj : BOARD.C defs.h

BOOK.obj : BOOK.C gnuchess.h defs.h chess.h

CHESS.obj : CHESS.C gnuchess.h defs.h chess.h saveopen.h  color.h 

COLOR.obj : COLOR.C chess.h color.h

CREATE.obj : CREATE.C defs.h chess.h

DSP.obj : DSP.C gnuchess.h defs.h chess.h

EVAL.obj : EVAL.C gnuchess.h defs.h

GLOBALS.obj : GLOBALS.C gnuchess.h

HITTEST.obj : HITTEST.C defs.h

INIT.obj : INIT.C

INITIALI.obj : INITIALI.C gnuchess.h defs.h

INITMENU.obj : INITMENU.C gnuchess.h chess.h

MSWDSP.obj : MSWDSP.C gnuchess.h chess.h defs.h stats.h

NUMDLG.obj : NUMDLG.C chess.h

PIECE.obj : PIECE.C chess.h defs.h

PROMOTE.obj : PROMOTE.C chess.h

REVIEW.obj : REVIEW.C gnuchess.h chess.h defs.h

SAVEOPEN.obj : SAVEOPEN.C saveopen.h

SEARCH.obj : SEARCH.C gnuchess.h defs.h

STATS.obj : STATS.C gnuchess.h stats.h

TEST.obj : TEST.C gnuchess.h chess.h defs.h

TIMECNT.obj : TIMECNT.C timecnt.h chess.h

#
# Code to generate new time stamp when any module updated
#
makever.exe: makever.c
        cl /nologo makever.c

VERSION.obj: VERSION.c

VERSION.c:  $(OBJS) $(RESS) $(BMPS) makever.exe
        makever >version.c

# Create the help file

chess.hlp: chess.hpj $(HELPFILES)
        -del chess.ph
        hc chess.hpj

chexe320.zip:
distexe: chess.exe readme.txt gnuchess.boo chess.hlp copying
        -del chexe320.zip
        pkzip -a chexe320 readme.txt chess.exe gnuchess.boo chess.hlp copying

distsrc: chess.exe chexe320.zip readme.txt chess.mak chess.hlp
        -del chess320.zip
        pkzip -a chess320 readme.txt $(PROJ).exe *.boo $(PROJ).hlp
        pkzip -a chess320 $(PROJ).def $(PROJ).rc *.dlg $(PROJ).mak $(PROJ).ico 
        pkzip -a chess320 copying winport change.log todo *.h *.c *.bmp 
        pkzip -a chess320 chess.hpj $(HELPFILES)
        pkzip -a chess320 $(HELPSOURCE)

clean:
        -del *.obj
        -del *.bak
        -del *.res
        -del *.err
        -del *.ph

$(PROJ).exe : $(DEF_FILE) $(OBJS) $(RT_OBJS) $(RESS)
        $(LRF) @<<$(PROJ).lrf
$(LFLAGS_G) $(LFLAGS_R) $(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_R)
$(LLIBS_G: = +^
) +
$(LLIBS_R: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) ; 
<<
        $(LINKER) @$(PROJ).lrf
        $(RC) $(RESS) $@

.c.obj :
        $(CC) /c $(CFLAGS_G) $(CFLAGS_R) /Fo$@ $<

.rc.res :
        $(RC) /r $<

#
# this rule is here to trap changes to the doc files.  Ideally it
# would call a program todo RTF conversion.
#
.doc.rtf :
        @echo $< is out of date. Resave as RTF.
        @zzz### dummy command line need abort command
