
;;; d-auto-mode-alist.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-auto-mode-alist.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: auto-mode-alist setter
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(setq auto-mode-alist
      (append '(
                ("\\.tesinfo$"   . tesinfo-mode)

                ("\\.lisp++$"    . c++-mode)
                ("\\.cmethod$"   . c++-mode)
                ("\\.jtw$"       . jtw-mode)
                ("\\.method$"    . jtw-mode)
                ("\\.function$"  . jtw-mode)
                ("\\.cs$"        . java-mode)

                ("\\.php$"       . html-mode)

                ("\\.hta$"       . c-mode)
                ("\\.ist"        . latex-mode)
                ("\\.latex$"     . latex-mode)
                ("\\.tex$"       . latex-mode)
                ("\\.tes$"       . tes-mode)
                ("\\.tes.m4$"    . tes-mode)
                ("\\.log$"       . text-mode)
                ("\\.tar$"       . tar-mode)
                ("\\.gz$"        . tar-mode)

                ("\\.dat$"       . text-mode)

                ("\\.pl$"        . prolog-mode)
                ("\\.clp$"       . emacs-lisp-mode)

                ("\\.places\\.sav$" . emacs-lisp-mode)

                ("\\.js$"        . c-mode)
                ("\\.css$"       . c-mode)

                ("\\.tex$"       . latex-mode)

                ("manifest\\.[0-9]+" . text-mode)

                ("\\.diary$"     . text-mode)

                ("\\.hts$"       . html-mode)
                ("\\.mk$"        . makefile-mode)
                ("\\.java$"      . java-mode)

                ("\\.emacs$"     . emacs-lisp-mode)
                ("\\.el$"        . emacs-lisp-mode)

                ("\\.cc$"        . c++-mode)
                ("\\.ch$"        . c++-mode)
                ("\\.hh$"        . c++-mode)

                ("\\.lzz$"       . c++-mode)
                ("\\.bb2?$"      . bbasic-mode)

                ("\\.slide$"     . latex-mode)
                ("\\.level$"     . emacs-lisp-mode)

                ("\\.rle$"       . hexl-mode)
                ("\\.a2d$"       . hexl-mode)

                ("\\.m4$"        . html-mode)
                ("\\.[Tt][Xx][Tt]$" . text-mode)
                ("\\.doc$"       . text-mode)
                ("_emacs$"       . emacs-lisp-mode)
                ("[Mm]akefile$"  . makefile-mode)

                ("^\\.emacs$"    . emacs-lisp-mode)
                ("\\.p2a2$"      . hexl-mode)
                ("\\.a$"         . hexl-mode)
                ("\\.pal$"       . hexl-mode)
                ("\\.dat$"       . hexl-mode)
                ("\\.reg$"       . hexl-mode)

                ("\\.h\\+\\+$"   . c++-mode)
                ("\\.c\\+\\+$"   . c++-mode)
                ("\\.ch\\+\\+$"  . c++-mode)
                ("\\.inc$"       . c++-mode)
                ("\\.inl$"       . c++-mode)
                ("\\.CC$"        . c++-mode)
                ("\\.cc$"        . c++-mode)
                ("\\.cpp$"       . c++-mode)
                ("\\.CPP$"       . c++-mode)
                ("\\.cxx$"       . c++-mode)
                ("\\.hpp$"       . c++-mode)
                ("\\.hxx$"       . c++-mode)
                ("\\.hh$"        . c++-mode)
                ("\\.c$"         . c++-mode)
                ("\\.dn$"        . c++-mode)
                ("\\.dl$"        . c++-mode)
                ("\\.d2$"        . c++-mode)
                ("\\.h$"         . c++-mode)
                ("\\.itcl$"      . tcl-mode)
                ("\\.jav$"       . java-mode)
                ("\\.java$"      . java-mode)
                ("\\.opt$"       . asm-mode)
                ("\\.o$"         . hexl-mode)
                ("\\.exe$"       . hexl-mode)
                ("\\.out$"       . hexl-mode)
                ("\\.bat$"       . fundamental-mode)
                ("\\.POV$"       . pov-mode)
                ("\\.pov$"       . pov-mode)
                ("\\.hts$"       . html-mode)
                ("\\.hmx$"       . html-mode)
                ("\\.tex$"       . latex-mode)
                ("\\.cm"         . compilation-mode)
                ("\\.comp"       . compilation-mode)
                ("manifest\\.[0-9]+" . text-mode)
                ) auto-mode-alist))

;;(defun d-fundamental-mode-hook ()
;; (set (make-variable-buffer-local 'font-lock-string-face) nil))
;;(add-hook 'fundamental-mode-hook 'd-fundamental-mode-hook)

(defadvice fundamental-mode (after d-remove-strings activate)
  (if (eq major-mode 'fundamental-mode)
      (set (make-local-variable 'font-lock-string-face) nil)))

(provide 'd-auto-mode-alist)
;;; d-auto-mode-alist.el ends here
