
;;; d-start.el --- A boot up function for GNU Emacs

;; Copyright (C) 2006-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-start.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Version: 1.1
;; Keywords: Emacs Lisp Bootup System

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; m4_install_instructions(d-start)

;;; Known Bugs:

;; None so far!

;;; Version History

;; Version 1.0 First version

;;; Code:

(defun checkpoint (&rest x) (message "*** checkpoint %s" (apply 'format x)))

(setq prefs-scratch-libd-online-p t)
(setq prefs-scratch-java-online-p t)

(progn
  (require 'cl)
  (if (file-exists-p "~www/dlisp/emergency-bindings.el")
      (load-file "~www/dlisp/emergency-bindings.el"))
  (if (file-exists-p "c:/home/dlisp/emergency-bindings.el")
      (load-file "c:/home/dlisp/emergency-bindings.el"))
  (d-emergency-set-load-path)
  (load-file (concat (car load-path) "/diagnose.el")))

(defalias 'elm 'emacs-lisp-mode)

(defmacro d-quote (&rest ignored))

(progn
  ;;
  ;; NOTE: debugs second run through
  ;;
  (if (boundp 'done-d-start)
      (progn
        (d-beeps "%s-st run through d-start.el" done-d-start)
        (incf done-d-start))
    (setq done-d-start 1))
  done-d-start)

;;(if (not os-type--windows-p)
(set-frame-font "Monospace 15" t)

(defun d-start ()
  (interactive)

  (setq debug-on-error t)

  (progn

    (if os-type--msdos-p
        (safe-require 'd-dos-fonts)
      (safe-require 'd-make-faces))

    (require 'd-fonts)

    (progn
      (safe-require 'd-auto-mode-alist)
      (safe-require 'd-flock) ;; TODO: put back
      (safe-require 'd-prefs)
      (safe-require 'd-keys) ;;; before d-time.el
      (safe-require 'd-exit)
      (safe-require 'd-key-find)
      (safe-require 'd-hippie)
      (safe-require 'd-electric) ;;; before d-groups.el
      (safe-require 'd-groups)
      (safe-require 'd-key-nav)
      (safe-require 'd-key-toggle)
      (safe-require 'd-time)
      (safe-require 'd-lisp)
      (safe-require 'd-prolog)
      (safe-require 'c2j)
      (safe-require 'd-speedbar)
      )
    ))

(d-start)

;;
;; NOTE: after d-prolog.el
;;

(if (and os-type--microsoft-p prefs-home-emacs-p)
    (safe-require 'bak)
  (safe-require 'datify))

(when prefs-home-emacs-p
  (safe-require 'd-number-sayer)
  (safe-require 'd-appt)
  )

(progn
  (safe-require 'd-copy)
  (safe-require 'd-publish)
  (safe-require 'd-wiki)
  (safe-require 'd-bat)
  (safe-require 'd-iss)
  (safe-require 'd-cc)
  (safe-require 'd-css)
  (safe-require 'jtw-mode)
  ;;(safe-require 'jtw2m4)
  (safe-require 'star-debugger)
  (safe-require 'toggle-checkpoints)
  (safe-require 'd-latex)
  (safe-require 'tes-mode)
  (safe-require 'd-dired)
  (safe-require 'd-dired-x)
  (safe-require 'd-dired-updown)
  (safe-require 'd-indent)
  )

(progn
  ;;
  ;; NOTE: web stuff
  ;;
  (safe-require 'd-html)
  (safe-require 'd-testlinks)
  (safe-require 'weblint))

(when t
  ;;
  ;; NOTE: trashcan stuff
  ;;
  (setq trashcan-dirname "TRASHCAN")
  (setq trashcan-patch-delete-stuff-p nil)
  (safe-require 'trashcan))

(if os-type--mswindows-p
    t
    ;;(setq delete-by-moving-to-trash t)
    ;;(setq trash-directory "c:/TRASHCAN"))
  )

(safe-require 'd-find)

(progn
  (safe-require 'directory-files-deep)
  (safe-require 'd-find)
  (safe-require 'd-comp)
  (safe-require 'd-outline)
  (safe-require 'd-bbasic)
  (safe-require 'd-math)
  (safe-require 'd-truncate-hook)
  (safe-require 'manifest)
  (safe-require 'd-hex)
  (safe-require 'd-sql)
  )

;; (elm)
;; (require 'rsi-brk)
(progn
  ;;(setq rsi-period (* 60 20))
  (setq rsi-log-time-worked nil)
  (safe-require 'rsi-brk)
  )
;;(safe-require 'pause-break)

(when (not os-type--msdos-p)
  ;;(safe-require 'd-groups) PUT BACK!
  )

;;(if os-type--microsoft-p (safe-require 'checksum))
;;(elm)
;;(safe-require 'd-readonly) PUT BACK!

(progn (and prefs-home-emacs-p os-type--microsoft-p (not os-type--msdos-p))
  ;;(setq cbrow--footer-regexp (regexp-quote ".ch"))
  (setq cbrow--footer ".ch")
  ;;(message "*** About to provide feature cbrow")
  (safe-require 'cbrow)
  )

(safe-require 'logger)

(progn
  (setq cfm--is-on nil)
  (safe-require 'cfm))

(progn
  (safe-require 'lisp++)
  (safe-require 'd-flush-checkpoints)
  (safe-require 'd-add-hours)
  (safe-require 'd-eshell)
  )

(when (and os-type--graphical-p emacs-dialect--gnuemacs-p)
  (safe-require 'd-unspacify)
  (safe-require 'd-capitalize)
  (safe-require 'archive-compare)
  (safe-require 'd-modeline)
  ;;(safe-require 'blanker)
  (safe-require 'd-abbrev)
  (safe-require 'd-dabbrev)
  ;;(safe-require 'd-meta-period)
  )

;;(safe-require 'rcgcs)
;; (elm)
(progn
  ;;(safe-require 'rcgcs-cycler)
  ;;(safe-require 'rcgcs-inheritance)
  ;;(safe-require 'rcgcs-nostuff)
  ;;
  ;; NOTE: cool this includes auto-g-c*.el
  (d-emergency-set-load-path)
  (safe-require 'autogc)
  )

(progn
  (safe-require 'd-etags)
  (safe-require 'flacs-compare)
  )

(progn (if os-type--linux-p
           (safe-require 'd-flyspell)))

(when (and os-type--microsoft-p prefs-home-emacs-p)
  (setq-default ispell-program-name "c:/cygwin/bin/aspell.exe")
  (setq ispell-dictionary "british"))

(if (and os-type--graphical-p (file-exists-p (concat (car load-path) "/imported-stuff/haskell-mode-1.44/dotemacs.el")))
    (safe-load-file (concat (car load-path) "/imported-stuff/haskell-mode-1.44/dotemacs.el"))
  )

;;(safe-load-file (concat (car load-path) "/imported-stuff/mmm-mode-0.5.1/dotemacs.el"))
;;(safe-load-file (concat (car load-path) "/imported-stuff/dotemacs.el"))

;;(if os-type--linux-p (safe-require 'varsity))

(d-emergency-set-load-path)

(progn
  (safe-require 'd-setdir)
  (safe-require 'd-php-mode)
  )

;;(elm)
(when (and prefs-windows-bindings-p (not noninteractive))
  ;;
  ;; NOTE: dlgopen stuff
  ;;
  (progn
    (setq dlgopen-executable-path (concat (car load-path) "/imported-stuff/dlgopen/getfile.exe"))
    (load-file                    (concat (car load-path) "/imported-stuff/dlgopen/dlgopen.el"))
    (global-set-key [f6]          'dlgopen-open-files)
    (global-set-key [(control o)] 'dlgopen-open-files))
  ;;
  ;; NOTE: CUA stuff
  ;;
  ;;(load-file "~/dlisp/imported-stuff/cua.el")
  (cua-mode)

  (define-key global-map [(control a)] 'd-mark-whole-buffer)

  (defun d-mark-whole-buffer ()
    (interactive)
    (mark-whole-buffer)
    (transient-mark-mode 1))

  )

(when prefs-windows-bindings-p

  (define-key global-map [delete] 'd-delete)

  (defun d-delete ()
    (interactive)
    (if (region-active-p)
        (call-interactively 'delete-region)
      (delete-char 1)))

  (global-set-key [prior] 'd-shift-up)
  (global-set-key [next]  'd-shift-down)
  )

(progn
  (safe-require 'saveplace)
  (setq-default save-place t)
  (setq save-place-file "~/.places.sav")
  (setq save-place-limit  1000)
  (setq buffers-menu-max-size nil)
  (setq recentf-max-menu-items 50)
  (recentf-mode 1)
  )

 ;; LOAD AT START

(progn
  (if (not emacs-dialect--xemacs-p)
      (save-excursion
        (set-buffer "*Messages*")
        (setq default-directory "~/")))

  (when (or os-type--linux-p os-type--microsoft-p)
    (safe-find-file (file-truename "~/")))

  (when (and prefs-calendar-online-p (file-exists-p diary-file))
    (calendar)
    (mark-diary-entries)
    (other-window 1))

  )

(safe-require 'd-scratch)

(global-set-key "\M-."
                (function
                 (lambda () (interactive)
                   (global-set-key "\M-," (function (lambda () (interactive) (execute-kbd-macro "\C-u\M-."))))
                   ;;(global-set-key "\M-/" (function (lambda () (interactive) (execute-kbd-macro "\C-u\M-."))))
                   (call-interactively 'find-tag)
                   )))

(global-set-key "\M-\C-x" 'eval-defun)

(setq inhibit-startup-screen t)
(setq inhibit-splash-screen t)

(progn
  ;;
  ;; NOTE: These should be set (see diagnose.el)
  ;;
  (if (not (fboundp 'assert))
    (error "*** Error assert not bound"))
  (assert (boundp 'prefs-advanced-user-p))
  (assert (boundp 'prefs-home-emacs-p))
  (assert (boundp 'prefs-lcd-emacs-p))
  (assert (boundp 'os-type--linux-p))
  (assert (getenv "HOME"))
  )

;;(assert nil)

(progn
  (safe-require 'd-howto)
  (safe-require 'd-meal-timer)
  (safe-require 'd-make-tags)
  )

(progn
  (set-buffer "*scratch*")
  (elm))

(global-set-key [(control meta backspace)] 'backward-kill-sexp)

;;(safe-window-restore)
;;(safe-window-maximise)

(defun d-insert (form)
  (insert (prin1-to-string form)))

(defun insert-prin1-to-string (p)
  (insert (prin1-to-string p)))

(defun insert-prin1 (p)
  (insert (prin1-to-string p)))

(if prefs-windows-bindings-p
    (global-set-key (kbd "C-z") 'undo)
  (global-set-key "\C-z" 'd-control-z)
)

(defun d-control-z ()
  (interactive)
  (progn
    ;;(select-frame (car (frame-list)))
    (if (boundp 'iconify-or-deiconify-frame)
        (iconify-or-deiconify-frame))
    ;;(select-frame (cadr (frame-list)))
    ;;(iconify-or-deiconify-frame)
    ))

(defun d-frame-set-inner ()
  (progn
    (require 'assoc)
    (speedbar -1)
    ;;(sit-for 1)
    (if (and (cadr (frame-list)) (string-match "Speedbar" (prin1-to-string (car (frame-list)))))
        (progn
          (set-frame-position (cadr (frame-list)) 0 0)
          (set-frame-width (cadr (frame-list))  98)
          (set-frame-height (cadr (frame-list)) 43))
      (progn
        (set-frame-position (car (frame-list)) 0 0)
        (set-frame-width (car (frame-list))  98)
        (set-frame-height (car (frame-list)) 43))
      )
    ;;(sit-for 1)
    (speedbar 1))
  )

(defun d-frame-set ()
  (interactive)
  ;;(d-frame-set-inner)
  ;;(d-frame-set-inner)
  ;;(safe-window-maximise)
  )

(when (not noninteractive)
  (global-set-key [pause] 'save-buffers-kill-emacs)
  ;;(d-frame-set)
  )

(require 'manaaki)
(require 'manaaki-file-copier)

;;(require 'tagbody)
;;(require 'coroutine)
(require 'wagner-download)

(safe-require 'd-before-save-hook)
(safe-require 'd-shift-tab)
(safe-require 'compare-files)

(assert (fboundp 'd-quote))

(if os-type--linux-p
    (progn
      (safe-require 'd-recent)
      (d-recent--load-log-file)
      (global-set-key [kp-enter] 'd-recent-switch-to-buffer)
      ))

(setq-default cursor-type 'box)
;;(setq shell-file-name "c:/cygwin/bin/bash.exe")
;;(setq shell-file-name "c:/Program Files/emacs-23.1/bin/cmdproxy.exe")

;;(global-set-key "\"" 'self-insert-command)
;;(global-set-key [kp-enter] 'd-indent)

(defun <> (arg1 arg2)
  (/= arg1 arg2))
;;(<> 1 2) (<> 1 1)

;;(if prefs-home-emacs-p (require 'broken-keyboard))

(defun factorial (n)
  (if (= 0 n)
      1
    (* n (factorial (1- n)))))          ;

(defun << (int i, int j)
  (lsl i j))

;;; (d-make-colour 240 240 240)
(defun d-make-colour (r g b)
  (assert (integerp r))
  (assert (integerp g))
  (assert (integerp b))
  (assert (and (>= r 0) (<= r 255)))
  (assert (and (>= g 0) (<= g 255)))
  (assert (and (>= b 0) (<= b 255)))
  (format "#%02x%02x%02x" r g b))

;;; (! (= 0 (- 2 2)))
;;; (!= 0 (- 2 2))
;;; (eval '(- 2 2))
;;; (!= 1 2)
;;(defmacro != (o1 o2) (eq ,(eval o1) ,(eval o2)))
(defmacro != (o1 o2) `(/= ,o1 ,o2))

;;; (! (= 1 1))
(defmacro ! (o)
  `(not ,(eval o)))

(message "")

;;(safe-window-restore)
;;(safe-window-maximise)

(if os-type--linux-p
    t;;(set-default-font "-*-Courier New-normal-r-*-*-16-*-*-*-c-*-iso8859-1")
  (set-default-font "-*-courier new-normal-r-*-*-22-*-*-*-c-*-fontset-standard"))

(d-emergency-set-load-path)

(progn
  (global-set-key [S-down-mouse-1] 'ignore)
  (global-set-key [C-down-mouse-2] 'ignore)

  (global-set-key [(control left)]  'd-backward-sexp)
  (global-set-key [(meta left)]     'd-backward-sexp)
  (global-set-key [(shift left)]    'd-backward-sexp)

  (global-set-key [(control right)] 'd-forward-sexp)
  (global-set-key [(meta right)]    'd-forward-sexp)
  (global-set-key [(shift right)]   'd-forward-sexp)

  (global-set-key [f4] 'd-f4)

  )

(provide 'd-start)
;;; file: d-start.el ends here

