
(global-set-key "\C-f" 'd-find-file)
(global-set-key "\C-d" 'd-find-file)
(global-set-key "\C-xf" 'd-find-file)
(global-set-key "\C-xd" 'dired)
(global-set-key "\C-x\C-f" 'd-find-file)
(global-set-key "\C-x\C-d" 'dired)

(defun d-find--keybindings ()
  (define-key dired-mode-map "\C-m" 'd-dired-advertised-find-file)
)
(add-hook 'dired-mode-hook 'd-find--keybindings)

;; (setq filename "~/davins-stuff.lnk")
(defun d-find-file (filename)
  "Edit file FILENAME.  Wildcards are accepted."
  (interactive "FFind File/Folder: ")
  ;;(debug "Duck")
  (assert filename)
  ;;(d-beeps "filename=%s" filename)

  (if (fboundp 'd-recent-find-file-hook)
      (d-recent-find-file-hook filename))

  (if (file-directory-p filename)
      (dired filename)
    (if (string-match "\\.lnk$" filename)
        (let (shortcut)
          (save-window-excursion
            (setq buf (find-file filename))
            (goto-char (point-min))
            (if (re-search-forward "\0\\([a-zA-Z]:\\\\\\(\\\\\\|[-a-zA-Z0-9' _]\\)*\\)\0" nil t)
                (progn
                  (setq shortcut (buffer-substring-no-properties (match-beginning 1) (match-end 1)))
                  (kill-buffer buf))
              (kill-buffer buf)
              (error "Error in shortcut file %s" filename)
              ))
          (when shortcut
            (message "Following link %s -> %s" filename shortcut)
            (find-file shortcut)))
      (if (string-match "\\*" filename)
          (progn
            ;;(d-foo)
            (find-file filename 'WILDCARDS))
        (let ((case-fold-search t))
          (cond
           ;; ----------------------------------------------------------
           ((and (buffer-file-name)
                 (string= (expand-file-name filename) (expand-file-name (buffer-file-name))))
            ;;(d-beeps "foo!")
            (dired (file-name-directory filename))
            )
           ;; ----------------------------------------------------------
           ((file-directory-p filename)
            ;;(d-beeps "123")
            (if (string-match "/\\(Driver Pack Solution\\)/" filename)
                (progn
                  (setq filename (substring filename (match-end 1) (1- (length filename))))
                  (if (string= "" filename)
                      (dired (concat drive-f ":/Driver Pack Solution/"))
                    (if (get-buffer "Driver Pack Solution")
                        (progn
                          (switch-to-buffer "Driver Pack Solution")
                          (goto-char (point-min))
                          (re-search-forward filename nil t)
                          (beginning-of-line)
                          ;;(d-dired-advertised-find-file)
                          ;;(dired-next-line 2)
                          ;;(d-beeps "f=%s" filename)
                          )
                      (dired filename))))
              (dired filename)
              ))
           ;; ----------------------------------------------------------
           ((or os-type--mswindows-p os-type--msdos-p)
            ;;(d-beeps "Regina")
            (cond

             ((string-match "\\.flac$" filename)
              (save-window-excursion
                (shell-command (concat "\"c:/Program Files/foobar2000/foobar2000.exe\" \"" filename "\" &"))))

             ((string-match "\\.\\(ico\\|bmp\\|jpe?g\\|mpe?g\\|png\\|gif\\)$" filename)
              (save-window-excursion
                (if (file-exists-p "c:/Program Files/IrfanView/i_view32.exe")
                    (shell-command (concat "\"c:/Program Files/IrfanView/i_view32.exe\" \"" filename "\" &"))
                  (if (file-exists-p "c:/Program Files (x86)/IrfanView/i_view32.exe")
                      (shell-command (concat "\"c:/Program Files (x86)/IrfanView/i_view32.exe\" \"" (file-name-nondirectory filename) "\" &"))
                    (d-beeps "Cannot find IrfanView")
                    ))))
             ((string-match "\\.\\(exe\\)$" filename)
              ;;(save-window-excursion
              (shell-command (concat filename " &"))
              )

             ((string-match "\\.mid$" filename)
              ;;(d-beeps "Foomatic")
              (shell-command (concat "\"c:/Program Files/Windows Media Player/mplayer2.exe\" \"" filename "\" &")))

             ((string-match "\\.level$" filename)
              (find-file filename)
              (setq truncate-lines t))

             ;;((string-match (concat "\\." d-files-regexp--archives "$") filename)
             ;;(shell-command (concat "cygstart \"" (expand-file-name filename) "\"")))

             ((or (string-match "\\.wav$" filename)
                  (string-match "\\.au$"  filename))
              ;;(debug "Carrot")
              (play-sound (list 'sound :file filename :volume 1.0)))

             ((string-match "\\.rle$" filename)
              (shell-command (concat "rle-loader.exe " filename)))

             ((string-match "\\.xcf$" filename)
              (shell-command (concat "\"~/../Program Files/GIMP-2.2/bin/gimp-2.2.exe\" " filename)))

             ((string-match "\\.exe$" filename)
              (shell-command (concat "cd " default-directory "; ./" filename)))

             ((string-match "\\.\\(pdf\\|eps\\)$" filename)
              (shell-command "\"/cygdrive/c/Program Files/Adobe/Reader 11.0/Reader/AcroRd32.exe\" " filename))

             ;;(shell-command "\"c:/Program Files/Adobe/Reader 11.0/AcroRd32.exe\" " filename))

             ((string-match "\\.ps$" filename)
              (shell-command (concat "\"d:/home/Program Files/gs/gs8.53/bin/gswin32.exe\" " filename)))

             ((string-match "\\.mp4$" filename)
              ;;(d-beeps "hello")
              (shell-command (concat "\"c:/Program Files/VideoLAN/VLC/vlc.exe\" \"" filename "\" &")))

             ;; NOTE: cygstart
             ((string-match (concat "\\.\\("
                                    "avi\\|bmp\\|eps\\|gif\\|iff\\|ico\\|jpg\\|jpeg\\|"
                                    "mpeg\\|mov\\|mpg\\|pcx\\|pdf\\|png\\|tga\\|wmv\\|" ;;; graphics files (missing dvi)
                                    "doc\\|rtf\\|" ;;; MS Word
                                    "exe\\|"       ;;; executable
                                    "swf\\|"       ;;; ShockWaveFlash
                                    "hlp\\|"       ;;; help
                                    "au\\|mid\\|mp3\\|wav\\|wma\\|" ;;; sound files
                                    "rtf\\|pdf\\|ps\\|" ;;; latex
                                    ;;"sex\\|"
                                    "\\)$") filename)
              ;;(let ((shell-file-name "D:/Program Files/emacs-21.3/bin/cmdproxy.exe"))
              (let ((cmd nil))
                (save-window-excursion
                  ;;(d-foo)
                  (setq cmd (concat "e:/cygwin/bin/cygstart.exe \"" (expand-file-name filename) "\""))
                  (message "cmd=%s" cmd)
                  (shell-command cmd)
                  )))

             ((string-match "\\.fig$" filename)
              (save-window-excursion
                ;;(shell-command (concat "c:/cygwin/usr/X11R6/bin/xfig.exe " (prin1-to-string filename) " &"))
                (shell-command (concat "c:/cygwin/bin/xfig.exe " (prin1-to-string filename) " &"))
                ))

             (t (find-file (file-truename filename)))
             ))
           ;; ----------------------------------------------------------
           (os-type--linux-p
            ;;(d-beeps "os-type--linux-p")
            (cond

             ((string-match "\\.\\(pdf\\|dvi\\|eps\\|ps\\)$" filename)
              (find-file filename))

             ((string-match "\\.exe$" filename)
              (save-window-excursion
                (shell-command filename)))

             ((string-match "\\.fig$" filename)
              (save-window-excursion
                (shell-command (concat "xfig \"" filename "\" &"))))

             ((string-match "\\.\\(bmp\\|gif\\|jpg\\|jpeg\\|ico\\|mpe?g\\|pgm\\|png\\|tga\\)$" filename)
              (save-window-excursion
                ;;(shell-command (concat "xv -geometry 1024x768 " filename " &"))
                ;;(shell-command (concat "eog -f " filename " &"))
                ;;(d-beeps "gpicview")
                (shell-command (concat "gpicview \"" (expand-file-name filename) "\" &"))
                ))

             ((or (string-match "\\.wav$" filename)
                  (string-match "\\.au$"  filename)
                  ;;(string-match "\\.mid$" filename)
                  )
              ;;(debug "Carrot")
              (play-sound (list 'sound :file filename :volume 1.0)))

             ((or (string-match "\\.mid$" filename)
                  (string-match "\\.flac$" filename))
              ;;(d-beeps "audacious")
              (shell-command (concat "audacious \"" filename "\" &")))

             ((string-match "\\.\\(dvi\\|eps\\|ps\\)$" filename)
              (shell-command (concat "nautilus " filename " &")))

             ((string-match "\\.pdf$" filename)
              (save-window-excursion
                (shell-command (concat "acroread " (prin1-to-string filename) " &"))))

             ((string-match "\\.dvi$" filename)
              (save-window-excursion
                (shell-command (concat "xdvi " (prin1-to-string filename) " &"))))

             (t (find-file (file-truename filename)))

             ))

           (t (find-file (file-truename filename)))
           )))))
  (if (fboundp 'd-speedbar)
      (delete-other-windows))
  (setq file-name-history (cons "~/" file-name-history))
  )



;;; (setq file "e:/msie-firefox.png")

(defun d-dired-advertised-find-file ()
  (interactive)
  (let ((filename (d-dired-get-current-file)))
    (assert filename)
    (push-mark)
    (if (string-match "^\\(.*\\) -> \\(.*\\)$" filename)
        (setq filename (substring filename (match-beginning 1) (match-end 1))))
    (d-find-file filename)
    ))

(defun d-dired-get-current-file ()
  (save-excursion
    (assert (eq major-mode 'dired-mode))
    (safe-command (dired-next-line 1)     'QUIETP)
    (safe-command (dired-previous-line 1) 'QUIETP)
    (let ((filename (buffer-substring-no-properties (point) (save-excursion
                                                              (re-search-forward "[\n\r]" nil t)
                                                              (backward-char)
                                                              (point))))
          dirname fullname)
      ;;(debug "Hot tomales")
      (cond
       ((re-search-backward "^  \\([a-z]:/.*\\):$" nil t)
        (setq dirname (buffer-substring-no-properties (match-beginning 1) (match-end 1)))
        (setq fullname (concat dirname "/" filename))
        ;;(debug "zoom 1")
        )
       ((re-search-backward "^  \\(/[][(){}_a-zA-Z0-9/'.,+! #&;-]*\\):$" nil t)
        (setq dirname (buffer-substring-no-properties (match-beginning 1) (match-end 1)))
        ;;(d-beeps "dirname=%s" dirname)
        (setq fullname (concat dirname "/" filename))
        ;;(debug "zoom 2")
        )
       ;;(t (debug "Roger"))
       )
      ;;(debug "zoom 3")
      fullname)))

(add-hook 'shell-mode-hook 'd-shell-mode-hook)
(defun d-shell-mode-hook ()
  (local-set-key "\C-d" 'd-find-file))

(d-quote
 (string-match "\\.\\$" filename)
 (shell-command (concat "start \"" filename "\""))
 (d-quote
  (if (get-buffer ".script.bat")
      (kill-buffer ".script.bat"))
  (save-excursion
    (set-buffer (find-file ".script.bat"))
    (read-only-mode -1)
    (erase-buffer)
    (insert "start " filename "\r\n")
    (save-buffer)
    (kill-buffer nil)
    (shell-command (concat "\"" default-directory ".script.bat\""))
    (delete-file (concat default-directory ".script.bat"))
    )))

(defadvice save-buffer (around d-find activate)
  (push-mark (point) 'NOMSG)
  ad-do-it
  (if mark-ring
      (goto-char (car mark-ring))))

(defadvice save-some-buffers (around d-find activate)
  (push-mark (point) 'NOMSG)
  ad-do-it
  (if mark-ring
      (goto-char (car mark-ring))))

(provide 'd-find)
;;; d-find.el ends here
