/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.voting;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.Configuration;
import org.gnunet.util.crypto.EcdsaPrivateKey;
import org.gnunet.util.crypto.EcdsaPublicKey;
import org.gnunet.util.crypto.EcdsaSignature;
import org.gnunet.voting.Ballot;
import org.gnunet.voting.InvalidBallotException;
import org.gnunet.voting.InvalidGroupCertException;

public class GroupCert {
    private String group;
    private EcdsaPublicKey member;
    private EcdsaPublicKey signerPublicKey;
    private AbsoluteTime expiration;
    private EcdsaSignature signature;

    private GroupCert() {
    }

    public static GroupCert create(EcdsaPublicKey member, String group, EcdsaPrivateKey signerPrivateKey, EcdsaPublicKey signerPublicKey, AbsoluteTime expiration) {
        Preconditions.checkNotNull((Object)member);
        Preconditions.checkNotNull((Object)group);
        Preconditions.checkNotNull((Object)signerPrivateKey);
        Preconditions.checkNotNull((Object)signerPublicKey);
        Preconditions.checkNotNull((Object)expiration);
        GroupCert groupCert = new GroupCert();
        groupCert.member = member;
        groupCert.expiration = expiration;
        groupCert.group = group;
        groupCert.signerPublicKey = signerPublicKey;
        String signData = "";
        signData = signData + member.toString();
        signData = signData + expiration.getSeconds();
        signData = signData + group;
        signData = signData + signerPublicKey;
        groupCert.signature = signerPrivateKey.sign(signData.getBytes(), 0);
        return groupCert;
    }

    public static GroupCert fromBallotConfig(Ballot ballot, Configuration cfg) {
        GroupCert groupCert = new GroupCert();
        Optional<String> optGroupSig = cfg.getValueString("vote", "GROUP_SIG");
        Optional<Long> optGroupExp = cfg.getValueNumber("vote", "GROUP_EXPIRATION");
        groupCert.member = ballot.voterPub;
        groupCert.group = ballot.group;
        if (!optGroupSig.isPresent()) {
            throw new InvalidBallotException("missing group cert signature in ballot");
        }
        groupCert.signature = EcdsaSignature.fromString((String)optGroupSig.get());
        if (groupCert.signature == null) {
            throw new InvalidBallotException("invalid group cert signature in ballot");
        }
        if (!optGroupExp.isPresent()) {
            throw new InvalidBallotException("missing or invalid group cert expiration in ballot");
        }
        groupCert.expiration = AbsoluteTime.fromSeconds((Long)optGroupExp.get());
        return groupCert;
    }

    public static GroupCert fromGroupCertConfig(Configuration cfg) {
        GroupCert groupCert = new GroupCert();
        Optional<String> optMember = cfg.getValueString("groupcert", "MEMBER");
        Optional<String> optCa = cfg.getValueString("groupcert", "CA");
        Optional<String> optSig = cfg.getValueString("groupcert", "SIG");
        Optional<Long> optExpiration = cfg.getValueNumber("groupcert", "EXPIRATION");
        Optional<String> optGroup = cfg.getValueString("groupcert", "GROUP");
        if (!optMember.isPresent()) {
            throw new InvalidGroupCertException("missing member key in group cert");
        }
        if (!optCa.isPresent()) {
            throw new InvalidGroupCertException("missing CA in group cert");
        }
        if (!optSig.isPresent()) {
            throw new InvalidGroupCertException("missing signature in group cert");
        }
        if (!optExpiration.isPresent()) {
            throw new InvalidGroupCertException("missing expiration in group cert");
        }
        if (!optGroup.isPresent()) {
            throw new InvalidGroupCertException("missing group identifier in group cert");
        }
        groupCert.group = (String)optGroup.get();
        groupCert.signature = EcdsaSignature.fromString((String)optSig.get());
        if (null == groupCert.signature) {
            throw new InvalidGroupCertException("invalid signature in group cert");
        }
        groupCert.expiration = AbsoluteTime.fromSeconds((Long)optExpiration.get());
        groupCert.signerPublicKey = EcdsaPublicKey.fromString((String)optCa.get());
        if (null == groupCert.signerPublicKey) {
            throw new InvalidGroupCertException("invalid CA in group cert");
        }
        groupCert.member = EcdsaPublicKey.fromString((String)optMember.get());
        if (null == groupCert.member) {
            throw new InvalidGroupCertException("invalid member in group cert");
        }
        return groupCert;
    }

    public void writeBallotConfig(Configuration cfg) {
        cfg.setValueString("vote", "GROUP_SIG", this.signature.toString());
        cfg.setValueNumber("vote", "GROUP_EXPIRATION", this.expiration.getSeconds());
    }

    public void writeGroupCertConfig(Configuration cfg) {
        cfg.setValueString("groupcert", "MEMBER", this.member.toString());
        cfg.setValueString("groupcert", "CA", this.signerPublicKey.toString());
        cfg.setValueString("groupcert", "SIG", this.signature.toString());
        cfg.setValueNumber("groupcert", "EXPIRATION", this.expiration.getSeconds());
        cfg.setValueString("groupcert", "GROUP", this.group);
    }

    public EcdsaPublicKey getMemberPublicKey() {
        return this.member;
    }

    public AbsoluteTime getExpiration() {
        return this.expiration;
    }

    public EcdsaSignature getSignature() {
        return this.signature;
    }
}

