; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefix=RV32I
; RUN: llc -mtriple=riscv32 -mattr=+experimental-zbt -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefix=RV32IBT
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefix=RV64I
; RUN: llc -mtriple=riscv64 -mattr=+experimental-zbt -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefix=RV64IBT

declare i32 @llvm.abs.i32(i32, i1 immarg)
declare i64 @llvm.abs.i64(i64, i1 immarg)

define i32 @neg_abs32(i32 %x) {
; RV32I-LABEL: neg_abs32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srai a1, a0, 31
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    sub a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IBT-LABEL: neg_abs32:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    srai a1, a0, 31
; RV32IBT-NEXT:    xor a0, a0, a1
; RV32IBT-NEXT:    sub a0, a1, a0
; RV32IBT-NEXT:    ret
;
; RV64I-LABEL: neg_abs32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sraiw a1, a0, 31
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    subw a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64IBT-LABEL: neg_abs32:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    sraiw a1, a0, 31
; RV64IBT-NEXT:    xor a0, a0, a1
; RV64IBT-NEXT:    subw a0, a1, a0
; RV64IBT-NEXT:    ret
  %abs = tail call i32 @llvm.abs.i32(i32 %x, i1 true)
  %neg = sub nsw i32 0, %abs
  ret i32 %neg
}

define i32 @select_neg_abs32(i32 %x) {
; RV32I-LABEL: select_neg_abs32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srai a1, a0, 31
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    sub a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IBT-LABEL: select_neg_abs32:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    srai a1, a0, 31
; RV32IBT-NEXT:    xor a0, a0, a1
; RV32IBT-NEXT:    sub a0, a1, a0
; RV32IBT-NEXT:    ret
;
; RV64I-LABEL: select_neg_abs32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sraiw a1, a0, 31
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    subw a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64IBT-LABEL: select_neg_abs32:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    sraiw a1, a0, 31
; RV64IBT-NEXT:    xor a0, a0, a1
; RV64IBT-NEXT:    subw a0, a1, a0
; RV64IBT-NEXT:    ret
  %1 = icmp slt i32 %x, 0
  %2 = sub nsw i32 0, %x
  %3 = select i1 %1, i32 %x, i32 %2
  ret i32 %3
}

define i64 @neg_abs64(i64 %x) {
; RV32I-LABEL: neg_abs64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srai a2, a1, 31
; RV32I-NEXT:    xor a0, a0, a2
; RV32I-NEXT:    sltu a3, a2, a0
; RV32I-NEXT:    xor a1, a1, a2
; RV32I-NEXT:    sub a1, a2, a1
; RV32I-NEXT:    sub a1, a1, a3
; RV32I-NEXT:    sub a0, a2, a0
; RV32I-NEXT:    ret
;
; RV32IBT-LABEL: neg_abs64:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    srai a2, a1, 31
; RV32IBT-NEXT:    xor a0, a0, a2
; RV32IBT-NEXT:    sltu a3, a2, a0
; RV32IBT-NEXT:    xor a1, a1, a2
; RV32IBT-NEXT:    sub a1, a2, a1
; RV32IBT-NEXT:    sub a1, a1, a3
; RV32IBT-NEXT:    sub a0, a2, a0
; RV32IBT-NEXT:    ret
;
; RV64I-LABEL: neg_abs64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srai a1, a0, 63
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    sub a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64IBT-LABEL: neg_abs64:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    srai a1, a0, 63
; RV64IBT-NEXT:    xor a0, a0, a1
; RV64IBT-NEXT:    sub a0, a1, a0
; RV64IBT-NEXT:    ret
  %abs = tail call i64 @llvm.abs.i64(i64 %x, i1 true)
  %neg = sub nsw i64 0, %abs
  ret i64 %neg
}

define i64 @select_neg_abs64(i64 %x) {
; RV32I-LABEL: select_neg_abs64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srai a2, a1, 31
; RV32I-NEXT:    xor a0, a0, a2
; RV32I-NEXT:    sltu a3, a2, a0
; RV32I-NEXT:    xor a1, a1, a2
; RV32I-NEXT:    sub a1, a2, a1
; RV32I-NEXT:    sub a1, a1, a3
; RV32I-NEXT:    sub a0, a2, a0
; RV32I-NEXT:    ret
;
; RV32IBT-LABEL: select_neg_abs64:
; RV32IBT:       # %bb.0:
; RV32IBT-NEXT:    srai a2, a1, 31
; RV32IBT-NEXT:    xor a0, a0, a2
; RV32IBT-NEXT:    sltu a3, a2, a0
; RV32IBT-NEXT:    xor a1, a1, a2
; RV32IBT-NEXT:    sub a1, a2, a1
; RV32IBT-NEXT:    sub a1, a1, a3
; RV32IBT-NEXT:    sub a0, a2, a0
; RV32IBT-NEXT:    ret
;
; RV64I-LABEL: select_neg_abs64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srai a1, a0, 63
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    sub a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64IBT-LABEL: select_neg_abs64:
; RV64IBT:       # %bb.0:
; RV64IBT-NEXT:    srai a1, a0, 63
; RV64IBT-NEXT:    xor a0, a0, a1
; RV64IBT-NEXT:    sub a0, a1, a0
; RV64IBT-NEXT:    ret
  %1 = icmp slt i64 %x, 0
  %2 = sub nsw i64 0, %x
  %3 = select i1 %1, i64 %x, i64 %2
  ret i64 %3
}

