from __future__ import annotations

from types import SimpleNamespace
from typing import TYPE_CHECKING

from docutils import nodes

from sphinx.transforms.post_transforms.images import ImageConverter
from sphinx.util.docutils import new_document

if TYPE_CHECKING:
    from pathlib import Path

WEBP_DATA = (
    b'RIFF\xa8\x01\x00\x00WEBPVP8X\n\x00\x00\x00'
    b"\x10\x00\x00\x00\x0f\x00\x00\x0f\x00\x00ALPH\xc3\x00\x00\x00\x01'"
    b'\xa2\xa8\x91$\xe5z\xe7\x18_\xe7\xdf*\x99\x88\x98\xfftq\x8d\xe0'
    b'&0\xe2\xe1\x8bw2\xc8\xc1\x11\\\x83+0\xe8\xb0x\x15\x8ex'
    b'Q5\xc1\x08\x0c\x02O\x92\xa0j\xb0U\x19\x1c\xd6\xb6mF/N'
    b'\xc6v<\xb6\xedw\xfb\xaf)\xae!\xa2\xffI\xd1\xfd\x8f\x90\xf7\xba'
    b'DI$\x1b:%\x914\xf3\x14m\x0e\xc7\xd3\xe5\x16 \xf4\x0b\x14'
    b'\xbe\x90\xe1\x83\xb7\x1a2\x9e6\x82\x7f\x1d)~Nv\x08\xfb\x88\x9e'
    b'\xb3\x91\xef\x99sF\xe82\x82\xdb\xf8\xccH\xb2\xf7E0} \xfd'
    b'6\x17\x8c!2V-\xa5\xd6k#\xbc]\xe3\xa5Y\x15\xd5\x9c\x81'
    b'\xa4\xd9n\x96u\x8a\x181\x0f\x8a\xaa,P4\xfa0\x82\xdf\xbak'
    b'PR)\xb5-\xcf\xe9T\x14\n\x01\x00\x00\x00VP8 \xbe\x00'
    b'\x00\x00\x90\x02\x00\x9d\x01*\x10\x00\x10\x00\x03\x004%\xb0\x02t0'
    b'O\x08\x85\x0c|\x03\x1d\x08,\xfd\xe8\x00\xfe\xfdt\xa0\xfd\x02\x9b\x1f'
    b'\x8a\xf7C|\x9c7\xf6\xd2\x0c\xaf\xd3\xff5h\xe2\xee\xa7\xbd\xc9o'
    b'\x1b\xf4\xaa\xc5c\xae\xba\x9f\x97\x84\xdfA\xa2;\xda[\xe4\xef\xf8\xcb'
    b'\xf1\xbd\x7f\xe1\xaf\xfa?\xe5\t\xec\xf4\xbbf_\xff\xaa)\xd9\x7f\xc9'
    b'l\xe7\x86\xe6\xac\x97\xb9\xe4\xc6\xf4\x93#\x8c_\xdd\x8f9U \x7f'
    b'\x95O\xfc9\xf8\xffo\xd2k\x03\xe8\x9f\xbc\x83\x98fm\xb1\xd5\x13'
    b'\xffv\x17\xe6\xb1\xfe]\x8a\xe4\x9fG\xbf\xb3\xfa\xbf\xfe\x1d\x1d\xf3\x12'
    b'\x8f\xfe\\\xcf\xc1\xfa\xf9\x18\xc3\xbd\xcf\xcf\x1f\x919\xa0\x01\xfd\x9a\x01'
    b'K1,\xde\xbc\xd9{\xaa\xac\x00\x00\x00'
)


def test_guess_mimetype_webp(tmp_path: Path) -> None:
    document = new_document('<source>')
    document.settings.env = SimpleNamespace(srcdir=tmp_path)
    converter = ImageConverter(document)

    file_webp = 'webp-image.webp'
    image = nodes.image(uri=file_webp, candidates={'*': file_webp})
    assert converter.guess_mimetypes(image) == ['image/webp']

    file_dat = 'webp-image.dat'
    tmp_path.joinpath(file_dat).write_bytes(WEBP_DATA)
    image = nodes.image(uri=file_dat, candidates={'*': file_dat})
    assert converter.guess_mimetypes(image) == ['image/webp']
