set terminal fig monochrome landscape big metric dashed font "Helvetica" fontsize 24 
set output "viscosity.fig"
set title "Relative viscosity of water"
a = -1.704
b = -5.306
c = 7.003
mu0 = 1.788e-3
z(T) = 273.15/T
relmu(T) = exp(a + b * z(T) + c * (z(T))**2)
plot [T=273.15:350] relmu(T), "viscosity.dat" u 1:($2/mu0) w lp 3