/*
 *           PVM 3.0:  Parallel Virtual Machine System 3.0
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *          R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM 3.0 was funded in part by the U.S. Department of Energy, the
 * National Science Foundation and the State of Tennessee.
 */

/*
 * PVM3.0-I860
 *
 *  mycube.h:  cube data structures and other definitions
 *
 *      send bug reports to:    wjiang@cs.utk.edu
 *
 */

/* host process ID set by setpid() */
#define PVMDPID         0		/* pvmd */
#define CUBEDPID        1		/* cubed */

#define MAXCUBES        10      /* max. number of cubes allowed */
#define CUBENAMELEN		16		/* max number of characters in cube name */

#define TIDNODE         0x8000  /* to distinguish between node & host tasks */
#define TIDCUBE			0x7c00	/* 5 bits to store cube ID */
#define TIDCLOCAL		0x03ff	/* 10 bits to store direct node # */

/* pvm internal messages */
#define PMTPVMD			1		/* from pvmd */
#define PMTCUBED		2		/* from cubed */
#define PMTNODE			3		/* from a node */
#define PMTTID			4		/* special msg containing tid of node task */
#define PMTTOKEN		5		/* ack sent to task by cubed */
#define PMTANY			0xFFFFFFFF

#define PDMCUBE         32      /* pvmd debug mask */

#define HOSTNODEMTU		262144	/* max. message size between host and node */
#define CUBELOGFILE 	"/tmp/cubel.%d"  /* log file for cubed and node procs */

/* use unix pid to build name */
#define MAKECUBENAME(name,no)	(sprintf((name),"pvm%d",(no)))
/* determine if task is host or node process */
#define TIDISNODE(tid)	((tid) & (tidnode))
/* make cube portion of tid (host + cube) from cube ID */
#define CUBEPART(host,id,mask)	((host)+((id)<<(ffs(mask)-1)))
/* extract cube ID from tid */
#define TIDTOCUBE(tid)	(((tid) & tidcmask) >> (ffs(tidcmask)-1))


/* we keep a list of all subcubes allocated */

struct cube {
    struct cube *c_link;        
    struct cube *c_rlink;
    int		c_size;		/* number of nodes requested */
    int		c_id;		/* the global (physical) qm_cubeid */
    char	*c_name;	/* cube name */
	int		c_cubed;	/* tid of cube daemon */

/* these things are stored here for convenience */
    char	*c_file;	/* name of the executable */
    int		c_ptid;		/* tid of task who requested the cube */
    int		c_msrc;		/* the pvmd who sent the request */
    int		c_mwid;		/* wait ID of task who requested the cube */
};

void cube_init __ProtoGlarp__((void));
struct cube *cube_new __ProtoGlarp__((void));
struct cube *cube_find __ProtoGlarp__((short cid));
struct cube *cube_byname __ProtoGlarp__((char *name));
struct cube *cubeprobe __ProtoGlarp__((void));
void cube_cleanup __ProtoGlarp__((struct cube *cp));
void cube_free __ProtoGlarp__((struct cube *cp));
