#!/bin/csh -fb
#
# aimk [-here] [-nomk] [ make args ... ]
#
# Architecture Dependent Make Facility.  Automatically sets PVM
# machine-type for make to use.
#
# This is a heuristic thing that may need to be tuned from time
# to time.  I don't know of a real solution to determining the
# machine type.  Claims to pick one of:
#   ALPHA, AFX8, BFLY, BSD386, CNVX, CM2, CM5, CRAY, CRAYSMP, DGAV,
#   HP300, HPPA, I860, KSR1, NEXT, PGON, PMAX, RS6K, SGI, SUN2, SUN3,
#   SUN4, SYMM, TITN, UVAX, VAX,
#   UNKNOWN
# Need to do:
#   IPSC2
#
# Aimk exports environment variables that can be used in makefiles
#   ARCH = the selected architecture
#   ARCHLIB = arch-specific libraries needed when using libpvm
#
# Notes:
#   1. Local people mess with things.
#   2. It's good to try a few things for robustness.
#
# 22 Jul 1991  Robert Manchek  manchek@CS.UTK.EDU.
#

set noglob

unset makeincwd
unset nomk
set found
while ($#argv >= 1 && $?found)
	switch ("$argv[1]")
	case "-here":
		set makeincwd
		set argv=($argv[2-])
		breaksw
	case "-nomk":
		set nomk
		set argv=($argv[2-])
		breaksw
	default:
		unset found
		breaksw
	endsw
end

#
# begin section that may need to be tuned.
#

set ARCH=UNKNOWN

if (-x /bin/uname) then
	set os="`/bin/uname -s`"
	set ht="`/bin/uname -m`"
	set osht="$os,$ht"

	switch ("$osht")
	case SunOS,sun3*:
		set ARCH=SUN3
		breaksw
	case SunOS,sun4*:
		set ARCH=SUN4
		breaksw
	case ULTRIX,RISC:
		set ARCH=PMAX
		breaksw
	case ULTRIX,VAX:
		set ARCH=UVAX
		breaksw
	case AIX,*:
		set ARCH=RS6K
		breaksw
	case *,9000/*:
		set ARCH=HPPA
		breaksw
	case IRIX,*:
	case IRIX,*:
		set ARCH=SGI
		breaksw
	case *,alpha:
		set ARCH=ALPHA
		breaksw
	case CRSOS,smp:
		set ARCH=CRAYSMP
		breaksw
	case *,paragon:
		set ARCH=PGON
		breaksw
	case dgux,AViiON:
		set ARCH=DGAV
		breaksw
	endsw
endif

if ($ARCH == UNKNOWN) then
	if (-x /bin/arch) then
		switch (`/bin/arch`)
		case ksr1:
			set ARCH=KSR1
			breaksw
		case sun2:
			set ARCH=SUN2
			breaksw
		case sun3:
			set ARCH=SUN3
			breaksw
		case sun4:
			set ARCH=SUN4
		default:
			breaksw
		endsw
	endif
endif

if ($ARCH == UNKNOWN) then
	if (-e /ultrixboot) then
		if (-e /pcs750.bin) then
			set ARCH=UVAX
		else
			set ARCH=PMAX
		endif
	else
		if (-e /pcs750.bin) set ARCH=VAX
	endif

	if (-e /usr/alliant) set ARCH=AFX8
	if (-e /usr/bin/cluster) set ARCH=BFLY
	if (-e /usr/convex) set ARCH=CNVX
	if (-e /unicos) set ARCH=CRAY
	if (-e /hp-ux) set ARCH=HP300
	if (-e /usr/bin/getcube) set ARCH=I860
	if (-e /usr/bin/asm56000) set ARCH=NEXT
	if (-e /etc/vg) set ARCH=RS6K
	if (-d /usr/include/caif) set ARCH=RT
	if (-e /dynix) set ARCH=SYMM
	if (-e /bin/titan) set ARCH=TITN
	if (-x /usr/bin/machine) then
		switch (`/usr/bin/machine`)
		case i386:
			set ARCH=BSD386
			breaksw
		default:
			breaksw
		endsw
	endif
endif

if ($ARCH == SUN4 && -e /dev/cm) set ARCH=CM2
if ($ARCH == SUN4 && -e /dev/cmni) set ARCH=CM5

#
# ugh, done.
#

#
# get lflags
#

switch ($ARCH)
case BSD386:
case PGON:
	setenv ARCHLIB -lrpc
	breaksw

case I860:
case IPSC2:
	setenv ARCHLIB "-lrpc -lsocket"
	breaksw

case SGI:
	setenv ARCHLIB -lsun
	breaksw

default:
	set ARCHLIB
endsw

#
# run make in cwd or subdir if exists.
#

if ($?nomk) then
	echo $ARCH
	exit 0
endif

if (! $?makeincwd && -d $ARCH) then
	echo making in $ARCH/ for $ARCH
	(cd $ARCH; make ARCH=$ARCH "ARCHLIB=$ARCHLIB" $argv)
else
	echo making in . for $ARCH
	make ARCH=$ARCH "ARCHLIB=$ARCHLIB" $argv
endif

echo done.
exit 0

