/*
 * imgview.C - tiff raster image viewer
 *
 * created:  3 May 1993
 *
 * changed:  1 Jun 1993
 */


#include "imgview.h"
#include "delhand.h"

#include <IV-look/kit.h>
#include <InterViews/action.h>
#include <InterViews/image.h>
#include <InterViews/layout.h>
#include <InterViews/patch.h>
#include <InterViews/style.h>
#include <InterViews/tformsetter.h>
#include <InterViews/tiff.h>
#include <InterViews/window.h>

#include <iostream.h>


static ApplicationWindow* imvdlgwin = 0;
static TransformFitter* fitter = 0;
static Patch* imvpatch = 0;

/*
class CloseAction: public Action
{
  public:
    void setwin (ApplicationWindow* win)
    { win_ = win; }

    void execute ();

  private:
    ApplicationWindow* win_;
};


void CloseAction::execute ()
{ if (win_)
  { cerr << "unmapping" << endl;
    win_->unmap ();  // unmap the dialog window // Bus error (core dumped)!
    cerr << "unbinding" << endl;
    win_->unbind ();  // IV-bug
    cerr << "done" << endl;
  }
}
*/


void showimage (const char* image)
{
  Raster* r = TIFFRaster::load (image);
  if (!r)
  { cerr << "error: open tiff image " << image << " failed" << endl;
    return;
  }

  if (!imvdlgwin)  // create window on first call
  {
    WidgetKit& kit = *WidgetKit::instance ();
    const LayoutKit& layout = *LayoutKit::instance ();
  
    Style* imvstyle = new Style (kit.style ());
    imvstyle->attribute ("name", "Hyper-G Image Viewer");  // Title
    imvstyle->attribute ("iconName", "Hyper-G Image");
/*
    CloseAction* closeaction = new CloseAction;
    Menu* menubar = kit.menubar ();
    MenuItem* menuitem = kit.menubar_item ("Quit");
    menuitem->action (new CloseAction);
    menubar->append_item (menuitem);
*/

    fitter = new TransformFitter (nil);  // (imvimage)
    imvpatch = new Patch (fitter);

    imvdlgwin = new ApplicationWindow (
	kit.outset_frame (
	  layout.variable_span (
	    imvpatch
	  )
	)
    );

//    closeaction->setwin (imvdlgwin);
    imvdlgwin->style (imvstyle);

    // delete handler
    SDeleteHandler* delhandler = new SDeleteHandler;
    imvdlgwin->wm_delete (delhandler);
  }

  Image* imvimage = new Image (r);
  fitter->body (imvimage);

  imvpatch->redraw ();
/*
  imvpatch->reallocate ();  // ?!
  imvpatch->redraw ();
*/
  imvdlgwin->map ();
}
