//<copyright>
// 
// Copyright (c) 1994,95,96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        wtranslate.C
//
// Purpose:     implementation of class WTranslate
//
// Created:     18 Feb 94   Michael Pichler
//
// Changed:     24 Oct 95   Tomas Torron-Mack (added Spanish)
//
// Changed:     15 Dec 95   ric Plante <planteer@JSP.UMontreal.CA> (added French)
//
// Changed:     23 Jan 96   Michael Pichler
//
// $Id: wtranslate.C,v 1.5 1996/01/25 08:18:27 bmarsch Exp $
//
//</file>



#include "wtranslate.h"



// English, German, Styrian, French, Italian, Spanish


static const char* wstringtable [][HgLanguage::NumLanguages] =
{
  { "About Harmony", "Info ber Harmony", "Info ba Haarmoni", " propos de Harmony", 0, "Info Acerca de Harmony" },
  { "All rights reserved", "Alle Rechte vorbehalten", "lle Rechte vurbehlten", "Tous droits rservs", 0, "Todos los derechos reservados" },
  { "Apply", "Anwenden", "Nimms her", "Appliquer", 0, "Aplicar" },
  { "Cancel", "Abbrechen", "Tuas weg", "Annuler", "Annulla", "Cancelar" },
  { "Copyright  1993-1996 IICM", 0, 0, 0, 0, 0 },
  { "Deselect All", "Nichts auswhlen", "Nix auswhln", "Annuler toutes slections", 0, "Deseleccionar Todo" },
  { "Help", "Hilfe", "Hf ma", "Aide", "Aiuto", "Ayuda" },
  { "No", "Nein", "Naa", "Non", "No", "No" },
  { "OK", "OK", "Guat", 0, 0, "OK" },
  { "Select All", "Alles auswhlen", "lles auswhln", "Tout slecter", 0, "Seleccionar Todo" },
  { "Selected", "selekiert", "slektiat", "Slect", 0, "Seleccionado" },
  { "Stop", "Stop", "Her auf", 0, 0, "Stop" },
  { "Graz University of Technology", "Technische Universitt Graz", "Technische Universitt Graz", "Universit de Technologie de Graz", 0, "Universidad Tecnolgica de Graz" },
  { "Unselected", "deselekiert", "unslektiat", "Non slect", 0, "No seleccionado" },
  { "Yes", "Ja", "Joo", "Oui", "S", "Si" },
  { "New:", "Neu:", "Nei:", "Nouveau:", 0, "Nuevo:" },
  { "Old:", "Alt:", "Oid:", "Ancien:", 0, "Antiguo:" },
  { "Close", "Schlieen", "Zuamchn", 0, 0, "Cerrar" },
  { "Reset", "Zurcksetzen", "Zrucksetzn", 0, 0, "Reajustar" },
  { "Restore", "Wiederherstellen", "Wia frira", 0, 0, 0 },
  { "Retry", "Wiederholen", "Tuas nomoi", 0, 0, 0 }
};



const char* WTranslate::str (StrSym strsym, HgLanguage::Language language)
{
  const char* res = wstringtable [strsym][language];

  if (res)
    return res;
  else
    return wstringtable [strsym][HgLanguage::Default];
}
