// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
// 
// Copyright (c) 1993 
// Institute for Information Processing and Computer Supported New Media (IICM), 
// Graz University of Technology, Austria. 
// 
// </copyright> 
//
//
// <file> 
// 
// Name:        vwstuff.C
// 
// Purpose:     definition of the base class for all Hyper-G viewers
//              definition of the base class for everyone who tells 
//                a Hyper-G viewer what to do 
//              
// 
// Created:     26 Jul 93   Joerg Faschingbauer
// 
// Modified:    
// 
// </file> 
#include "vwstuff.h"


boolean HgViewer :: isFatal (VwError e) {
   return e==NOCONNECTION || e==TIMEOUT || e==EXECFAIL || e==UNDEF || e==CONNCLOSED ;
}

const char* HgViewer :: errorDescription (HgViewer::VwError err, HgLanguage::Language) {
   if (err >= NERRORS)
      return "" ;
   return err_descr_[err] ;
}

const char* HgViewer::err_descr_[] = {
   "no error, why ask ???",
   "no connection",
   "connection timed out",
   "could not be started",
   "undefined error",
   "connection closed",
   "load was not completed"
} ;
