
/*  @(#)mk.c 1.2 91/12/30
 *
 *  Tree node creation routines used in the popi yacc grammar.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc.
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#include "popi.h"
#include "expr.h"


Tree *
mk(t, a, b)
enum tree t ;
Tree *a, *b ;
{
  Tree *new = (Tree *) LINT_CAST(treealloc(2)) ;
  new->kids[0] = (void *) a ;
  new->kids[1] = (void *) b ;
  new->t = t ;
  return(new) ;
}


Tree *
mkInum(i)
int i ;
{
  Tree *new = (Tree *) LINT_CAST(treealloc(0)) ;
  new->i = i ;
  new->t = T_Inum ;
  return(new) ;
}


Tree *
mkFnum(d)
double d ;
{
  Tree *new = (Tree *) LINT_CAST(treealloc(0)) ;
  new->d = d ;
  new->t = T_Fnum ;
  return(new) ;
}


Tree *
mkun(t, a)
enum tree t ;
void *a ;
{
  Tree *new = (Tree *) LINT_CAST(treealloc(1)) ;
  new->kids[0] = a ;
  new->t = t ;
  return(new) ;
}


Tree *
mkCond(a, b, c)
Tree *a, *b, *c ;
{
  Tree *new = (Tree *) LINT_CAST(treealloc(3)) ;
  new->kids[0] = (void *) a ;
  new->kids[1] = (void *) b ;
  new->kids[2] = (void *) c ;
  new->t = T_Cond ;
  return(new) ;
}


Tree *
mkempty(t)
enum tree t ;
{
  Tree *new = (Tree *) LINT_CAST(treealloc(0)) ;
  new->t = t ;
  return(new) ;
}
