/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1999  Elmar Ludwig - Universitaet Osnabrueck
 *
 * Generated automatically from gtkwindow.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 */
#ifndef GTOOLKIT_GTKWINDOW_H
#define GTOOLKIT_GTKWINDOW_H

#include <GToolKit/GTKBin.h>
#include <gtk/gtkwindow.h>

@interface GTKWindow : GTKBin
{
    id delegate;		// delegate of this window object
@private
    guint handler_id;		// /delete_event/ signal handler id
}

+ (GtkType) getType;
+ windowWithType:(GtkWindowType) type;
- initWithType:(GtkWindowType) type;
- (void) setTitle:(const NSString *) title;
- (void) setWmclass:(const NSString *) wmclass_name wmclassClass:(const NSString *) wmclass_class;
- (void) setPolicy:(gint) allow_shrink allowGrow:(gint) allow_grow autoShrink:(gint) auto_shrink;
- (void) addAccelGroup:(GTKAccelGroup *) accel_group;
- (void) removeAccelGroup:(GTKAccelGroup *) accel_group;
- (void) setPosition:(GtkWindowPosition) position;
- (gint) activateFocus;
- (gint) activateDefault;
- (void) setTransientFor:(GTKWindow *) parent;
- (void) setGeometryHints:(GTKWidget *) geometry_widget geometry:(GdkGeometry *) geometry geomMask:(GdkWindowHints) geom_mask;
- (void) setDefaultSize:(gint) width height:(gint) height;
- (void) setModal:(gboolean) modal;
- (void) setDelegate:_delegate;
- delegate;
- (NSString *) title;
- (GTKWidget *) focusWidget;
- (GTKWidget *) defaultWidget;
@end

extern NSString *GTKWindowDidBecomeMainNotification;
extern NSString *GTKWindowDidResignMainNotification;
extern NSString *GTKWindowWillCloseNotification;
extern NSString *GTKWindowWillOpenNotification;

/*
 * These methods may be implemented by the delegate.
 */
@protocol GTKWindowDelegate
- (void) windowDidBecomeMain:(NSNotification *) event;
- (void) windowDidResignMain:(NSNotification *) event;
- (BOOL) windowShouldClose:(GTKWindow *) sender;
- (void) windowWillClose:(NSNotification *) event;
@end

#endif
