#include <GToolKit/GToolKit.h>
#include <Foundation/NSAutoreleasePool.h>
#include <Foundation/NSArray.h>

@interface Foo : NSObject
{
    GTKHScale *scale;
    GTKEntry *entry;
}
- (void) updateEntry:sender;
- (void) updateScale:sender;
- (void) showDialog:sender;
@end

@implementation Foo

- init
{
    GTKWindow *window;
    GTKVBox *box;
    GTKAdjustment *adjust;
    GTKCombo *combo;
    GTKButton *button;

    [super init];

    window = [GTKWindow windowWithType:GTK_WINDOW_TOPLEVEL];
    button = [GTKButton buttonWithLabel:@"Colors..."];
    adjust = [GTKAdjustment adjustmentWithValue:50 lower:0 upper:100
			    stepIncrement:1 pageIncrement:10 pageSize:0];
    box = [GTKVBox vBoxWithHomogeneous:YES spacing:10];
    scale = [GTKHScale hScaleWithAdjustment:adjust];
    combo = [GTKCombo combo];
    entry = [combo entry];

    [combo setPopdownStrings:
	   [NSArray arrayWithObjects:@"0", @"25", @"50", @"75", @"100", nil]];

    [box packStartDefaults:scale];
    [box packStartDefaults:combo];
    [box packStartDefaults:button];
    [window setBorderWidth:10];
    [window add:box];
    [window show];

    [window connectSignal:@"destroy" withTarget:GTKApp
	    sel:@selector(terminate:)];
    [adjust connectSignal:@"value_changed" withTarget:self
	    sel:@selector(updateEntry:)];
    [entry  connectSignal:@"changed" withTarget:self
	    sel:@selector(updateScale:)];
    [button connectSignal:@"clicked" withTarget:self
	    sel:@selector(showDialog:)];
    return self;
}

- (void) updateEntry:sender
{
    [entry setDoubleValue:[sender getValue]];
}

- (void) updateScale:sender
{
    [scale setDoubleValue:[sender doubleValue]];
}

- (void) showDialog:sender
{
    GTKColorSelectionDialog *dialog =
	[GTKColorSelectionDialog colorSelectionDialogWithTitle:@"Choose Color"];

    [[dialog colorSelection] setOpacity:YES];
    [dialog show];
}
@end

int main (int argc, char *argv[])
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
#ifdef LIB_FOUNDATION_LIBRARY
    extern char **environ;
    [NSProcessInfo initializeWithArguments:argv count:argc environment:environ];
#endif

    [[GTKApplication alloc] initWithArgc:&argc argv:&argv];
    [[Foo new] autorelease];

    [GTKApp run];
    [pool release];
    return 0;
}
